package com.xebialabs.xlrelease.delivery.events

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlrelease.delivery.transition.TransitionParams
import com.xebialabs.xlrelease.domain.delivery._
import com.xebialabs.xlrelease.domain.events.{InterceptableAction, XLReleaseEvent}

sealed trait DeliveryEvent extends XLReleaseEvent {
  val delivery: Delivery
}

// RELEASE DELIVERY EVENTS

case class DeliveryCreatingEvent(delivery: Delivery) extends InterceptableAction

case class DeliveryCreatedEvent(delivery: Delivery) extends DeliveryEvent

case class DeliveryUpdatedEvent(delivery: Delivery) extends DeliveryEvent

case class DeliveryDeletedEvent(delivery: Delivery) extends DeliveryEvent

case class DeliveryCompletedEvent(delivery: Delivery) extends DeliveryEvent

case class DeliveryCreatedFromAsCodeEvent(delivery: Delivery, scmTraceabilityData: Option[SCMTraceabilityData]) extends DeliveryEvent

case class DeliveryUpdatedFromAsCodeEvent(delivery: Delivery, scmTraceabilityData: Option[SCMTraceabilityData]) extends DeliveryEvent

// STAGE EVENTS

sealed trait StageEvent extends DeliveryEvent {
  val stage: Stage
}

case class StageCreatedEvent(stage: Stage, delivery: Delivery) extends StageEvent

case class StageUpdatedEvent(original: Stage, stage: Stage, delivery: Delivery) extends StageEvent

case class StageRemovedEvent(stage: Stage, delivery: Delivery) extends StageEvent

case class StageReopenedEvent(stage: Stage, delivery: Delivery) extends StageEvent

case class StageStartedEvent(stage: Stage, delivery: Delivery) extends StageEvent

case class StageCompletedEvent(stage: Stage, delivery: Delivery) extends StageEvent

// TRACKED ITEM EVENTS

sealed trait TrackedItemEvent extends DeliveryEvent {
  val item: TrackedItem
}

case class ItemCreatedEvent(item: TrackedItem, delivery: Delivery) extends TrackedItemEvent

case class ItemUpdatedEvent(item: TrackedItem, delivery: Delivery, oldItem: TrackedItem) extends TrackedItemEvent

case class ItemRemovedEvent(item: TrackedItem, delivery: Delivery) extends TrackedItemEvent

case class ItemDescopedEvent(item: TrackedItem, delivery: Delivery) extends TrackedItemEvent

case class ItemRescopedEvent(item: TrackedItem, delivery: Delivery) extends TrackedItemEvent

case class ItemSkippedEvent(item: TrackedItem, stage: Stage, delivery: Delivery) extends TrackedItemEvent

case class ItemResetEvent(item: TrackedItem, stage: Stage, delivery: Delivery, fromReleaseId: String) extends TrackedItemEvent

case class ItemCompletedEvent(item: TrackedItem, stage: Stage, delivery: Delivery, fromReleaseId: String) extends TrackedItemEvent

case class ItemAvailableEvent(item: TrackedItem, stage: Stage, delivery: Delivery) extends TrackedItemEvent

case class ItemTransitionApprovedEvent(item: TrackedItem,
                                       stageItem: StageTrackedItem,
                                       transition: Transition,
                                       stage: Stage,
                                       delivery: Delivery)
  extends TransitionChangeEvent

// TRANSITION EVENTS

sealed trait TransitionEvent extends DeliveryEvent {
  val transition: Transition
}

sealed trait TransitionChangeEvent extends DeliveryEvent {
  val transition: Transition
}

case class TransitionCreatedEvent(transition: Transition, delivery: Delivery) extends TransitionEvent

case class TransitionUpdatedEvent(transition: Transition, updated: Transition, delivery: Delivery) extends TransitionEvent

case class TransitionRemovedEvent(transition: Transition, delivery: Delivery) extends TransitionEvent

case class TransitionExecutedEvent(transition: Transition, delivery: Delivery, params: TransitionParams) extends TransitionEvent


// CONDITION EVENTS

sealed trait ConditionEvent extends TransitionEvent {
  val condition: Condition
}

case class ConditionUpdatedEvent(condition: Condition, transition: Transition, delivery: Delivery) extends ConditionEvent

case class ConditionSatisfiedEvent(condition: Condition, transition: Transition, delivery: Delivery) extends ConditionEvent

