package com.xebialabs.xlrelease.delivery.util

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.delivery._
import com.xebialabs.xlrelease.service.CiIdService

import scala.reflect.ClassTag

class DeliveryObjectFactory(ciIdService: CiIdService) {
  def deliveryId(): String = createUniqueId[Delivery](Delivery.DELIVERY_ROOT)

  def trackedItemId(deliveryId: String): String = createUniqueId[TrackedItem](deliveryId)

  def stageId(deliveryId: String): String = createUniqueId[Stage](deliveryId)

  def transitionId(stageId: String): String = createUniqueId[Transition](stageId)

  def conditionId(transitionId: String): String = createUniqueId[Condition](transitionId)

  def stageTrackedItemId(stageId: String): String = createUniqueId[StageTrackedItem](stageId)

  def createStageTrackedItem(stageId: String, itemId: String): StageTrackedItem = {
    val id = createUniqueId[StageTrackedItem](stageId)
    val stageTrackedItem = createCi[StageTrackedItem](id)
    stageTrackedItem.setTrackedItemId(itemId)
    stageTrackedItem
  }

  def newCiWithId[T <: ConfigurationItem : ClassTag](parentId: String): T = {
    createCi[T](createUniqueId[T](parentId))
  }

  def createUniqueId[T: ClassTag](parentId: String): String =
    ciIdService.getUniqueId(
      Type.valueOf(implicitly[ClassTag[T]].runtimeClass),
      parentId
    )

  private def createCi[T <: ConfigurationItem : ClassTag](id: String): T =
    Type.valueOf(implicitly[ClassTag[T]].runtimeClass)
      .getDescriptor
      .newInstance[T](id)
}
