/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.ConditionSatisfiedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.ConditionTrigger;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.UserTrigger;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@Service
@ScalaSignature(bytes="\u0006\u0005\t]h\u0001\u0002\u0012$\u00019B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u000b\t\u0004A\u0011A2\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!!0\u0001\t\u0003\ty\fC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAu\u0001\u0011\u0005\u00111\u001e\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/A\u0011B!\u000f\u0001#\u0003%\tAa\u000f\t\u000f\t=\u0003\u0001\"\u0001\u0003R!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005c\u0002A\u0011\u0001B:\u0011\u001d\u0011Y\b\u0001C\u0005\u0005{BqA!'\u0001\t\u0013\u0011Y\nC\u0004\u0003\"\u0002!IAa)\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"9!1\u001a\u0001\u0005\n\t5\u0007\"\u0003Bm\u0001E\u0005I\u0011\u0002B\u001e\u0011\u001d\u0011Y\u000e\u0001C\u0005\u0005;DqA!9\u0001\t\u0013\u0011\u0019O\u0001\rEK2Lg/\u001a:z\u000bb,7-\u001e;j_:\u001cVM\u001d<jG\u0016T!\u0001J\u0013\u0002\u000fM,'O^5dK*\u0011aeJ\u0001\tI\u0016d\u0017N^3ss*\u0011\u0001&K\u0001\nq2\u0014X\r\\3bg\u0016T!AK\u0016\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0017\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001yS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQa\u001d7gi)T\u0011AO\u0001\tOJL'P\u001f7fI&\u0011Ah\u000e\u0002\b\u0019><w-\u001b8h\u0003I!W\r\\5wKJL(+\u001a9pg&$xN]=\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005+\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\t\u0011\u0002\u0013\t\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"A\u0012%\u000e\u0003\u001dS!!Q\u0014\n\u0005%;%!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006qA/Y:l%\u0016\u0004xn]5u_JL\bC\u0001$M\u0013\tiuI\u0001\bUCN\\'+\u001a9pg&$xN]=\u0002\u0017\rL\u0017\nZ*feZL7-\u001a\t\u0003!Jk\u0011!\u0015\u0006\u0003I\u001dJ!aU)\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\tKZ,g\u000e\u001e\"vgB\u0011a+W\u0007\u0002/*\u0011\u0001lJ\u0001\u0007KZ,g\u000e^:\n\u0005i;&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u0011Q\fY\u0007\u0002=*\u0011qlJ\u0001\u0007C\u000e$xN]:\n\u0005\u0005t&a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0004eM\u001eD\u0017N[6\u0011\u0005\u0015\u0004Q\"A\u0012\t\u000bu:\u0001\u0019\u0001 \t\u000b\u0011;\u0001\u0019A#\t\u000b);\u0001\u0019A&\t\u000b9;\u0001\u0019A(\t\u000bQ;\u0001\u0019A+\t\u000bm;\u0001\u0019\u0001/)\u0005\u001di\u0007C\u00018z\u001b\u0005y'B\u00019r\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003eN\fqAZ1di>\u0014\u0018P\u0003\u0002uk\u0006)!-Z1og*\u0011ao^\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u00010A\u0002pe\u001eL!A_8\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001G7be.\u001cuN\u001c3ji&|g.Q:TCRL7OZ5fIR)Q0!\u0001\u0002\u001cA\u0011\u0001G`\u0005\u0003\u007fF\u0012A!\u00168ji\"9\u00111\u0001\u0005A\u0002\u0005\u0015\u0011A\u00033fY&4XM]=JIB!\u0011qAA\u000b\u001d\u0011\tI!!\u0005\u0011\u0007\u0005-\u0011'\u0004\u0002\u0002\u000e)\u0019\u0011qB\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\"M\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0011\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M\u0011\u0007C\u0004\u0002\u001e!\u0001\r!!\u0002\u0002\u0017\r|g\u000eZ5uS>t\u0017\n\u001a\u0015\u0004\u0011\u0005\u0005\u0002\u0003BA\u0012\u0003_i!!!\n\u000b\u0007A\f9C\u0003\u0003\u0002*\u0005-\u0012aB7fiJL7m\u001d\u0006\u0004\u0003[Y\u0013\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005E\u0012Q\u0005\u0002\u0006)&lW\rZ\u0001\u0019[\u0006tW/\u00197D_6\u0004H.\u001a;f)J\fgn]5uS>tGcB?\u00028\u0005e\u0012Q\b\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0011\u001d\tY$\u0003a\u0001\u0003\u000b\tA\u0002\u001e:b]NLG/[8o\u0013\u0012Dq!a\u0010\n\u0001\u0004\t\t%\u0001\u0006qCJ\fW.\u001a;feN\u0004B!a\u0011\u0002R5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0003g_Jl7O\u0003\u0003\u0002L\u00055\u0013A\u0001<2\u0015\r\tyeJ\u0001\u0004CBL\u0017\u0002BA*\u0003\u000b\u0012!cQ8na2,G/\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011\"!\t\u0002#\u0015DXmY;uKR\u0013\u0018M\\:ji&|g\u000eF\u0003~\u00037\ni\u0007C\u0004\u0002^)\u0001\r!a\u0018\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0005\u0003\u0002b\u0005%TBAA2\u0015\r1\u0013Q\r\u0006\u0004\u0003O:\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002l\u0005\r$A\u0003+sC:\u001c\u0018\u000e^5p]\"9\u0011q\u000e\u0006A\u0002\u0005E\u0014A\u00029be\u0006l7\u000f\u0005\u0003\u0002t\u0005]TBAA;\u0015\r\ti&J\u0005\u0005\u0003s\n)H\u0001\tUe\u0006t7/\u001b;j_:\u0004\u0016M]1ng\u0006\u0011\"/Z4jgR,'oU;cg\u000e\u0014\u0018NY3s)\u0019\ty(!\"\u0002\bB!\u0011\u0011MAA\u0013\u0011\t\u0019)a\u0019\u0003%M+(m]2sSB$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0003\u0007Y\u0001\u0019AA\u0003\u0011\u001d\tIi\u0003a\u0001\u0003\u0017\u000b!b];cg\u000e\u0014\u0018NY3s!\u0011\t\t'!$\n\t\u0005=\u00151\r\u0002\u000b'V\u00147o\u0019:jE\u0016\u0014\bfA\u0006\u0002\"\u0005)r-\u001a;Ue\u0006\u001c7.\u001a3Ji\u0016l')\u001f+ji2,GCBAL\u0003;\u000by\n\u0005\u0003\u0002b\u0005e\u0015\u0002BAN\u0003G\u00121\u0002\u0016:bG.,G-\u0013;f[\"9\u00111\u0001\u0007A\u0002\u0005\u0015\u0001bBAQ\u0019\u0001\u0007\u0011QA\u0001\nSR,W\u000eV5uY\u0016D3\u0001DA\u0011\u0003=9W\r\u001e+sC\u000e\\W\rZ%uK6\u001cH\u0003BAU\u0003s\u0003b!a+\u00026\u0006]UBAAW\u0015\u0011\ty+!-\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003g\u000bAA[1wC&!\u0011qWAW\u0005\u0011a\u0015n\u001d;\t\u000f\u0005\rQ\u00021\u0001\u0002\u0006!\u001aQ\"!\t\u0002#\r\u0014X-\u0019;f)J\f7m[3e\u0013R,W\u000e\u0006\u0004\u0002\u0018\u0006\u0005\u00171\u0019\u0005\b\u0003\u0007q\u0001\u0019AA\u0003\u0011\u001d\t)M\u0004a\u0001\u0003/\u000bA!\u001b;f[\"\u001aa\"!\t\u0002#U\u0004H-\u0019;f)J\f7m[3e\u0013R,W\u000e\u0006\u0004\u0002\u0018\u00065\u0017q\u001a\u0005\b\u0003\u0007y\u0001\u0019AA\u0003\u0011\u001d\t)m\u0004a\u0001\u0003/C3aDA\u0011\u0003E!W\r\\3uKR\u0013\u0018mY6fI&#X-\u001c\u000b\u0006{\u0006]\u0017\u0011\u001c\u0005\b\u0003\u0007\u0001\u0002\u0019AA\u0003\u0011\u001d\tY\u000e\u0005a\u0001\u0003\u000b\ta!\u001b;f[&#\u0007f\u0001\t\u0002\"\u0005\u0011B-Z:d_B,GK]1dW\u0016$\u0017\n^3n)\u0015i\u00181]As\u0011\u001d\t\u0019!\u0005a\u0001\u0003\u000bAq!a7\u0012\u0001\u0004\t)\u0001K\u0002\u0012\u0003C\t!C]3tG>\u0004X\r\u0016:bG.,G-\u0013;f[R)Q0!<\u0002p\"9\u00111\u0001\nA\u0002\u0005\u0015\u0001bBAn%\u0001\u0007\u0011Q\u0001\u0015\u0004%\u0005\u0005\u0012\u0001\u0006:fO&\u001cH/\u001a:Ue\u0006\u001c7.\u001a3Ji\u0016l7\u000fF\u0004~\u0003o\fIPa\u0004\t\u000f\u0005\r1\u00031\u0001\u0002\u0006!9\u00111`\nA\u0002\u0005u\u0018!B5uK6\u001c\bCBA\u0000\u0005\u0013\t)A\u0004\u0003\u0003\u0002\t\u0015a\u0002BA\u0006\u0005\u0007I\u0011AM\u0005\u0004\u0005\u000f\t\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u0017\u0011iAA\u0002TKFT1Aa\u00022\u0011\u001d\u0011\tb\u0005a\u0001\u0003\u000b\tQB\u001a:p[J+G.Z1tK&#\u0007fA\n\u0002\"\u00059R.\u0019:l)J\f7m[3e\u0013R,Wn]%o'R\fw-\u001a\u000b\u000f\u0003S\u0013IBa\u0007\u0003 \t\u0005\"1\u0006B\u0017\u0011\u001d\t\u0019\u0001\u0006a\u0001\u0003\u000bAqA!\b\u0015\u0001\u0004\t)!A\u0004ti\u0006<W-\u00133\t\u000f\u0005mH\u00031\u0001\u0002~\"9!1\u0005\u000bA\u0002\t\u0015\u0012AB:uCR,8\u000f\u0005\u0003\u0002b\t\u001d\u0012\u0002\u0002B\u0015\u0003G\u0012\u0011\u0003\u0016:bG.,G-\u0013;f[N#\u0018\r^;t\u0011\u001d\u0011\t\u0002\u0006a\u0001\u0003\u000bA\u0011Ba\f\u0015!\u0003\u0005\rA!\r\u0002\u001fA\u0014XmY3eS:<7\u000b^1hKN\u00042\u0001\rB\u001a\u0013\r\u0011)$\r\u0002\b\u0005>|G.Z1oQ\r!\u0012\u0011E\u0001\"[\u0006\u00148\u000e\u0016:bG.,G-\u0013;f[NLen\u0015;bO\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0005{QCA!\r\u0003@-\u0012!\u0011\t\t\u0005\u0005\u0007\u0012Y%\u0004\u0002\u0003F)!!q\tB%\u0003%)hn\u00195fG.,GM\u0003\u0002qc%!!Q\nB#\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017g.L\u0007\u000f\u0016:bG.,G-\u0013;f[&s7\u000b^1hKR9QPa\u0015\u0003V\t]\u0003bBA\u0002-\u0001\u0007\u0011Q\u0001\u0005\b\u0005;1\u0002\u0019AA\u0003\u0011\u001d\tYN\u0006a\u0001\u0003\u000bA3AFA\u0011\u0003]\u0011Xm]3u)J\f7m[3e\u0013R,W.\u00138Ti\u0006<W\rF\u0004~\u0005?\u0012\tGa\u0019\t\u000f\u0005\rq\u00031\u0001\u0002\u0006!9!QD\fA\u0002\u0005\u0015\u0001bBAn/\u0001\u0007\u0011Q\u0001\u0015\u0004/\u0005\u0005\u0012!D2p[BdW\r^3Ti\u0006<W\rF\u0003~\u0005W\u0012i\u0007C\u0004\u0002\u0004a\u0001\r!!\u0002\t\u000f\tu\u0001\u00041\u0001\u0002\u0006!\u001a\u0001$!\t\u0002\u0017I,w\u000e]3o'R\fw-\u001a\u000b\u0006{\nU$q\u000f\u0005\b\u0003\u0007I\u0002\u0019AA\u0003\u0011\u001d\u0011i\"\u0007a\u0001\u0003\u000bA3!GA\u0011\u0003-!wnV5uQN#\u0018mZ3\u0015\u000fu\u0014yH!!\u0003\u0004\"9\u00111\u0001\u000eA\u0002\u0005\u0015\u0001b\u0002B\u000f5\u0001\u0007\u0011Q\u0001\u0005\b\u0005\u000bS\u0002\u0019\u0001BD\u0003\t1g\u000e\u0005\u00051\u0005\u0013\u0013iIa%~\u0013\r\u0011Y)\r\u0002\n\rVt7\r^5p]J\u00022!\u001aBH\u0013\r\u0011\tj\t\u0002\u0015\t\u0016d\u0017N^3ssN#\u0018\r^3NC:\fw-\u001a:\u0011\t\u0005\u0005$QS\u0005\u0005\u0005/\u000b\u0019GA\u0003Ti\u0006<W-\u0001\bqe>\u001cWm]:DQ\u0006tw-Z:\u0015\u0007u\u0014i\nC\u0004\u0003 n\u0001\rA!$\u0002\u000f5\fg.Y4fe\u0006q\u0002/\u0019:uSRLwN\\%uK6\u001c()_#ySN$\u0018N\\4B]\u0012tUm\u001e\u000b\u0007\u0005K\u0013iK!.\u0011\u000fA\u00129Ka+\u0003,&\u0019!\u0011V\u0019\u0003\rQ+\b\u000f\\33!\u0019\tyP!\u0003\u0002\u0018\"1a\u0005\ba\u0001\u0005_\u0003B!!\u0019\u00032&!!1WA2\u0005!!U\r\\5wKJL\bb\u0002B\\9\u0001\u0007!\u0011X\u0001\u000fSR,W.\u00133PeRKG\u000f\\3t!\u0019\t9Aa/\u0002\u0006%!!QXA\r\u0005\r\u0019V\r^\u0001\u001dC\u0012$'+\u001a7fCN,\u0017\n\u001a+p\r&\u00148\u000f^(qK:\u001cF/Y4f)\u001di(1\u0019Bc\u0005\u000fDaAJ\u000fA\u0002\t=\u0006bBAn;\u0001\u0007\u0011Q\u0001\u0005\b\u0005\u0013l\u0002\u0019AA\u0003\u0003%\u0011X\r\\3bg\u0016LE-\u0001\u0007wC2LG-\u0019;f\u0013R,W\u000eF\u0004~\u0005\u001f\u0014\tN!6\t\r\u0019r\u0002\u0019\u0001BX\u0011\u001d\u0011\u0019N\ba\u0001\u0003/\u000b1\u0002\u001e:bG.,G-\u0013;f[\"I!q\u001b\u0010\u0011\u0002\u0003\u0007!\u0011G\u0001\u0010m\u0006d\u0017\u000eZ1uK6+WNY3sg\u00061b/\u00197jI\u0006$X-\u0013;f[\u0012\"WMZ1vYR$3'\u0001\bwC2LG-\u0019;f\u001b\u0016l'-\u001a:\u0015\u0007u\u0014y\u000eC\u0004\u0003J\u0002\u0002\r!!\u0002\u0002\u0019Y\fG.\u001b3bi\u0016$\u0016m]6\u0015\u0007u\u0014)\u000fC\u0004\u0003h\u0006\u0002\r!!\u0002\u0002\rQ\f7o[%eQ\r\u0001!1\u001e\t\u0005\u0005[\u0014\u00190\u0004\u0002\u0003p*\u0019!\u0011_;\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003v\n=(aB*feZL7-\u001a")
public class DeliveryExecutionService
implements Logging {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryExecutionService deliveryExecutionService = this;
        synchronized (deliveryExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void markConditionAsSatisfied(String deliveryId, String conditionId) {
        this.logger().debug((Function0 & Serializable)() -> "Marking condition '" + conditionId + "' as satisfied");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Transition transition = delivery.getTransitionByIdOrTitle(DeliveryUtils$.MODULE$.transitionIdFrom(conditionId));
        Condition condition = transition.getConditionById(conditionId);
        Stage stage = transition.getStage();
        Condition root = transition.getRootCondition();
        Buffer changes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(root.markAsSatisfied(conditionId, new Date())).asScala().$minus$eq((Object)root);
        if (!delivery.isTemplate() && changes.nonEmpty()) {
            this.deliveryRepository.update(delivery);
            ((IterableOnceOps)changes.map((Function1 & Serializable)x$1 -> new ConditionSatisfiedEvent((Condition)x$1, transition, delivery))).foreach((Function1 & Serializable)x$1 -> {
                this.eventBus.publish(x$1);
                return BoxedUnit.UNIT;
            });
            if (root.isSatisfied() && stage.isOpen()) {
                scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(delivery.getStageGroupOfStage(stage)).asScala().toSeq();
                Set completedItems = ((IterableOnceOps)DeliveryUtils$.MODULE$.getItemsCompletedInAllStages(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped()))).toSeq(), stages).map((Function1 & Serializable)x$3 -> x$3.getId())).toSet();
                Seq transitionedItems = (Seq)OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(delivery.findNextStage(stage))).map((Function1 & Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$4.getItems()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTrackedItemId())).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
                Set toTransition = (Set)completedItems.$minus$minus((IterableOnce)transitionedItems);
                this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)toTransition, true, new ConditionTrigger(conditionId, condition.toString())));
                return;
            }
            return;
        }
    }

    @Timed
    public void manualCompleteTransition(String deliveryId, String transitionId, CompleteTransition parameters) {
        this.logger().debug((Function0 & Serializable)() -> "Manual transition '" + transitionId + "' on delivery '" + deliveryId + "' with params '" + parameters + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByTransitionId(transitionId);
        Transition transition = stage.getTransition();
        Checks.checkArgument((boolean)stage.isOpen(), (String)("Transition already completed on stage '" + stage.getTitle() + "'"), (Object[])new Object[0]);
        Checks.checkNotNull((Object)parameters.getTransitionItems(), (String)"Transition items");
        Set transitionItems = CollectionConverters$.MODULE$.ListHasAsScala(parameters.getTransitionItems()).asScala().toSet();
        transitionItems.foreach((Function1 & Serializable)itemId -> {
            DeliveryExecutionService.$anonfun$manualCompleteTransition$2(delivery, stage, itemId);
            return BoxedUnit.UNIT;
        });
        this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)transitionItems, parameters.isCloseStages(), new UserTrigger(Permissions.getAuthenticatedUserName())));
    }

    private void executeTransition(Transition transition, TransitionParams params) {
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(params.delivery(), this.ciIdService);
        manager.handleTransition(transition, params);
        this.processChanges(manager);
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.logger().debug((Function0 & Serializable)() -> "Registering subscriber '" + subscriber + "' to delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateTask(subscriber.sourceId());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        SubscriptionResult result = manager.registerSubscriber(subscriber);
        this.processChanges(manager);
        return result;
    }

    @Timed
    public TrackedItem getTrackedItemByTitle(String deliveryId, String itemTitle) {
        return this.deliveryRepository.read(deliveryId).getItemByIdOrTitle(itemTitle);
    }

    @Timed
    public java.util.List<TrackedItem> getTrackedItems(String deliveryId) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        return delivery.getTrackedItems();
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> "Creating new tracked item '" + item.getTitle() + "' on delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem addedItem = manager.addTrackedItem(item);
        this.processChanges(manager);
        return addedItem;
    }

    @Timed
    public TrackedItem updateTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> "Updating tracked item with id '" + item.getId() + "' on delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem updatedItem = manager.updateTrackedItem(item);
        this.processChanges(manager);
        return updatedItem;
    }

    @Timed
    public void deleteTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> "Removing tracked item '" + itemId + "' from delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.deleteTrackedItem(itemId);
        this.processChanges(manager);
    }

    @Timed
    public void descopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> "Descoping tracked item '" + itemId + "' from delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.descopeItems((scala.collection.immutable.Seq<TrackedItem>)new .colon.colon((Object)delivery.getItemByIdOrTitle(itemId), (List)Nil$.MODULE$));
        this.processChanges(manager);
    }

    @Timed
    public void rescopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> "Rescoping tracked item '" + itemId + "' from delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.rescopeItems((scala.collection.immutable.Seq<TrackedItem>)new .colon.colon((Object)delivery.getItemByIdOrTitle(itemId), (List)Nil$.MODULE$));
        this.processChanges(manager);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, scala.collection.immutable.Seq<String> items, String fromReleaseId) {
        this.logger().debug((Function0 & Serializable)() -> "Registering new tracked items [" + items.mkString(", ") + "] on delivery '" + deliveryId + "' from release '" + fromReleaseId + "'");
        this.validateMember(fromReleaseId);
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> tuple2 = this.partitionItemsByExistingAndNew(delivery, (Set<String>)items.toSet());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq newItems = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingItems, (Object)newItems);
        scala.collection.immutable.Seq existingItems2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq newItems2 = (scala.collection.immutable.Seq)tuple22._2();
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        delivery.addReleaseId(fromReleaseId);
        existingItems2.foreach((Function1 & Serializable)existingItem -> {
            DeliveryExecutionService.$anonfun$registerTrackedItems$2(this, fromReleaseId, delivery, existingItem);
            return BoxedUnit.UNIT;
        });
        newItems2.foreach((Function1 & Serializable)item -> {
            DeliveryExecutionService.$anonfun$registerTrackedItems$3(this, fromReleaseId, deliveryId, delivery, manager, item);
            return BoxedUnit.UNIT;
        });
        this.processChanges(manager);
    }

    @Timed
    public java.util.List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageId, scala.collection.immutable.Seq<String> items, TrackedItemStatus status, String fromReleaseId, boolean precedingStages) {
        this.logger().debug((Function0 & Serializable)() -> "Marking tracked items [" + items.mkString(", ") + "] as completed on stage '" + stageId + "' on delivery '" + deliveryId + "'" + (fromReleaseId != null ? "from '" + fromReleaseId + "'" : ""));
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)((IterableOps)items.distinct()).map((Function1 & Serializable)idOrTitle -> {
            LazyRef lowercaseTitle$lzy = new LazyRef();
            return (TrackedItem)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().find((Function1 & Serializable)trackedItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$markTrackedItemsInStage$3(idOrTitle, lowercaseTitle$lzy, trackedItem))).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Tracked item '" + idOrTitle + "' does not exist in delivery '" + delivery.getTitle() + "'", new Object[0]);
            });
        });
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        if (fromReleaseId != null) {
            this.validateMember(fromReleaseId);
            existingItems.foreach((Function1 & Serializable)x$9 -> {
                manager.addReleaseToItem(x$9, fromReleaseId);
                return BoxedUnit.UNIT;
            });
        }
        scala.collection.immutable.Seq<TrackedItem> markedItems = manager.markTrackedItemsInStage((scala.collection.immutable.Seq<TrackedItem>)existingItems, stage, status, precedingStages, fromReleaseId);
        this.processChanges(manager);
        return CollectionConverters$.MODULE$.SeqHasAsJava(markedItems).asJava();
    }

    public boolean markTrackedItemsInStage$default$6() {
        return false;
    }

    @Timed
    public void skipTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> "Skipping tracked item '" + itemId + "' on stage '" + stageId + "' in delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.skipTrackedItemInStage(trackedItem, stage);
        this.processChanges(manager);
    }

    @Timed
    public void resetTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> "Resetting tracked item '" + itemId + "' on stage '" + stageId + "' in delivery '" + deliveryId + "'");
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.resetTrackedItemInStage(trackedItem, stage, manager.resetTrackedItemInStage$default$3());
        this.processChanges(manager);
    }

    @Timed
    public void completeStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> "Marking stage '" + stageId + "' as completed");
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.completeStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void reopenStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> "Marking stage '" + stageId + "' as open again");
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.reopenStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    private void doWithStage(String deliveryId, String stageId, Function2<DeliveryStateManager, Stage, BoxedUnit> fn) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        fn.apply((Object)manager, (Object)stage);
        this.processChanges(manager);
    }

    private void processChanges(DeliveryStateManager manager) {
        manager.completeDeliveryIfNecessary();
        this.deliveryRepository.update(manager.delivery());
        manager.getMessages().foreach((Function1 & Serializable)x$10 -> {
            DeliveryExecutionService.$anonfun$processChanges$1(this, x$10);
            return BoxedUnit.UNIT;
        });
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> partitionItemsByExistingAndNew(Delivery delivery, Set<String> itemIdOrTitles) {
        Map idsByTitles = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)i.getTitle().toLowerCase(), (Object)Ids.getName((String)i.getId())))).toSeq());
        Map itemsByIds = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)Ids.getName((String)i.getId()), i))).toSeq());
        return (Tuple2)itemIdOrTitles.foldRight((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().empty()), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String idOrTitle = (String)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    scala.collection.immutable.Seq existingAcc = (scala.collection.immutable.Seq)tuple22._1();
                    scala.collection.immutable.Seq newAcc = (scala.collection.immutable.Seq)tuple22._2();
                    return (Tuple2)itemsByIds.get((Object)Ids.getName((String)idOrTitle)).orElse((Function0 & Serializable)() -> idsByTitles.get((Object)idOrTitle.toLowerCase()).flatMap((Function1 & Serializable)key -> itemsByIds.get(key))).fold((Function0 & Serializable)() -> {
                        TrackedItem trackedItem = new TrackedItem(idOrTitle);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingAcc), newAcc.$plus$colon((Object)trackedItem));
                    }, (Function1 & Serializable)item -> {
                        TrackedItem trackedItem = item;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(existingAcc.$plus$colon((Object)trackedItem)), (Object)newAcc);
                    });
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void addReleaseIdToFirstOpenStage(Delivery delivery, String itemId, String releaseId) {
        OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(delivery.findFirstOpenStage())).foreach((Function1 & Serializable)stage -> {
            DeliveryExecutionService.$anonfun$addReleaseIdToFirstOpenStage$1(itemId, releaseId, stage);
            return BoxedUnit.UNIT;
        });
    }

    private void validateItem(Delivery delivery, TrackedItem trackedItem, boolean validateMembers) {
        LazyRef lowerCaseTitle$lzy = new LazyRef();
        Checks.checkNotNull((Object)trackedItem, (String)"Tracked item");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)trackedItem.getTitle()), (String)"Tracked item title must be set", (Object[])new Object[0]);
        Checks.checkArgument((trackedItem.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!trackedItem.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)("Title must not contain reserved character " + DbConstants$.MODULE$.ESCAPE_CHAR()), (Object[])new Object[0]);
        Checks.checkArgument((!CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().exists((Function1 & Serializable)existing -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$validateItem$1(trackedItem, lowerCaseTitle$lzy, existing))) ? 1 : 0) != 0, (String)("A tracked item with title '" + trackedItem.getTitle() + "' already exists"), (Object[])new Object[0]);
        if (trackedItem.getReleaseIds() == null) {
            trackedItem.setReleaseIds(new HashSet());
        }
        if (validateMembers) {
            trackedItem.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
            return;
        }
    }

    private boolean validateItem$default$3() {
        return true;
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)("Provided ID '" + releaseId + "' must be a valid release ID"), (Object[])new Object[0]);
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        Checks.checkArgument((releaseStatus != null ? 1 : 0) != 0, (String)("Provided ID '" + releaseId + "' must exist in the database"), (Object[])new Object[0]);
        ReleaseStatus releaseStatus2 = releaseStatus;
        ReleaseStatus releaseStatus3 = ReleaseStatus.TEMPLATE;
        Checks.checkArgument(((releaseStatus2 == null ? releaseStatus3 != null : !releaseStatus2.equals(releaseStatus3)) ? 1 : 0) != 0, (String)("Provided entity '" + releaseId + "' must be a release"), (Object[])new Object[0]);
    }

    private void validateTask(String taskId) {
        Checks.checkArgument((boolean)Ids.isTaskId((String)taskId), (String)("Provided ID '" + taskId + "' must be a valid task ID"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(taskId), (String)("Provided task ID '" + taskId + "' must exist in the database"), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$manualCompleteTransition$3(String itemId$1, Stage x$6) {
        return x$6.getItemById(itemId$1).getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$manualCompleteTransition$2(Delivery delivery$2, Stage stage$1, String itemId) {
        TrackedItem trackedItem = delivery$2.getItemByIdOrTitle(itemId);
        Checks.checkArgument((!trackedItem.isDescoped() ? 1 : 0) != 0, (String)("De-scoped tracked item '" + trackedItem.getTitle() + "' can not be transitioned"), (Object[])new Object[0]);
        Buffer notDoneInStages = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery$2.getStagesBefore(stage$1)).asScala().$colon$plus((Object)stage$1)).filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$manualCompleteTransition$3(itemId, x$6)));
        Checks.checkArgument((boolean)notDoneInStages.isEmpty(), (String)("Tracked item '" + trackedItem.getTitle() + "' must be completed or skipped in stage '" + ((IterableOnceOps)notDoneInStages.map((Function1 & Serializable)x$7 -> x$7.getTitle())).mkString("', '") + "' in order to transition to the next stage"), (Object[])new Object[0]);
    }

    public static final /* synthetic */ void $anonfun$registerTrackedItems$2(DeliveryExecutionService $this, String fromReleaseId$1, Delivery delivery$3, TrackedItem existingItem) {
        existingItem.addReleaseId(fromReleaseId$1);
        $this.addReleaseIdToFirstOpenStage(delivery$3, existingItem.getId(), fromReleaseId$1);
    }

    public static final /* synthetic */ void $anonfun$registerTrackedItems$3(DeliveryExecutionService $this, String fromReleaseId$1, String deliveryId$8, Delivery delivery$3, DeliveryStateManager manager$1, TrackedItem item) {
        item.addReleaseId(fromReleaseId$1);
        $this.logger().debug((Function0 & Serializable)() -> "Creating new tracked item '" + item.getTitle() + "' on delivery '" + deliveryId$8 + "'");
        $this.validateItem(delivery$3, item, false);
        manager$1.addTrackedItem(item);
        $this.addReleaseIdToFirstOpenStage(delivery$3, item.getId(), fromReleaseId$1);
    }

    private static final /* synthetic */ String lowercaseTitle$lzycompute$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        String string;
        LazyRef lazyRef = lowercaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : (String)lowercaseTitle$lzy$1.initialize((Object)idOrTitle$1.toLowerCase());
        }
        return string;
    }

    private static final String lowercaseTitle$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        if (lowercaseTitle$lzy$1.initialized()) {
            return (String)lowercaseTitle$lzy$1.value();
        }
        return DeliveryExecutionService.lowercaseTitle$lzycompute$1(lowercaseTitle$lzy$1, idOrTitle$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$3(String idOrTitle$1, LazyRef lowercaseTitle$lzy$1, TrackedItem trackedItem) {
        String string = Ids.getName((String)trackedItem.getId());
        String string2 = Ids.getName((String)idOrTitle$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trackedItem.getTitle().toLowerCase();
        String string4 = DeliveryExecutionService.lowercaseTitle$1(lowercaseTitle$lzy$1, idOrTitle$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$processChanges$1(DeliveryExecutionService $this, String x$10) {
        $this.logger().info((Function0 & Serializable)() -> x$10);
    }

    public static final /* synthetic */ void $anonfun$addReleaseIdToFirstOpenStage$1(String itemId$7, String releaseId$1, Stage stage) {
        OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(stage.findItemById(itemId$7))).foreach((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.addReleaseId(releaseId$1)));
    }

    private static final /* synthetic */ String lowerCaseTitle$lzycompute$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        String string;
        LazyRef lazyRef = lowerCaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : (String)lowerCaseTitle$lzy$1.initialize((Object)trackedItem$1.getTitle().toLowerCase());
        }
        return string;
    }

    private static final String lowerCaseTitle$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        if (lowerCaseTitle$lzy$1.initialized()) {
            return (String)lowerCaseTitle$lzy$1.value();
        }
        return DeliveryExecutionService.lowerCaseTitle$lzycompute$1(lowerCaseTitle$lzy$1, trackedItem$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateItem$1(TrackedItem trackedItem$1, LazyRef lowerCaseTitle$lzy$1, TrackedItem existing) {
        String string = existing.getTitle().toLowerCase();
        String string2 = DeliveryExecutionService.lowerCaseTitle$1(lowerCaseTitle$lzy$1, trackedItem$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = existing.getId();
        String string4 = trackedItem$1.getId();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    @Autowired
    public DeliveryExecutionService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, TaskRepository taskRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, ReleaseActorService releaseActorService) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

