import React, { useEffect, useState } from 'react';
import { DotAutoComplete } from '@digital-ai/dot-components';
import { useAppSelector, useAppDispatch } from '../../../../../../../../../../../core/xlr-ui/app/js/hooks';

import { TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { deliveryTasks, getDeliveryTasksState } from '../ducks/delivery-tasks.reducer';
import { Delivery } from '../types';
import { AUTOCOMPLETE_MAX_HEIGHT } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/common/constants';
import { IdAutoCompleteOption } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/types';
import { useCleanValueWhenChanged } from '../helper';
import { isVariable } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/helper/variables.helper';

const { searchPatterns } = deliveryTasks.actions;

export const Pattern = ({ disabled, onChange, property, task }: TaskInputCommonProps) => {
    const dispatch = useAppDispatch();
    const { patterns } = useAppSelector(getDeliveryTasksState);
    const deliveryId = task.inputProperties?.deliveryId as string;
    const patternId = task.inputProperties?.patternId as string;
    const [patternsAutocomplete, setPatternsAutocomplete] = useState<Array<IdAutoCompleteOption>>([]);
    const [autocompleteValue, setAutocompleteValue] = useState<IdAutoCompleteOption | null>(null);
    const isPatternEnabled = isVariable(deliveryId);

    useCleanValueWhenChanged(onChange, [deliveryId]);

    useEffect(() => {
        const deliveryIdAsVariable = isVariable(deliveryId);
        if (deliveryId && deliveryIdAsVariable) {
            dispatch(searchPatterns());
        }
    }, [deliveryId]);

    useEffect(() => {
        if (patterns) {
            setPatternsAutocomplete(
                patterns.map((pattern: Delivery) => ({
                    id: pattern.id,
                    title: pattern.title,
                })),
            );
        }
    }, [patterns]);

    useEffect(() => {
        if (patternsAutocomplete) {
            setAutocompleteValue(patternsAutocomplete.find((p) => p.id === patternId) || null);
        }
    }, [patternsAutocomplete, patternId]);

    const onHandleChange = (v: IdAutoCompleteOption) => {
        onChange(v?.id);
    };

    return (
        <div className="task-input-property">
            <DotAutoComplete
                group={false}
                helperText={property.description}
                inputId={property.name}
                key={autocompleteValue?.title}
                label={property.label}
                maxHeight={AUTOCOMPLETE_MAX_HEIGHT}
                multiple={false}
                onChange={(_e, value) => onHandleChange(value as IdAutoCompleteOption)}
                options={patternsAutocomplete}
                persistentLabel={true}
                readOnly={disabled || !isPatternEnabled}
                required={property.required}
                value={autocompleteValue}
            />
        </div>
    );
};
