package com.xebialabs.xlrelease.delivery.transition.condition.time

import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent
import com.xebialabs.xlrelease.domain.delivery.conditions.TimeCondition
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import org.apache.commons.lang3.time.DateUtils.addHours
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@EventListener
@Component
class TimeConditionConversionHandler {

  @Subscribe
  def onDeliveryCreating(event: DeliveryCreatingEvent): Unit = {
    val delivery = event.delivery
    val timeConditions = delivery.getTransitions.asScala.flatMap(_.getConditionsOfType(classOf[TimeCondition]).asScala)

    timeConditions.foreach { condition =>
      if (condition.getFixedDate == null && condition.getStartDateOffset != null && condition.getStartDateOffset > 0) {
        condition.setFixedDate(addHours(delivery.getStartDate, condition.getStartDateOffset))
      }
    }
  }

}
