/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.delivery.events.DeliveryCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.delivery.events.ItemAvailableEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemDescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemResetEvent;
import com.xebialabs.xlrelease.delivery.events.ItemSkippedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemTransitionApprovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.StageReopenedEvent;
import com.xebialabs.xlrelease.delivery.events.StageStartedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionExecutedEvent;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.TransitionEvaluator$;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.TransitionResult;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.StageTrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Date;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}t!\u0002\u00192\u0011\u0003ad!\u0002 2\u0011\u0003y\u0004\"\u0002$\u0002\t\u00039\u0005\"\u0002%\u0002\t\u0003Ie\u0001\u0002 2\u0001-C\u0001\u0002\u000e\u0003\u0003\u0006\u0004%\t\u0001\u0014\u0005\t)\u0012\u0011\t\u0011)A\u0005\u001b\"AQ\u000b\u0002B\u0001B\u0003%a\u000bC\u0003G\t\u0011\u0005A\fC\u0004`\t\t\u0007I\u0011\u00021\t\r9$\u0001\u0015!\u0003b\u0011\u001dyGA1A\u0005\nADa! \u0003!\u0002\u0013\t\b\"\u0002@\u0005\t\u0003y\bbBA\n\t\u0011\u0005\u0011Q\u0003\u0005\b\u00033!A\u0011AA\u000e\u0011\u001d\t9\u0003\u0002C\u0001\u0003SAq!!\f\u0005\t\u0003\ty\u0003C\u0004\u0002<\u0011!\t!!\u0010\t\u000f\u0005\u0015C\u0001\"\u0001\u0002H!9\u0011\u0011\f\u0003\u0005\u0002\u0005m\u0003bBA/\t\u0011\u0005\u0011q\f\u0005\n\u0003\u001b#\u0011\u0013!C\u0001\u0003\u001fC\u0011\"!*\u0005#\u0003%\t!a*\t\u000f\u0005-F\u0001\"\u0001\u0002.\"9\u0011q\u0017\u0003\u0005\u0002\u0005e\u0006\"CAa\tE\u0005I\u0011AAT\u0011\u001d\t\u0019\r\u0002C\u0001\u0003\u000bDq!!3\u0005\t\u0003\tY\rC\u0004\u0002P\u0012!\t!!5\t\u000f\u0005UG\u0001\"\u0001\u0002X\"9\u00111\u001c\u0003\u0005\u0002\u0005u\u0007bBAr\t\u0011\u0005\u0011Q\u001d\u0005\b\u0003O$A\u0011AAu\u0011%\t\t\u0010BI\u0001\n\u0003\t9\u000bC\u0004\u0002t\u0012!\t!!>\t\u000f\u0005}H\u0001\"\u0001\u0003\u0002!9\u0011q \u0003\u0005\n\tm\u0001b\u0002B\u0016\t\u0011%!Q\u0006\u0005\n\u0005k!\u0011\u0013!C\u0005\u0005oAqAa\u000f\u0005\t\u0013\u0011i\u0004C\u0004\u0003N\u0011!IAa\u0014\t\u000f\tEC\u0001\"\u0003\u0003T!9!q\u000b\u0003\u0005\n\te\u0003b\u0002B/\t\u0011%\u0011Q\u001d\u0005\b\u0005?\"A\u0011\u0002B1\u0011\u001d\u0011)\u0007\u0002C\u0005\u0005OBqA!\u001c\u0005\t\u0013\t)/\u0001\u000bEK2Lg/\u001a:z'R\fG/Z'b]\u0006<WM\u001d\u0006\u0003eM\nqa]3sm&\u001cWM\u0003\u00025k\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u00027o\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003qe\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\n1aY8n\u0007\u0001\u0001\"!P\u0001\u000e\u0003E\u0012A\u0003R3mSZ,'/_*uCR,W*\u00198bO\u0016\u00148CA\u0001A!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001P\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0015\n=$\u0011\u000f\t\u0003{\u0011\u0019\"\u0001\u0002!\u0016\u00035\u0003\"A\u0014*\u000e\u0003=S!\u0001\u000e)\u000b\u0005E+\u0014A\u00023p[\u0006Lg.\u0003\u0002T\u001f\nAA)\u001a7jm\u0016\u0014\u00180A\u0005eK2Lg/\u001a:zA\u00059a-Y2u_JL\bCA,[\u001b\u0005A&BA-4\u0003\u0011)H/\u001b7\n\u0005mC&!\u0006#fY&4XM]=PE*,7\r\u001e$bGR|'/\u001f\u000b\u0004\u0015vs\u0006\"\u0002\u001b\t\u0001\u0004i\u0005\"B+\t\u0001\u00041\u0016AB3wK:$8/F\u0001b!\r\u0011w-[\u0007\u0002G*\u0011A-Z\u0001\b[V$\u0018M\u00197f\u0015\t1')\u0001\u0006d_2dWm\u0019;j_:L!\u0001[2\u0003\r\t+hMZ3s!\tQG.D\u0001l\u0015\ty6'\u0003\u0002nW\niA)\u001a7jm\u0016\u0014\u00180\u0012<f]R\fq!\u001a<f]R\u001c\b%\u0001\u0005nKN\u001c\u0018mZ3t+\u0005\t\bc\u00012heB\u00111O\u001f\b\u0003ib\u0004\"!\u001e\"\u000e\u0003YT!a^\u001e\u0002\rq\u0012xn\u001c;?\u0013\tI()\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u0014aa\u0015;sS:<'BA=C\u0003%iWm]:bO\u0016\u001c\b%A\u0005hKR,e/\u001a8ugV\u0011\u0011\u0011\u0001\t\u0006\u0003\u0007\ti!\u001b\b\u0005\u0003\u000b\tIAD\u0002v\u0003\u000fI\u0011aQ\u0005\u0004\u0003\u0017\u0011\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tB\u0001\u0003MSN$(bAA\u0006\u0005\u0006Yq-\u001a;NKN\u001c\u0018mZ3t+\t\t9\u0002E\u0003\u0002\u0004\u00055!/\u0001\bbI\u0012$&/Y2lK\u0012LE/Z7\u0015\t\u0005u\u00111\u0005\t\u0004\u001d\u0006}\u0011bAA\u0011\u001f\nYAK]1dW\u0016$\u0017\n^3n\u0011\u001d\t)c\u0004a\u0001\u0003;\tA!\u001b;f[\u0006\tR\u000f\u001d3bi\u0016$&/Y2lK\u0012LE/Z7\u0015\t\u0005u\u00111\u0006\u0005\b\u0003K\u0001\u0002\u0019AA\u000f\u0003E!W\r\\3uKR\u0013\u0018mY6fI&#X-\u001c\u000b\u0005\u0003c\t9\u0004E\u0002B\u0003gI1!!\u000eC\u0005\u0011)f.\u001b;\t\r\u0005e\u0012\u00031\u0001s\u0003\u0019IG/Z7JI\u0006\u0001\u0012\r\u001a3SK2,\u0017m]3U_&#X-\u001c\u000b\u0007\u0003c\ty$!\u0011\t\u000f\u0005\u0015\"\u00031\u0001\u0002\u001e!1\u00111\t\nA\u0002I\f\u0011B]3mK\u0006\u001cX-\u00133\u0002%I,w-[:uKJ\u001cVOY:de&\u0014WM\u001d\u000b\u0005\u0003\u0013\ny\u0005E\u0002O\u0003\u0017J1!!\u0014P\u0005I\u0019VOY:de&\u0004H/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\u0005E3\u00031\u0001\u0002T\u0005Q1/\u001e2tGJL'-\u001a:\u0011\u00079\u000b)&C\u0002\u0002X=\u0013!bU;cg\u000e\u0014\u0018NY3s\u0003\u0015\u0019H/\u0019:u)\u0005i\u0015aF7be.$&/Y2lK\u0012LE/Z7t\u0013:\u001cF/Y4f)1\t\t'a\u001a\u0002l\u0005U\u0014qPAE!\u0019\t\u0019!a\u0019\u0002\u001e%!\u0011QMA\t\u0005\r\u0019V-\u001d\u0005\b\u0003S*\u0002\u0019AA1\u0003\u0015IG/Z7t\u0011\u001d\ti'\u0006a\u0001\u0003_\nQa\u001d;bO\u0016\u00042ATA9\u0013\r\t\u0019h\u0014\u0002\u0006'R\fw-\u001a\u0005\b\u0003o*\u0002\u0019AA=\u0003\u0019\u0019H/\u0019;vgB\u0019a*a\u001f\n\u0007\u0005utJA\tUe\u0006\u001c7.\u001a3Ji\u0016l7\u000b^1ukND\u0011\"!!\u0016!\u0003\u0005\r!a!\u0002\u001fA\u0014XmY3eS:<7\u000b^1hKN\u00042!QAC\u0013\r\t9I\u0011\u0002\b\u0005>|G.Z1o\u0011!\tY)\u0006I\u0001\u0002\u0004\u0011\u0018!\u00044s_6\u0014V\r\\3bg\u0016LE-A\u0011nCJ\\GK]1dW\u0016$\u0017\n^3ng&s7\u000b^1hK\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0012*\"\u00111QAJW\t\t)\n\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\u0013Ut7\r[3dW\u0016$'bAAP\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0016\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!I7be.$&/Y2lK\u0012LE/Z7t\u0013:\u001cF/Y4fI\u0011,g-Y;mi\u0012*TCAAUU\r\u0011\u00181S\u0001\u0017[\u0006\u00148\u000e\u0016:bG.,G-\u0013;f[&s7\u000b^1hKRQ\u0011\u0011GAX\u0003c\u000b\u0019,!.\t\u000f\u0005\u0015\u0002\u00041\u0001\u0002\u001e!9\u0011Q\u000e\rA\u0002\u0005=\u0004bBA<1\u0001\u0007\u0011\u0011\u0010\u0005\u0007\u0003\u0017C\u0002\u0019\u0001:\u00025\r|W\u000e\u001d7fi\u0016$&/Y2lK\u0012LE/Z7J]N#\u0018mZ3\u0015\u000f5\u000bY,!0\u0002@\"9\u0011QE\rA\u0002\u0005u\u0001bBA73\u0001\u0007\u0011q\u000e\u0005\t\u0003\u0017K\u0002\u0013!a\u0001e\u0006!3m\\7qY\u0016$X\r\u0016:bG.,G-\u0013;f[&s7\u000b^1hK\u0012\"WMZ1vYR$3'A\u0007d_6\u0004H.\u001a;f'R\fw-\u001a\u000b\u0005\u0003c\t9\rC\u0004\u0002nm\u0001\r!a\u001c\u0002\u0017I,w\u000e]3o'R\fw-\u001a\u000b\u0005\u0003c\ti\rC\u0004\u0002nq\u0001\r!a\u001c\u0002\u0019\u0011,7oY8qK&#X-\\:\u0015\t\u0005E\u00121\u001b\u0005\b\u0003Sj\u0002\u0019AA1\u00031\u0011Xm]2pa\u0016LE/Z7t)\u0011\t\t$!7\t\u000f\u0005%d\u00041\u0001\u0002b\u000512o[5q)J\f7m[3e\u0013R,W.\u00138Ti\u0006<W\rF\u0003N\u0003?\f\t\u000fC\u0004\u0002&}\u0001\r!!\b\t\u000f\u00055t\u00041\u0001\u0002p\u0005Y2m\\7qY\u0016$X\rR3mSZ,'/_%g\u001d\u0016\u001cWm]:bef$\"!!\r\u0002/I,7/\u001a;Ue\u0006\u001c7.\u001a3Ji\u0016l\u0017J\\*uC\u001e,GcB'\u0002l\u00065\u0018q\u001e\u0005\b\u0003K\t\u0003\u0019AA\u000f\u0011\u001d\ti'\ta\u0001\u0003_B\u0001\"a#\"!\u0003\u0005\rA]\u0001\"e\u0016\u001cX\r\u001e+sC\u000e\\W\rZ%uK6Len\u0015;bO\u0016$C-\u001a4bk2$HeM\u0001\u0010gR\f'\u000f^*uC\u001e,wI]8vaR1\u0011\u0011GA|\u0003{Dq!!?$\u0001\u0004\tY0\u0001\u0004ti\u0006<Wm\u001d\t\u0007\u0003\u0007\t\u0019'a\u001c\t\u000f\u0005%4\u00051\u0001\u0002b\u0005\u0001\u0002.\u00198eY\u0016$&/\u00198tSRLwN\u001c\u000b\u0007\u0003c\u0011\u0019A!\u0004\t\u000f\t\u0015A\u00051\u0001\u0003\b\u0005QAO]1og&$\u0018n\u001c8\u0011\u00079\u0013I!C\u0002\u0003\f=\u0013!\u0002\u0016:b]NLG/[8o\u0011\u001d\u0011y\u0001\na\u0001\u0005#\ta\u0001]1sC6\u001c\b\u0003\u0002B\n\u0005/i!A!\u0006\u000b\u0007\t\u00151'\u0003\u0003\u0003\u001a\tU!\u0001\u0005+sC:\u001c\u0018\u000e^5p]B\u000b'/Y7t)!\t\tD!\b\u0003 \t\u0005\u0002b\u0002B\u0003K\u0001\u0007!q\u0001\u0005\b\u0005\u001f)\u0003\u0019\u0001B\t\u0011\u001d\u0011\u0019#\na\u0001\u0005K\t\u0001\u0003\u001e:b]NLG/[8o%\u0016\u001cX\u000f\u001c;\u0011\t\tM!qE\u0005\u0005\u0005S\u0011)B\u0001\tUe\u0006t7/\u001b;j_:\u0014Vm];mi\u0006Ybm\u001c:dK\u000ecwn]3Ti\u0006<Wm]%g\u001d>$8\t\\8tK\u0012$b!!\r\u00030\tE\u0002bBA}M\u0001\u0007\u00111 \u0005\n\u0005g1\u0003\u0013!a\u0001\u0003C\na\"\u001b;f[N$v\u000eR3tG>\u0004X-A\u0013g_J\u001cWm\u00117pg\u0016\u001cF/Y4fg&3gj\u001c;DY>\u001cX\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\b\u0016\u0005\u0003C\n\u0019*A\u0013g_J\u001cWmU6jaR\u0013\u0018mY6fI&#X-\\%o'R\fw-Z%g\u001d>$(+Z1esRA\u0011\u0011\u0007B \u0005\u0003\u0012\u0019\u0005C\u0004\u0002&!\u0002\r!!\b\t\u000f\u00055\u0004\u00061\u0001\u0002p!9!Q\t\u0015A\u0002\t\u001d\u0013\u0001E:uC\u001e,GK]1dW\u0016$\u0017\n^3n!\rq%\u0011J\u0005\u0004\u0005\u0017z%\u0001E*uC\u001e,GK]1dW\u0016$\u0017\n^3n\u0003%A\u0017m]*uC\u001e,7/\u0006\u0002\u0002\u0004\u0006)\u0012n]!mY><X\r\u001a+p\u00072|7/Z*uC\u001e,G\u0003BAB\u0005+Bq!!\u001c+\u0001\u0004\ty'\u0001\fjg\u0006cGn\\<fIR{'+Z8qK:\u001cF/Y4f)\u0011\t\u0019Ia\u0017\t\u000f\u000554\u00061\u0001\u0002p\u0005)2\r[3dW\u0012+G.\u001b<fefL5/Q2uSZ,\u0017!D1eIN+(m]2sS\n,'\u000f\u0006\u0003\u0002J\t\r\u0004bBA)[\u0001\u0007\u00111K\u0001\u0014G\",7m[%uK6L5/\u00123ji\u0006\u0014G.\u001a\u000b\u0007\u0003c\u0011IGa\u001b\t\u000f\u0005\u0015b\u00061\u0001\u0002\u001e!9\u0011Q\u000e\u0018A\u0002\u0005=\u0014aF2iK\u000e\\G)\u001a7jm\u0016\u0014\u00180S:FI&$\u0018M\u00197f\u0011\u0015!4\u00011\u0001N\u0011\u001d\u0011\u0019h\u0001a\u0001\u0005k\n1bY5JIN+'O^5dKB!!q\u000fB>\u001b\t\u0011IH\u0003\u00023k%!!Q\u0010B=\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3")
public class DeliveryStateManager {
    private final Delivery delivery;
    private final DeliveryObjectFactory factory;
    private final Buffer<DeliveryEvent> events;
    private final Buffer<String> messages;

    public static DeliveryStateManager apply(Delivery delivery, CiIdService ciIdService) {
        return DeliveryStateManager$.MODULE$.apply(delivery, ciIdService);
    }

    public Delivery delivery() {
        return this.delivery;
    }

    private Buffer<DeliveryEvent> events() {
        return this.events;
    }

    private Buffer<String> messages() {
        return this.messages;
    }

    public List<DeliveryEvent> getEvents() {
        return this.events().toList();
    }

    public List<String> getMessages() {
        return this.messages().toList();
    }

    public TrackedItem addTrackedItem(TrackedItem item) {
        block0: {
            this.checkDeliveryIsActive();
            String itemId = this.factory.trackedItemId(this.delivery().getId());
            item.setId(itemId);
            item.setModifiedDate(new Date());
            this.delivery().addTrackedItem(item);
            this.delivery().addReleaseIds(item.getReleaseIds());
            this.events().$plus$eq((Object)new ItemCreatedEvent(item, this.delivery()));
            if (this.delivery().isTemplate()) break block0;
            this.delivery().getStagesBeforeFirstOpenTransition().forEach(stage -> {
                block0: {
                    StageTrackedItem stageTrackedItem = $this.factory.createStageTrackedItem(stage.getId(), itemId);
                    stage.getItems().add(stageTrackedItem);
                    this.events().$plus$eq((Object)new ItemAvailableEvent(item, (Stage)stage, this.delivery()));
                    if (!stage.isClosed()) break block0;
                    stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
                    this.events().$plus$eq((Object)new ItemSkippedEvent(item, (Stage)stage, this.delivery()));
                }
            });
        }
        return item;
    }

    /*
     * WARNING - void declaration
     */
    public TrackedItem updateTrackedItem(TrackedItem item) {
        void var2_2;
        this.checkDeliveryIsActive();
        TrackedItem updatedItem = this.delivery().getItemByIdOrTitle(item.getId());
        TrackedItem originalItem = (TrackedItem)CiCloneHelper.cloneCi((ConfigurationItem)updatedItem);
        updatedItem.setTitle(item.getTitle());
        updatedItem.setModifiedDate(new Date());
        this.events().$plus$eq((Object)new ItemUpdatedEvent(updatedItem, this.delivery(), originalItem));
        return var2_2;
    }

    public void deleteTrackedItem(String itemId) {
        this.checkDeliveryIsActive();
        TrackedItem item = this.delivery().getItemByIdOrTitle(itemId);
        this.delivery().removeTrackedItem(itemId);
        if (!this.delivery().isTemplate()) {
            this.delivery().getStages().forEach(x$1 -> x$1.removeTrackedItem(itemId));
        }
        this.events().$plus$eq((Object)new ItemRemovedEvent(item, this.delivery()));
    }

    public void addReleaseToItem(TrackedItem item, String releaseId) {
        this.checkDeliveryIsActive();
        item.addReleaseId(releaseId);
        this.delivery().addReleaseId(releaseId);
    }

    public SubscriptionResult registerSubscriber(Subscriber subscriber) {
        this.checkDeliveryIsActive();
        return this.addSubscriber(subscriber);
    }

    public Delivery start() {
        block0: {
            this.delivery().setStatus(DeliveryStatus.IN_PROGRESS);
            if (!this.hasStages()) break block0;
            scala.collection.immutable.Seq firstStageGroup = CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStagesBeforeFirstOpenTransition()).asScala().toSeq();
            this.startStageGroup((scala.collection.immutable.Seq<Stage>)firstStageGroup, (scala.collection.immutable.Seq<TrackedItem>)CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getTrackedItems()).asScala().toSeq());
        }
        return this.delivery();
    }

    public scala.collection.immutable.Seq<TrackedItem> markTrackedItemsInStage(scala.collection.immutable.Seq<TrackedItem> items, Stage stage2, TrackedItemStatus status, boolean precedingStages, String fromReleaseId) {
        this.checkDeliveryIsEditable();
        Checks.checkTrue((boolean)stage2.isOpen(), (String)"Stage must be open in order to update items in it", (Object[])new Object[0]);
        scala.collection.immutable.Seq descopedItems = (scala.collection.immutable.Seq)items.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped()));
        Checks.checkTrue((boolean)descopedItems.isEmpty(), (String)new StringBuilder(72).append("Unable to complete task, the following tracked items are de-scoped:\n * ").append(((IterableOnceOps)descopedItems.map((Function1 & Serializable)x$3 -> x$3.getTitle())).mkString("\n * ")).append("\n").toString(), (Object[])new Object[0]);
        if (precedingStages) {
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStagesBefore(stage2)).asScala().dropWhile((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isClosed()))).foreach((Function1 & Serializable)stage -> {
                scala.collection.immutable.Seq itemsInStage = (scala.collection.immutable.Seq)items.filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$markTrackedItemsInStage$5(stage, item)));
                return this.markTrackedItemsInStage((scala.collection.immutable.Seq<TrackedItem>)itemsInStage, (Stage)stage, status, false, fromReleaseId);
            });
        }
        items.foreach((Function1 & Serializable)item -> {
            DeliveryStateManager.$anonfun$markTrackedItemsInStage$6(stage2, fromReleaseId, item);
            return BoxedUnit.UNIT;
        });
        Set doneItems = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(stage2.getItems()).asScala().filter((Function1 & Serializable)stageItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$markTrackedItemsInStage$8(status, stageItem)))).map((Function1 & Serializable)x$6 -> x$6.getTrackedItemId())).toSet();
        Tuple2 tuple2 = items.partition((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)doneItems.contains((Object)item.getId())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq done = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq notDone = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)done, (Object)notDone);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Seq done2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq notDone2 = (scala.collection.immutable.Seq)tuple23._2();
        Object object = done2.nonEmpty() ? this.messages().$plus$eq((Object)new StringBuilder(50).append("Tracked items [").append(((IterableOnceOps)done2.map((Function1 & Serializable)x$8 -> x$8.getId())).mkString(", ")).append("] are already in status on stage '").append(stage2.getId()).append("'").toString()) : BoxedUnit.UNIT;
        notDone2.foreach((Function1 & Serializable)x$9 -> {
            this.markTrackedItemInStage(x$9, stage2, status, fromReleaseId);
            return BoxedUnit.UNIT;
        });
        return notDone2;
    }

    public boolean markTrackedItemsInStage$default$4() {
        return false;
    }

    public String markTrackedItemsInStage$default$5() {
        return null;
    }

    public void markTrackedItemInStage(TrackedItem item, Stage stage, TrackedItemStatus status, String fromReleaseId) {
        TrackedItemStatus trackedItemStatus = status;
        if (TrackedItemStatus.READY.equals(trackedItemStatus)) {
            this.completeTrackedItemInStage(item, stage, fromReleaseId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TrackedItemStatus.SKIPPED.equals(trackedItemStatus)) {
            this.skipTrackedItemInStage(item, stage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TrackedItemStatus.NOT_READY.equals(trackedItemStatus)) {
            this.resetTrackedItemInStage(item, stage, fromReleaseId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Delivery completeTrackedItemInStage(TrackedItem item, Stage stage, String fromReleaseId) {
        BoxedUnit boxedUnit;
        this.checkItemIsEditable(item, stage);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.READY;
        if (trackedItemStatus == null ? trackedItemStatus2 != null : !trackedItemStatus.equals(trackedItemStatus2)) {
            stageItem.setStatus(TrackedItemStatus.READY);
            boxedUnit = this.events().$plus$eq((Object)new ItemCompletedEvent(item, stage, this.delivery(), fromReleaseId));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.delivery();
    }

    public String completeTrackedItemInStage$default$3() {
        return null;
    }

    public void completeStage(Stage stage) {
        this.checkDeliveryIsEditable();
        Checks.checkTrue((boolean)this.isAllowedToCloseStage(stage), (String)"Stages cannot be completed if their preceding stages are not closed", (Object[])new Object[0]);
        scala.collection.immutable.Seq toDescopeAndSkip = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(stage.getItems()).asScala().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeStage$1(x$10)))).map((Function1 & Serializable)stageItem -> this.delivery().getItemByIdOrTitle(stageItem.getTrackedItemId()))).toSeq();
        this.forceCloseStagesIfNotClosed((scala.collection.immutable.Seq<Stage>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Stage[]{stage}))), (scala.collection.immutable.Seq<TrackedItem>)toDescopeAndSkip);
    }

    public void reopenStage(Stage stage) {
        block0: {
            this.checkDeliveryIsEditable();
            Checks.checkTrue((boolean)this.isAllowedToReopenStage(stage), (String)"Stages cannot be reopened if their subsequent stages are closed", (Object[])new Object[0]);
            if (!stage.isClosed()) break block0;
            stage.setStatus(StageStatus.OPEN);
            this.events().$plus$eq((Object)new StageReopenedEvent(stage, this.delivery()));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)x$11 -> {
                DeliveryStateManager.$anonfun$reopenStage$1(x$11);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void descopeItems(scala.collection.immutable.Seq<TrackedItem> items) {
        Map itemsNotYetDescoped = ((IterableOnceOps)((IterableOps)items.view().filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDescoped()))).map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), item))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        itemsNotYetDescoped.valuesIterator().foreach((Function1 & Serializable)item -> {
            item.setDescoped(true);
            return (Buffer)this.events().$plus$eq((Object)new ItemDescopedEvent((TrackedItem)item, this.delivery()));
        });
    }

    public void rescopeItems(scala.collection.immutable.Seq<TrackedItem> items) {
        Map descopedItems = ((IterableOnceOps)((IterableOps)items.view().filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isDescoped()))).map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), item))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        descopedItems.valuesIterator().foreach((Function1 & Serializable)item -> {
            item.setDescoped(false);
            return (Buffer)this.events().$plus$eq((Object)new ItemRescopedEvent((TrackedItem)item, this.delivery()));
        });
    }

    public Delivery skipTrackedItemInStage(TrackedItem item, Stage stage) {
        this.checkItemIsEditable(item, stage);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        this.forceSkipTrackedItemInStageIfNotReady(item, stage, stageItem);
        return this.delivery();
    }

    public void completeDeliveryIfNecessary() {
        block0: {
            boolean allItemsClosedInAllStages;
            if (!this.delivery().isAutoComplete() || !this.events().exists((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeDeliveryIfNecessary$1(item))) || !(allItemsClosedInAllStages = CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getTrackedItems()).asScala().forall((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeDeliveryIfNecessary$2(this, item))))) break block0;
            this.forceCloseStagesIfNotClosed((scala.collection.immutable.Seq<Stage>)CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStages()).asScala().toSeq(), this.forceCloseStagesIfNotClosed$default$2());
        }
    }

    public Delivery resetTrackedItemInStage(TrackedItem item, Stage stage, String fromReleaseId) {
        BoxedUnit boxedUnit;
        this.checkItemIsEditable(item, stage);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        if (trackedItemStatus == null ? trackedItemStatus2 != null : !trackedItemStatus.equals(trackedItemStatus2)) {
            stageItem.setStatus(TrackedItemStatus.NOT_READY);
            this.events().$plus$eq((Object)new ItemResetEvent(item, stage, this.delivery(), fromReleaseId));
            boxedUnit = this.events().$plus$eq((Object)new ItemAvailableEvent(item, stage, this.delivery()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.delivery();
    }

    public String resetTrackedItemInStage$default$3() {
        return null;
    }

    public void startStageGroup(scala.collection.immutable.Seq<Stage> stages, scala.collection.immutable.Seq<TrackedItem> items) {
        stages.foreach((Function1 & Serializable)stage -> {
            DeliveryStateManager.$anonfun$startStageGroup$1(this, items, stage);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTransition(Transition transition, TransitionParams params) {
        TransitionEvaluator$.MODULE$.evaluate(params).foreach((Function1 & Serializable)result -> {
            this.handleTransition(transition, params, result);
            return BoxedUnit.UNIT;
        });
    }

    private void handleTransition(Transition transition, TransitionParams params, TransitionResult transitionResult) {
        this.events().$plus$eq((Object)new TransitionExecutedEvent(transition, this.delivery(), params));
        Stage stage2 = this.delivery().getStageByTransition(transition);
        transitionResult.toTransition().toList().foreach((Function1 & Serializable)item -> (Buffer)this.events().$plus$eq((Object)new ItemTransitionApprovedEvent((TrackedItem)item, (StageTrackedItem)stage2.findItemById(item.getId()).get(), transition, stage2, this.delivery())));
        if (transitionResult.closeStages()) {
            Buffer stagesToClose = (Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStagesBefore(params.transitionStage())).asScala().filter((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)stage.isOpen()))).$colon$plus((Object)params.transitionStage());
            this.forceCloseStagesIfNotClosed((scala.collection.immutable.Seq<Stage>)stagesToClose.toSeq(), (scala.collection.immutable.Seq<TrackedItem>)transitionResult.toDescope().toList());
        }
        scala.collection.immutable.Seq nextStageGroup = CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStageGroupAfterTransition(transition)).asScala().toSeq();
        this.startStageGroup((scala.collection.immutable.Seq<Stage>)nextStageGroup, (scala.collection.immutable.Seq<TrackedItem>)transitionResult.toTransition().toList());
    }

    private void forceCloseStagesIfNotClosed(scala.collection.immutable.Seq<Stage> stages, scala.collection.immutable.Seq<TrackedItem> itemsToDescope) {
        stages.foreach((Function1 & Serializable)stage -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            itemsToDescope.foreach((Function1 & Serializable)item -> {
                DeliveryStateManager.$anonfun$forceCloseStagesIfNotClosed$2(this, stage, item);
                return BoxedUnit.UNIT;
            });
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)x$19 -> {
                x$19.setAutomated(false);
                return BoxedUnit.UNIT;
            });
            if (stage.isOpen()) {
                stage.setStatus(StageStatus.CLOSED);
                boxedUnit2 = this.events().$plus$eq((Object)new StageCompletedEvent((Stage)stage, this.delivery()));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.delivery().isLastStage(stage)) {
                this.delivery().setStatus(DeliveryStatus.COMPLETED);
                boxedUnit = this.events().$plus$eq((Object)new DeliveryCompletedEvent(this.delivery()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        this.descopeItems(itemsToDescope);
    }

    private scala.collection.immutable.Seq<TrackedItem> forceCloseStagesIfNotClosed$default$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private void forceSkipTrackedItemInStageIfNotReady(TrackedItem item, Stage stage, StageTrackedItem stageTrackedItem) {
        block0: {
            TrackedItemStatus trackedItemStatus = stageTrackedItem.getStatus();
            TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
            if (trackedItemStatus != null ? !trackedItemStatus.equals(trackedItemStatus2) : trackedItemStatus2 != null) break block0;
            stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
            this.events().$plus$eq((Object)new ItemSkippedEvent(item, stage, this.delivery()));
        }
    }

    private boolean hasStages() {
        return this.delivery().getStages() != null && !this.delivery().getStages().isEmpty();
    }

    private boolean isAllowedToCloseStage(Stage stage) {
        return OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(this.delivery().findPreviousStage(stage))).forall((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToCloseStage$1(x$20)));
    }

    private boolean isAllowedToReopenStage(Stage stage) {
        return OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(this.delivery().findNextStage(stage))).forall((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToReopenStage$1(x$21)));
    }

    private void checkDeliveryIsActive() {
        Checks.checkTrue((!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])DeliveryStatus.INACTIVE_STATUSES), (Object)this.delivery().getStatus()) ? 1 : 0) != 0, (String)"Can't modify ABORTED or COMPLETED release delivery", (Object[])new Object[0]);
    }

    private SubscriptionResult addSubscriber(Subscriber subscriber) {
        Object object;
        SubscriptionStatus subscriptionStatus;
        subscriber.validate(this.delivery());
        SubscriptionResult result = subscriber.evaluate(this.delivery());
        int subscriberIndex = CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getSubscribers()).asScala().indexWhere((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.isEqual(subscriber)));
        SubscriptionResult subscriptionResult = result;
        if (subscriptionResult != null && SubscriptionStatus.COMPLETED.equals(subscriptionStatus = subscriptionResult.status()) && subscriberIndex != -1) {
            object = this.delivery().getSubscribers().remove(subscriberIndex);
        } else {
            SubscriptionStatus subscriptionStatus2;
            SubscriptionStatus subscriptionStatus3;
            boolean bl = subscriptionResult != null && SubscriptionStatus.FAILED.equals(subscriptionStatus3 = subscriptionResult.status()) ? true : subscriptionResult != null && SubscriptionStatus.IN_PROGRESS.equals(subscriptionStatus2 = subscriptionResult.status());
            if (bl && subscriberIndex != -1) {
                object = this.delivery().getSubscribers().set(subscriberIndex, subscriber);
            } else {
                SubscriptionStatus subscriptionStatus4;
                SubscriptionStatus subscriptionStatus5;
                boolean bl2 = subscriptionResult != null && SubscriptionStatus.FAILED.equals(subscriptionStatus5 = subscriptionResult.status()) ? true : subscriptionResult != null && SubscriptionStatus.IN_PROGRESS.equals(subscriptionStatus4 = subscriptionResult.status());
                if (bl2) {
                    this.delivery().addSubscriber(subscriber);
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
        }
        return result;
    }

    private void checkItemIsEditable(TrackedItem item, Stage stage) {
        this.checkDeliveryIsEditable();
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to update items in it", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot change status of descoped item", (Object[])new Object[0]);
    }

    private void checkDeliveryIsEditable() {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !deliveryStatus.equals(deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Delivery must be active in order to change state", (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$5(Stage stage$1, TrackedItem item) {
        return stage$1.findItemById(item.getId()).isPresent();
    }

    public static final /* synthetic */ void $anonfun$markTrackedItemsInStage$6(Stage stage$2, String fromReleaseId$1, TrackedItem item) {
        OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(stage$2.findItemById(item.getId()))).foreach((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.addReleaseId(fromReleaseId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$8(TrackedItemStatus status$1, StageTrackedItem stageItem) {
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = status$1;
        return !(trackedItemStatus != null ? !trackedItemStatus.equals(trackedItemStatus2) : trackedItemStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$completeStage$1(StageTrackedItem x$10) {
        TrackedItemStatus trackedItemStatus = x$10.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        return !(trackedItemStatus != null ? !trackedItemStatus.equals(trackedItemStatus2) : trackedItemStatus2 != null);
    }

    public static final /* synthetic */ void $anonfun$reopenStage$1(Transition x$11) {
        x$11.getAllConditions().forEach(x$12 -> x$12.reset());
    }

    public static final /* synthetic */ boolean $anonfun$completeDeliveryIfNecessary$1(DeliveryEvent item) {
        return item instanceof ItemCompletedEvent || item instanceof ItemSkippedEvent || item instanceof ItemDescopedEvent;
    }

    public static final /* synthetic */ boolean $anonfun$completeDeliveryIfNecessary$4(StageTrackedItem x$15) {
        return x$15.getStatus().isDone();
    }

    public static final /* synthetic */ boolean $anonfun$completeDeliveryIfNecessary$3(TrackedItem item$2, Stage stage) {
        return OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(stage.findItemById(item$2.getId()))).exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeDeliveryIfNecessary$4(x$15)));
    }

    public static final /* synthetic */ boolean $anonfun$completeDeliveryIfNecessary$2(DeliveryStateManager $this, TrackedItem item) {
        return item.isDescoped() || CollectionConverters$.MODULE$.ListHasAsScala($this.delivery().getStages()).asScala().forall((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeDeliveryIfNecessary$3(item, stage)));
    }

    public static final /* synthetic */ void $anonfun$startStageGroup$1(DeliveryStateManager $this, scala.collection.immutable.Seq items$2, Stage stage) {
        block0: {
            Set existingItems = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(stage.getItems()).asScala().map((Function1 & Serializable)x$16 -> x$16.getTrackedItemId())).toSet();
            scala.collection.immutable.Seq newItems = (scala.collection.immutable.Seq)items$2.filterNot((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)existingItems.apply((Object)item.getId())));
            java.util.List stageItems = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newItems.map((Function1 & Serializable)item -> $this.factory.createStageTrackedItem(stage.getId(), item.getId()))).asJava();
            stage.addTrackedItems(stageItems);
            Object object = existingItems.isEmpty() ? $this.events().$plus$eq((Object)new StageStartedEvent(stage, $this.delivery())) : BoxedUnit.UNIT;
            newItems.foreach((Function1 & Serializable)x$17 -> (Buffer)$this.events().$plus$eq((Object)new ItemAvailableEvent((TrackedItem)x$17, stage, $this.delivery())));
            if (!stage.isClosed()) break block0;
            stageItems.forEach(stageItem -> stageItem.setStatus(TrackedItemStatus.SKIPPED));
            newItems.foreach((Function1 & Serializable)x$18 -> (Buffer)$this.events().$plus$eq((Object)new ItemSkippedEvent((TrackedItem)x$18, stage, $this.delivery())));
        }
    }

    public static final /* synthetic */ void $anonfun$forceCloseStagesIfNotClosed$2(DeliveryStateManager $this, Stage stage$5, TrackedItem item) {
        stage$5.findItemById(item.getId()).ifPresent(stageItem -> $this.forceSkipTrackedItemInStageIfNotReady(item, stage$5, (StageTrackedItem)stageItem));
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToCloseStage$1(Stage x$20) {
        StageStatus stageStatus = x$20.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return !(stageStatus != null ? !stageStatus.equals(stageStatus2) : stageStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToReopenStage$1(Stage x$21) {
        StageStatus stageStatus = x$21.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return stageStatus == null ? stageStatus2 != null : !stageStatus.equals(stageStatus2);
    }

    public DeliveryStateManager(Delivery delivery, DeliveryObjectFactory factory) {
        this.delivery = delivery;
        this.factory = factory;
        this.events = (Buffer)Buffer$.MODULE$.empty();
        this.messages = (Buffer)Buffer$.MODULE$.empty();
    }
}

