import React, { ReactElement } from 'react';
import { ReactWrapper } from 'enzyme';
import { AutoCompleteOption, AutoCompleteProps, DotAutoComplete } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { stringPropertyMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/property.mock';
import { taskMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/task.mock';

import { PropertiesEnum } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { AUTOCOMPLETE_MAX_HEIGHT } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/common/constants';
import { RootState } from '../../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { Pattern } from './pattern.component';

describe('pattern', () => {
    const defaultState = {
        taskDrawer: {
            variables: [{ key: 'var' }],
        },
        deliveryTasks: {
            deliveriesOrPatterns: [],
            deliveryOrPattern: null,
            patterns: [
                {
                    id: 'PatternId1',
                    title: 'My Pattern 1',
                    stages: [
                        {
                            id: 'PatternId1/Stage1',
                            title: 'Stage one',
                        },
                        {
                            id: 'PatternId1/Stage2',
                            title: 'Stage two',
                        },
                    ],
                },
                {
                    id: 'PatternId2',
                    title: 'My Pattern 2',
                    stages: [
                        {
                            id: 'PatternId2/Stage1',
                            title: 'Stage one',
                        },
                        {
                            id: 'PatternId2/Stage2',
                            title: 'Stage two',
                        },
                    ],
                },
            ],
        },
    };

    const onChange = jest.fn();
    const dispatch = jest.fn();
    let wrapper: ReactWrapper;

    const mount = (component: ReactElement, state: RootState = defaultState) => {
        wrapper = mountWithStoreAndTheme(component, dispatch, state);
    };

    const getDotAutoComplete = () => wrapper.find(DotAutoComplete);

    const verifyCommonAutocompleteProps = (autocompleteProps: AutoCompleteProps<AutoCompleteOption>) => {
        expect(autocompleteProps.readOnly).toBe(false);
        expect(autocompleteProps.group).toBe(false);
        expect(autocompleteProps.helperText).toBe(stringPropertyMock.description);
        expect(autocompleteProps.inputId).toBe(stringPropertyMock.name);
        expect(autocompleteProps.label).toBe(stringPropertyMock.label);
        expect(autocompleteProps.persistentLabel).toBe(true);
        expect(autocompleteProps.maxHeight).toBe(AUTOCOMPLETE_MAX_HEIGHT);
        expect(autocompleteProps.multiple).toBe(false);
        expect(autocompleteProps.required).toBe(stringPropertyMock.required);
    };

    beforeEach(() => {
        dispatch.mockReset();
        onChange.mockReset();
    });

    it('should set the proper props', () => {
        const task = {
            ...taskMock,
            inputProperties: {
                patternId: 'PatternId2',
                deliveryId: '${var}',
            },
        };
        mount(
            <Pattern
                disabled={false}
                expanded={false}
                onChange={onChange}
                propertiesEnum={PropertiesEnum.InputProperties}
                property={stringPropertyMock}
                task={task}
            />,
        );

        const autocompleteProps = getDotAutoComplete().props();
        verifyCommonAutocompleteProps(autocompleteProps);
        expect(autocompleteProps.value).toStrictEqual({
            id: 'PatternId2',
            title: 'My Pattern 2',
        });
        expect(autocompleteProps.options).toStrictEqual([
            {
                id: 'PatternId1',
                title: 'My Pattern 1',
            },
            {
                id: 'PatternId2',
                title: 'My Pattern 2',
            },
        ]);
    });
    it('should trigger search pattern if delivery is variable', () => {
        const task = {
            ...taskMock,
            inputProperties: {
                patternId: 'PatternId2',
                deliveryId: '${var}',
            },
        };
        mount(
            <Pattern
                disabled={false}
                expanded={false}
                onChange={onChange}
                propertiesEnum={PropertiesEnum.InputProperties}
                property={stringPropertyMock}
                task={task}
            />,
        );
        expect(dispatch).toHaveBeenCalledWith({ payload: undefined, type: 'deliveryTasks/searchPatterns' });
    });
    it('should not trigger search pattern if delivery is not a variable', () => {
        const task = {
            ...taskMock,
            inputProperties: {
                patternId: 'PatternId2',
                deliveryId: 'DeliveryId',
            },
        };
        mount(
            <Pattern
                disabled={false}
                expanded={false}
                onChange={onChange}
                propertiesEnum={PropertiesEnum.InputProperties}
                property={stringPropertyMock}
                task={task}
            />,
        );

        expect(dispatch).not.toHaveBeenCalled();
    });
});
