import React from 'react';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { InputWithFolder } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/input-with-folder/input-with-folder.component';
import { useAppSelector } from '../../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getFolders } from '../../../../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.selectors';
import { findFolder } from '../../../../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.reducer';
import { TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { getPropertyFromInputProperties } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/helper/task.helper';
import { StringWithVariables } from './string-with-variables.component';
import './folder.component.less';

export const FolderWithVariables = (props: TaskInputCommonProps) => {
    return (
        <StringWithVariables {...props}>
            <FolderAutocomplete {...props} />
        </StringWithVariables>
    );
};

const FolderAutocomplete = ({ disabled, expanded, onChange, property, task }: TaskInputCommonProps) => {
    const folders = useAppSelector(getFolders);

    const selectedFolderId = getPropertyFromInputProperties(task, property.name);

    const selectedFolder = selectedFolderId ? (findFolder({ id: selectedFolderId }, folders) as Folder) : undefined;

    const handleFolderChange = (folder?: Folder) => {
        onChange(folder ? folder.id : null);
    };

    return (
        <div className="folder-autocomplete">
            <InputWithFolder
                description={property.description}
                disabled={disabled}
                isFolderFullWidth={expanded}
                label={property.label}
                onChange={handleFolderChange}
                required={property.required}
                value={selectedFolder}
            />
        </div>
    );
};
