import React, { ReactNode, useEffect, useState } from 'react';
import { ButtonToggleOption } from '@digital-ai/dot-components';
import { PropertiesEnum, TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { TaskInputPropertiesVariableOrValue, TaskProperties, VariableType } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { propertiesForm } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/ducks/properties-form.reducer';
import { getTaskDrawerState } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/ducks/task-drawer.reducer';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { addVariableCharacters, isVariable } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/helper/variables.helper';
import { getPropertyFromInputProperties } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/helper/task.helper';
import { TaskVariableAutocomplete } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/variable-autocomplete/task-variable-autocomplete.component';
import '../../../../../../../../../../../core/xlr-ui/app/styles/xlrelease/disabled-with-default-color.less';
import { VariableToggler } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/variable-toggler/variable-toggler.component';

const { createReleaseVariableAndUpdateTask } = propertiesForm.actions;

interface StringWithVariablesProps extends TaskInputCommonProps {
    children: ReactNode;
}

export const StringWithVariables = ({ children, property, task, disabled, onChange }: StringWithVariablesProps) => {
    const { allVariables } = useAppSelector(getTaskDrawerState);
    const dispatch = useAppDispatch();

    const value = getPropertyFromInputProperties(task, property.name);

    const [isInVariableSelection, setIsInVariableSelection] = useState(isVariable(value));
    useEffect(() => {
        if (value) {
            setIsInVariableSelection(isVariable(value));
        }
    }, [value]);

    const handleAddVariable = (variableName: string, variableType: VariableType) => {
        dispatch(
            createReleaseVariableAndUpdateTask({
                propertiesEnum: PropertiesEnum.InputProperties,
                propertyName: property.name,
                taskValue: addVariableCharacters(variableName),
                variableName,
                variableType,
            }),
        );
    };

    const handleSwitchToVariableButtonClick = (): void => {
        setIsInVariableSelection(!isInVariableSelection);
        onChange(null);
    };

    const handleOnChange = (taskVariableAndValue: TaskInputPropertiesVariableOrValue) => {
        onChange(taskVariableAndValue.variable);
    };

    const fixedTaskProperties: TaskProperties = {
        ...task.inputProperties,
        [property.name]: { variable: getPropertyFromInputProperties(task, property.name) as string, value: null },
    };

    const renderVariableSelectionMode = () => {
        return (
            <TaskVariableAutocomplete
                disabled={disabled}
                onAddVariable={handleAddVariable}
                onChange={handleOnChange}
                property={property}
                taskProperties={fixedTaskProperties}
                variables={allVariables}
            />
        );
    };

    const buttonOptions: ButtonToggleOption[] = [
        {
            ariaLabel: 'Click to switch between variable and manual entry',
            disabled,
            text: '',
            value: true,
            iconId: 'variable',
        },
    ];

    return (
        <div className="task-input-property input-with-variables disabled-with-default-color">
            {!disabled && (
                <VariableToggler
                    buttonOptions={buttonOptions}
                    isInVariableSelection={isInVariableSelection}
                    onSwitchToVariableButtonClick={handleSwitchToVariableButtonClick}
                />
            )}
            {isInVariableSelection ? renderVariableSelectionMode() : children}
        </div>
    );
};
