package com.xebialabs.xlrelease.api.internal;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.security.PermissionChecker;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;

/**
 * Fixtures for release deliveries
 */
@Path("/fixtures/deliveries")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
@NoCache
public class FixturesDeliveryResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesDeliveryResource.class);

    private DeliveryService deliveryService;
    private DeliveryPatternService deliveryPatternService;
    private PermissionChecker permissions;
    private DeliveryRepository deliveryRepository;

    @Autowired
    public FixturesDeliveryResource(DeliveryService deliveryService,
                                    DeliveryPatternService deliveryPatternService,
                                    PermissionChecker permissions,
                                    DeliveryRepository deliveryRepository) {
        this.deliveryService = deliveryService;
        this.deliveryPatternService = deliveryPatternService;
        this.permissions = permissions;
        this.deliveryRepository = deliveryRepository;
    }

    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    public Delivery createDelivery(Delivery delivery) {
        permissions.check(ADMIN);

        logger.debug("creating release delivery", delivery.getId());
        return deliveryService.createDelivery(delivery, false);
    }

    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    @Path("/patterns/{shouldResetPattern: true|false}")
    public Delivery createDeliveryPattern(Delivery delivery, @PathParam("shouldResetPattern") boolean shouldResetPattern) {
        permissions.check(ADMIN);

        logger.debug("creating release delivery pattern", delivery.getId());
        return deliveryPatternService.createDeliveryPattern(delivery, shouldResetPattern);
    }

    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @DELETE
    @Path("/{deliveryId:.*Delivery[^/]*}")
    public void deleteDelivery(@PathParam("deliveryId") String deliveryId) {
        permissions.check(ADMIN);

        logger.debug("removing release delivery %s", deliveryId);
        if (deliveryRepository.exists(deliveryId)) {
            deliveryRepository.delete(deliveryId);
        }
    }


}
