import React from 'react';
import { Folder, Task, TaskInputPropertyValue } from '../../../../../../../../../../core/xlr-ui/app/types';
import { SyntheticPropertyDefinition } from '../../../../../../../../../../core/xlr-ui/app/types/synthetic';
import { InputWithFolder } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/properties/components/input-with-folder/input-with-folder.component';
import { useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getFolders } from '../../../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.selectors';
import { findFolder } from '../../../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.reducer';

export interface DeliveryFolderSelectorProps {
    expanded: boolean;
    onChange: (value: TaskInputPropertyValue) => void;
    property: SyntheticPropertyDefinition;
    task: Task;
}

export const DeliveryFolderSelector = ({ expanded, onChange, property, task }: DeliveryFolderSelectorProps) => {
    const folders = useAppSelector(getFolders);

    const selectedFolderId = task.inputProperties?.[property.name];

    const selectedFolder = findFolder({ id: selectedFolderId }, folders);

    const handleFolderChange = (folder: Folder) => {
        onChange(folder.id);
    };

    return (
        <InputWithFolder
            description={property.description}
            disabled={false}
            folders={folders}
            isFolderFullWidth={expanded}
            label={property.label}
            onChange={handleFolderChange}
            required={property.required}
            value={selectedFolder}
        />
    );
};
