import sys
from com.xebialabs.xlrelease.api.v1.forms import DeliveryFilters, DeliveryOrderMode
from com.xebialabs.xlrelease.domain.delivery import DeliveryStatus
from delivery import make_delivery_hyperlink

global deliveryPatternApi, deliveryApi, taskApi, task, title, patternId, searchStrategy, itemsFilter, nameFilter, selectionStrategy


def set_task_status_line(delivery_title, delivery_id):
    task.setStatusLine(make_delivery_hyperlink(delivery_title, delivery_id))


def handle_not_found():
    print("No active delivery matching the search criteria was found\n")
    sys.exit(1)


def find_latest_by_title_and_tracked_items(delivery_title_pattern, tracked_items_title_pattern):
    escaped_delivery_title_pattern = sanitize_search_pattern(delivery_title_pattern)
    escaped_tracked_items_title_pattern = sanitize_search_pattern(tracked_items_title_pattern)

    delivery_filters = (
        DeliveryFilters()
            .withStatuses(DeliveryStatus.IN_PROGRESS)
            .withTrackedItemTitle(escaped_tracked_items_title_pattern)
            .withStrictTrackedItemTitleMatch(True)
            .withTitle(escaped_delivery_title_pattern)
            .withStrictTitleMatch(True)
    )

    found_deliveries = deliveryApi.searchDeliveries(delivery_filters, 0, 1, DeliveryOrderMode.CREATED_DATE)
    if found_deliveries:
        delivery = found_deliveries[0]
        print("Found delivery : %s" % make_delivery_hyperlink(delivery.title, delivery.id))
        set_task_status_line(delivery.title, delivery.id)
        return delivery.id
    else:
        return handle_not_found()


def sanitize_search_pattern(search_pattern):
    return search_pattern.replace("%", "`%").replace("_", "`_").replace("*", "%").replace("?", "_")


deliveryId = find_latest_by_title_and_tracked_items(nameFilter, itemsFilter)
