/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.delivery.events.ConditionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.service.DeliveryTimelineCalculator;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.delivery.conditions.ConditionGroup;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.CiHelper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@Service
@ScalaSignature(bytes="\u0006\u0005\rma\u0001\u0002\u0015*\u0001QB\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003V\u0011!Y\u0006A!b\u0001\n\u0003a\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\r\u0004!Q1A\u0005\u0002\u0011D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tS\u0002\u0011)\u0019!C\u0001U\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001q\u0011!!\bA!A!\u0002\u0013\t\b\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0001<\t\u0011u\u0004!\u0011!Q\u0001\n]D\u0001B \u0001\u0003\u0006\u0004%\ta \u0005\u000b\u0003\u000f\u0001!\u0011!Q\u0001\n\u0005\u0005\u0001BCA\u0005\u0001\t\u0015\r\u0011\"\u0001\u0002\f!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u0015\u0005}\u0001A!b\u0001\n\u0003\t\t\u0003\u0003\u0006\u00020\u0001\u0011\t\u0011)A\u0005\u0003GAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBA\\\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDq!a>\u0001\t\u0003\tI\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\u0018!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\"\u0001\u0011\u0005!Q\t\u0005\b\u0005\u000b\u0003A\u0011\u0001BD\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005_CqA!0\u0001\t\u0003\u0011y\fC\u0004\u0003J\u0002!\tAa3\t\u000f\t\u0015\b\u0001\"\u0015\u0003h\"I!\u0011\u001f\u0001\u0012\u0002\u0013E!1\u001f\u0005\b\u0005K\u0004A\u0011CB\u0004\u0005=!U\r\\5wKJL8+\u001a:wS\u000e,'B\u0001\u0016,\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001L\u0017\u0002\u0011\u0011,G.\u001b<fefT!AL\u0018\u0002\u0013ad'/\u001a7fCN,'B\u0001\u00192\u0003%AXMY5bY\u0006\u00147OC\u00013\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001QgO\"H!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fMB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0006g24GG\u001b\u0006\u0002\u0001\u0006AqM]5{u2,G-\u0003\u0002C{\t9Aj\\4hS:<\u0007C\u0001#F\u001b\u0005I\u0013B\u0001$*\u0005i!U\r\\5wKJLH+[7fY&tWmQ1mGVd\u0017\r^8s!\t!\u0005*\u0003\u0002JS\t!B)\u001a7jm\u0016\u0014\u0018pU3sm&\u001cW-\u0016;jYN\f!\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ssV\tA\n\u0005\u0002N!6\taJ\u0003\u0002PW\u0005Q!/\u001a9pg&$xN]=\n\u0005Es%A\u0005#fY&4XM]=SKB|7/\u001b;pef\f1\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005)\u0006C\u0001,Y\u001b\u00059&BA(.\u0013\tIvKA\tSK2,\u0017m]3SKB|7/\u001b;pef\f!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,W#A/\u0011\u0005y\u0003W\"A0\u000b\u0005)j\u0013BA1`\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqB]3mK\u0006\u001cXmU3sm&\u001cW\rI\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\u0012!\u001a\t\u0003=\u001aL!aZ0\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!E1sG\"Lg/\u001b8h'\u0016\u0014h/[2fA\u0005!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016,\u0012a\u001b\t\u0003=2L!!\\0\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0002\n1bY5JIN+'O^5dKV\t\u0011\u000f\u0005\u0002_e&\u00111o\u0018\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{[\u0005\u0011AMY\u0005\u0003yf\u0014\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002#\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b%A\u0007g_2$WM]*feZL7-Z\u000b\u0003\u0003\u0003\u00012AXA\u0002\u0013\r\t)a\u0018\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001d\u0019|G\u000eZ3s'\u0016\u0014h/[2fA\u0005Y!o\u001c7f'\u0016\u0014h/[2f+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0011M,7-\u001e:jifT1!a\u00060\u0003!!W\r\u001d7ps&$\u0018\u0002BA\u000e\u0003#\u00111BU8mKN+'O^5dK\u0006a!o\u001c7f'\u0016\u0014h/[2fA\u0005AQM^3oi\n+8/\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*5\na!\u001a<f]R\u001c\u0018\u0002BA\u0017\u0003O\u0011\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003k\t9$!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\n)%a\u0012\u0002JA\u0011A\t\u0001\u0005\u0006\u0015V\u0001\r\u0001\u0014\u0005\u0006'V\u0001\r!\u0016\u0005\u00067V\u0001\r!\u0018\u0005\u0006GV\u0001\r!\u001a\u0005\u0006SV\u0001\ra\u001b\u0005\u0006_V\u0001\r!\u001d\u0005\u0006kV\u0001\ra\u001e\u0005\u0007}V\u0001\r!!\u0001\t\u000f\u0005%Q\u00031\u0001\u0002\u000e!9\u0011qD\u000bA\u0002\u0005\r\u0002fA\u000b\u0002NA!\u0011qJA3\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013AC1o]>$\u0018\r^5p]*!\u0011qKA-\u0003\u001d1\u0017m\u0019;pefTA!a\u0017\u0002^\u0005)!-Z1og*!\u0011qLA1\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA2\u0003\ry'oZ\u0005\u0005\u0003O\n\tFA\u0005BkR|w/\u001b:fI\u0006Yq-\u001a;EK2Lg/\u001a:z)\u0011\ti'a\u001f\u0011\t\u0005=\u0014qO\u0007\u0003\u0003cR1\u0001LA:\u0015\r\t)(L\u0001\u0007I>l\u0017-\u001b8\n\t\u0005e\u0014\u0011\u000f\u0002\t\t\u0016d\u0017N^3ss\"9\u0011Q\u0010\fA\u0002\u0005}\u0014A\u00033fY&4XM]=JIB!\u0011\u0011QAH\u001d\u0011\t\u0019)a#\u0011\u0007\u0005\u0015u'\u0004\u0002\u0002\b*\u0019\u0011\u0011R\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\tiiN\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055u\u0007K\u0002\u0017\u0003/\u0003B!!'\u0002&6\u0011\u00111\u0014\u0006\u0005\u0003'\niJ\u0003\u0003\u0002 \u0006\u0005\u0016aB7fiJL7m\u001d\u0006\u0004\u0003G\u000b\u0014\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005\u001d\u00161\u0014\u0002\u0006)&lW\rZ\u0001\u000fKbL7\u000f^:EK2Lg/\u001a:z)\u0011\ti+a-\u0011\u0007Y\ny+C\u0002\u00022^\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002~]\u0001\r!a )\u0007]\t9*\u0001\bde\u0016\fG/\u001a#fY&4XM]=\u0015\t\u00055\u00141\u0018\u0005\u0007Ya\u0001\r!!\u001c)\u0007a\ty\f\u0005\u0003\u0002B\u0006=WBAAb\u0015\u0011\t)-a2\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0003\u0013\fY-\u0001\u0004d_6lwN\u001c\u0006\u0004\u0003\u001b\f\u0014AB4p_\u001edW-\u0003\u0003\u0002R\u0006\r'!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\"\u001a\u0001$a&\u0015\r\u00055\u0014q[Am\u0011\u0019a\u0013\u00041\u0001\u0002n!9\u00111\\\rA\u0002\u00055\u0016!\u0003:foJLG/Z%eQ\rI\u0012qS\u0001\u000fkB$\u0017\r^3EK2Lg/\u001a:z)\u0011\ti'a9\t\u000f\u0005\u0015(\u00041\u0001\u0002n\u00059Q\u000f\u001d3bi\u0016$\u0007f\u0001\u000e\u0002\u0018\u0006qA-\u001a7fi\u0016$U\r\\5wKJLH\u0003BAw\u0003g\u00042ANAx\u0013\r\t\tp\u000e\u0002\u0005+:LG\u000fC\u0004\u0002~m\u0001\r!a )\u0007m\t9*A\u0006va\u0012\fG/Z*uC\u001e,GCBA~\u0005\u0003\u0011\u0019\u0001\u0005\u0003\u0002p\u0005u\u0018\u0002BA\u0000\u0003c\u0012Qa\u0015;bO\u0016Dq!! \u001d\u0001\u0004\ty\bC\u0004\u0002fr\u0001\r!a?)\u0007q\t9*\u0001\tva\u0012\fG/\u001a+sC:\u001c\u0018\u000e^5p]R1!1\u0002B\t\u0005'\u0001B!a\u001c\u0003\u000e%!!qBA9\u0005)!&/\u00198tSRLwN\u001c\u0005\b\u0003{j\u0002\u0019AA@\u0011\u001d\t)/\ba\u0001\u0005\u0017A3!HAL)\u0019\u0011YA!\u0007\u0003\u001c!1AF\ba\u0001\u0003[Bq!!:\u001f\u0001\u0004\u0011Y\u0001K\u0002\u001f\u0003/\u000b\u0001#\u001e9eCR,7i\u001c8eSRLwN\\:\u0015\r\t\r\"1\bB !\u0019\u0011)Ca\f\u000369!!q\u0005B\u0016\u001d\u0011\t)I!\u000b\n\u0003aJ1A!\f8\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\r\u00034\t\u00191+Z9\u000b\u0007\t5r\u0007\u0005\u0003\u0002p\t]\u0012\u0002\u0002B\u001d\u0003c\u0012\u0011bQ8oI&$\u0018n\u001c8\t\u000f\tur\u00041\u0001\u0003\f\u0005\u0011rN]5hS:\fG\u000e\u0016:b]NLG/[8o\u0011\u001d\u0011\te\ba\u0001\u0005\u0017\t\u0011#\u001e9eCR,G\r\u0016:b]NLG/[8o\u0003\u0019\u0019X-\u0019:dQRA!q\tB,\u0005_\u0012I\b\u0005\u0004\u0003J\tM\u0013QN\u0007\u0003\u0005\u0017RAA!\u0014\u0003P\u0005!Q\u000f^5m\u0015\t\u0011\t&\u0001\u0003kCZ\f\u0017\u0002\u0002B+\u0005\u0017\u0012A\u0001T5ti\"9!\u0011\f\u0011A\u0002\tm\u0013a\u00024jYR,'o\u001d\t\u0005\u0005;\u0012Y'\u0004\u0002\u0003`)!!\u0011\rB2\u0003\u00151wN]7t\u0015\u0011\u0011)Ga\u001a\u0002\u0005Y\f$b\u0001B5[\u0005\u0019\u0011\r]5\n\t\t5$q\f\u0002\u0018\u0003\n\u001cHO]1di\u0012+G.\u001b<fef4\u0015\u000e\u001c;feNDqA!\u001d!\u0001\u0004\u0011\u0019(\u0001\u0003qC\u001e,\u0007c\u0001,\u0003v%\u0019!qO,\u0003\tA\u000bw-\u001a\u0005\b\u0005w\u0002\u0003\u0019\u0001B?\u0003\u001dy'\u000fZ3s\u0005f\u0004BA!\u0018\u0003\u0000%!!\u0011\u0011B0\u0005E!U\r\\5wKJLxJ\u001d3fe6{G-\u001a\u0015\u0004A\u0005]\u0015aC4fiRKW.\u001a7j]\u0016$bA!#\u0003\u0016\n]\u0005\u0003\u0002BF\u0005#k!A!$\u000b\t\t=%1M\u0001\u0006m&,wo]\u0005\u0005\u0005'\u0013iI\u0001\tEK2Lg/\u001a:z)&lW\r\\5oK\"9\u0011QP\u0011A\u0002\u0005}\u0004b\u0002BMC\u0001\u0007!1T\u0001\u0004]><\b\u0003\u0002BO\u0005Ok!Aa(\u000b\t\t\u0005&1U\u0001\u0005i&lWM\u0003\u0003\u0003&\u0006\u0005\u0014\u0001\u00026pI\u0006LAA!+\u0003 \nAA)\u0019;f)&lW\rK\u0002\"\u0003/\u000b1bZ3u%\u0016dW-Y:fgR!!\u0011\u0017B]!\u0019\u0011IEa\u0015\u00034B!!1\u0012B[\u0013\u0011\u00119L!$\u0003/\u0011+G.\u001b<fef4En\\<SK2,\u0017m]3J]\u001a|\u0007bBA?E\u0001\u0007\u0011q\u0010\u0015\u0004E\u0005]\u0015\u0001\t4j]\u0012$U\r\\5wKJLWm\u001d*fM\u0016\u0014XM\\2j]\u001e\u0014V\r\\3bg\u0016$BA!1\u0003DB1!Q\u0005B\u0018\u0003\u007fBqA!2$\u0001\u0004\ty(A\u0005sK2,\u0017m]3JI\"\u001a1%a&\u0002K\u0019Lg\u000eZ!di&4X\rR3mSZ,'/[3t%\u00164WM]3oG&twMR8mI\u0016\u0014H\u0003\u0002Bg\u0005?\u0004bA!\n\u00030\t=\u0007\u0003\u0002Bi\u00057l!Aa5\u000b\t\tU'q[\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u0002\u0003Z:\u000b1a]9m\u0013\u0011\u0011iNa5\u0003\u001b\rK\u0017\nZ,ji\"$\u0016\u000e\u001e7f\u0011\u001d\u0011\t\u000f\na\u0001\u0003\u007f\n\u0001BZ8mI\u0016\u0014\u0018\n\u001a\u0015\u0004I\u0005]\u0015\u0001E2iK\u000e\\\u0017j]+qI\u0006$\u0018M\u00197f)\u0019\tiO!;\u0003n\"9!1^\u0013A\u0002\u00055\u0014\u0001E3ySN$\u0018N\\4EK2Lg/\u001a:z\u0011%\u0011y/\nI\u0001\u0002\u0004\ty(\u0001\u0004bGRLwN\\\u0001\u001bG\",7m[%t+B$\u0017\r^1cY\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005kTC!a \u0003x.\u0012!\u0011 \t\u0005\u0005w\u001c\u0019!\u0004\u0002\u0003~*!!q`B\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0002T]JAa!\u0002\u0003~\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015\t\u000558\u0011\u0002\u0005\b\u0007\u00179\u0003\u0019AA~\u0003\u0015\u0019H/Y4fQ\r\u00011q\u0002\t\u0005\u0007#\u00199\"\u0004\u0002\u0004\u0014)!1QCA/\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u00073\u0019\u0019BA\u0004TKJ4\u0018nY3")
public class DeliveryService
implements DeliveryTimelineCalculator,
DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final ArchivingService archivingService;
    private final ReleaseSearchService releaseSearchService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validate(Delivery delivery, boolean withQueries) {
        DeliveryServiceUtils.validate$(this, delivery, withQueries);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    @Override
    public DeliveryTimeline calculateTimeline(Delivery delivery, DateTime now) {
        return DeliveryTimelineCalculator.calculateTimeline$(this, delivery, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return DeliveryTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryService deliveryService = this;
        synchronized (deliveryService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getDelivery(String deliveryId) {
        void var2_2;
        Delivery delivery = this.getDeliveryOrPattern(deliveryId);
        this.checkIsDelivery(delivery);
        return var2_2;
    }

    @Timed
    public boolean existsDelivery(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    @VisibleForTesting
    public Delivery createDelivery(Delivery delivery) {
        return this.createDelivery(delivery, true);
    }

    @Timed
    public Delivery createDelivery(Delivery delivery, boolean rewriteId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(32).append("Creating new release delivery [").append(delivery).append("]").toString());
        this.validateDelivery(delivery);
        String deliveryId = rewriteId || delivery.getId() == null || !Ids.isDeliveryId((String)delivery.getId()) ? this.factory().deliveryId() : delivery.getId();
        delivery.setId(deliveryId);
        CiHelper.rewriteWithNewId((ConfigurationItem)delivery, (String)deliveryId);
        delivery.getStages().forEach(stage -> Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
            transition.setStage(stage);
            return BoxedUnit.UNIT;
        }));
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            DeliveryService.$anonfun$createDelivery$4(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public Delivery updateDelivery(Delivery updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("Updating release delivery [").append(updated).append("]").toString());
        this.validateDelivery(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDelivery(String deliveryId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("Deleting release delivery [").append(deliveryId).append("]").toString());
        Delivery delivery = this.deliveryRepository().read(deliveryId);
        this.checkIsDelivery(delivery);
        this.doDelete(deliveryId);
    }

    @Timed
    public Stage updateStage(String deliveryId, Stage updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(32).append("Updating stage '").append(updated).append("' on delivery '").append(deliveryId).append("'").toString());
        Checks.checkNotNull((Object)updated, (String)"Stage");
        Delivery delivery = this.getDelivery(deliveryId);
        this.checkIsUpdatable(delivery, this.checkIsUpdatable$default$2());
        Stage original = delivery.getStageByIdOrTitle(updated.getId());
        Stage originalBeforeChanges = (Stage)CiCloneHelper.cloneCi((ConfigurationItem)original);
        original.setOwner(updated.getOwner());
        original.setTeam(updated.getTeam());
        this.deliveryRepository().update(delivery);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(originalBeforeChanges, original, delivery));
        return original;
    }

    @Timed
    public Transition updateTransition(String deliveryId, Transition updated) {
        return this.updateTransition(this.getDelivery(deliveryId), updated);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Transition updateTransition(Delivery delivery, Transition updated) {
        void var3_3;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(22).append("Updating transition [").append(updated).append("]").toString());
        this.checkIsUpdatable(delivery, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)updated, (String)"Transition");
        Transition original = delivery.getTransitionByIdOrTitle(updated.getId());
        Transition originalBeforeChanges = (Transition)CiCloneHelper.cloneCi((ConfigurationItem)original);
        Stage stage = original.getStage();
        this.checkIsUpdatable(stage);
        this.validateTransition(delivery, stage, updated);
        scala.collection.immutable.Seq<Condition> updatedConditions = this.updateConditions(original, updated);
        original.setAutomated(updated.isAutomated());
        this.deliveryRepository().update(delivery);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(originalBeforeChanges, updated, delivery));
        updatedConditions.foreach((Function1 & Serializable)condition -> {
            DeliveryService.$anonfun$updateTransition$2(this, original, delivery, condition);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private scala.collection.immutable.Seq<Condition> updateConditions(Transition originalTransition, Transition updatedTransition) {
        Buffer originalConditions = CollectionConverters$.MODULE$.ListHasAsScala(originalTransition.getAllConditions()).asScala();
        Buffer updatedConditions = CollectionConverters$.MODULE$.ListHasAsScala(updatedTransition.getAllConditions()).asScala();
        Checks.checkArgument((originalConditions.size() == updatedConditions.size() ? 1 : 0) != 0, (String)"Not permitted to add or remove conditions on a running delivery", (Object[])new Object[0]);
        return ((IterableOnceOps)((IterableOps)originalConditions.zip((IterableOnce)updatedConditions)).flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Condition condition;
                Condition original = (Condition)tuple2._1();
                Condition updated = (Condition)tuple2._2();
                String string = original.getId();
                String string2 = updated.getId();
                Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)new StringBuilder(0).append("Updating order or structure of conditions not allowed on a running delivery. ").append(new StringBuilder(30).append("Expected condition '").append(original.getId()).append("', got '").append(updated.getId()).append("''").toString()).toString(), (Object[])new Object[0]);
                Type type = original.getType();
                Type type2 = updated.getType();
                Checks.checkArgument((!(type != null ? !type.equals(type2) : type2 != null) ? 1 : 0) != 0, (String)"Condition type cannot be changed on a running delivery", (Object[])new Object[0]);
                Condition condition2 = original;
                if (condition2 instanceof ConditionGroup) {
                    none$ = None$.MODULE$;
                } else if (condition2 != null && (condition = condition2).isSatisfied()) {
                    none$ = None$.MODULE$;
                } else {
                    Buffer changedProps = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(original.getInputProperties()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.areEqual((ConfigurationItem)original, (ConfigurationItem)updated)));
                    changedProps.foreach((Function1 & Serializable)pd -> {
                        pd.set((ConfigurationItem)original, pd.get((ConfigurationItem)updated));
                        return BoxedUnit.UNIT;
                    });
                    none$ = changedProps.nonEmpty() ? new Some((Object)original) : None$.MODULE$;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            None$ none$2 = none$;
            return none$2;
        })).toSeq();
    }

    @Timed
    public List<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.deliveryRepository().search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET(), this.deliveryRepository().search$default$7())).asJava();
    }

    @Timed
    public DeliveryTimeline getTimeline(String deliveryId, DateTime now) {
        Delivery delivery = this.getDelivery(deliveryId);
        return this.calculateTimeline(delivery, now);
    }

    @Timed
    public List<DeliveryFlowReleaseInfo> getReleases(String deliveryId) {
        scala.collection.immutable.Seq<DeliveryFlowReleaseInfo> releases = this.deliveryRepository().findReleasesByDeliveryId(deliveryId);
        Set allReleaseIds = this.deliveryRepository().getByIdOrTitle(deliveryId).getReleaseIds();
        scala.collection.immutable.Seq seq = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(allReleaseIds).asScala().filterNot((Function1 & Serializable)fullId -> BoxesRunTime.boxToBoolean((boolean)DeliveryService.$anonfun$getReleases$1(releases, fullId)))).toSeq();
        Nil$ nil$ = package$.MODULE$.Nil();
        scala.collection.immutable.Seq seq2 = seq;
        scala.collection.immutable.Seq seq3 = !(nil$ != null ? !nil$.equals(seq2) : seq2 != null) ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty() : (scala.collection.immutable.Seq)this.archivingService().searchReleasesBasicExtByReleaseIds(seq).map((Function1 & Serializable)item -> new DeliveryFlowReleaseInfo(Ids.getName((String)item.id()), item.title(), item.status(), item.startDate(), item.endDate(), true));
        scala.collection.immutable.Seq archivedReleases = seq3;
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releases.$plus$plus((IterableOnce)archivedReleases)).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findDeliveriesReferencingRelease(String releaseId) {
        return this.deliveryRepository().findDeliveriesReferencingReleaseId(releaseId);
    }

    @Timed
    public scala.collection.immutable.Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolder(String folderId) {
        return this.deliveryRepository().findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        Checks.checkArgument((boolean)existingDelivery.isUpdatable(), (String)new StringBuilder(42).append("Cannot ").append(action).append(" release delivery '").append(existingDelivery.getTitle()).append("' because it is ").append(existingDelivery.getStatus()).toString(), (Object[])new Object[0]);
    }

    public void checkIsUpdatable(Stage stage) {
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(60).append("Cannot update transition on stage '").append(stage.getTitle()).append("' because it is COMPLETED").toString(), (Object[])new Object[0]);
    }

    @Override
    public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static final /* synthetic */ void $anonfun$createDelivery$4(DeliveryService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ void $anonfun$updateTransition$2(DeliveryService $this, Transition original$1, Delivery delivery$2, Condition condition) {
        $this.eventBus().publish((XLReleaseEvent)new ConditionUpdatedEvent(condition, original$1, delivery$2));
    }

    public static final /* synthetic */ boolean $anonfun$getReleases$1(scala.collection.immutable.Seq releases$1, String fullId) {
        return ((SeqOps)releases$1.map((Function1 & Serializable)x$2 -> x$2.getId())).contains((Object)Ids.getName((String)fullId));
    }

    @Autowired
    public DeliveryService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, ArchivingService archivingService, ReleaseSearchService releaseSearchService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.archivingService = archivingService;
        this.releaseSearchService = releaseSearchService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryTimelineCalculator.$init$(this);
        DeliveryServiceUtils.$init$(this);
        Statics.releaseFence();
    }
}

