/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.delivery.events.DeliveryCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryEvent;
import com.xebialabs.xlrelease.delivery.events.ItemAvailableEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemDescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemRescopedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemResetEvent;
import com.xebialabs.xlrelease.delivery.events.ItemSkippedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemTransitionApprovedEvent;
import com.xebialabs.xlrelease.delivery.events.ItemUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageCompletedEvent;
import com.xebialabs.xlrelease.delivery.events.StageReopenedEvent;
import com.xebialabs.xlrelease.delivery.events.StageStartedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionExecutedEvent;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.TransitionEvaluator$;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.TransitionResult;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.StageTrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Date;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmt!B\u00181\u0011\u0003Yd!B\u001f1\u0011\u0003q\u0004\"B#\u0002\t\u00031\u0005\"B$\u0002\t\u0003Ae\u0001B\u001f1\u0001)C\u0001b\r\u0003\u0003\u0006\u0004%\ta\u0013\u0005\t'\u0012\u0011\t\u0011)A\u0005\u0019\"AA\u000b\u0002B\u0001B\u0003%Q\u000bC\u0003F\t\u0011\u00051\fC\u0004_\t\t\u0007I\u0011B0\t\r5$\u0001\u0015!\u0003a\u0011\u001dqGA1A\u0005\n=Da\u0001 \u0003!\u0002\u0013\u0001\b\"B?\u0005\t\u0003q\bbBA\t\t\u0011\u0005\u00111\u0003\u0005\b\u0003/!A\u0011AA\r\u0011\u001d\t)\u0003\u0002C\u0001\u0003OAq!a\u000b\u0005\t\u0003\ti\u0003C\u0004\u0002:\u0011!\t!a\u000f\t\u000f\u0005\rC\u0001\"\u0001\u0002F!9\u0011q\u000b\u0003\u0005\u0002\u0005e\u0003bBA.\t\u0011\u0005\u0011Q\f\u0005\n\u0003\u0017#\u0011\u0013!C\u0001\u0003\u001bC\u0011\"a)\u0005#\u0003%\t!!*\t\u000f\u0005%F\u0001\"\u0001\u0002,\"9\u0011Q\u0017\u0003\u0005\u0002\u0005]\u0006\"CA`\tE\u0005I\u0011AAS\u0011\u001d\t\t\r\u0002C\u0001\u0003\u0007Dq!a2\u0005\t\u0003\tI\rC\u0004\u0002N\u0012!\t!a4\t\u000f\u0005MG\u0001\"\u0001\u0002V\"9\u0011\u0011\u001c\u0003\u0005\u0002\u0005m\u0007bBAq\t\u0011\u0005\u00111\u001d\u0005\n\u0003W$\u0011\u0013!C\u0001\u0003KCq!!<\u0005\t\u0003\ty\u000fC\u0004\u0002z\u0012!\t!a?\t\u000f\u0005eH\u0001\"\u0003\u0003\u0016!9!Q\u0005\u0003\u0005\n\t\u001d\u0002\"\u0003B\u0018\tE\u0005I\u0011\u0002B\u0019\u0011\u001d\u0011)\u0004\u0002C\u0005\u0005oAqAa\u0012\u0005\t\u0013\u0011I\u0005C\u0004\u0003L\u0011!IA!\u0014\t\u000f\tEC\u0001\"\u0003\u0003T!9!q\u000b\u0003\u0005\n\te\u0003b\u0002B.\t\u0011%!Q\f\u0005\b\u0005C\"A\u0011\u0002B2\u0011\u001d\u0011I\u0007\u0002C\u0005\u00053\nA\u0003R3mSZ,'/_*uCR,W*\u00198bO\u0016\u0014(BA\u00193\u0003\u001d\u0019XM\u001d<jG\u0016T!a\r\u001b\u0002\u0011\u0011,G.\u001b<fefT!!\u000e\u001c\u0002\u0013ad'/\u001a7fCN,'BA\u001c9\u0003%AXMY5bY\u0006\u00147OC\u0001:\u0003\r\u0019w.\\\u0002\u0001!\ta\u0014!D\u00011\u0005Q!U\r\\5wKJL8\u000b^1uK6\u000bg.Y4feN\u0011\u0011a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0014!B1qa2LH#B%\u0003l\t5\u0004C\u0001\u001f\u0005'\t!q(F\u0001M!\ti\u0015+D\u0001O\u0015\t\u0019tJ\u0003\u0002Qi\u00051Am\\7bS:L!A\u0015(\u0003\u0011\u0011+G.\u001b<fef\f\u0011\u0002Z3mSZ,'/\u001f\u0011\u0002\u000f\u0019\f7\r^8ssB\u0011a+W\u0007\u0002/*\u0011\u0001LM\u0001\u0005kRLG.\u0003\u0002[/\n)B)\u001a7jm\u0016\u0014\u0018p\u00142kK\u000e$h)Y2u_JLHcA%];\")1\u0007\u0003a\u0001\u0019\")A\u000b\u0003a\u0001+\u00061QM^3oiN,\u0012\u0001\u0019\t\u0004C\u001aDW\"\u00012\u000b\u0005\r$\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003K\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\t9'M\u0001\u0004Ck\u001a4WM\u001d\t\u0003S.l\u0011A\u001b\u0006\u0003=JJ!\u0001\u001c6\u0003\u001b\u0011+G.\u001b<fef,e/\u001a8u\u0003\u001d)g/\u001a8ug\u0002\n\u0001\"\\3tg\u0006<Wm]\u000b\u0002aB\u0019\u0011MZ9\u0011\u0005ILhBA:x!\t!\u0018)D\u0001v\u0015\t1((\u0001\u0004=e>|GOP\u0005\u0003q\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u00010Q\u0001\n[\u0016\u001c8/Y4fg\u0002\n\u0011bZ3u\u000bZ,g\u000e^:\u0016\u0003}\u0004R!!\u0001\u0002\f!tA!a\u0001\u0002\b9\u0019A/!\u0002\n\u0003\tK1!!\u0003B\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\t!A*[:u\u0015\r\tI!Q\u0001\fO\u0016$X*Z:tC\u001e,7/\u0006\u0002\u0002\u0016A)\u0011\u0011AA\u0006c\u0006q\u0011\r\u001a3Ue\u0006\u001c7.\u001a3Ji\u0016lG\u0003BA\u000e\u0003C\u00012!TA\u000f\u0013\r\tyB\u0014\u0002\f)J\f7m[3e\u0013R,W\u000eC\u0004\u0002$=\u0001\r!a\u0007\u0002\t%$X-\\\u0001\u0012kB$\u0017\r^3Ue\u0006\u001c7.\u001a3Ji\u0016lG\u0003BA\u000e\u0003SAq!a\t\u0011\u0001\u0004\tY\"A\teK2,G/\u001a+sC\u000e\\W\rZ%uK6$B!a\f\u00026A\u0019\u0001)!\r\n\u0007\u0005M\u0012I\u0001\u0003V]&$\bBBA\u001c#\u0001\u0007\u0011/\u0001\u0004ji\u0016l\u0017\nZ\u0001\u0011C\u0012$'+\u001a7fCN,Gk\\%uK6$b!a\f\u0002>\u0005}\u0002bBA\u0012%\u0001\u0007\u00111\u0004\u0005\u0007\u0003\u0003\u0012\u0002\u0019A9\u0002\u0013I,G.Z1tK&#\u0017A\u0005:fO&\u001cH/\u001a:Tk\n\u001c8M]5cKJ$B!a\u0012\u0002NA\u0019Q*!\u0013\n\u0007\u0005-cJ\u0001\nTk\n\u001c8M]5qi&|gNU3tk2$\bbBA('\u0001\u0007\u0011\u0011K\u0001\u000bgV\u00147o\u0019:jE\u0016\u0014\bcA'\u0002T%\u0019\u0011Q\u000b(\u0003\u0015M+(m]2sS\n,'/A\u0003ti\u0006\u0014H\u000fF\u0001M\u0003]i\u0017M]6Ue\u0006\u001c7.\u001a3Ji\u0016l7/\u00138Ti\u0006<W\r\u0006\u0007\u0002`\u0005\u0015\u0014\u0011NA:\u0003{\n9\t\u0005\u0004\u0002\u0002\u0005\u0005\u00141D\u0005\u0005\u0003G\nyAA\u0002TKFDq!a\u001a\u0016\u0001\u0004\ty&A\u0003ji\u0016l7\u000fC\u0004\u0002lU\u0001\r!!\u001c\u0002\u000bM$\u0018mZ3\u0011\u00075\u000by'C\u0002\u0002r9\u0013Qa\u0015;bO\u0016Dq!!\u001e\u0016\u0001\u0004\t9(\u0001\u0004ti\u0006$Xo\u001d\t\u0004\u001b\u0006e\u0014bAA>\u001d\n\tBK]1dW\u0016$\u0017\n^3n'R\fG/^:\t\u0013\u0005}T\u0003%AA\u0002\u0005\u0005\u0015a\u00049sK\u000e,G-\u001b8h'R\fw-Z:\u0011\u0007\u0001\u000b\u0019)C\u0002\u0002\u0006\u0006\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\nV\u0001\n\u00111\u0001r\u000351'o\\7SK2,\u0017m]3JI\u0006\tS.\u0019:l)J\f7m[3e\u0013R,Wn]%o'R\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0012\u0016\u0005\u0003\u0003\u000b\tj\u000b\u0002\u0002\u0014B!\u0011QSAP\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015!C;oG\",7m[3e\u0015\r\ti*Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAQ\u0003/\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0005j\u0017M]6Ue\u0006\u001c7.\u001a3Ji\u0016l7/\u00138Ti\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00136+\t\t9KK\u0002r\u0003#\u000ba#\\1sWR\u0013\u0018mY6fI&#X-\\%o'R\fw-\u001a\u000b\u000b\u0003_\ti+a,\u00022\u0006M\u0006bBA\u00121\u0001\u0007\u00111\u0004\u0005\b\u0003WB\u0002\u0019AA7\u0011\u001d\t)\b\u0007a\u0001\u0003oBa!!#\u0019\u0001\u0004\t\u0018AG2p[BdW\r^3Ue\u0006\u001c7.\u001a3Ji\u0016l\u0017J\\*uC\u001e,Gc\u0002'\u0002:\u0006m\u0016Q\u0018\u0005\b\u0003GI\u0002\u0019AA\u000e\u0011\u001d\tY'\u0007a\u0001\u0003[B\u0001\"!#\u001a!\u0003\u0005\r!]\u0001%G>l\u0007\u000f\\3uKR\u0013\u0018mY6fI&#X-\\%o'R\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005i1m\\7qY\u0016$Xm\u0015;bO\u0016$B!a\f\u0002F\"9\u00111N\u000eA\u0002\u00055\u0014a\u0003:f_B,gn\u0015;bO\u0016$B!a\f\u0002L\"9\u00111\u000e\u000fA\u0002\u00055\u0014\u0001\u00043fg\u000e|\u0007/Z%uK6\u001cH\u0003BA\u0018\u0003#Dq!a\u001a\u001e\u0001\u0004\ty&\u0001\u0007sKN\u001cw\u000e]3Ji\u0016l7\u000f\u0006\u0003\u00020\u0005]\u0007bBA4=\u0001\u0007\u0011qL\u0001\u0017g.L\u0007\u000f\u0016:bG.,G-\u0013;f[&s7\u000b^1hKR)A*!8\u0002`\"9\u00111E\u0010A\u0002\u0005m\u0001bBA6?\u0001\u0007\u0011QN\u0001\u0018e\u0016\u001cX\r\u001e+sC\u000e\\W\rZ%uK6Len\u0015;bO\u0016$r\u0001TAs\u0003O\fI\u000fC\u0004\u0002$\u0001\u0002\r!a\u0007\t\u000f\u0005-\u0004\u00051\u0001\u0002n!A\u0011\u0011\u0012\u0011\u0011\u0002\u0003\u0007\u0011/A\u0011sKN,G\u000f\u0016:bG.,G-\u0013;f[&s7\u000b^1hK\u0012\"WMZ1vYR$3'A\bti\u0006\u0014Ho\u0015;bO\u0016<%o\\;q)\u0019\ty#!=\u0002x\"9\u00111\u001f\u0012A\u0002\u0005U\u0018AB:uC\u001e,7\u000f\u0005\u0004\u0002\u0002\u0005\u0005\u0014Q\u000e\u0005\b\u0003O\u0012\u0003\u0019AA0\u0003AA\u0017M\u001c3mKR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u00020\u0005u(q\u0001\u0005\b\u0003\u007f\u001c\u0003\u0019\u0001B\u0001\u0003)!(/\u00198tSRLwN\u001c\t\u0004\u001b\n\r\u0011b\u0001B\u0003\u001d\nQAK]1og&$\u0018n\u001c8\t\u000f\t%1\u00051\u0001\u0003\f\u00051\u0001/\u0019:b[N\u0004BA!\u0004\u0003\u00125\u0011!q\u0002\u0006\u0004\u0003\u007f\u0014\u0014\u0002\u0002B\n\u0005\u001f\u0011\u0001\u0003\u0016:b]NLG/[8o!\u0006\u0014\u0018-\\:\u0015\u0011\u0005=\"q\u0003B\r\u00057Aq!a@%\u0001\u0004\u0011\t\u0001C\u0004\u0003\n\u0011\u0002\rAa\u0003\t\u000f\tuA\u00051\u0001\u0003 \u0005\u0001BO]1og&$\u0018n\u001c8SKN,H\u000e\u001e\t\u0005\u0005\u001b\u0011\t#\u0003\u0003\u0003$\t=!\u0001\u0005+sC:\u001c\u0018\u000e^5p]J+7/\u001e7u\u0003m1wN]2f\u00072|7/Z*uC\u001e,7/\u00134O_R\u001cEn\\:fIR1\u0011q\u0006B\u0015\u0005WAq!a=&\u0001\u0004\t)\u0010C\u0005\u0003.\u0015\u0002\n\u00111\u0001\u0002`\u0005q\u0011\u000e^3ngR{G)Z:d_B,\u0017!\n4pe\u000e,7\t\\8tKN#\u0018mZ3t\u0013\u001atu\u000e^\"m_N,G\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019D\u000b\u0003\u0002`\u0005E\u0015!\n4pe\u000e,7k[5q)J\f7m[3e\u0013R,W.\u00138Ti\u0006<W-\u00134O_R\u0014V-\u00193z)!\tyC!\u000f\u0003<\tu\u0002bBA\u0012O\u0001\u0007\u00111\u0004\u0005\b\u0003W:\u0003\u0019AA7\u0011\u001d\u0011yd\na\u0001\u0005\u0003\n\u0001c\u001d;bO\u0016$&/Y2lK\u0012LE/Z7\u0011\u00075\u0013\u0019%C\u0002\u0003F9\u0013\u0001c\u0015;bO\u0016$&/Y2lK\u0012LE/Z7\u0002\u0013!\f7o\u0015;bO\u0016\u001cXCAAA\u0003UI7/\u00117m_^,G\rV8DY>\u001cXm\u0015;bO\u0016$B!!!\u0003P!9\u00111N\u0015A\u0002\u00055\u0014AF5t\u00032dwn^3e)>\u0014Vm\u001c9f]N#\u0018mZ3\u0015\t\u0005\u0005%Q\u000b\u0005\b\u0003WR\u0003\u0019AA7\u0003U\u0019\u0007.Z2l\t\u0016d\u0017N^3ss&\u001b\u0018i\u0019;jm\u0016$\"!a\f\u0002\u001b\u0005$GmU;cg\u000e\u0014\u0018NY3s)\u0011\t9Ea\u0018\t\u000f\u0005=C\u00061\u0001\u0002R\u0005\u00192\r[3dW&#X-\\%t\u000b\u0012LG/\u00192mKR1\u0011q\u0006B3\u0005OBq!a\t.\u0001\u0004\tY\u0002C\u0004\u0002l5\u0002\r!!\u001c\u0002/\rDWmY6EK2Lg/\u001a:z\u0013N,E-\u001b;bE2,\u0007\"B\u001a\u0004\u0001\u0004a\u0005b\u0002B8\u0007\u0001\u0007!\u0011O\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0003\u0003t\t]TB\u0001B;\u0015\t\tD'\u0003\u0003\u0003z\tU$aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004")
public class DeliveryStateManager {
    private final Delivery delivery;
    private final DeliveryObjectFactory factory;
    private final Buffer<DeliveryEvent> events;
    private final Buffer<String> messages;

    public static DeliveryStateManager apply(Delivery delivery, CiIdService ciIdService) {
        return DeliveryStateManager$.MODULE$.apply(delivery, ciIdService);
    }

    public Delivery delivery() {
        return this.delivery;
    }

    private Buffer<DeliveryEvent> events() {
        return this.events;
    }

    private Buffer<String> messages() {
        return this.messages;
    }

    public List<DeliveryEvent> getEvents() {
        return this.events().toList();
    }

    public List<String> getMessages() {
        return this.messages().toList();
    }

    public TrackedItem addTrackedItem(TrackedItem item) {
        block0: {
            this.checkDeliveryIsActive();
            String itemId = this.factory.trackedItemId(this.delivery().getId());
            item.setId(itemId);
            item.setModifiedDate(new Date());
            this.delivery().addTrackedItem(item);
            this.delivery().addReleaseIds(item.getReleaseIds());
            this.events().$plus$eq((Object)new ItemCreatedEvent(item, this.delivery()));
            if (this.delivery().isTemplate()) break block0;
            this.delivery().getStagesBeforeFirstOpenTransition().forEach(stage -> {
                block0: {
                    StageTrackedItem stageTrackedItem = $this.factory.createStageTrackedItem(stage.getId(), itemId);
                    stage.getItems().add(stageTrackedItem);
                    this.events().$plus$eq((Object)new ItemAvailableEvent(item, (Stage)stage, this.delivery()));
                    if (!stage.isClosed()) break block0;
                    stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
                    this.events().$plus$eq((Object)new ItemSkippedEvent(item, (Stage)stage, this.delivery()));
                }
            });
        }
        return item;
    }

    /*
     * WARNING - void declaration
     */
    public TrackedItem updateTrackedItem(TrackedItem item) {
        void var2_2;
        this.checkDeliveryIsActive();
        TrackedItem updatedItem = this.delivery().getItemByIdOrTitle(item.getId());
        TrackedItem originalItem = (TrackedItem)CiCloneHelper.cloneCi((ConfigurationItem)updatedItem);
        updatedItem.setTitle(item.getTitle());
        updatedItem.setModifiedDate(new Date());
        this.events().$plus$eq((Object)new ItemUpdatedEvent(updatedItem, this.delivery(), originalItem));
        return var2_2;
    }

    public void deleteTrackedItem(String itemId) {
        this.checkDeliveryIsActive();
        TrackedItem item = this.delivery().getItemByIdOrTitle(itemId);
        this.delivery().removeTrackedItem(itemId);
        if (!this.delivery().isTemplate()) {
            this.delivery().getStages().forEach(x$1 -> x$1.removeTrackedItem(itemId));
        }
        this.events().$plus$eq((Object)new ItemRemovedEvent(item, this.delivery()));
    }

    public void addReleaseToItem(TrackedItem item, String releaseId) {
        this.checkDeliveryIsActive();
        item.addReleaseId(releaseId);
        this.delivery().addReleaseId(releaseId);
    }

    public SubscriptionResult registerSubscriber(Subscriber subscriber) {
        this.checkDeliveryIsActive();
        return this.addSubscriber(subscriber);
    }

    public Delivery start() {
        block0: {
            this.delivery().setStatus(DeliveryStatus.IN_PROGRESS);
            if (!this.hasStages()) break block0;
            scala.collection.immutable.Seq firstStageGroup = CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStagesBeforeFirstOpenTransition()).asScala().toSeq();
            this.startStageGroup((scala.collection.immutable.Seq<Stage>)firstStageGroup, (scala.collection.immutable.Seq<TrackedItem>)CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getTrackedItems()).asScala().toSeq());
        }
        return this.delivery();
    }

    public scala.collection.immutable.Seq<TrackedItem> markTrackedItemsInStage(scala.collection.immutable.Seq<TrackedItem> items, Stage stage2, TrackedItemStatus status, boolean precedingStages, String fromReleaseId) {
        Set doneItems;
        Tuple2 tuple2;
        this.checkDeliveryIsEditable();
        Checks.checkTrue((boolean)stage2.isOpen(), (String)"Stage must be open in order to update items in it", (Object[])new Object[0]);
        scala.collection.immutable.Seq descopedItems = (scala.collection.immutable.Seq)items.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped()));
        Checks.checkTrue((boolean)descopedItems.isEmpty(), (String)new StringBuilder(72).append("Unable to complete task, the following tracked items are de-scoped:\n * ").append(((IterableOnceOps)descopedItems.map((Function1 & Serializable)x$3 -> x$3.getTitle())).mkString("\n * ")).append("\n").toString(), (Object[])new Object[0]);
        if (precedingStages) {
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStagesBefore(stage2)).asScala().dropWhile((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isClosed()))).foreach((Function1 & Serializable)stage -> {
                scala.collection.immutable.Seq itemsInStage = (scala.collection.immutable.Seq)items.filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$markTrackedItemsInStage$5(stage, item)));
                return this.markTrackedItemsInStage((scala.collection.immutable.Seq<TrackedItem>)itemsInStage, (Stage)stage, status, false, fromReleaseId);
            });
        }
        if ((tuple2 = items.partition(arg_0 -> DeliveryStateManager.$anonfun$markTrackedItemsInStage$8$adapted(doneItems = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(stage2.getItems()).asScala().filter((Function1 & Serializable)stageItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$markTrackedItemsInStage$6(status, stageItem)))).map((Function1 & Serializable)x$5 -> x$5.getTrackedItemId())).toSet(), arg_0))) == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq done = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq notDone = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)done, (Object)notDone);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Seq done2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq notDone2 = (scala.collection.immutable.Seq)tuple23._2();
        Object object = done2.nonEmpty() ? this.messages().$plus$eq((Object)new StringBuilder(50).append("Tracked items [").append(((IterableOnceOps)done2.map((Function1 & Serializable)x$7 -> x$7.getId())).mkString(", ")).append("] are already in status on stage '").append(stage2.getId()).append("'").toString()) : BoxedUnit.UNIT;
        notDone2.foreach((Function1 & Serializable)x$8 -> {
            this.markTrackedItemInStage(x$8, stage2, status, fromReleaseId);
            return BoxedUnit.UNIT;
        });
        return notDone2;
    }

    public boolean markTrackedItemsInStage$default$4() {
        return false;
    }

    public String markTrackedItemsInStage$default$5() {
        return null;
    }

    public void markTrackedItemInStage(TrackedItem item, Stage stage, TrackedItemStatus status, String fromReleaseId) {
        TrackedItemStatus trackedItemStatus = status;
        if (TrackedItemStatus.READY.equals(trackedItemStatus)) {
            this.completeTrackedItemInStage(item, stage, fromReleaseId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TrackedItemStatus.SKIPPED.equals(trackedItemStatus)) {
            this.skipTrackedItemInStage(item, stage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TrackedItemStatus.NOT_READY.equals(trackedItemStatus)) {
            this.resetTrackedItemInStage(item, stage, fromReleaseId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Delivery completeTrackedItemInStage(TrackedItem item, Stage stage, String fromReleaseId) {
        BoxedUnit boxedUnit;
        this.checkItemIsEditable(item, stage);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.READY;
        if (trackedItemStatus == null ? trackedItemStatus2 != null : !trackedItemStatus.equals(trackedItemStatus2)) {
            stageItem.setStatus(TrackedItemStatus.READY);
            boxedUnit = this.events().$plus$eq((Object)new ItemCompletedEvent(item, stage, this.delivery(), fromReleaseId));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.delivery();
    }

    public String completeTrackedItemInStage$default$3() {
        return null;
    }

    public void completeStage(Stage stage) {
        this.checkDeliveryIsEditable();
        Checks.checkTrue((boolean)this.isAllowedToCloseStage(stage), (String)"Stages cannot be completed if their preceding stages are not closed", (Object[])new Object[0]);
        scala.collection.immutable.Seq toDescopeAndSkip = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(stage.getItems()).asScala().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$completeStage$1(x$9)))).map((Function1 & Serializable)stageItem -> this.delivery().getItemByIdOrTitle(stageItem.getTrackedItemId()))).toSeq();
        this.forceCloseStagesIfNotClosed((scala.collection.immutable.Seq<Stage>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Stage[]{stage}))), (scala.collection.immutable.Seq<TrackedItem>)toDescopeAndSkip);
    }

    public void reopenStage(Stage stage) {
        block0: {
            this.checkDeliveryIsEditable();
            Checks.checkTrue((boolean)this.isAllowedToReopenStage(stage), (String)"Stages cannot be reopened if their subsequent stages are closed", (Object[])new Object[0]);
            if (!stage.isClosed()) break block0;
            stage.setStatus(StageStatus.OPEN);
            this.events().$plus$eq((Object)new StageReopenedEvent(stage, this.delivery()));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)x$10 -> {
                DeliveryStateManager.$anonfun$reopenStage$1(x$10);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void descopeItems(scala.collection.immutable.Seq<TrackedItem> items) {
        Map itemsNotYetDescoped = ((IterableOnceOps)((IterableOps)items.view().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isDescoped()))).map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), item))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        itemsNotYetDescoped.valuesIterator().foreach((Function1 & Serializable)item -> {
            item.setDescoped(true);
            return (Buffer)this.events().$plus$eq((Object)new ItemDescopedEvent((TrackedItem)item, this.delivery()));
        });
    }

    public void rescopeItems(scala.collection.immutable.Seq<TrackedItem> items) {
        Map descopedItems = ((IterableOnceOps)((IterableOps)items.view().filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDescoped()))).map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.getId()), item))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        descopedItems.valuesIterator().foreach((Function1 & Serializable)item -> {
            item.setDescoped(false);
            return (Buffer)this.events().$plus$eq((Object)new ItemRescopedEvent((TrackedItem)item, this.delivery()));
        });
    }

    public Delivery skipTrackedItemInStage(TrackedItem item, Stage stage) {
        this.checkItemIsEditable(item, stage);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        this.forceSkipTrackedItemInStageIfNotReady(item, stage, stageItem);
        return this.delivery();
    }

    public Delivery resetTrackedItemInStage(TrackedItem item, Stage stage, String fromReleaseId) {
        BoxedUnit boxedUnit;
        this.checkItemIsEditable(item, stage);
        StageTrackedItem stageItem = stage.getItemById(item.getId());
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        if (trackedItemStatus == null ? trackedItemStatus2 != null : !trackedItemStatus.equals(trackedItemStatus2)) {
            stageItem.setStatus(TrackedItemStatus.NOT_READY);
            this.events().$plus$eq((Object)new ItemResetEvent(item, stage, this.delivery(), fromReleaseId));
            boxedUnit = this.events().$plus$eq((Object)new ItemAvailableEvent(item, stage, this.delivery()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.delivery();
    }

    public String resetTrackedItemInStage$default$3() {
        return null;
    }

    public void startStageGroup(scala.collection.immutable.Seq<Stage> stages, scala.collection.immutable.Seq<TrackedItem> items) {
        stages.foreach((Function1 & Serializable)stage -> {
            DeliveryStateManager.$anonfun$startStageGroup$1(this, items, stage);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTransition(Transition transition, TransitionParams params) {
        TransitionEvaluator$.MODULE$.evaluate(params).foreach((Function1 & Serializable)result -> {
            this.handleTransition(transition, params, result);
            return BoxedUnit.UNIT;
        });
    }

    private void handleTransition(Transition transition, TransitionParams params, TransitionResult transitionResult) {
        this.events().$plus$eq((Object)new TransitionExecutedEvent(transition, this.delivery(), params));
        Stage stage2 = this.delivery().getStageByTransition(transition);
        transitionResult.toTransition().toList().foreach((Function1 & Serializable)item -> (Buffer)this.events().$plus$eq((Object)new ItemTransitionApprovedEvent((TrackedItem)item, (StageTrackedItem)stage2.findItemById(item.getId()).get(), transition, stage2, this.delivery())));
        if (transitionResult.closeStages()) {
            Buffer stagesToClose = (Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStagesBefore(params.transitionStage())).asScala().filter((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)stage.isOpen()))).$colon$plus((Object)params.transitionStage());
            this.forceCloseStagesIfNotClosed((scala.collection.immutable.Seq<Stage>)stagesToClose.toSeq(), (scala.collection.immutable.Seq<TrackedItem>)transitionResult.toDescope().toList());
        }
        scala.collection.immutable.Seq nextStageGroup = CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getStageGroupAfterTransition(transition)).asScala().toSeq();
        this.startStageGroup((scala.collection.immutable.Seq<Stage>)nextStageGroup, (scala.collection.immutable.Seq<TrackedItem>)transitionResult.toTransition().toList());
    }

    private void forceCloseStagesIfNotClosed(scala.collection.immutable.Seq<Stage> stages, scala.collection.immutable.Seq<TrackedItem> itemsToDescope) {
        stages.foreach((Function1 & Serializable)stage -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            itemsToDescope.foreach((Function1 & Serializable)item -> {
                DeliveryStateManager.$anonfun$forceCloseStagesIfNotClosed$2(this, stage, item);
                return BoxedUnit.UNIT;
            });
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)x$17 -> {
                x$17.setAutomated(false);
                return BoxedUnit.UNIT;
            });
            if (stage.isOpen()) {
                stage.setStatus(StageStatus.CLOSED);
                boxedUnit2 = this.events().$plus$eq((Object)new StageCompletedEvent((Stage)stage, this.delivery()));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.delivery().isLastStage(stage)) {
                this.delivery().setStatus(DeliveryStatus.COMPLETED);
                boxedUnit = this.events().$plus$eq((Object)new DeliveryCompletedEvent(this.delivery()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        this.descopeItems(itemsToDescope);
    }

    private scala.collection.immutable.Seq<TrackedItem> forceCloseStagesIfNotClosed$default$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private void forceSkipTrackedItemInStageIfNotReady(TrackedItem item, Stage stage, StageTrackedItem stageTrackedItem) {
        block0: {
            TrackedItemStatus trackedItemStatus = stageTrackedItem.getStatus();
            TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
            if (trackedItemStatus != null ? !trackedItemStatus.equals(trackedItemStatus2) : trackedItemStatus2 != null) break block0;
            stageTrackedItem.setStatus(TrackedItemStatus.SKIPPED);
            this.events().$plus$eq((Object)new ItemSkippedEvent(item, stage, this.delivery()));
        }
    }

    private boolean hasStages() {
        return this.delivery().getStages() != null && !this.delivery().getStages().isEmpty();
    }

    private boolean isAllowedToCloseStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findPreviousStage(stage))).forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToCloseStage$1(x$18)));
    }

    private boolean isAllowedToReopenStage(Stage stage) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.delivery().findNextStage(stage))).forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DeliveryStateManager.$anonfun$isAllowedToReopenStage$1(x$19)));
    }

    private void checkDeliveryIsActive() {
        Checks.checkTrue((!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])DeliveryStatus.INACTIVE_STATUSES), (Object)this.delivery().getStatus()) ? 1 : 0) != 0, (String)"Can't modify ABORTED or COMPLETED release delivery", (Object[])new Object[0]);
    }

    private SubscriptionResult addSubscriber(Subscriber subscriber) {
        Object object;
        SubscriptionStatus subscriptionStatus;
        subscriber.validate(this.delivery());
        SubscriptionResult result = subscriber.evaluate(this.delivery());
        int subscriberIndex = CollectionConverters$.MODULE$.ListHasAsScala(this.delivery().getSubscribers()).asScala().indexWhere((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.isEqual(subscriber)));
        SubscriptionResult subscriptionResult = result;
        if (subscriptionResult != null && SubscriptionStatus.COMPLETED.equals(subscriptionStatus = subscriptionResult.status()) && subscriberIndex != -1) {
            object = this.delivery().getSubscribers().remove(subscriberIndex);
        } else {
            SubscriptionStatus subscriptionStatus2;
            SubscriptionStatus subscriptionStatus3;
            boolean bl = subscriptionResult != null && SubscriptionStatus.FAILED.equals(subscriptionStatus3 = subscriptionResult.status()) ? true : subscriptionResult != null && SubscriptionStatus.IN_PROGRESS.equals(subscriptionStatus2 = subscriptionResult.status());
            if (bl && subscriberIndex != -1) {
                object = this.delivery().getSubscribers().set(subscriberIndex, subscriber);
            } else {
                SubscriptionStatus subscriptionStatus4;
                SubscriptionStatus subscriptionStatus5;
                boolean bl2 = subscriptionResult != null && SubscriptionStatus.FAILED.equals(subscriptionStatus5 = subscriptionResult.status()) ? true : subscriptionResult != null && SubscriptionStatus.IN_PROGRESS.equals(subscriptionStatus4 = subscriptionResult.status());
                if (bl2) {
                    this.delivery().addSubscriber(subscriber);
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
        }
        return result;
    }

    private void checkItemIsEditable(TrackedItem item, Stage stage) {
        this.checkDeliveryIsEditable();
        Checks.checkTrue((boolean)stage.isOpen(), (String)"Stage must be open in order to update items in it", (Object[])new Object[0]);
        Checks.checkTrue((!item.isDescoped() ? 1 : 0) != 0, (String)"Cannot change status of descoped item", (Object[])new Object[0]);
    }

    private void checkDeliveryIsEditable() {
        DeliveryStatus deliveryStatus = this.delivery().getStatus();
        DeliveryStatus deliveryStatus2 = DeliveryStatus.IN_PROGRESS;
        Checks.checkTrue((!(deliveryStatus != null ? !deliveryStatus.equals(deliveryStatus2) : deliveryStatus2 != null) ? 1 : 0) != 0, (String)"Delivery must be active in order to change state", (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$5(Stage stage$1, TrackedItem item) {
        return stage$1.findItemById(item.getId()).isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$6(TrackedItemStatus status$1, StageTrackedItem stageItem) {
        TrackedItemStatus trackedItemStatus = stageItem.getStatus();
        TrackedItemStatus trackedItemStatus2 = status$1;
        return !(trackedItemStatus != null ? !trackedItemStatus.equals(trackedItemStatus2) : trackedItemStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$completeStage$1(StageTrackedItem x$9) {
        TrackedItemStatus trackedItemStatus = x$9.getStatus();
        TrackedItemStatus trackedItemStatus2 = TrackedItemStatus.NOT_READY;
        return !(trackedItemStatus != null ? !trackedItemStatus.equals(trackedItemStatus2) : trackedItemStatus2 != null);
    }

    public static final /* synthetic */ void $anonfun$reopenStage$1(Transition x$10) {
        x$10.getAllConditions().forEach(x$11 -> x$11.reset());
    }

    public static final /* synthetic */ void $anonfun$startStageGroup$1(DeliveryStateManager $this, scala.collection.immutable.Seq items$2, Stage stage) {
        block0: {
            Set existingItems = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(stage.getItems()).asScala().map((Function1 & Serializable)x$14 -> x$14.getTrackedItemId())).toSet();
            scala.collection.immutable.Seq newItems = (scala.collection.immutable.Seq)items$2.filterNot((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)existingItems.apply((Object)item.getId())));
            java.util.List stageItems = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newItems.map((Function1 & Serializable)item -> $this.factory.createStageTrackedItem(stage.getId(), item.getId()))).asJava();
            stage.addTrackedItems(stageItems);
            Object object = existingItems.isEmpty() ? $this.events().$plus$eq((Object)new StageStartedEvent(stage, $this.delivery())) : BoxedUnit.UNIT;
            newItems.foreach((Function1 & Serializable)x$15 -> (Buffer)$this.events().$plus$eq((Object)new ItemAvailableEvent((TrackedItem)x$15, stage, $this.delivery())));
            if (!stage.isClosed()) break block0;
            stageItems.forEach(stageItem -> stageItem.setStatus(TrackedItemStatus.SKIPPED));
            newItems.foreach((Function1 & Serializable)x$16 -> (Buffer)$this.events().$plus$eq((Object)new ItemSkippedEvent((TrackedItem)x$16, stage, $this.delivery())));
        }
    }

    public static final /* synthetic */ void $anonfun$forceCloseStagesIfNotClosed$2(DeliveryStateManager $this, Stage stage$5, TrackedItem item) {
        stage$5.findItemById(item.getId()).ifPresent(stageItem -> $this.forceSkipTrackedItemInStageIfNotReady(item, stage$5, (StageTrackedItem)stageItem));
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToCloseStage$1(Stage x$18) {
        StageStatus stageStatus = x$18.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return !(stageStatus != null ? !stageStatus.equals(stageStatus2) : stageStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isAllowedToReopenStage$1(Stage x$19) {
        StageStatus stageStatus = x$19.getStatus();
        StageStatus stageStatus2 = StageStatus.CLOSED;
        return stageStatus == null ? stageStatus2 != null : !stageStatus.equals(stageStatus2);
    }

    public DeliveryStateManager(Delivery delivery, DeliveryObjectFactory factory) {
        this.delivery = delivery;
        this.factory = factory;
        this.events = (Buffer)Buffer$.MODULE$.empty();
        this.messages = (Buffer)Buffer$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$markTrackedItemsInStage$8$adapted(Set doneItems$1, TrackedItem item) {
        return BoxesRunTime.boxToBoolean((boolean)doneItems$1.contains((Object)item.getId()));
    }
}

