/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.ConditionSatisfiedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.ConditionTrigger;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.UserTrigger;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t-h\u0001B\u0011#\u00015B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u000b\u0005\u0004A\u0011\u00012\t\u000bi\u0004A\u0011A>\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a/\u0001\t\u0003\ti\fC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003c\u0004A\u0011AAz\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+A\u0011Ba\u000e\u0001#\u0003%\tA!\u000f\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B3\u0001\u0011\u0005!q\r\u0005\b\u0005_\u0002A\u0011\u0001B9\u0011\u001d\u0011I\b\u0001C\u0005\u0005wBqAa&\u0001\t\u0013\u0011I\nC\u0004\u0003 \u0002!IA!)\t\u000f\tu\u0006\u0001\"\u0003\u0003@\"I!1\u001a\u0001\u0012\u0002\u0013%!\u0011\b\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0011\u001d\u0011)\u000e\u0001C\u0005\u0005/\u0014\u0001\u0004R3mSZ,'/_#yK\u000e,H/[8o'\u0016\u0014h/[2f\u0015\t\u0019C%A\u0004tKJ4\u0018nY3\u000b\u0005\u00152\u0013\u0001\u00033fY&4XM]=\u000b\u0005\u001dB\u0013!\u0003=me\u0016dW-Y:f\u0015\tI#&A\u0005yK\nL\u0017\r\\1cg*\t1&A\u0002d_6\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0014\u0001C4sSjTH.\u001a3\n\u0005m2$a\u0002'pO\u001eLgnZ\u0001\u0013I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002?\u00036\tqH\u0003\u0002AI\u0005Q!/\u001a9pg&$xN]=\n\u0005\t{$A\u0005#fY&4XM]=SKB|7/\u001b;pef\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\t)u)D\u0001G\u0015\t\u0001e%\u0003\u0002I\r\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011QiS\u0005\u0003\u0019\u001a\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\u0006dS&#7+\u001a:wS\u000e,\u0007CA(R\u001b\u0005\u0001&BA\u0012'\u0013\t\u0011\u0006KA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001C3wK:$()^:\u0011\u0005UCV\"\u0001,\u000b\u0005]3\u0013AB3wK:$8/\u0003\u0002Z-\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005q{V\"A/\u000b\u0005y3\u0013AB1di>\u00148/\u0003\u0002a;\n\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u00061A(\u001b8jiz\"raY3gO\"L'\u000e\u0005\u0002e\u00015\t!\u0005C\u0003=\u000f\u0001\u0007Q\bC\u0003D\u000f\u0001\u0007A\tC\u0003J\u000f\u0001\u0007!\nC\u0003N\u000f\u0001\u0007a\nC\u0003T\u000f\u0001\u0007A\u000bC\u0003[\u000f\u0001\u00071\f\u000b\u0002\bYB\u0011Q\u000e_\u0007\u0002]*\u0011q\u000e]\u0001\u000bC:tw\u000e^1uS>t'BA9s\u0003\u001d1\u0017m\u0019;pefT!a\u001d;\u0002\u000b\t,\u0017M\\:\u000b\u0005U4\u0018aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003]\f1a\u001c:h\u0013\tIhNA\u0005BkR|w/\u001b:fI\u0006AR.\u0019:l\u0007>tG-\u001b;j_:\f5oU1uSN4\u0017.\u001a3\u0015\tq|\u0018\u0011\u0004\t\u0003_uL!A \u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0003A\u0001\u0019AA\u0002\u0003)!W\r\\5wKJL\u0018\n\u001a\t\u0005\u0003\u000b\t\u0019B\u0004\u0003\u0002\b\u0005=\u0001cAA\u0005a5\u0011\u00111\u0002\u0006\u0004\u0003\u001ba\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0012A\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000b\u0003/\u0011aa\u0015;sS:<'bAA\ta!9\u00111\u0004\u0005A\u0002\u0005\r\u0011aC2p]\u0012LG/[8o\u0013\u0012D3\u0001CA\u0010!\u0011\t\t#!\f\u000e\u0005\u0005\r\"bA8\u0002&)!\u0011qEA\u0015\u0003\u001diW\r\u001e:jGNT1!a\u000b+\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0018\u0003G\u0011Q\u0001V5nK\u0012\f\u0001$\\1ok\u0006d7i\\7qY\u0016$X\r\u0016:b]NLG/[8o)\u001da\u0018QGA\u001c\u0003wAq!!\u0001\n\u0001\u0004\t\u0019\u0001C\u0004\u0002:%\u0001\r!a\u0001\u0002\u0019Q\u0014\u0018M\\:ji&|g.\u00133\t\u000f\u0005u\u0012\u00021\u0001\u0002@\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0011\t\u0005\u0005\u0013qJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005)am\u001c:ng*!\u0011\u0011JA&\u0003\t1\u0018GC\u0002\u0002N\u0019\n1!\u00199j\u0013\u0011\t\t&a\u0011\u0003%\r{W\u000e\u001d7fi\u0016$&/\u00198tSRLwN\u001c\u0015\u0004\u0013\u0005}\u0011!E3yK\u000e,H/\u001a+sC:\u001c\u0018\u000e^5p]R)A0!\u0017\u0002l!9\u00111\f\u0006A\u0002\u0005u\u0013A\u0003;sC:\u001c\u0018\u000e^5p]B!\u0011qLA4\u001b\t\t\tGC\u0002&\u0003GR1!!\u001a'\u0003\u0019!w.\\1j]&!\u0011\u0011NA1\u0005)!&/\u00198tSRLwN\u001c\u0005\b\u0003[R\u0001\u0019AA8\u0003\u0019\u0001\u0018M]1ngB!\u0011\u0011OA;\u001b\t\t\u0019HC\u0002\u0002\\\u0011JA!a\u001e\u0002t\t\u0001BK]1og&$\u0018n\u001c8QCJ\fWn]\u0001\u0013e\u0016<\u0017n\u001d;feN+(m]2sS\n,'\u000f\u0006\u0004\u0002~\u0005\r\u0015Q\u0011\t\u0005\u0003?\ny(\u0003\u0003\u0002\u0002\u0006\u0005$AE*vEN\u001c'/\u001b9uS>t'+Z:vYRDq!!\u0001\f\u0001\u0004\t\u0019\u0001C\u0004\u0002\b.\u0001\r!!#\u0002\u0015M,(m]2sS\n,'\u000f\u0005\u0003\u0002`\u0005-\u0015\u0002BAG\u0003C\u0012!bU;cg\u000e\u0014\u0018NY3sQ\rY\u0011qD\u0001\u0016O\u0016$HK]1dW\u0016$\u0017\n^3n\u0005f$\u0016\u000e\u001e7f)\u0019\t)*a'\u0002\u001eB!\u0011qLAL\u0013\u0011\tI*!\u0019\u0003\u0017Q\u0013\u0018mY6fI&#X-\u001c\u0005\b\u0003\u0003a\u0001\u0019AA\u0002\u0011\u001d\ty\n\u0004a\u0001\u0003\u0007\t\u0011\"\u001b;f[RKG\u000f\\3)\u00071\ty\"A\bhKR$&/Y2lK\u0012LE/Z7t)\u0011\t9+a.\u0011\r\u0005%\u00161WAK\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016\u0001B;uS2T!!!-\u0002\t)\fg/Y\u0005\u0005\u0003k\u000bYK\u0001\u0003MSN$\bbBA\u0001\u001b\u0001\u0007\u00111\u0001\u0015\u0004\u001b\u0005}\u0011!E2sK\u0006$X\r\u0016:bG.,G-\u0013;f[R1\u0011QSA`\u0003\u0003Dq!!\u0001\u000f\u0001\u0004\t\u0019\u0001C\u0004\u0002D:\u0001\r!!&\u0002\t%$X-\u001c\u0015\u0004\u001d\u0005}\u0011!E;qI\u0006$X\r\u0016:bG.,G-\u0013;f[R1\u0011QSAf\u0003\u001bDq!!\u0001\u0010\u0001\u0004\t\u0019\u0001C\u0004\u0002D>\u0001\r!!&)\u0007=\ty\"A\teK2,G/\u001a+sC\u000e\\W\rZ%uK6$R\u0001`Ak\u0003/Dq!!\u0001\u0011\u0001\u0004\t\u0019\u0001C\u0004\u0002ZB\u0001\r!a\u0001\u0002\r%$X-\\%eQ\r\u0001\u0012qD\u0001\u0013I\u0016\u001c8m\u001c9f)J\f7m[3e\u0013R,W\u000eF\u0003}\u0003C\f\u0019\u000fC\u0004\u0002\u0002E\u0001\r!a\u0001\t\u000f\u0005e\u0017\u00031\u0001\u0002\u0004!\u001a\u0011#a\b\u0002%I,7oY8qKR\u0013\u0018mY6fI&#X-\u001c\u000b\u0006y\u0006-\u0018Q\u001e\u0005\b\u0003\u0003\u0011\u0002\u0019AA\u0002\u0011\u001d\tIN\u0005a\u0001\u0003\u0007A3AEA\u0010\u0003Q\u0011XmZ5ti\u0016\u0014HK]1dW\u0016$\u0017\n^3ngR9A0!>\u0002x\n5\u0001bBA\u0001'\u0001\u0007\u00111\u0001\u0005\b\u0003s\u001c\u0002\u0019AA~\u0003\u0015IG/Z7t!\u0019\tiPa\u0002\u0002\u00049!\u0011q B\u0002\u001d\u0011\tIA!\u0001\n\u0003EJ1A!\u00021\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0003\u0003\f\t\u00191+Z9\u000b\u0007\t\u0015\u0001\u0007C\u0004\u0003\u0010M\u0001\r!a\u0001\u0002\u001b\u0019\u0014x.\u001c*fY\u0016\f7/Z%eQ\r\u0019\u0012qD\u0001\u0018[\u0006\u00148\u000e\u0016:bG.,G-\u0013;f[NLen\u0015;bO\u0016$b\"a*\u0003\u0018\te!Q\u0004B\u0010\u0005S\u0011Y\u0003C\u0004\u0002\u0002Q\u0001\r!a\u0001\t\u000f\tmA\u00031\u0001\u0002\u0004\u000591\u000f^1hK&#\u0007bBA})\u0001\u0007\u00111 \u0005\b\u0005C!\u0002\u0019\u0001B\u0012\u0003\u0019\u0019H/\u0019;vgB!\u0011q\fB\u0013\u0013\u0011\u00119#!\u0019\u0003#Q\u0013\u0018mY6fI&#X-\\*uCR,8\u000fC\u0004\u0003\u0010Q\u0001\r!a\u0001\t\u0013\t5B\u0003%AA\u0002\t=\u0012a\u00049sK\u000e,G-\u001b8h'R\fw-Z:\u0011\u0007=\u0012\t$C\u0002\u00034A\u0012qAQ8pY\u0016\fg\u000eK\u0002\u0015\u0003?\t\u0011%\\1sWR\u0013\u0018mY6fI&#X-\\:J]N#\u0018mZ3%I\u00164\u0017-\u001e7uIY*\"Aa\u000f+\t\t=\"QH\u0016\u0003\u0005\u007f\u0001BA!\u0011\u0003J5\u0011!1\t\u0006\u0005\u0005\u000b\u00129%A\u0005v]\u000eDWmY6fI*\u0011q\u000eM\u0005\u0005\u0005\u0017\u0012\u0019EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fac]6jaR\u0013\u0018mY6fI&#X-\\%o'R\fw-\u001a\u000b\by\nE#1\u000bB+\u0011\u001d\t\tA\u0006a\u0001\u0003\u0007AqAa\u0007\u0017\u0001\u0004\t\u0019\u0001C\u0004\u0002ZZ\u0001\r!a\u0001)\u0007Y\ty\"A\fsKN,G\u000f\u0016:bG.,G-\u0013;f[&s7\u000b^1hKR9AP!\u0018\u0003`\t\u0005\u0004bBA\u0001/\u0001\u0007\u00111\u0001\u0005\b\u000579\u0002\u0019AA\u0002\u0011\u001d\tIn\u0006a\u0001\u0003\u0007A3aFA\u0010\u00035\u0019w.\u001c9mKR,7\u000b^1hKR)AP!\u001b\u0003l!9\u0011\u0011\u0001\rA\u0002\u0005\r\u0001b\u0002B\u000e1\u0001\u0007\u00111\u0001\u0015\u00041\u0005}\u0011a\u0003:f_B,gn\u0015;bO\u0016$R\u0001 B:\u0005kBq!!\u0001\u001a\u0001\u0004\t\u0019\u0001C\u0004\u0003\u001ce\u0001\r!a\u0001)\u0007e\ty\"A\u0006e_^KG\u000f[*uC\u001e,Gc\u0002?\u0003~\t}$\u0011\u0011\u0005\b\u0003\u0003Q\u0002\u0019AA\u0002\u0011\u001d\u0011YB\u0007a\u0001\u0003\u0007AqAa!\u001b\u0001\u0004\u0011))\u0001\u0002g]BAqFa\"\u0003\f\nEE0C\u0002\u0003\nB\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0007\u0011\u0014i)C\u0002\u0003\u0010\n\u0012A\u0003R3mSZ,'/_*uCR,W*\u00198bO\u0016\u0014\b\u0003BA0\u0005'KAA!&\u0002b\t)1\u000b^1hK\u0006q\u0001O]8dKN\u001c8\t[1oO\u0016\u001cHc\u0001?\u0003\u001c\"9!QT\u000eA\u0002\t-\u0015aB7b]\u0006<WM]\u0001\u001fa\u0006\u0014H/\u001b;j_:LE/Z7t\u0005f,\u00050[:uS:<\u0017I\u001c3OK^$bAa)\u0003,\nM\u0006cB\u0018\u0003&\n%&\u0011V\u0005\u0004\u0005O\u0003$A\u0002+va2,'\u0007\u0005\u0004\u0002~\n\u001d\u0011Q\u0013\u0005\u0007Kq\u0001\rA!,\u0011\t\u0005}#qV\u0005\u0005\u0005c\u000b\tG\u0001\u0005EK2Lg/\u001a:z\u0011\u001d\u0011)\f\ba\u0001\u0005o\u000ba\"\u001b;f[&#wJ\u001d+ji2,7\u000f\u0005\u0004\u0002\u0006\te\u00161A\u0005\u0005\u0005w\u000b9BA\u0002TKR\fAB^1mS\u0012\fG/Z%uK6$r\u0001 Ba\u0005\u0007\u00149\r\u0003\u0004&;\u0001\u0007!Q\u0016\u0005\b\u0005\u000bl\u0002\u0019AAK\u0003-!(/Y2lK\u0012LE/Z7\t\u0013\t%W\u0004%AA\u0002\t=\u0012a\u0004<bY&$\u0017\r^3NK6\u0014WM]:\u0002-Y\fG.\u001b3bi\u0016LE/Z7%I\u00164\u0017-\u001e7uIM\naB^1mS\u0012\fG/Z'f[\n,'\u000fF\u0002}\u0005#DqAa5 \u0001\u0004\t\u0019!A\u0005sK2,\u0017m]3JI\u0006aa/\u00197jI\u0006$X\rV1tWR\u0019AP!7\t\u000f\tm\u0007\u00051\u0001\u0002\u0004\u00051A/Y:l\u0013\u0012D3\u0001\u0001Bp!\u0011\u0011\tOa:\u000e\u0005\t\r(b\u0001Bsi\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t%(1\u001d\u0002\b'\u0016\u0014h/[2f\u0001")
public class DeliveryExecutionService
implements Logging {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryExecutionService deliveryExecutionService = this;
        synchronized (deliveryExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void markConditionAsSatisfied(String deliveryId, String conditionId) {
        block1: {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Marking condition '").append(conditionId).append("' as satisfied").toString());
            Delivery delivery = this.deliveryRepository.read(deliveryId);
            Transition transition = delivery.getTransitionByIdOrTitle(DeliveryUtils$.MODULE$.transitionIdFrom(conditionId));
            Condition condition = transition.getConditionById(conditionId);
            Stage stage = transition.getStage();
            Condition root = transition.getRootCondition();
            Buffer changes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(root.markAsSatisfied(conditionId, new Date())).asScala().$minus$eq((Object)root);
            if (!changes.nonEmpty()) break block1;
            this.deliveryRepository.update(delivery);
            ((IterableOnceOps)changes.map((Function1 & Serializable)x$1 -> new ConditionSatisfiedEvent((Condition)x$1, transition, delivery))).foreach((Function1 & Serializable)x$1 -> {
                this.eventBus.publish(x$1);
                return BoxedUnit.UNIT;
            });
            if (root.isSatisfied() && stage.isOpen()) {
                scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(delivery.getStageGroupOfStage(stage)).asScala().toSeq();
                Set completedItems = ((IterableOnceOps)DeliveryUtils$.MODULE$.getItemsCompletedInAllStages(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped()))).toSeq(), stages).map((Function1 & Serializable)x$3 -> x$3.getId())).toSet();
                Seq transitionedItems = (Seq)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delivery.findNextStage(stage))).map((Function1 & Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$4.getItems()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTrackedItemId())).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
                Set toTransition = (Set)completedItems.$minus$minus((IterableOnce)transitionedItems);
                this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)toTransition, true, new ConditionTrigger(conditionId, condition.toString())));
            }
        }
    }

    @Timed
    public void manualCompleteTransition(String deliveryId, String transitionId, CompleteTransition parameters) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Manual transition '").append(transitionId).append("' on delivery '").append(deliveryId).append("' with params '").append(parameters).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByTransitionId(transitionId);
        Transition transition = stage.getTransition();
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(40).append("Transition already completed on stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        Checks.checkNotNull((Object)parameters.getTransitionItems(), (String)"Transition items");
        Set transitionItems = CollectionConverters$.MODULE$.ListHasAsScala(parameters.getTransitionItems()).asScala().toSet();
        transitionItems.foreach((Function1 & Serializable)itemId -> {
            DeliveryExecutionService.$anonfun$manualCompleteTransition$2(delivery, stage, itemId);
            return BoxedUnit.UNIT;
        });
        this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)transitionItems, parameters.isCloseStages(), new UserTrigger(Permissions.getAuthenticatedUserName())));
    }

    private void executeTransition(Transition transition, TransitionParams params) {
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(params.delivery(), this.ciIdService);
        manager.handleTransition(transition, params);
        this.processChanges(manager);
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(40).append("Registering subscriber '").append(subscriber).append("' to delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateTask(subscriber.sourceId());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        SubscriptionResult result = manager.registerSubscriber(subscriber);
        this.processChanges(manager);
        return result;
    }

    @Timed
    public TrackedItem getTrackedItemByTitle(String deliveryId, String itemTitle) {
        return this.deliveryRepository.read(deliveryId).getItemByIdOrTitle(itemTitle);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String deliveryId) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        return delivery.getTrackedItems();
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem addedItem = manager.addTrackedItem(item);
        this.processChanges(manager);
        return addedItem;
    }

    @Timed
    public TrackedItem updateTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(47).append("Updating tracked item with id '").append(item.getId()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem updatedItem = manager.updateTrackedItem(item);
        this.processChanges(manager);
        return updatedItem;
    }

    @Timed
    public void deleteTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(41).append("Removing tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.deleteTrackedItem(itemId);
        this.processChanges(manager);
    }

    @Timed
    public void descopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Descoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.descopeItems((scala.collection.immutable.Seq<TrackedItem>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void rescopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Rescoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.rescopeItems((scala.collection.immutable.Seq<TrackedItem>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, scala.collection.immutable.Seq<String> items, String fromReleaseId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(63).append("Registering new tracked items [").append(items.mkString(", ")).append("] on delivery '").append(deliveryId).append("' from release '").append(fromReleaseId).append("'").toString());
        this.validateMember(fromReleaseId);
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> tuple2 = this.partitionItemsByExistingAndNew(delivery, (Set<String>)items.toSet());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq newItems = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingItems, (Object)newItems);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Seq existingItems2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq newItems2 = (scala.collection.immutable.Seq)tuple23._2();
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        delivery.addReleaseId(fromReleaseId);
        existingItems2.foreach((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.addReleaseId(fromReleaseId)));
        newItems2.foreach((Function1 & Serializable)item -> {
            item.addReleaseId(fromReleaseId);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
            this.validateItem(delivery, (TrackedItem)item, false);
            return manager.addTrackedItem((TrackedItem)item);
        });
        this.processChanges(manager);
    }

    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageId, scala.collection.immutable.Seq<String> items, TrackedItemStatus status, String fromReleaseId, boolean precedingStages) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(64).append("Marking tracked items [").append(items.mkString(", ")).append("] as completed on stage '").append(stageId).append("' on delivery '").append(deliveryId).append("'").toString()).append(String.valueOf(fromReleaseId != null ? new StringBuilder(7).append("from '").append(fromReleaseId).append("'").toString() : "")).toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)((IterableOps)items.distinct()).map((Function1 & Serializable)idOrTitle -> {
            LazyRef lowercaseTitle$lzy = new LazyRef();
            return (TrackedItem)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().find((Function1 & Serializable)trackedItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$markTrackedItemsInStage$3(idOrTitle, lowercaseTitle$lzy, trackedItem))).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(45).append("Tracked item '").append((String)idOrTitle).append("' does not exist in delivery '").append(delivery.getTitle()).append("'").toString(), new Object[0]);
            });
        });
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        if (fromReleaseId != null) {
            this.validateMember(fromReleaseId);
            existingItems.foreach((Function1 & Serializable)x$10 -> {
                manager.addReleaseToItem(x$10, fromReleaseId);
                return BoxedUnit.UNIT;
            });
        }
        scala.collection.immutable.Seq<TrackedItem> markedItems = manager.markTrackedItemsInStage((scala.collection.immutable.Seq<TrackedItem>)existingItems, stage, status, precedingStages, fromReleaseId);
        this.processChanges(manager);
        return CollectionConverters$.MODULE$.SeqHasAsJava(markedItems).asJava();
    }

    public boolean markTrackedItemsInStage$default$6() {
        return false;
    }

    @Timed
    public void skipTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("Skipping tracked item '").append(itemId).append("' on stage '").append(stageId).append("' in delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.skipTrackedItemInStage(trackedItem, stage);
        this.processChanges(manager);
    }

    @Timed
    public void resetTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(52).append("Resetting tracked item '").append(itemId).append("' on stage '").append(stageId).append("' in delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.resetTrackedItemInStage(trackedItem, stage, manager.resetTrackedItemInStage$default$3());
        this.processChanges(manager);
    }

    @Timed
    public void completeStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(29).append("Marking stage '").append(stageId).append("' as completed").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.completeStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void reopenStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(30).append("Marking stage '").append(stageId).append("' as open again").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.reopenStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    private void doWithStage(String deliveryId, String stageId, Function2<DeliveryStateManager, Stage, BoxedUnit> fn) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        fn.apply((Object)manager, (Object)stage);
        this.processChanges(manager);
    }

    private void processChanges(DeliveryStateManager manager) {
        this.deliveryRepository.update(manager.delivery());
        manager.getMessages().foreach((Function1 & Serializable)x$11 -> {
            DeliveryExecutionService.$anonfun$processChanges$1(this, x$11);
            return BoxedUnit.UNIT;
        });
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> partitionItemsByExistingAndNew(Delivery delivery, Set<String> itemIdOrTitles) {
        Map idsByTitles = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)i.getTitle().toLowerCase(), (Object)Ids.getName((String)i.getId())))).toSeq());
        Map itemsByIds = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)Ids.getName((String)i.getId()), i))).toSeq());
        return (Tuple2)itemIdOrTitles.foldRight((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().empty()), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String idOrTitle;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    idOrTitle = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            scala.collection.immutable.Seq existingAcc = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq newAcc = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple23 = (Tuple2)itemsByIds.get((Object)Ids.getName((String)idOrTitle)).orElse((Function0 & Serializable)() -> idsByTitles.get((Object)idOrTitle.toLowerCase()).flatMap((Function1 & Serializable)key -> itemsByIds.get(key))).fold((Function0 & Serializable)() -> {
                TrackedItem trackedItem = new TrackedItem(idOrTitle);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingAcc), newAcc.$plus$colon((Object)trackedItem));
            }, (Function1 & Serializable)item -> {
                TrackedItem trackedItem = item;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(existingAcc.$plus$colon((Object)trackedItem)), (Object)newAcc);
            });
            return tuple23;
        });
    }

    private void validateItem(Delivery delivery, TrackedItem trackedItem, boolean validateMembers) {
        block1: {
            LazyRef lowerCaseTitle$lzy = new LazyRef();
            Checks.checkNotNull((Object)trackedItem, (String)"Tracked item");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)trackedItem.getTitle()), (String)"Tracked item title must be set", (Object[])new Object[0]);
            Checks.checkArgument((trackedItem.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
            Checks.checkArgument((!trackedItem.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
            Checks.checkArgument((!CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().exists((Function1 & Serializable)existing -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$validateItem$1(trackedItem, lowerCaseTitle$lzy, existing))) ? 1 : 0) != 0, (String)new StringBuilder(43).append("A tracked item with title '").append(trackedItem.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
            if (trackedItem.getReleaseIds() == null) {
                trackedItem.setReleaseIds(new HashSet());
            }
            if (!validateMembers) break block1;
            trackedItem.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        }
    }

    private boolean validateItem$default$3() {
        return true;
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must be a valid release ID").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        Checks.checkArgument((releaseStatus != null ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must exist in the database").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus2 = releaseStatus;
        ReleaseStatus releaseStatus3 = ReleaseStatus.TEMPLATE;
        Checks.checkArgument(((releaseStatus2 == null ? releaseStatus3 != null : !releaseStatus2.equals(releaseStatus3)) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Provided entity '").append(releaseId).append("' must be a release").toString(), (Object[])new Object[0]);
    }

    private void validateTask(String taskId) {
        Checks.checkArgument((boolean)Ids.isTaskId((String)taskId), (String)new StringBuilder(38).append("Provided ID '").append(taskId).append("' must be a valid task ID").toString(), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(taskId), (String)new StringBuilder(46).append("Provided task ID '").append(taskId).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$manualCompleteTransition$3(String itemId$1, Stage x$6) {
        return x$6.getItemById(itemId$1).getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$manualCompleteTransition$2(Delivery delivery$2, Stage stage$1, String itemId) {
        TrackedItem trackedItem = delivery$2.getItemByIdOrTitle(itemId);
        Checks.checkArgument((!trackedItem.isDescoped() ? 1 : 0) != 0, (String)new StringBuilder(49).append("De-scoped tracked item '").append(trackedItem.getTitle()).append("' can not be transitioned").toString(), (Object[])new Object[0]);
        Buffer notDoneInStages = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery$2.getStagesBefore(stage$1)).asScala().$colon$plus((Object)stage$1)).filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$manualCompleteTransition$3(itemId, x$6)));
        Checks.checkArgument((boolean)notDoneInStages.isEmpty(), (String)new StringBuilder(0).append(new StringBuilder(44).append("Tracked item '").append(trackedItem.getTitle()).append("' must be completed or skipped").toString()).append(new StringBuilder(53).append(" in stage '").append(((IterableOnceOps)notDoneInStages.map((Function1 & Serializable)x$7 -> x$7.getTitle())).mkString("', '")).append("' in order to transition to the next stage").toString()).toString(), (Object[])new Object[0]);
    }

    private static final /* synthetic */ String lowercaseTitle$lzycompute$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        String string;
        LazyRef lazyRef = lowercaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : (String)lowercaseTitle$lzy$1.initialize((Object)idOrTitle$1.toLowerCase());
        }
        return string;
    }

    private static final String lowercaseTitle$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        return lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : DeliveryExecutionService.lowercaseTitle$lzycompute$1(lowercaseTitle$lzy$1, idOrTitle$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$3(String idOrTitle$1, LazyRef lowercaseTitle$lzy$1, TrackedItem trackedItem) {
        String string = Ids.getName((String)trackedItem.getId());
        String string2 = Ids.getName((String)idOrTitle$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trackedItem.getTitle().toLowerCase();
        String string4 = DeliveryExecutionService.lowercaseTitle$1(lowercaseTitle$lzy$1, idOrTitle$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$processChanges$1(DeliveryExecutionService $this, String x$11) {
        $this.logger().info((Function0 & Serializable)() -> x$11);
    }

    private static final /* synthetic */ String lowerCaseTitle$lzycompute$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        String string;
        LazyRef lazyRef = lowerCaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : (String)lowerCaseTitle$lzy$1.initialize((Object)trackedItem$1.getTitle().toLowerCase());
        }
        return string;
    }

    private static final String lowerCaseTitle$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        return lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : DeliveryExecutionService.lowerCaseTitle$lzycompute$1(lowerCaseTitle$lzy$1, trackedItem$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateItem$1(TrackedItem trackedItem$1, LazyRef lowerCaseTitle$lzy$1, TrackedItem existing) {
        String string = existing.getTitle().toLowerCase();
        String string2 = DeliveryExecutionService.lowerCaseTitle$1(lowerCaseTitle$lzy$1, trackedItem$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = existing.getId();
        String string4 = trackedItem$1.getId();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    @Autowired
    public DeliveryExecutionService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, TaskRepository taskRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, ReleaseActorService releaseActorService) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

