/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.ConditionSatisfiedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.ConditionTrigger;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.UserTrigger;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tug\u0001\u0002\u0011\"\u00011B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000b\u0001\u0004A\u0011A1\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!!/\u0001\t\u0003\tY\fC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007bBAs\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0003_\u0004A\u0011AAy\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'A\u0011B!\u000e\u0001#\u0003%\tAa\u000e\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!q\u000b\u0001\u0005\u0002\te\u0003b\u0002B1\u0001\u0011\u0005!1\r\u0005\b\u0005W\u0002A\u0011\u0002B7\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqA!%\u0001\t\u0013\u0011\u0019\nC\u0004\u00030\u0002!IA!-\t\u0013\tu\u0006!%A\u0005\n\t]\u0002b\u0002B`\u0001\u0011%!\u0011\u0019\u0005\b\u0005\u000f\u0004A\u0011\u0002Be\u0005a!U\r\\5wKJLX\t_3dkRLwN\\*feZL7-\u001a\u0006\u0003E\r\nqa]3sm&\u001cWM\u0003\u0002%K\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u0002'O\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003Q%\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003)\n1aY8n\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006g24GG\u001b\u0006\u0002q\u0005AqM]5{u2,G-\u0003\u0002;k\t9Aj\\4hS:<\u0017A\u00053fY&4XM]=SKB|7/\u001b;pef\u0004\"!\u0010!\u000e\u0003yR!aP\u0012\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002B}\t\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\t\u001ak\u0011!\u0012\u0006\u0003\u007f\u0015J!aR#\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\buCN\\'+\u001a9pg&$xN]=\u0011\u0005\u0011S\u0015BA&F\u00059!\u0016m]6SKB|7/\u001b;pef\f1bY5JIN+'O^5dKB\u0011a\nU\u0007\u0002\u001f*\u0011!%J\u0005\u0003#>\u00131bQ5JIN+'O^5dK\u0006AQM^3oi\n+8\u000f\u0005\u0002U/6\tQK\u0003\u0002WK\u00051QM^3oiNL!\u0001W+\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0002\\=6\tAL\u0003\u0002^K\u00051\u0011m\u0019;peNL!a\u0018/\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u001d\u0011G-\u001a4hQ&\u0004\"a\u0019\u0001\u000e\u0003\u0005BQaO\u0004A\u0002qBQAQ\u0004A\u0002\rCQ\u0001S\u0004A\u0002%CQ\u0001T\u0004A\u00025CQAU\u0004A\u0002MCQ!W\u0004A\u0002iC#aB6\u0011\u00051<X\"A7\u000b\u00059|\u0017AC1o]>$\u0018\r^5p]*\u0011\u0001/]\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u00118/A\u0003cK\u0006t7O\u0003\u0002uk\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001w\u0003\ry'oZ\u0005\u0003q6\u0014\u0011\"Q;u_^L'/\u001a3\u000215\f'o[\"p]\u0012LG/[8o\u0003N\u001c\u0016\r^5tM&,G\r\u0006\u0003|}\u0006]\u0001C\u0001\u0018}\u0013\tixF\u0001\u0003V]&$\bBB@\t\u0001\u0004\t\t!\u0001\u0006eK2Lg/\u001a:z\u0013\u0012\u0004B!a\u0001\u0002\u00129!\u0011QAA\u0007!\r\t9aL\u0007\u0003\u0003\u0013Q1!a\u0003,\u0003\u0019a$o\\8u}%\u0019\u0011qB\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019\"!\u0006\u0003\rM#(/\u001b8h\u0015\r\tya\f\u0005\b\u00033A\u0001\u0019AA\u0001\u0003-\u0019wN\u001c3ji&|g.\u00133)\u0007!\ti\u0002\u0005\u0003\u0002 \u0005-RBAA\u0011\u0015\rq\u00171\u0005\u0006\u0005\u0003K\t9#A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005%\u0012&\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ti#!\t\u0003\u000bQKW.\u001a3\u000215\fg.^1m\u0007>l\u0007\u000f\\3uKR\u0013\u0018M\\:ji&|g\u000eF\u0004|\u0003g\t)$!\u000f\t\r}L\u0001\u0019AA\u0001\u0011\u001d\t9$\u0003a\u0001\u0003\u0003\tA\u0002\u001e:b]NLG/[8o\u0013\u0012Dq!a\u000f\n\u0001\u0004\ti$\u0001\u0006qCJ\fW.\u001a;feN\u0004B!a\u0010\u0002N5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0003g_Jl7O\u0003\u0003\u0002H\u0005%\u0013A\u0001<2\u0015\r\tY%J\u0001\u0004CBL\u0017\u0002BA(\u0003\u0003\u0012!cQ8na2,G/\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011\"!\b\u0002#\u0015DXmY;uKR\u0013\u0018M\\:ji&|g\u000eF\u0003|\u0003/\nI\u0007C\u0004\u0002Z)\u0001\r!a\u0017\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0005\u0003\u0002^\u0005\u0015TBAA0\u0015\r!\u0013\u0011\r\u0006\u0004\u0003G*\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002h\u0005}#A\u0003+sC:\u001c\u0018\u000e^5p]\"9\u00111\u000e\u0006A\u0002\u00055\u0014A\u00029be\u0006l7\u000f\u0005\u0003\u0002p\u0005MTBAA9\u0015\r\tIfI\u0005\u0005\u0003k\n\tH\u0001\tUe\u0006t7/\u001b;j_:\u0004\u0016M]1ng\u0006\u0011\"/Z4jgR,'oU;cg\u000e\u0014\u0018NY3s)\u0019\tY(!!\u0002\u0004B!\u0011QLA?\u0013\u0011\ty(a\u0018\u0003%M+(m]2sSB$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0007\u007f.\u0001\r!!\u0001\t\u000f\u0005\u00155\u00021\u0001\u0002\b\u0006Q1/\u001e2tGJL'-\u001a:\u0011\t\u0005u\u0013\u0011R\u0005\u0005\u0003\u0017\u000byF\u0001\u0006Tk\n\u001c8M]5cKJD3aCA\u000f\u0003U9W\r\u001e+sC\u000e\\W\rZ%uK6\u0014\u0015\u0010V5uY\u0016$b!a%\u0002\u001a\u0006m\u0005\u0003BA/\u0003+KA!a&\u0002`\tYAK]1dW\u0016$\u0017\n^3n\u0011\u0019yH\u00021\u0001\u0002\u0002!9\u0011Q\u0014\u0007A\u0002\u0005\u0005\u0011!C5uK6$\u0016\u000e\u001e7fQ\ra\u0011QD\u0001\u0010O\u0016$HK]1dW\u0016$\u0017\n^3ngR!\u0011QUA[!\u0019\t9+!-\u0002\u00146\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+\u0001\u0003vi&d'BAAX\u0003\u0011Q\u0017M^1\n\t\u0005M\u0016\u0011\u0016\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004\u0000\u001b\u0001\u0007\u0011\u0011\u0001\u0015\u0004\u001b\u0005u\u0011!E2sK\u0006$X\r\u0016:bG.,G-\u0013;f[R1\u00111SA_\u0003\u007fCaa \bA\u0002\u0005\u0005\u0001bBAa\u001d\u0001\u0007\u00111S\u0001\u0005SR,W\u000eK\u0002\u000f\u0003;\t\u0011#\u001e9eCR,GK]1dW\u0016$\u0017\n^3n)\u0019\t\u0019*!3\u0002L\"1qp\u0004a\u0001\u0003\u0003Aq!!1\u0010\u0001\u0004\t\u0019\nK\u0002\u0010\u0003;\t\u0011\u0003Z3mKR,GK]1dW\u0016$\u0017\n^3n)\u0015Y\u00181[Ak\u0011\u0019y\b\u00031\u0001\u0002\u0002!9\u0011q\u001b\tA\u0002\u0005\u0005\u0011AB5uK6LE\rK\u0002\u0011\u0003;\t!\u0003Z3tG>\u0004X\r\u0016:bG.,G-\u0013;f[R)10a8\u0002b\"1q0\u0005a\u0001\u0003\u0003Aq!a6\u0012\u0001\u0004\t\t\u0001K\u0002\u0012\u0003;\t!C]3tG>\u0004X\r\u0016:bG.,G-\u0013;f[R)10!;\u0002l\"1qP\u0005a\u0001\u0003\u0003Aq!a6\u0013\u0001\u0004\t\t\u0001K\u0002\u0013\u0003;\tAC]3hSN$XM\u001d+sC\u000e\\W\rZ%uK6\u001cHcB>\u0002t\u0006U(1\u0002\u0005\u0007\u007fN\u0001\r!!\u0001\t\u000f\u0005]8\u00031\u0001\u0002z\u0006)\u0011\u000e^3ngB1\u00111 B\u0003\u0003\u0003qA!!@\u0003\u00029!\u0011qAA\u0000\u0013\u0005\u0001\u0014b\u0001B\u0002_\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0004\u0005\u0013\u00111aU3r\u0015\r\u0011\u0019a\f\u0005\b\u0005\u001b\u0019\u0002\u0019AA\u0001\u000351'o\\7SK2,\u0017m]3JI\"\u001a1#!\b\u0002/5\f'o\u001b+sC\u000e\\W\rZ%uK6\u001c\u0018J\\*uC\u001e,GCDAS\u0005+\u00119Ba\u0007\u0003\u001e\t\u001d\"\u0011\u0006\u0005\u0007\u007fR\u0001\r!!\u0001\t\u000f\teA\u00031\u0001\u0002\u0002\u000591\u000f^1hK&#\u0007bBA|)\u0001\u0007\u0011\u0011 \u0005\b\u0005?!\u0002\u0019\u0001B\u0011\u0003\u0019\u0019H/\u0019;vgB!\u0011Q\fB\u0012\u0013\u0011\u0011)#a\u0018\u0003#Q\u0013\u0018mY6fI&#X-\\*uCR,8\u000fC\u0004\u0003\u000eQ\u0001\r!!\u0001\t\u0013\t-B\u0003%AA\u0002\t5\u0012a\u00049sK\u000e,G-\u001b8h'R\fw-Z:\u0011\u00079\u0012y#C\u0002\u00032=\u0012qAQ8pY\u0016\fg\u000eK\u0002\u0015\u0003;\t\u0011%\\1sWR\u0013\u0018mY6fI&#X-\\:J]N#\u0018mZ3%I\u00164\u0017-\u001e7uIY*\"A!\u000f+\t\t5\"1H\u0016\u0003\u0005{\u0001BAa\u0010\u0003H5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%A\u0005v]\u000eDWmY6fI*\u0011anL\u0005\u0005\u0005\u0013\u0012\tEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fac]6jaR\u0013\u0018mY6fI&#X-\\%o'R\fw-\u001a\u000b\bw\n=#\u0011\u000bB*\u0011\u0019yh\u00031\u0001\u0002\u0002!9!\u0011\u0004\fA\u0002\u0005\u0005\u0001bBAl-\u0001\u0007\u0011\u0011\u0001\u0015\u0004-\u0005u\u0011!D2p[BdW\r^3Ti\u0006<W\rF\u0003|\u00057\u0012i\u0006\u0003\u0004\u0000/\u0001\u0007\u0011\u0011\u0001\u0005\b\u000539\u0002\u0019AA\u0001Q\r9\u0012QD\u0001\fe\u0016|\u0007/\u001a8Ti\u0006<W\rF\u0003|\u0005K\u00129\u0007\u0003\u0004\u00001\u0001\u0007\u0011\u0011\u0001\u0005\b\u00053A\u0002\u0019AA\u0001Q\rA\u0012QD\u0001\fI><\u0016\u000e\u001e5Ti\u0006<W\rF\u0004|\u0005_\u0012\tHa\u001d\t\r}L\u0002\u0019AA\u0001\u0011\u001d\u0011I\"\u0007a\u0001\u0003\u0003AqA!\u001e\u001a\u0001\u0004\u00119(\u0001\u0002g]BAaF!\u001f\u0003~\t\r50C\u0002\u0003|=\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0007\r\u0014y(C\u0002\u0003\u0002\u0006\u0012A\u0003R3mSZ,'/_*uCR,W*\u00198bO\u0016\u0014\b\u0003BA/\u0005\u000bKAAa\"\u0002`\t)1\u000b^1hK\u0006q\u0001O]8dKN\u001c8\t[1oO\u0016\u001cHcA>\u0003\u000e\"9!q\u0012\u000eA\u0002\tu\u0014aB7b]\u0006<WM]\u0001\u001fa\u0006\u0014H/\u001b;j_:LE/Z7t\u0005f,\u00050[:uS:<\u0017I\u001c3OK^$bA!&\u0003\u001e\n\u0015\u0006c\u0002\u0018\u0003\u0018\nm%1T\u0005\u0004\u00053{#A\u0002+va2,'\u0007\u0005\u0004\u0002|\n\u0015\u00111\u0013\u0005\u0007Im\u0001\rAa(\u0011\t\u0005u#\u0011U\u0005\u0005\u0005G\u000byF\u0001\u0005EK2Lg/\u001a:z\u0011\u001d\u00119k\u0007a\u0001\u0005S\u000ba\"\u001b;f[&#wJ\u001d+ji2,7\u000f\u0005\u0004\u0002\u0004\t-\u0016\u0011A\u0005\u0005\u0005[\u000b)BA\u0002TKR\fAB^1mS\u0012\fG/Z%uK6$ra\u001fBZ\u0005k\u0013I\f\u0003\u0004%9\u0001\u0007!q\u0014\u0005\b\u0005oc\u0002\u0019AAJ\u0003-!(/Y2lK\u0012LE/Z7\t\u0013\tmF\u0004%AA\u0002\t5\u0012a\u0004<bY&$\u0017\r^3NK6\u0014WM]:\u0002-Y\fG.\u001b3bi\u0016LE/Z7%I\u00164\u0017-\u001e7uIM\naB^1mS\u0012\fG/Z'f[\n,'\u000fF\u0002|\u0005\u0007DqA!2\u001f\u0001\u0004\t\t!A\u0005sK2,\u0017m]3JI\u0006aa/\u00197jI\u0006$X\rV1tWR\u00191Pa3\t\u000f\t5w\u00041\u0001\u0002\u0002\u00051A/Y:l\u0013\u0012D3\u0001\u0001Bi!\u0011\u0011\u0019N!7\u000e\u0005\tU'b\u0001Blg\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\tm'Q\u001b\u0002\b'\u0016\u0014h/[2f\u0001")
public class DeliveryExecutionService
implements Logging {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryExecutionService deliveryExecutionService = this;
        synchronized (deliveryExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void markConditionAsSatisfied(String deliveryId, String conditionId) {
        block1: {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Marking condition '").append(conditionId).append("' as satisfied").toString());
            Delivery delivery = this.deliveryRepository.read(deliveryId);
            Transition transition = delivery.getTransitionByIdOrTitle(DeliveryUtils$.MODULE$.transitionIdFrom(conditionId));
            Condition condition = transition.getConditionById(conditionId);
            Stage stage = transition.getStage();
            Condition root = transition.getRootCondition();
            Buffer changes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(root.markAsSatisfied(conditionId, new Date())).asScala().$minus$eq((Object)root);
            if (delivery.isTemplate() || !changes.nonEmpty()) break block1;
            this.deliveryRepository.update(delivery);
            ((IterableOnceOps)changes.map((Function1 & Serializable)x$1 -> new ConditionSatisfiedEvent((Condition)x$1, transition, delivery))).foreach((Function1 & Serializable)x$1 -> {
                this.eventBus.publish(x$1);
                return BoxedUnit.UNIT;
            });
            if (root.isSatisfied() && stage.isOpen()) {
                scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(delivery.getStageGroupOfStage(stage)).asScala().toSeq();
                Set completedItems = ((IterableOnceOps)DeliveryUtils$.MODULE$.getItemsCompletedInAllStages(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped()))).toSeq(), stages).map((Function1 & Serializable)x$3 -> x$3.getId())).toSet();
                Seq transitionedItems = (Seq)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delivery.findNextStage(stage))).map((Function1 & Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$4.getItems()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTrackedItemId())).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
                Set toTransition = (Set)completedItems.$minus$minus((IterableOnce)transitionedItems);
                this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)toTransition, true, new ConditionTrigger(conditionId, condition.toString())));
            }
        }
    }

    @Timed
    public void manualCompleteTransition(String deliveryId, String transitionId, CompleteTransition parameters) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Manual transition '").append(transitionId).append("' on delivery '").append(deliveryId).append("' with params '").append(parameters).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByTransitionId(transitionId);
        Transition transition = stage.getTransition();
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(40).append("Transition already completed on stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        Checks.checkNotNull((Object)parameters.getTransitionItems(), (String)"Transition items");
        Set transitionItems = CollectionConverters$.MODULE$.ListHasAsScala(parameters.getTransitionItems()).asScala().toSet();
        transitionItems.foreach((Function1 & Serializable)itemId -> {
            DeliveryExecutionService.$anonfun$manualCompleteTransition$2(delivery, stage, itemId);
            return BoxedUnit.UNIT;
        });
        this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)transitionItems, parameters.isCloseStages(), new UserTrigger(Permissions.getAuthenticatedUserName())));
    }

    private void executeTransition(Transition transition, TransitionParams params) {
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(params.delivery(), this.ciIdService);
        manager.handleTransition(transition, params);
        this.processChanges(manager);
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(40).append("Registering subscriber '").append(subscriber).append("' to delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateTask(subscriber.sourceId());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        SubscriptionResult result = manager.registerSubscriber(subscriber);
        this.processChanges(manager);
        return result;
    }

    @Timed
    public TrackedItem getTrackedItemByTitle(String deliveryId, String itemTitle) {
        return this.deliveryRepository.read(deliveryId).getItemByIdOrTitle(itemTitle);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String deliveryId) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        return delivery.getTrackedItems();
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem addedItem = manager.addTrackedItem(item);
        this.processChanges(manager);
        return addedItem;
    }

    @Timed
    public TrackedItem updateTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(47).append("Updating tracked item with id '").append(item.getId()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item, this.validateItem$default$3());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem updatedItem = manager.updateTrackedItem(item);
        this.processChanges(manager);
        return updatedItem;
    }

    @Timed
    public void deleteTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(41).append("Removing tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.deleteTrackedItem(itemId);
        this.processChanges(manager);
    }

    @Timed
    public void descopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Descoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.descopeItems((scala.collection.immutable.Seq<TrackedItem>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void rescopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Rescoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.rescopeItems((scala.collection.immutable.Seq<TrackedItem>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, scala.collection.immutable.Seq<String> items, String fromReleaseId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(63).append("Registering new tracked items [").append(items.mkString(", ")).append("] on delivery '").append(deliveryId).append("' from release '").append(fromReleaseId).append("'").toString());
        this.validateMember(fromReleaseId);
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> tuple2 = this.partitionItemsByExistingAndNew(delivery, (Set<String>)items.toSet());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq newItems = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingItems, (Object)newItems);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Seq existingItems2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq newItems2 = (scala.collection.immutable.Seq)tuple23._2();
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        delivery.addReleaseId(fromReleaseId);
        existingItems2.foreach((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.addReleaseId(fromReleaseId)));
        newItems2.foreach((Function1 & Serializable)item -> {
            item.addReleaseId(fromReleaseId);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
            this.validateItem(delivery, (TrackedItem)item, false);
            return manager.addTrackedItem((TrackedItem)item);
        });
        this.processChanges(manager);
    }

    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageId, scala.collection.immutable.Seq<String> items, TrackedItemStatus status, String fromReleaseId, boolean precedingStages) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(64).append("Marking tracked items [").append(items.mkString(", ")).append("] as completed on stage '").append(stageId).append("' on delivery '").append(deliveryId).append("'").toString()).append(String.valueOf(fromReleaseId != null ? new StringBuilder(7).append("from '").append(fromReleaseId).append("'").toString() : "")).toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)((IterableOps)items.distinct()).map((Function1 & Serializable)idOrTitle -> {
            LazyRef lowercaseTitle$lzy = new LazyRef();
            return (TrackedItem)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().find((Function1 & Serializable)trackedItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$markTrackedItemsInStage$3(idOrTitle, lowercaseTitle$lzy, trackedItem))).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(45).append("Tracked item '").append((String)idOrTitle).append("' does not exist in delivery '").append(delivery.getTitle()).append("'").toString(), new Object[0]);
            });
        });
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        if (fromReleaseId != null) {
            this.validateMember(fromReleaseId);
            existingItems.foreach((Function1 & Serializable)x$10 -> {
                manager.addReleaseToItem(x$10, fromReleaseId);
                return BoxedUnit.UNIT;
            });
        }
        scala.collection.immutable.Seq<TrackedItem> markedItems = manager.markTrackedItemsInStage((scala.collection.immutable.Seq<TrackedItem>)existingItems, stage, status, precedingStages, fromReleaseId);
        this.processChanges(manager);
        return CollectionConverters$.MODULE$.SeqHasAsJava(markedItems).asJava();
    }

    public boolean markTrackedItemsInStage$default$6() {
        return false;
    }

    @Timed
    public void skipTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("Skipping tracked item '").append(itemId).append("' on stage '").append(stageId).append("' in delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.skipTrackedItemInStage(trackedItem, stage);
        this.processChanges(manager);
    }

    @Timed
    public void completeStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(29).append("Marking stage '").append(stageId).append("' as completed").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.completeStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void reopenStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(30).append("Marking stage '").append(stageId).append("' as open again").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.reopenStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    private void doWithStage(String deliveryId, String stageId, Function2<DeliveryStateManager, Stage, BoxedUnit> fn) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        fn.apply((Object)manager, (Object)stage);
        this.processChanges(manager);
    }

    private void processChanges(DeliveryStateManager manager) {
        this.deliveryRepository.update(manager.delivery());
        manager.getMessages().foreach((Function1 & Serializable)x$11 -> {
            DeliveryExecutionService.$anonfun$processChanges$1(this, x$11);
            return BoxedUnit.UNIT;
        });
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> partitionItemsByExistingAndNew(Delivery delivery, Set<String> itemIdOrTitles) {
        Map idsByTitles = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)i.getTitle().toLowerCase(), (Object)Ids.getName((String)i.getId())))).toSeq());
        Map itemsByIds = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)Ids.getName((String)i.getId()), i))).toSeq());
        return (Tuple2)itemIdOrTitles.foldRight((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().empty()), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String idOrTitle;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    idOrTitle = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            scala.collection.immutable.Seq existingAcc = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq newAcc = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple23 = (Tuple2)itemsByIds.get((Object)Ids.getName((String)idOrTitle)).orElse((Function0 & Serializable)() -> idsByTitles.get((Object)idOrTitle.toLowerCase()).flatMap((Function1 & Serializable)key -> itemsByIds.get(key))).fold((Function0 & Serializable)() -> {
                TrackedItem trackedItem = new TrackedItem(idOrTitle);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingAcc), newAcc.$plus$colon((Object)trackedItem));
            }, (Function1 & Serializable)item -> {
                TrackedItem trackedItem = item;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(existingAcc.$plus$colon((Object)trackedItem)), (Object)newAcc);
            });
            return tuple23;
        });
    }

    private void validateItem(Delivery delivery, TrackedItem trackedItem, boolean validateMembers) {
        block1: {
            LazyRef lowerCaseTitle$lzy = new LazyRef();
            Checks.checkNotNull((Object)trackedItem, (String)"Tracked item");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)trackedItem.getTitle()), (String)"Tracked item title must be set", (Object[])new Object[0]);
            Checks.checkArgument((trackedItem.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
            Checks.checkArgument((!trackedItem.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
            Checks.checkArgument((!CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().exists((Function1 & Serializable)existing -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$validateItem$1(trackedItem, lowerCaseTitle$lzy, existing))) ? 1 : 0) != 0, (String)new StringBuilder(43).append("A tracked item with title '").append(trackedItem.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
            if (trackedItem.getReleaseIds() == null) {
                trackedItem.setReleaseIds(new HashSet());
            }
            if (!validateMembers) break block1;
            trackedItem.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        }
    }

    private boolean validateItem$default$3() {
        return true;
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must be a valid release ID").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        Checks.checkArgument((releaseStatus != null ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must exist in the database").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus2 = releaseStatus;
        ReleaseStatus releaseStatus3 = ReleaseStatus.TEMPLATE;
        Checks.checkArgument(((releaseStatus2 == null ? releaseStatus3 != null : !releaseStatus2.equals(releaseStatus3)) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Provided entity '").append(releaseId).append("' must be a release").toString(), (Object[])new Object[0]);
    }

    private void validateTask(String taskId) {
        Checks.checkArgument((boolean)Ids.isTaskId((String)taskId), (String)new StringBuilder(38).append("Provided ID '").append(taskId).append("' must be a valid task ID").toString(), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(taskId), (String)new StringBuilder(46).append("Provided task ID '").append(taskId).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$manualCompleteTransition$3(String itemId$1, Stage x$6) {
        return x$6.getItemById(itemId$1).getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$manualCompleteTransition$2(Delivery delivery$2, Stage stage$1, String itemId) {
        TrackedItem trackedItem = delivery$2.getItemByIdOrTitle(itemId);
        Checks.checkArgument((!trackedItem.isDescoped() ? 1 : 0) != 0, (String)new StringBuilder(49).append("De-scoped tracked item '").append(trackedItem.getTitle()).append("' can not be transitioned").toString(), (Object[])new Object[0]);
        Buffer notDoneInStages = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery$2.getStagesBefore(stage$1)).asScala().$colon$plus((Object)stage$1)).filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$manualCompleteTransition$3(itemId, x$6)));
        Checks.checkArgument((boolean)notDoneInStages.isEmpty(), (String)new StringBuilder(0).append(new StringBuilder(44).append("Tracked item '").append(trackedItem.getTitle()).append("' must be completed or skipped").toString()).append(new StringBuilder(53).append(" in stage '").append(((IterableOnceOps)notDoneInStages.map((Function1 & Serializable)x$7 -> x$7.getTitle())).mkString("', '")).append("' in order to transition to the next stage").toString()).toString(), (Object[])new Object[0]);
    }

    private static final /* synthetic */ String lowercaseTitle$lzycompute$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        String string;
        LazyRef lazyRef = lowercaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : (String)lowercaseTitle$lzy$1.initialize((Object)idOrTitle$1.toLowerCase());
        }
        return string;
    }

    private static final String lowercaseTitle$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        return lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : DeliveryExecutionService.lowercaseTitle$lzycompute$1(lowercaseTitle$lzy$1, idOrTitle$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$3(String idOrTitle$1, LazyRef lowercaseTitle$lzy$1, TrackedItem trackedItem) {
        String string = Ids.getName((String)trackedItem.getId());
        String string2 = Ids.getName((String)idOrTitle$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trackedItem.getTitle().toLowerCase();
        String string4 = DeliveryExecutionService.lowercaseTitle$1(lowercaseTitle$lzy$1, idOrTitle$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$processChanges$1(DeliveryExecutionService $this, String x$11) {
        $this.logger().info((Function0 & Serializable)() -> x$11);
    }

    private static final /* synthetic */ String lowerCaseTitle$lzycompute$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        String string;
        LazyRef lazyRef = lowerCaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : (String)lowerCaseTitle$lzy$1.initialize((Object)trackedItem$1.getTitle().toLowerCase());
        }
        return string;
    }

    private static final String lowerCaseTitle$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        return lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : DeliveryExecutionService.lowerCaseTitle$lzycompute$1(lowerCaseTitle$lzy$1, trackedItem$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateItem$1(TrackedItem trackedItem$1, LazyRef lowerCaseTitle$lzy$1, TrackedItem existing) {
        String string = existing.getTitle().toLowerCase();
        String string2 = DeliveryExecutionService.lowerCaseTitle$1(lowerCaseTitle$lzy$1, trackedItem$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = existing.getId();
        String string4 = trackedItem$1.getId();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    @Autowired
    public DeliveryExecutionService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, TaskRepository taskRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, ReleaseActorService releaseActorService) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

