/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\rug\u0001\u0002\u001d:\u0001\u0011C\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t/\u0002\u0011\t\u0011)A\u0005#\"A\u0001\f\u0001BC\u0002\u0013\u0005\u0011\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0001\u0007A!b\u0001\n\u0003\t\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011!\u0004!Q1A\u0005\u0002%D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t]\u0002\u0011)\u0019!C\u0001_\"Aa\u000f\u0001B\u0001B\u0003%\u0001\u000f\u0003\u0005x\u0001\t\u0015\r\u0011\"\u0001y\u0011!a\bA!A!\u0002\u0013I\b\u0002C?\u0001\u0005\u000b\u0007I\u0011\u0001@\t\u0013\u0005=\u0001A!A!\u0002\u0013y\bBCA\t\u0001\t\u0015\r\u0011\"\u0001\u0002\u0014!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!!\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002@\u0002!\t!!3\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?AqAa\u0012\u0001\t\u0003\u0011I\u0005C\u0004\u0003X\u0001!\tA!\u0017\t\u0013\te\u0004!%A\u0005\u0002\tm\u0004b\u0002BH\u0001\u0011\u0005!\u0011\u0013\u0005\b\u0005/\u0002A\u0011\u0001BT\u0011\u001d\u0011\t\f\u0001C\u0001\u0005gC\u0011Ba0\u0001#\u0003%\tA!1\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\"9!\u0011\u001b\u0001\u0005\u0002\tM\u0007b\u0002Bi\u0001\u0011\u0005!q\u001d\u0005\b\u0005c\u0004A\u0011\u0001Bz\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0005wDqaa\u0001\u0001\t\u0003\u0019)\u0001C\u0004\u0004\u0010\u0001!Ia!\u0005\t\u000f\r-\u0002\u0001\"\u0003\u0004.!91\u0011\u0007\u0001\u0005\u0002\rM\u0002bBB\u0019\u0001\u0011\u00051q\u0007\u0005\b\u0007\u007f\u0001A\u0011AB!\u0011\u001d\u0019)\u0005\u0001C\u0005\u0007\u000fBqa!\u0016\u0001\t\u0013\u00199\u0006C\u0004\u0004\\\u0001!\ta!\u0018\t\u0013\r\u0015\u0004!%A\u0005\u0002\t\u0005\u0007bBB4\u0001\u0011%1\u0011\u000e\u0005\b\u0007o\u0002A\u0011BB=\u0011\u001d\u0019\u0019\f\u0001C\u0005\u0007kC\u0011b!0\u0001#\u0003%Iaa0\t\u000f\r\r\u0007\u0001\"\u0015\u0004F\n1B)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hnU3sm&\u001cWM\u0003\u0002;w\u000591/\u001a:wS\u000e,'B\u0001\u001f>\u0003!!W\r\\5wKJL(B\u0001 @\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002A\u0003\u0006I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0005\u0006\u00191m\\7\u0004\u0001M\u0019\u0001!R&\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g!\taU*D\u0001:\u0013\tq\u0015H\u0001\u000bEK2Lg/\u001a:z'\u0016\u0014h/[2f+RLGn]\u0001\u0013I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180F\u0001R!\t\u0011V+D\u0001T\u0015\t!6(\u0001\u0006sKB|7/\u001b;pefL!AV*\u0003%\u0011+G.\u001b<fef\u0014V\r]8tSR|'/_\u0001\u0014I\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JLX#\u0001.\u0011\u0005mkV\"\u0001/\u000b\u0005Qk\u0014B\u00010]\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0013e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b%\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u0003\t\u0004\"aY3\u000e\u0003\u0011T!AO\u001f\n\u0005\u0019$'A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0010e\u0016dW-Y:f'\u0016\u0014h/[2fA\u0005Y1-[%e'\u0016\u0014h/[2f+\u0005Q\u0007CA2l\u0013\taGMA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001D2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\u0013\u0001E1sG\"Lg/\u001a3SK2,\u0017m]3t+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:>\u0003\t!'-\u0003\u0002ve\n\u0001\u0012I]2iSZ,GMU3mK\u0006\u001cXm]\u0001\u0012CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\u0013!\u00044pY\u0012,'oU3sm&\u001cW-F\u0001z!\t\u0019'0\u0003\u0002|I\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\faBZ8mI\u0016\u00148+\u001a:wS\u000e,\u0007%A\u0006s_2,7+\u001a:wS\u000e,W#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005A1/Z2ve&$\u0018PC\u0002\u0002\n}\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003\u001b\t\u0019AA\u0006S_2,7+\u001a:wS\u000e,\u0017\u0001\u0004:pY\u0016\u001cVM\u001d<jG\u0016\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mQ(\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003?\tIBA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)I\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003g\t)$a\u000e\u0011\u00051\u0003\u0001\"B(\u0012\u0001\u0004\t\u0006\"\u0002-\u0012\u0001\u0004Q\u0006\"\u00021\u0012\u0001\u0004\u0011\u0007\"\u00025\u0012\u0001\u0004Q\u0007\"\u00028\u0012\u0001\u0004\u0001\b\"B<\u0012\u0001\u0004I\b\"B?\u0012\u0001\u0004y\bbBA\t#\u0001\u0007\u0011Q\u0003\u0015\u0004#\u0005m\u0002\u0003BA\u001f\u0003'j!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\u000bC:tw\u000e^1uS>t'\u0002BA#\u0003\u000f\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002J\u0005-\u0013!\u00022fC:\u001c(\u0002BA'\u0003\u001f\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003#\n1a\u001c:h\u0013\u0011\t)&a\u0010\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AC4fiB\u000bG\u000f^3s]R!\u00111LA5!\u0011\ti&!\u001a\u000e\u0005\u0005}#b\u0001\u001f\u0002b)\u0019\u00111M\u001f\u0002\r\u0011|W.Y5o\u0013\u0011\t9'a\u0018\u0003\u0011\u0011+G.\u001b<fefDq!a\u001b\u0013\u0001\u0004\ti'A\u0005qCR$XM\u001d8JIB!\u0011qNA?\u001d\u0011\t\t(!\u001f\u0011\u0007\u0005Mt)\u0004\u0002\u0002v)\u0019\u0011qO\"\u0002\rq\u0012xn\u001c;?\u0013\r\tYhR\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0014\u0011\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mt\tK\u0002\u0013\u0003\u000b\u0003B!a\"\u0002\u00146\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0003\nYI\u0003\u0003\u0002\u000e\u0006=\u0015aB7fiJL7m\u001d\u0006\u0004\u0003#\u000b\u0015\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005U\u0015\u0011\u0012\u0002\u0006)&lW\rZ\u0001\u0016O\u0016$\b+\u0019;uKJt')_%e\u001fJ$\u0016\u000e\u001e7f)\u0011\tY&a'\t\u000f\u0005u5\u00031\u0001\u0002n\u0005\u0001\u0002/\u0019;uKJt\u0017\nZ(s)&$H.\u001a\u0015\u0004'\u0005\u0015\u0015AF3ySN$8\u000fU1ui\u0016\u0014hnV5uQRKG\u000f\\3\u0015\r\u0005\u0015\u00161VAX!\r1\u0015qU\u0005\u0004\u0003S;%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[#\u0002\u0019AA7\u0003\tIG\rC\u0004\u00022R\u0001\r!!\u001c\u0002\u000bQLG\u000f\\3)\u0007Q\t))A\u0007fq&\u001cHo\u001d)biR,'O\u001c\u000b\u0005\u0003K\u000bI\fC\u0004\u0002<V\u0001\r!!\u001c\u0002\u0015\u0011,G.\u001b<fefLE\rK\u0002\u0016\u0003\u000b\u000bQc\u0019:fCR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002\\\u0005\r\u0007bBAc-\u0001\u0007\u00111L\u0001\ba\u0006$H/\u001a:oQ\r1\u0012Q\u0011\u000b\u0007\u00037\nY-!4\t\u000f\u0005\u0015w\u00031\u0001\u0002\\!9\u0011qZ\fA\u0002\u0005\u0015\u0016AE:i_VdGMU3tKR\u0004\u0016\r\u001e;fe:D3aFAC\u0003U)\b\u000fZ1uK\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:$B!a\u0017\u0002X\"9\u0011\u0011\u001c\rA\u0002\u0005m\u0013aB;qI\u0006$X\r\u001a\u0015\u00041\u0005\u0015\u0015!\u00063fY\u0016$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u0003C\f9\u000fE\u0002G\u0003GL1!!:H\u0005\u0011)f.\u001b;\t\u000f\u0005-\u0014\u00041\u0001\u0002n!\u001a\u0011$!\"\u00021\u0011,\b\u000f\\5dCR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0004\u0002\\\u0005=\u0018\u0011\u001f\u0005\b\u0003WR\u0002\u0019AA7\u0011\u001d\t\u0019P\u0007a\u0001\u0003k\fa\u0001]1sC6\u001c\b\u0003BA|\u0005\u000bi!!!?\u000b\t\u0005m\u0018Q`\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0003\u007f\u0014\t!\u0001\u0002wc)\u0019!1A\u001f\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\b\u0005e(\u0001\u0007#va2L7-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]\"\u001a!$!\"\u00023\r\u0014X-\u0019;f\t\u0016d\u0017N^3ss\u001a\u0013x.\u001c)biR,'O\u001c\u000b\u0007\u00037\u0012yA!\u0005\t\u000f\u0005-4\u00041\u0001\u0002n!9!1C\u000eA\u0002\tU\u0011A\u00039be\u0006lW\r^3sgB!\u0011q\u001fB\f\u0013\u0011\u0011I\"!?\u0003\u001d\r\u0013X-\u0019;f\t\u0016d\u0017N^3ss\"\u001a1$!\"\u0002\u001dM,\u0017M]2i!\u0006$H/\u001a:ogR1!\u0011\u0005B\u0019\u0005w\u0001bAa\t\u0003.\u0005mSB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005W\tAA[1wC&!!q\u0006B\u0013\u0005\u0011a\u0015n\u001d;\t\u000f\tMB\u00041\u0001\u00036\u00059a-\u001b7uKJ\u001c\b\u0003BA|\u0005oIAA!\u000f\u0002z\n1B)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hNR5mi\u0016\u00148\u000fC\u0004\u0003>q\u0001\rAa\u0010\u0002\tA\fw-\u001a\t\u00047\n\u0005\u0013b\u0001B\"9\n!\u0001+Y4fQ\ra\u0012QQ\u0001\nO\u0016$8\u000b^1hKN$BAa\u0013\u0003TA1!1\u0005B\u0017\u0005\u001b\u0002B!!\u0018\u0003P%!!\u0011KA0\u0005\u0015\u0019F/Y4f\u0011\u001d\tY'\ba\u0001\u0003[B3!HAC\u0003!\tG\rZ*uC\u001e,G\u0003\u0003B'\u00057\u0012iF!\u0019\t\u000f\u0005-d\u00041\u0001\u0002n!9!q\f\u0010A\u0002\t5\u0013!B:uC\u001e,\u0007\"\u0003B2=A\u0005\t\u0019\u0001B3\u0003!\u0001xn]5uS>t\u0007C\u0002B\u0012\u0005O\u0012Y'\u0003\u0003\u0003j\t\u0015\"\u0001C(qi&|g.\u00197\u0011\t\t5$1O\u0007\u0003\u0005_RAA!\u001d\u0003*\u0005!A.\u00198h\u0013\u0011\u0011)Ha\u001c\u0003\u000f%sG/Z4fe\"\u001aa$!\"\u0002%\u0005$Gm\u0015;bO\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0005{RCA!\u001a\u0003\u0000-\u0012!\u0011\u0011\t\u0005\u0005\u0007\u0013Y)\u0004\u0002\u0003\u0006*!!q\u0011BE\u0003%)hn\u00195fG.,GMC\u0002\u0002B\u001dKAA!$\u0003\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005$Gm\u0015;bO\u0016\u0014U\r^<fK:$\"B!\u0014\u0003\u0014\nU%q\u0013BQ\u0011\u001d\tY\u0007\ta\u0001\u0003[BqAa\u0018!\u0001\u0004\u0011i\u0005C\u0004\u0003\u001a\u0002\u0002\rAa'\u0002\r\t,gm\u001c:f!\u00151%QTA7\u0013\r\u0011yj\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t\r\u0006\u00051\u0001\u0003\u001c\u0006)\u0011M\u001a;fe\"\u001a\u0001%!\"\u0015\u0011\t5#\u0011\u0016BV\u0005[Cq!!2\"\u0001\u0004\tY\u0006C\u0004\u0003`\u0005\u0002\rA!\u0014\t\u000f\t\r\u0014\u00051\u0001\u0003f!\u001a\u0011%!\"\u0002\u0017U\u0004H-\u0019;f'R\fw-\u001a\u000b\t\u0005\u001b\u0012)La.\u0003:\"9\u00111\u000e\u0012A\u0002\u00055\u0004bBAmE\u0001\u0007!Q\n\u0005\n\u0005w\u0013\u0003\u0013!a\u0001\u0003K\u000b\u0011B\u001a:p[\n\u000bGo\u00195)\u0007\t\n))A\u000bva\u0012\fG/Z*uC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\r'\u0006BAS\u0005\u007f\n1\u0002Z3mKR,7\u000b^1hKR1\u0011\u0011\u001dBe\u0005\u0017Dq!a\u001b%\u0001\u0004\ti\u0007C\u0004\u0003N\u0012\u0002\r!!\u001c\u0002\u000fM$\u0018mZ3JI\"\u001aA%!\"\u0002\u001b\u0005$G\r\u0016:b]NLG/[8o)!\u0011)Na7\u0003^\n\u0005\b\u0003BA/\u0005/LAA!7\u0002`\tQAK]1og&$\u0018n\u001c8\t\u000f\u0005-T\u00051\u0001\u0002n!9!q\\\u0013A\u0002\u00055\u0014AD:uC\u001e,\u0017\nZ(s)&$H.\u001a\u0005\b\u0005G,\u0003\u0019\u0001Bk\u0003)!(/\u00198tSRLwN\u001c\u0015\u0004K\u0005\u0015E\u0003\u0003Bk\u0005S\u0014YO!<\t\u000f\u0005\u0015g\u00051\u0001\u0002\\!9!q\u001c\u0014A\u0002\u00055\u0004b\u0002BrM\u0001\u0007!Q\u001b\u0015\u0004M\u0005\u0015\u0015\u0001E;qI\u0006$X\r\u0016:b]NLG/[8o)\u0019\u0011)N!>\u0003x\"9\u00111N\u0014A\u0002\u00055\u0004bBAmO\u0001\u0007!Q\u001b\u0015\u0004O\u0005\u0015EC\u0002Bk\u0005{\u0014y\u0010C\u0004\u0002F\"\u0002\r!a\u0017\t\u000f\u0005e\u0007\u00061\u0001\u0003V\"\u001a\u0001&!\"\u0002!\u0011,G.\u001a;f)J\fgn]5uS>tGCBAq\u0007\u000f\u0019I\u0001C\u0004\u0002l%\u0002\r!!\u001c\t\u000f\r-\u0011\u00061\u0001\u0002n\u0005aAO]1og&$\u0018n\u001c8JI\"\u001a\u0011&!\"\u00021\u001d,g.\u001a:bi\u0016$\u0016\u000e\u001e7f\u0013\u001atUmY3tg\u0006\u0014\u0018\u0010\u0006\u0004\u0002b\u000eM1Q\u0003\u0005\b\u0005?R\u0003\u0019\u0001B'\u0011\u001d\u00199B\u000ba\u0001\u00073\taa\u001d;bO\u0016\u001c\bCBB\u000e\u0007K\u0011iE\u0004\u0003\u0004\u001e\r\u0005b\u0002BA:\u0007?I\u0011\u0001S\u0005\u0004\u0007G9\u0015a\u00029bG.\fw-Z\u0005\u0005\u0007O\u0019ICA\u0002TKFT1aa\tH\u00039\u0019\u0007.Z2l\u0013N\u0004\u0016\r\u001e;fe:$B!!9\u00040!1Ah\u000ba\u0001\u00037\nqB^1mS\u0012\fG/\u001a)biR,'O\u001c\u000b\u0005\u0003C\u001c)\u0004\u0003\u0004=Y\u0001\u0007\u00111\f\u000b\u0007\u0003C\u001cIda\u000f\t\rqj\u0003\u0019AA.\u0011\u001d\u0019i$\fa\u0001\u0003K\u000b1b^5uQF+XM]5fg\u0006!c/\u00197jI\u0006$Xm\u0015;bO\u0016\u001c\u0018I\u001c3Ue\u0006t7/\u001b;j_:\u001c\u0018I\u001c3Ji\u0016l7\u000f\u0006\u0003\u0002b\u000e\r\u0003bBAc]\u0001\u0007\u00111L\u0001\u0011m\u0006d\u0017\u000eZ1uK:+wo\u0015;bO\u0016$\u0002\"!9\u0004J\r-3Q\n\u0005\b\u0007/y\u0003\u0019AB\r\u0011\u001d\u0011yf\fa\u0001\u0005\u001bBqAa\u00190\u0001\u0004\u0019y\u0005E\u0002G\u0007#J1aa\u0015H\u0005\rIe\u000e^\u0001\u0018m\u0006d\u0017\u000eZ1uKN#\u0018mZ3Qe>\u0004XM\u001d;jKN$B!!9\u0004Z!9!q\f\u0019A\u0002\t5\u0013\u0001\u0004:fg\u0016$\b+\u0019;uKJtGCBAq\u0007?\u001a\t\u0007C\u0004\u0002FF\u0002\r!a\u0017\t\u0013\r\r\u0014\u0007%AA\u0002\u0005\u0015\u0016a\u00034pe\u000e,g*Z<JIN\faC]3tKR\u0004\u0016\r\u001e;fe:$C-\u001a4bk2$HEM\u0001\u000fe\u0016\u001cX\r^\"p]\u0012LG/[8o)\u0019\t\toa\u001b\u0004n!9!1]\u001aA\u0002\tU\u0007bBB8g\u0001\u00071\u0011O\u0001\nG>tG-\u001b;j_:\u0004B!!\u0018\u0004t%!1QOA0\u0005%\u0019uN\u001c3ji&|g.\u0001\nhK:,'/\u0019;f\u001fJ,\u0006\u000fZ1uK&#W\u0003BB>\u0007'#\"b! \u0004&\u000e%6QVBY)\u0011\tiga \t\u0013\r\u0005E'!AA\u0004\r\r\u0015AC3wS\u0012,gnY3%cA11QQBF\u0007\u001fk!aa\"\u000b\u0007\r%u)A\u0004sK\u001adWm\u0019;\n\t\r55q\u0011\u0002\t\u00072\f7o\u001d+bOB!1\u0011SBJ\u0019\u0001!qa!&5\u0005\u0004\u00199JA\u0001U#\u0011\u0019Ija(\u0011\u0007\u0019\u001bY*C\u0002\u0004\u001e\u001e\u0013qAT8uQ&tw\rE\u0002G\u0007CK1aa)H\u0005\r\te.\u001f\u0005\b\u0007O#\u0004\u0019AA7\u0003))\u00070[:uS:<\u0017\n\u001a\u0005\b\u0007W#\u0004\u0019AA7\u0003-yG\u000e\u001a)be\u0016tG/\u00133\t\u000f\r=F\u00071\u0001\u0002n\u0005Ya.Z<QCJ,g\u000e^%e\u0011\u001d\u0019\u0019\u0007\u000ea\u0001\u0003K\u000bA#\u00197sK\u0006$\u00170\u0012=jgR\u001c()\u001f+ji2,GCBAS\u0007o\u001bY\fC\u0004\u0004:V\u0002\r!!\u001c\u0002\u0019A\fG\u000f^3s]RKG\u000f\\3\t\u0013\u0005-T\u0007%AA\u0002\u00055\u0014AH1me\u0016\fG-_#ySN$8OQ=USRdW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019\tM\u000b\u0003\u0002n\t}\u0014\u0001E2iK\u000e\\\u0017j]+qI\u0006$\u0018M\u00197f)\u0019\t\toa2\u0004L\"91\u0011Z\u001cA\u0002\u0005m\u0013\u0001E3ySN$\u0018N\\4EK2Lg/\u001a:z\u0011%\u0019im\u000eI\u0001\u0002\u0004\ti'\u0001\u0004bGRLwN\u001c\u0015\u0004\u0001\rE\u0007\u0003BBj\u00073l!a!6\u000b\t\r]\u00171J\u0001\u000bgR,'/Z8usB,\u0017\u0002BBn\u0007+\u0014qaU3sm&\u001cW\r")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validate(Delivery delivery, boolean withQueries) {
        DeliveryServiceUtils.validate$(this, delivery, withQueries);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        return this.createDeliveryPattern(pattern, true);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern, boolean shouldResetPattern) {
        Checks.checkNotNull((Object)pattern, (String)"Release delivery");
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append(pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        if (shouldResetPattern) {
            this.resetPattern(pattern, this.resetPattern$default$2());
        }
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append(updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$"));
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])c))).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1)));
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(Integer.toString(++orderNumber)).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        if (parameters.getFolderId() != null) {
            delivery.setFolderId(parameters.getFolderId());
        }
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.deliveryRepository().search((AbstractDeliveryFilters)filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (scala.collection.immutable.Seq<Permission>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Optional<Integer> position) {
        return this.addStage(this.getPattern(patternId), stage, position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Timed
    public Stage addStageBetween(String patternId, Stage stage, Option<String> before, Option<String> after) {
        Stage stage2;
        Delivery pattern = this.getPattern(patternId);
        Option beforeIndex = before.map(DeliveryPatternService.getStageIndex$1(pattern));
        Option afterIndex = after.map(DeliveryPatternService.getStageIndex$1(pattern));
        if (before.isDefined()) {
            if (after.isDefined()) {
                if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != BoxesRunTime.unboxToInt((Object)beforeIndex.get()) - 1) throw new LogFriendlyConcurrentModificationException("Unable to add stage between %s and %s, because these two stages are not neighbors any more", new Object[]{after.get(), before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)beforeIndex.get()))));
                return stage2;
            } else {
                if (BoxesRunTime.unboxToInt((Object)beforeIndex.get()) != 0) throw new LogFriendlyConcurrentModificationException("Unable to add first stage before %s, because it is not first stage of delivery pattern any more", new Object[]{before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(0)));
            }
            return stage2;
        } else if (after.isDefined()) {
            if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != pattern.getStages().size() - 1) throw new LogFriendlyConcurrentModificationException("Unable to add last stage after %s, because it is not last stage of the delivery pattern any more", new Object[]{after.get()});
            stage2 = this.addStage(pattern, stage, Optional.empty());
            return stage2;
        } else {
            if (!pattern.getStages().isEmpty()) throw new LogFriendlyConcurrentModificationException("Unable to add first stage to the pattern, because pattern is not empty any more", new Object[0]);
            stage2 = this.addStage(pattern, stage, Optional.empty());
        }
        return stage2;
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage, Optional<Integer> position) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Adding new stage '").append(stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        this.generateTitleIfNecessary(stage, (scala.collection.immutable.Seq<Stage>)stages);
        Integer realPosition = position.orElse(Predef$.MODULE$.int2Integer(stages.size()));
        this.validateStageProperties(stage);
        this.validateNewStage((scala.collection.immutable.Seq<Stage>)stages, stage, Predef$.MODULE$.Integer2int(realPosition));
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, Predef$.MODULE$.Integer2int(realPosition));
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    public Optional<Integer> addStage$default$3() {
        return Optional.empty();
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated, boolean fromBatch) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(31).append("Updating stage '").append(updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStageProperties(updated);
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        if (!fromBatch) {
            this.validateNewStage((scala.collection.immutable.Seq<Stage>)((scala.collection.immutable.Seq)stages.diff((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Stage[]{original})))), updated, stages.indexOf((Object)original));
        }
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    public boolean updateStage$default$3() {
        return false;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Adding new transition '").append(transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        if (stage.getTransition() != null) {
            throw new LogFriendlyConcurrentModificationException("There is already a transition named '%s' associated with stage '%s'", new Object[]{stage.getTransition().getTitle(), stage.getTitle()});
        }
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)x$2));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Updating transition '").append(updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)updated, (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)x$3));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, scala.collection.immutable.Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)stage, (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    public void validatePattern(Delivery delivery) {
        this.validatePattern(delivery, true);
    }

    public void validatePattern(Delivery delivery, boolean withQueries) {
        block0: {
            this.validate(delivery, withQueries);
            this.checkIsPattern(delivery);
            Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
            if (!withQueries) break block0;
            Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
        }
    }

    public void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties((Stage)stage);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTitle());
        Buffer duplicateStages = (Buffer)((SeqOps)stageTitles.diff((Seq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getTrackedItems()).asScala().map((Function1 & Serializable)x$6 -> x$6.getTitle().toLowerCase());
        Buffer duplicateItems = (Buffer)((SeqOps)trackedItemTitles.diff((Seq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(scala.collection.immutable.Seq<Stage> stages, Stage stage, int position) {
        Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        Checks.checkArgument((!stages.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Stage stage) {
        Checks.checkNotNull((Object)stage, (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    public void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    public boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds((AbstractDeliveryFilters)filters).exists((Function1 & Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$addStageBetween$2(String folderlessId$1, Tuple2 t) {
        return Ids.getName((String)((BaseConfigurationItem)t._1()).getId()).equals(folderlessId$1);
    }

    public static final /* synthetic */ int $anonfun$addStageBetween$1(Delivery pattern$2, String id) {
        String folderlessId = Ids.getName((String)id);
        return ((Tuple2)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(pattern$2.getStages()).asScala().zipWithIndex()).find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$addStageBetween$2(folderlessId, t))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyConcurrentModificationException("Stage %s not found", new Object[]{id});
        }))._2$mcI$sp();
    }

    private static final Function1 getStageIndex$1(Delivery pattern$2) {
        return (Function1 & Serializable)id -> BoxesRunTime.boxToInteger((int)DeliveryPatternService.$anonfun$addStageBetween$1(pattern$2, id));
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
        Statics.releaseFence();
    }
}

