/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.delivery.events.ConditionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.service.DeliveryTimelineCalculator;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.delivery.conditions.ConditionGroup;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.CiHelper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@Service
@ScalaSignature(bytes="\u0006\u0005\r=a\u0001B\u0014)\u0001MB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003U\u0011!Q\u0006A!b\u0001\n\u0003Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011)\u0019!C\u0001S\"AQ\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005o\u0001\t\u0015\r\u0011\"\u0001p\u0011!\u0019\bA!A!\u0002\u0013\u0001\b\u0002\u0003;\u0001\u0005\u000b\u0007I\u0011A;\t\u0011q\u0004!\u0011!Q\u0001\nYD\u0001\" \u0001\u0003\u0006\u0004%\tA \u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n}D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\tY\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003;\u0001!Q1A\u0005\u0002\u0005}\u0001BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u0002\"!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!!.\u0001\t\u0003\t\u0019\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\bbBA{\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005gAqAa\u001d\u0001\t\u0003\u0011)\bC\u0004\u0003\u001c\u0002!\tA!(\t\u000f\t-\u0006\u0001\"\u0001\u0003.\"9!q\u0017\u0001\u0005\u0002\te\u0006b\u0002Bj\u0001\u0011E#Q\u001b\u0005\n\u0005?\u0004\u0011\u0013!C\t\u0005CDqAa5\u0001\t#\u0011)PA\bEK2Lg/\u001a:z'\u0016\u0014h/[2f\u0015\tI#&A\u0004tKJ4\u0018nY3\u000b\u0005-b\u0013\u0001\u00033fY&4XM]=\u000b\u00055r\u0013!\u0003=me\u0016dW-Y:f\u0015\ty\u0003'A\u0005yK\nL\u0017\r\\1cg*\t\u0011'A\u0002d_6\u001c\u0001aE\u0003\u0001ii\u0012e\t\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nQa\u001d7gi)T\u0011aP\u0001\tOJL'P\u001f7fI&\u0011\u0011\t\u0010\u0002\b\u0019><w-\u001b8h!\t\u0019E)D\u0001)\u0013\t)\u0005F\u0001\u000eEK2Lg/\u001a:z)&lW\r\\5oK\u000e\u000bGnY;mCR|'\u000f\u0005\u0002D\u000f&\u0011\u0001\n\u000b\u0002\u0015\t\u0016d\u0017N^3ssN+'O^5dKV#\u0018\u000e\\:\u0002%\u0011,G.\u001b<fef\u0014V\r]8tSR|'/_\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011aJK\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001)N\u0005I!U\r\\5wKJL(+\u001a9pg&$xN]=\u0002'\u0011,G.\u001b<fef\u0014V\r]8tSR|'/\u001f\u0011\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001U!\t)v+D\u0001W\u0015\tqE&\u0003\u0002Y-\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f+\u0005a\u0006CA/`\u001b\u0005q&BA\u0015-\u0013\t\u0001gL\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u001fI,G.Z1tKN+'O^5dK\u0002\n\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0016\u0003\u0011\u0004\"!X3\n\u0005\u0019t&\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E\t'o\u00195jm&twmU3sm&\u001cW\rI\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0016\u0003)\u0004\"!X6\n\u00051t&\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u000bsK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\u0011\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002aB\u0011Q,]\u0005\u0003ez\u00131bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u0005\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011\u0010L\u0001\u0003I\nL!a\u001f=\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u0005iam\u001c7eKJ\u001cVM\u001d<jG\u0016,\u0012a \t\u0004;\u0006\u0005\u0011bAA\u0002=\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\faBZ8mI\u0016\u00148+\u001a:wS\u000e,\u0007%A\u0006s_2,7+\u001a:wS\u000e,WCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0001b]3dkJLG/\u001f\u0006\u0004\u0003+q\u0013\u0001\u00033fa2|\u00170\u001b;\n\t\u0005e\u0011q\u0002\u0002\f%>dWmU3sm&\u001cW-\u0001\u0007s_2,7+\u001a:wS\u000e,\u0007%\u0001\u0005fm\u0016tGOQ;t+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9\u0003L\u0001\u0007KZ,g\u000e^:\n\t\u0005-\u0012Q\u0005\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003\u0019a\u0014N\\5u}Q1\u00121GA\u001b\u0003o\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"\u0003\u000b\n9\u0005\u0005\u0002D\u0001!)\u0011*\u0006a\u0001\u0017\")!+\u0006a\u0001)\")!,\u0006a\u00019\")!-\u0006a\u0001I\")\u0001.\u0006a\u0001U\")a.\u0006a\u0001a\")A/\u0006a\u0001m\")Q0\u0006a\u0001\u007f\"9\u0011qA\u000bA\u0002\u0005-\u0001bBA\u000f+\u0001\u0007\u0011\u0011\u0005\u0015\u0004+\u0005-\u0003\u0003BA'\u0003Gj!!a\u0014\u000b\t\u0005E\u00131K\u0001\u000bC:tw\u000e^1uS>t'\u0002BA+\u0003/\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002Z\u0005m\u0013!\u00022fC:\u001c(\u0002BA/\u0003?\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003C\n1a\u001c:h\u0013\u0011\t)'a\u0014\u0003\u0013\u0005+Ho\\<je\u0016$\u0017aC4fi\u0012+G.\u001b<fef$B!a\u001b\u0002zA!\u0011QNA;\u001b\t\tyGC\u0002,\u0003cR1!a\u001d-\u0003\u0019!w.\\1j]&!\u0011qOA8\u0005!!U\r\\5wKJL\bbBA>-\u0001\u0007\u0011QP\u0001\u000bI\u0016d\u0017N^3ss&#\u0007\u0003BA@\u0003\u001bsA!!!\u0002\nB\u0019\u00111\u0011\u001c\u000e\u0005\u0005\u0015%bAADe\u00051AH]8pizJ1!a#7\u0003\u0019\u0001&/\u001a3fM&!\u0011qRAI\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0012\u001c)\u0007Y\t)\n\u0005\u0003\u0002\u0018\u0006\rVBAAM\u0015\u0011\t\t&a'\u000b\t\u0005u\u0015qT\u0001\b[\u0016$(/[2t\u0015\r\t\t\u000bM\u0001\tG>$\u0017\r[1mK&!\u0011QUAM\u0005\u0015!\u0016.\\3e\u00039)\u00070[:ug\u0012+G.\u001b<fef$B!a+\u00022B\u0019Q'!,\n\u0007\u0005=fGA\u0004C_>dW-\u00198\t\u000f\u0005mt\u00031\u0001\u0002~!\u001aq#!&\u0002\u001d\r\u0014X-\u0019;f\t\u0016d\u0017N^3ssR!\u00111NA]\u0011\u0019Y\u0003\u00041\u0001\u0002l!\u001a\u0001$!0\u0011\t\u0005}\u0016QZ\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\t9-!3\u0002\r\r|W.\\8o\u0015\r\tY\rM\u0001\u0007O>|w\r\\3\n\t\u0005=\u0017\u0011\u0019\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0007f\u0001\r\u0002\u0016R1\u00111NAk\u0003/DaaK\rA\u0002\u0005-\u0004bBAm3\u0001\u0007\u00111V\u0001\ne\u0016<(/\u001b;f\u0013\u0012D3!GAK\u00039)\b\u000fZ1uK\u0012+G.\u001b<fef$B!a\u001b\u0002b\"9\u00111\u001d\u000eA\u0002\u0005-\u0014aB;qI\u0006$X\r\u001a\u0015\u00045\u0005U\u0015A\u00043fY\u0016$X\rR3mSZ,'/\u001f\u000b\u0005\u0003W\f\t\u0010E\u00026\u0003[L1!a<7\u0005\u0011)f.\u001b;\t\u000f\u0005m4\u00041\u0001\u0002~!\u001a1$!&\u0002!U\u0004H-\u0019;f)J\fgn]5uS>tGCBA}\u0003\u007f\u0014\t\u0001\u0005\u0003\u0002n\u0005m\u0018\u0002BA\u007f\u0003_\u0012!\u0002\u0016:b]NLG/[8o\u0011\u001d\tY\b\ba\u0001\u0003{Bq!a9\u001d\u0001\u0004\tI\u0010K\u0002\u001d\u0003+#b!!?\u0003\b\t%\u0001BB\u0016\u001e\u0001\u0004\tY\u0007C\u0004\u0002dv\u0001\r!!?)\u0007u\t)*\u0001\tva\u0012\fG/Z\"p]\u0012LG/[8ogR1!\u0011\u0003B\u0015\u0005[\u0001bAa\u0005\u0003\u001e\t\rb\u0002\u0002B\u000b\u00053qA!a!\u0003\u0018%\tq'C\u0002\u0003\u001cY\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003 \t\u0005\"aA*fc*\u0019!1\u0004\u001c\u0011\t\u00055$QE\u0005\u0005\u0005O\tyGA\u0005D_:$\u0017\u000e^5p]\"9!1\u0006\u0010A\u0002\u0005e\u0018AE8sS\u001eLg.\u00197Ue\u0006t7/\u001b;j_:DqAa\f\u001f\u0001\u0004\tI0A\tva\u0012\fG/\u001a3Ue\u0006t7/\u001b;j_:\faa]3be\u000eDG\u0003\u0003B\u001b\u0005\u000b\u0012iFa\u001a\u0011\r\t]\"\u0011IA6\u001b\t\u0011ID\u0003\u0003\u0003<\tu\u0012\u0001B;uS2T!Aa\u0010\u0002\t)\fg/Y\u0005\u0005\u0005\u0007\u0012ID\u0001\u0003MSN$\bb\u0002B$?\u0001\u0007!\u0011J\u0001\bM&dG/\u001a:t!\u0011\u0011YE!\u0017\u000e\u0005\t5#\u0002\u0002B(\u0005#\nQAZ8s[NTAAa\u0015\u0003V\u0005\u0011a/\r\u0006\u0004\u0005/b\u0013aA1qS&!!1\fB'\u0005]\t%m\u001d;sC\u000e$H)\u001a7jm\u0016\u0014\u0018PR5mi\u0016\u00148\u000fC\u0004\u0003`}\u0001\rA!\u0019\u0002\tA\fw-\u001a\t\u0004+\n\r\u0014b\u0001B3-\n!\u0001+Y4f\u0011\u001d\u0011Ig\ba\u0001\u0005W\nqa\u001c:eKJ\u0014\u0015\u0010\u0005\u0003\u0003L\t5\u0014\u0002\u0002B8\u0005\u001b\u0012\u0011\u0003R3mSZ,'/_(sI\u0016\u0014Xj\u001c3fQ\ry\u0012QS\u0001\fO\u0016$H+[7fY&tW\r\u0006\u0004\u0003x\t\r%Q\u0011\t\u0005\u0005s\u0012y(\u0004\u0002\u0003|)!!Q\u0010B)\u0003\u00151\u0018.Z<t\u0013\u0011\u0011\tIa\u001f\u0003!\u0011+G.\u001b<fef$\u0016.\\3mS:,\u0007bBA>A\u0001\u0007\u0011Q\u0010\u0005\b\u0005\u000f\u0003\u0003\u0019\u0001BE\u0003\rqwn\u001e\t\u0005\u0005\u0017\u0013)*\u0004\u0002\u0003\u000e*!!q\u0012BI\u0003\u0011!\u0018.\\3\u000b\t\tM\u0015qL\u0001\u0005U>$\u0017-\u0003\u0003\u0003\u0018\n5%\u0001\u0003#bi\u0016$\u0016.\\3)\u0007\u0001\n)*A\u0006hKR\u0014V\r\\3bg\u0016\u001cH\u0003\u0002BP\u0005O\u0003bAa\u000e\u0003B\t\u0005\u0006\u0003\u0002B=\u0005GKAA!*\u0003|\t9B)\u001a7jm\u0016\u0014\u0018P\u00127poJ+G.Z1tK&sgm\u001c\u0005\b\u0003w\n\u0003\u0019AA?Q\r\t\u0013QS\u0001!M&tG\rR3mSZ,'/[3t%\u00164WM]3oG&twMU3mK\u0006\u001cX\r\u0006\u0003\u00030\nE\u0006C\u0002B\n\u0005;\ti\bC\u0004\u00034\n\u0002\r!! \u0002\u0013I,G.Z1tK&#\u0007f\u0001\u0012\u0002\u0016\u0006)c-\u001b8e\u0003\u000e$\u0018N^3EK2Lg/\u001a:jKN\u0014VMZ3sK:\u001c\u0017N\\4G_2$WM\u001d\u000b\u0005\u0005w\u0013i\r\u0005\u0004\u0003\u0014\tu!Q\u0018\t\u0005\u0005\u007f\u0013I-\u0004\u0002\u0003B*!!1\u0019Bc\u0003-\u0001XM]:jgR,gnY3\u000b\u0007\t\u001dW*A\u0002tc2LAAa3\u0003B\ni1)[%e/&$\b\u000eV5uY\u0016DqAa4$\u0001\u0004\ti(\u0001\u0005g_2$WM]%eQ\r\u0019\u0013QS\u0001\u0011G\",7m[%t+B$\u0017\r^1cY\u0016$b!a;\u0003X\nm\u0007b\u0002BmI\u0001\u0007\u00111N\u0001\u0011KbL7\u000f^5oO\u0012+G.\u001b<fefD\u0011B!8%!\u0003\u0005\r!! \u0002\r\u0005\u001cG/[8o\u0003i\u0019\u0007.Z2l\u0013N,\u0006\u000fZ1uC\ndW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019O\u000b\u0003\u0002~\t\u00158F\u0001Bt!\u0011\u0011IO!=\u000e\u0005\t-(\u0002\u0002Bw\u0005_\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Ec'\u0003\u0003\u0003t\n-(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR!\u00111\u001eB|\u0011\u001d\u0011IP\na\u0001\u0005w\fQa\u001d;bO\u0016\u0004B!!\u001c\u0003~&!!q`A8\u0005\u0015\u0019F/Y4fQ\r\u000111\u0001\t\u0005\u0007\u000b\u0019Y!\u0004\u0002\u0004\b)!1\u0011BA.\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007\u001b\u00199AA\u0004TKJ4\u0018nY3")
public class DeliveryService
implements DeliveryTimelineCalculator,
DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final ArchivingService archivingService;
    private final ReleaseSearchService releaseSearchService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validate(Delivery delivery, boolean withQueries) {
        DeliveryServiceUtils.validate$(this, delivery, withQueries);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    @Override
    public DeliveryTimeline calculateTimeline(Delivery delivery, DateTime now) {
        return DeliveryTimelineCalculator.calculateTimeline$(this, delivery, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return DeliveryTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryService deliveryService = this;
        synchronized (deliveryService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getDelivery(String deliveryId) {
        void var2_2;
        Delivery delivery = this.getDeliveryOrPattern(deliveryId);
        this.checkIsDelivery(delivery);
        return var2_2;
    }

    @Timed
    public boolean existsDelivery(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    @VisibleForTesting
    public Delivery createDelivery(Delivery delivery) {
        return this.createDelivery(delivery, true);
    }

    @Timed
    public Delivery createDelivery(Delivery delivery, boolean rewriteId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(32).append("Creating new release delivery [").append(delivery).append("]").toString());
        this.validateDelivery(delivery);
        String deliveryId = rewriteId || delivery.getId() == null || !Ids.isDeliveryId((String)delivery.getId()) ? this.factory().deliveryId() : delivery.getId();
        delivery.setId(deliveryId);
        CiHelper.rewriteWithNewId((ConfigurationItem)delivery, (String)deliveryId);
        delivery.getStages().forEach(stage -> Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
            transition.setStage(stage);
            return BoxedUnit.UNIT;
        }));
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            DeliveryService.$anonfun$createDelivery$4(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public Delivery updateDelivery(Delivery updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("Updating release delivery [").append(updated).append("]").toString());
        this.validateDelivery(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDelivery(String deliveryId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("Deleting release delivery [").append(deliveryId).append("]").toString());
        Delivery delivery = this.deliveryRepository().read(deliveryId);
        this.checkIsDelivery(delivery);
        this.doDelete(deliveryId);
    }

    @Timed
    public Transition updateTransition(String deliveryId, Transition updated) {
        return this.updateTransition(this.getDelivery(deliveryId), updated);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Transition updateTransition(Delivery delivery, Transition updated) {
        void var3_3;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(22).append("Updating transition [").append(updated).append("]").toString());
        this.checkIsUpdatable(delivery, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)updated, (String)"Transition");
        Transition original = delivery.getTransitionByIdOrTitle(updated.getId());
        Transition originalBeforeChanges = (Transition)CiCloneHelper.cloneCi((ConfigurationItem)original);
        Stage stage = original.getStage();
        this.checkIsUpdatable(stage);
        this.validateTransition(delivery, stage, updated);
        scala.collection.immutable.Seq<Condition> updatedConditions = this.updateConditions(original, updated);
        original.setAutomated(updated.isAutomated());
        this.deliveryRepository().update(delivery);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(originalBeforeChanges, updated, delivery));
        updatedConditions.foreach((Function1 & Serializable)condition -> {
            DeliveryService.$anonfun$updateTransition$2(this, original, delivery, condition);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private scala.collection.immutable.Seq<Condition> updateConditions(Transition originalTransition, Transition updatedTransition) {
        Buffer originalConditions = CollectionConverters$.MODULE$.ListHasAsScala(originalTransition.getAllConditions()).asScala();
        Buffer updatedConditions = CollectionConverters$.MODULE$.ListHasAsScala(updatedTransition.getAllConditions()).asScala();
        Checks.checkArgument((originalConditions.size() == updatedConditions.size() ? 1 : 0) != 0, (String)"Not permitted to add or remove conditions on a running delivery", (Object[])new Object[0]);
        return ((IterableOnceOps)((IterableOps)originalConditions.zip((IterableOnce)updatedConditions)).flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Condition condition;
                Condition original = (Condition)tuple2._1();
                Condition updated = (Condition)tuple2._2();
                String string = original.getId();
                String string2 = updated.getId();
                Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)new StringBuilder(0).append("Updating order or structure of conditions not allowed on a running delivery. ").append(new StringBuilder(30).append("Expected condition '").append(original.getId()).append("', got '").append(updated.getId()).append("''").toString()).toString(), (Object[])new Object[0]);
                Type type = original.getType();
                Type type2 = updated.getType();
                Checks.checkArgument((!(type != null ? !type.equals(type2) : type2 != null) ? 1 : 0) != 0, (String)"Condition type cannot be changed on a running delivery", (Object[])new Object[0]);
                Condition condition2 = original;
                if (condition2 instanceof ConditionGroup) {
                    none$ = None$.MODULE$;
                } else if (condition2 != null && (condition = condition2).isSatisfied()) {
                    none$ = None$.MODULE$;
                } else {
                    Buffer changedProps = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(original.getInputProperties()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.areEqual((ConfigurationItem)original, (ConfigurationItem)updated)));
                    changedProps.foreach((Function1 & Serializable)pd -> {
                        pd.set((ConfigurationItem)original, pd.get((ConfigurationItem)updated));
                        return BoxedUnit.UNIT;
                    });
                    none$ = changedProps.nonEmpty() ? new Some((Object)original) : None$.MODULE$;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            None$ none$2 = none$;
            return none$2;
        })).toSeq();
    }

    @Timed
    public List<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.deliveryRepository().search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET())).asJava();
    }

    @Timed
    public DeliveryTimeline getTimeline(String deliveryId, DateTime now) {
        Delivery delivery = this.getDelivery(deliveryId);
        return this.calculateTimeline(delivery, now);
    }

    @Timed
    public List<DeliveryFlowReleaseInfo> getReleases(String deliveryId) {
        scala.collection.immutable.Seq<DeliveryFlowReleaseInfo> releases = this.deliveryRepository().findReleasesByDeliveryId(deliveryId);
        Set allReleaseIds = this.deliveryRepository().getByIdOrTitle(deliveryId).getReleaseIds();
        scala.collection.immutable.Seq seq = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(allReleaseIds).asScala().filterNot((Function1 & Serializable)fullId -> BoxesRunTime.boxToBoolean((boolean)DeliveryService.$anonfun$getReleases$1(releases, fullId)))).toSeq();
        Nil$ nil$ = package$.MODULE$.Nil();
        scala.collection.immutable.Seq seq2 = seq;
        scala.collection.immutable.Seq seq3 = !(nil$ != null ? !nil$.equals(seq2) : seq2 != null) ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty() : (scala.collection.immutable.Seq)this.archivingService().searchReleasesBasicExtByReleaseIds(seq).map((Function1 & Serializable)item -> new DeliveryFlowReleaseInfo(Ids.getName((String)item.id()), item.title(), item.status(), item.startDate(), item.endDate(), true));
        scala.collection.immutable.Seq archivedReleases = seq3;
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releases.$plus$plus((IterableOnce)archivedReleases)).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findDeliveriesReferencingRelease(String releaseId) {
        return this.deliveryRepository().findDeliveriesReferencingReleaseId(releaseId);
    }

    @Timed
    public scala.collection.immutable.Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolder(String folderId) {
        return this.deliveryRepository().findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        Checks.checkArgument((boolean)existingDelivery.isUpdatable(), (String)new StringBuilder(42).append("Cannot ").append(action).append(" release delivery '").append(existingDelivery.getTitle()).append("' because it is ").append(existingDelivery.getStatus()).toString(), (Object[])new Object[0]);
    }

    public void checkIsUpdatable(Stage stage) {
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(60).append("Cannot update transition on stage '").append(stage.getTitle()).append("' because it is COMPLETED").toString(), (Object[])new Object[0]);
    }

    @Override
    public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static final /* synthetic */ void $anonfun$createDelivery$4(DeliveryService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ void $anonfun$updateTransition$2(DeliveryService $this, Transition original$1, Delivery delivery$2, Condition condition) {
        $this.eventBus().publish((XLReleaseEvent)new ConditionUpdatedEvent(condition, original$1, delivery$2));
    }

    public static final /* synthetic */ boolean $anonfun$getReleases$1(scala.collection.immutable.Seq releases$1, String fullId) {
        return ((SeqOps)releases$1.map((Function1 & Serializable)x$2 -> x$2.getId())).contains((Object)Ids.getName((String)fullId));
    }

    @Autowired
    public DeliveryService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, ArchivingService archivingService, ReleaseSearchService releaseSearchService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.archivingService = archivingService;
        this.releaseSearchService = releaseSearchService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryTimelineCalculator.$init$(this);
        DeliveryServiceUtils.$init$(this);
        Statics.releaseFence();
    }
}

