/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\rEg\u0001B\u001c9\u0001\rC\u0001B\u0014\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005!\"Aq\u000b\u0001BC\u0002\u0013\u0005\u0001\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003Z\u0011!y\u0006A!b\u0001\n\u0003\u0001\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u001d\u0004!Q1A\u0005\u0002!D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t[\u0002\u0011)\u0019!C\u0001]\"AQ\u000f\u0001B\u0001B\u0003%q\u000e\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001x\u0011!Y\bA!A!\u0002\u0013A\b\u0002\u0003?\u0001\u0005\u000b\u0007I\u0011A?\t\u0013\u00055\u0001A!A!\u0002\u0013q\bBCA\b\u0001\t\u0015\r\u0011\"\u0001\u0002\u0012!Q\u0011q\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0005\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!!0\u0001\t\u0003\ty\fC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{AqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0005\u0003n\u0001\t\n\u0011\"\u0001\u0003p!9!1\u0011\u0001\u0005\u0002\t\u0015\u0005b\u0002B&\u0001\u0011\u0005!1\u0014\u0005\b\u0005K\u0003A\u0011\u0001BT\u0011%\u0011\u0019\fAI\u0001\n\u0003\u0011)\fC\u0004\u0003:\u0002!\tAa/\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\"9!Q\u0019\u0001\u0005\u0002\tm\u0007b\u0002Bs\u0001\u0011\u0005!q\u001d\u0005\b\u0005K\u0004A\u0011\u0001Bx\u0011\u001d\u00119\u0010\u0001C\u0001\u0005sDqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0004\u0004 \u0001!Ia!\t\t\u000f\r\u0015\u0002\u0001\"\u0001\u0004(!91Q\u0005\u0001\u0005\u0002\r-\u0002bBB\u001a\u0001\u0011\u00051Q\u0007\u0005\b\u0007s\u0001A\u0011BB\u001e\u0011\u001d\u0019I\u0005\u0001C\u0005\u0007\u0017Bqaa\u0014\u0001\t\u0003\u0019\t\u0006C\u0005\u0004Z\u0001\t\n\u0011\"\u0001\u00036\"911\f\u0001\u0005\n\ru\u0003bBB6\u0001\u0011%1Q\u000e\u0005\b\u0007O\u0003A\u0011BBU\u0011%\u0019\t\fAI\u0001\n\u0013\u0019\u0019\fC\u0004\u00048\u0002!\tf!/\u0003-\u0011+G.\u001b<fef\u0004\u0016\r\u001e;fe:\u001cVM\u001d<jG\u0016T!!\u000f\u001e\u0002\u000fM,'O^5dK*\u00111\bP\u0001\tI\u0016d\u0017N^3ss*\u0011QHP\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0010!\u0002\u0013a,'-[1mC\n\u001c(\"A!\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001!%\n\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u00172k\u0011\u0001O\u0005\u0003\u001bb\u0012A\u0003R3mSZ,'/_*feZL7-Z+uS2\u001c\u0018A\u00053fY&4XM]=SKB|7/\u001b;pef,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'j\n!B]3q_NLGo\u001c:z\u0013\t)&K\u0001\nEK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\u0018a\u00053fY&4XM]=SKB|7/\u001b;pef\u0004\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\t\u0011\f\u0005\u0002[96\t1L\u0003\u0002Ty%\u0011Ql\u0017\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\naB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001b!\t\u0011G-D\u0001d\u0015\tID(\u0003\u0002fG\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002SB\u0011!M[\u0005\u0003W\u000e\u00141bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u0005\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm]\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!\u000fP\u0001\u0003I\nL!\u0001^9\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!E1sG\"Lg/\u001a3SK2,\u0017m]3tA\u0005iam\u001c7eKJ\u001cVM\u001d<jG\u0016,\u0012\u0001\u001f\t\u0003EfL!A_2\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u000391w\u000e\u001c3feN+'O^5dK\u0002\n1B]8mKN+'O^5dKV\ta\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\tg\u0016\u001cWO]5us*\u0019\u0011q\u0001 \u0002\u0011\u0011,\u0007\u000f\\8zSRLA!a\u0003\u0002\u0002\tY!k\u001c7f'\u0016\u0014h/[2f\u00031\u0011x\u000e\\3TKJ4\u0018nY3!\u0003!)g/\u001a8u\u0005V\u001cXCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\ry\u00051QM^3oiNLA!!\b\u0002\u0018\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u00024\u0005U\u0002CA&\u0001\u0011\u0015q\u0015\u00031\u0001Q\u0011\u00159\u0016\u00031\u0001Z\u0011\u0015y\u0016\u00031\u0001b\u0011\u00159\u0017\u00031\u0001j\u0011\u0015i\u0017\u00031\u0001p\u0011\u00151\u0018\u00031\u0001y\u0011\u0015a\u0018\u00031\u0001\u007f\u0011\u001d\ty!\u0005a\u0001\u0003'A3!EA\u001d!\u0011\tY$!\u0015\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n!\"\u00198o_R\fG/[8o\u0015\u0011\t\u0019%!\u0012\u0002\u000f\u0019\f7\r^8ss*!\u0011qIA%\u0003\u0015\u0011W-\u00198t\u0015\u0011\tY%!\u0014\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!a\u0014\u0002\u0007=\u0014x-\u0003\u0003\u0002T\u0005u\"!C!vi><\u0018N]3e\u0003)9W\r\u001e)biR,'O\u001c\u000b\u0005\u00033\n9\u0007\u0005\u0003\u0002\\\u0005\rTBAA/\u0015\rY\u0014q\f\u0006\u0004\u0003Cb\u0014A\u00023p[\u0006Lg.\u0003\u0003\u0002f\u0005u#\u0001\u0003#fY&4XM]=\t\u000f\u0005%$\u00031\u0001\u0002l\u0005I\u0001/\u0019;uKJt\u0017\n\u001a\t\u0005\u0003[\nYH\u0004\u0003\u0002p\u0005]\u0004cAA9\r6\u0011\u00111\u000f\u0006\u0004\u0003k\u0012\u0015A\u0002\u001fs_>$h(C\u0002\u0002z\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA?\u0003\u007f\u0012aa\u0015;sS:<'bAA=\r\"\u001a!#a!\u0011\t\u0005\u0015\u0015\u0011S\u0007\u0003\u0003\u000fSA!a\u0010\u0002\n*!\u00111RAG\u0003\u001diW\r\u001e:jGNT1!a$A\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAJ\u0003\u000f\u0013Q\u0001V5nK\u0012\fQcZ3u!\u0006$H/\u001a:o\u0005fLEm\u0014:USRdW\r\u0006\u0003\u0002Z\u0005e\u0005bBAN'\u0001\u0007\u00111N\u0001\u0011a\u0006$H/\u001a:o\u0013\u0012|%\u000fV5uY\u0016D3aEAB\u0003Y)\u00070[:ugB\u000bG\u000f^3s]^KG\u000f\u001b+ji2,GCBAR\u0003S\u000bi\u000bE\u0002F\u0003KK1!a*G\u0005\u001d\u0011un\u001c7fC:Dq!a+\u0015\u0001\u0004\tY'\u0001\u0002jI\"9\u0011q\u0016\u000bA\u0002\u0005-\u0014!\u0002;ji2,\u0007f\u0001\u000b\u0002\u0004\u0006iQ\r_5tiN\u0004\u0016\r\u001e;fe:$B!a)\u00028\"9\u0011\u0011X\u000bA\u0002\u0005-\u0014A\u00033fY&4XM]=JI\"\u001aQ#a!\u0002+\r\u0014X-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]R!\u0011\u0011LAa\u0011\u001d\t\u0019M\u0006a\u0001\u00033\nq\u0001]1ui\u0016\u0014h\u000eK\u0002\u0017\u0003\u0007\u000bQ#\u001e9eCR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002Z\u0005-\u0007bBAg/\u0001\u0007\u0011\u0011L\u0001\bkB$\u0017\r^3eQ\r9\u00121Q\u0001\u0016I\u0016dW\r^3EK2Lg/\u001a:z!\u0006$H/\u001a:o)\u0011\t).a7\u0011\u0007\u0015\u000b9.C\u0002\u0002Z\u001a\u0013A!\u00168ji\"9\u0011\u0011\u000e\rA\u0002\u0005-\u0004f\u0001\r\u0002\u0004\u0006AB-\u001e9mS\u000e\fG/\u001a#fY&4XM]=QCR$XM\u001d8\u0015\r\u0005e\u00131]As\u0011\u001d\tI'\u0007a\u0001\u0003WBq!a:\u001a\u0001\u0004\tI/\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003W\fI0\u0004\u0002\u0002n*!\u0011q^Ay\u0003\u00151wN]7t\u0015\u0011\t\u00190!>\u0002\u0005Y\f$bAA|y\u0005\u0019\u0011\r]5\n\t\u0005m\u0018Q\u001e\u0002\u0019\tV\u0004H.[2bi\u0016$U\r\\5wKJL\b+\u0019;uKJt\u0007fA\r\u0002\u0004\u0006I2M]3bi\u0016$U\r\\5wKJLhI]8n!\u0006$H/\u001a:o)\u0019\tIFa\u0001\u0003\u0006!9\u0011\u0011\u000e\u000eA\u0002\u0005-\u0004b\u0002B\u00045\u0001\u0007!\u0011B\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003BAv\u0005\u0017IAA!\u0004\u0002n\nq1I]3bi\u0016$U\r\\5wKJL\bf\u0001\u000e\u0002\u0004\u0006q1/Z1sG\"\u0004\u0016\r\u001e;fe:\u001cHC\u0002B\u000b\u0005K\u0011y\u0003\u0005\u0004\u0003\u0018\t\u0005\u0012\u0011L\u0007\u0003\u00053QAAa\u0007\u0003\u001e\u0005!Q\u000f^5m\u0015\t\u0011y\"\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0012\u00053\u0011A\u0001T5ti\"9!qE\u000eA\u0002\t%\u0012a\u00024jYR,'o\u001d\t\u0005\u0003W\u0014Y#\u0003\u0003\u0003.\u00055(A\u0006#fY&4XM]=QCR$XM\u001d8GS2$XM]:\t\u000f\tE2\u00041\u0001\u00034\u0005!\u0001/Y4f!\rQ&QG\u0005\u0004\u0005oY&\u0001\u0002)bO\u0016D3aGAB\u0003%9W\r^*uC\u001e,7\u000f\u0006\u0003\u0003@\t\u001d\u0003C\u0002B\f\u0005C\u0011\t\u0005\u0005\u0003\u0002\\\t\r\u0013\u0002\u0002B#\u0003;\u0012Qa\u0015;bO\u0016Dq!!\u001b\u001d\u0001\u0004\tY\u0007K\u0002\u001d\u0003\u0007\u000b\u0001\"\u00193e'R\fw-\u001a\u000b\t\u0005\u0003\u0012yE!\u0015\u0003V!9\u0011\u0011N\u000fA\u0002\u0005-\u0004b\u0002B*;\u0001\u0007!\u0011I\u0001\u0006gR\fw-\u001a\u0005\n\u0005/j\u0002\u0013!a\u0001\u00053\n\u0001\u0002]8tSRLwN\u001c\t\u0007\u0005/\u0011YFa\u0018\n\t\tu#\u0011\u0004\u0002\t\u001fB$\u0018n\u001c8bYB!!\u0011\rB4\u001b\t\u0011\u0019G\u0003\u0003\u0003f\tu\u0011\u0001\u00027b]\u001eLAA!\u001b\u0003d\t9\u0011J\u001c;fO\u0016\u0014\bfA\u000f\u0002\u0004\u0006\u0011\u0012\r\u001a3Ti\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tH\u000b\u0003\u0003Z\tM4F\u0001B;!\u0011\u00119Ha \u000e\u0005\te$\u0002\u0002B>\u0005{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}b)\u0003\u0003\u0003\u0002\ne$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001a3Ti\u0006<WMQ3uo\u0016,g\u000e\u0006\u0006\u0003B\t\u001d%\u0011\u0012BF\u0005+Cq!!\u001b \u0001\u0004\tY\u0007C\u0004\u0003T}\u0001\rA!\u0011\t\u000f\t5u\u00041\u0001\u0003\u0010\u00061!-\u001a4pe\u0016\u0004R!\u0012BI\u0003WJ1Aa%G\u0005\u0019y\u0005\u000f^5p]\"9!qS\u0010A\u0002\t=\u0015!B1gi\u0016\u0014\bfA\u0010\u0002\u0004RA!\u0011\tBO\u0005?\u0013\t\u000bC\u0004\u0002D\u0002\u0002\r!!\u0017\t\u000f\tM\u0003\u00051\u0001\u0003B!9!q\u000b\u0011A\u0002\te\u0003f\u0001\u0011\u0002\u0004\u0006YQ\u000f\u001d3bi\u0016\u001cF/Y4f)!\u0011\tE!+\u0003,\n5\u0006bBA5C\u0001\u0007\u00111\u000e\u0005\b\u0003\u001b\f\u0003\u0019\u0001B!\u0011%\u0011y+\tI\u0001\u0002\u0004\t\u0019+A\u0005ge>l')\u0019;dQ\"\u001a\u0011%a!\u0002+U\u0004H-\u0019;f'R\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0017\u0016\u0005\u0003G\u0013\u0019(A\u0006eK2,G/Z*uC\u001e,GCBAk\u0005{\u0013y\fC\u0004\u0002j\r\u0002\r!a\u001b\t\u000f\t\u00057\u00051\u0001\u0002l\u000591\u000f^1hK&#\u0007fA\u0012\u0002\u0004\u0006i\u0011\r\u001a3Ue\u0006t7/\u001b;j_:$\u0002B!3\u0003P\nE'Q\u001b\t\u0005\u00037\u0012Y-\u0003\u0003\u0003N\u0006u#A\u0003+sC:\u001c\u0018\u000e^5p]\"9\u0011\u0011\u000e\u0013A\u0002\u0005-\u0004b\u0002BjI\u0001\u0007\u00111N\u0001\u000fgR\fw-Z%e\u001fJ$\u0016\u000e\u001e7f\u0011\u001d\u00119\u000e\na\u0001\u0005\u0013\f!\u0002\u001e:b]NLG/[8oQ\r!\u00131\u0011\u000b\t\u0005\u0013\u0014iNa8\u0003b\"9\u00111Y\u0013A\u0002\u0005e\u0003b\u0002BjK\u0001\u0007\u00111\u000e\u0005\b\u0005/,\u0003\u0019\u0001BeQ\r)\u00131Q\u0001\u0011kB$\u0017\r^3Ue\u0006t7/\u001b;j_:$bA!3\u0003j\n-\bbBA5M\u0001\u0007\u00111\u000e\u0005\b\u0003\u001b4\u0003\u0019\u0001BeQ\r1\u00131\u0011\u000b\u0007\u0005\u0013\u0014\tPa=\t\u000f\u0005\rw\u00051\u0001\u0002Z!9\u0011QZ\u0014A\u0002\t%\u0007fA\u0014\u0002\u0004\u0006\u0001B-\u001a7fi\u0016$&/\u00198tSRLwN\u001c\u000b\u0007\u0003+\u0014YP!@\t\u000f\u0005%\u0004\u00061\u0001\u0002l!9!q \u0015A\u0002\u0005-\u0014\u0001\u0004;sC:\u001c\u0018\u000e^5p]&#\u0007f\u0001\u0015\u0002\u0004\u0006Ar-\u001a8fe\u0006$X\rV5uY\u0016LeMT3dKN\u001c\u0018M]=\u0015\r\u0005U7qAB\u0005\u0011\u001d\u0011\u0019&\u000ba\u0001\u0005\u0003Bqaa\u0003*\u0001\u0004\u0019i!\u0001\u0004ti\u0006<Wm\u001d\t\u0007\u0007\u001f\u0019IB!\u0011\u000f\t\rE1Q\u0003\b\u0005\u0003c\u001a\u0019\"C\u0001H\u0013\r\u00199BR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019Yb!\b\u0003\u0007M+\u0017OC\u0002\u0004\u0018\u0019\u000bab\u00195fG.L5\u000fU1ui\u0016\u0014h\u000e\u0006\u0003\u0002V\u000e\r\u0002BB\u001e+\u0001\u0004\tI&A\bwC2LG-\u0019;f!\u0006$H/\u001a:o)\u0011\t)n!\u000b\t\rmZ\u0003\u0019AA-)\u0019\t)n!\f\u00040!11\b\fa\u0001\u00033Bqa!\r-\u0001\u0004\t\u0019+A\u0006xSRD\u0017+^3sS\u0016\u001c\u0018\u0001\n<bY&$\u0017\r^3Ti\u0006<Wm]!oIR\u0013\u0018M\\:ji&|gn]!oI&#X-\\:\u0015\t\u0005U7q\u0007\u0005\b\u0003\u0007l\u0003\u0019AA-\u0003A1\u0018\r\\5eCR,g*Z<Ti\u0006<W\r\u0006\u0005\u0002V\u000eu2qHB!\u0011\u001d\u0019YA\fa\u0001\u0007\u001bAqAa\u0015/\u0001\u0004\u0011\t\u0005C\u0004\u0003X9\u0002\raa\u0011\u0011\u0007\u0015\u001b)%C\u0002\u0004H\u0019\u00131!\u00138u\u0003]1\u0018\r\\5eCR,7\u000b^1hKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002V\u000e5\u0003b\u0002B*_\u0001\u0007!\u0011I\u0001\re\u0016\u001cX\r\u001e)biR,'O\u001c\u000b\u0007\u0003+\u001c\u0019f!\u0016\t\u000f\u0005\r\u0007\u00071\u0001\u0002Z!I1q\u000b\u0019\u0011\u0002\u0003\u0007\u00111U\u0001\fM>\u00148-\u001a(fo&#7/\u0001\fsKN,G\u000fU1ui\u0016\u0014h\u000e\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0011Xm]3u\u0007>tG-\u001b;j_:$b!!6\u0004`\r\u0005\u0004b\u0002Ble\u0001\u0007!\u0011\u001a\u0005\b\u0007G\u0012\u0004\u0019AB3\u0003%\u0019wN\u001c3ji&|g\u000e\u0005\u0003\u0002\\\r\u001d\u0014\u0002BB5\u0003;\u0012\u0011bQ8oI&$\u0018n\u001c8\u0002%\u001d,g.\u001a:bi\u0016|%/\u00169eCR,\u0017\nZ\u000b\u0005\u0007_\u001a9\t\u0006\u0006\u0004r\re5QTBQ\u0007K#B!a\u001b\u0004t!I1QO\u001a\u0002\u0002\u0003\u000f1qO\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBB=\u0007\u007f\u001a\u0019)\u0004\u0002\u0004|)\u00191Q\u0010$\u0002\u000fI,g\r\\3di&!1\u0011QB>\u0005!\u0019E.Y:t)\u0006<\u0007\u0003BBC\u0007\u000fc\u0001\u0001B\u0004\u0004\nN\u0012\raa#\u0003\u0003Q\u000bBa!$\u0004\u0014B\u0019Qia$\n\u0007\rEeIA\u0004O_RD\u0017N\\4\u0011\u0007\u0015\u001b)*C\u0002\u0004\u0018\u001a\u00131!\u00118z\u0011\u001d\u0019Yj\ra\u0001\u0003W\n!\"\u001a=jgRLgnZ%e\u0011\u001d\u0019yj\ra\u0001\u0003W\n1b\u001c7e!\u0006\u0014XM\u001c;JI\"911U\u001aA\u0002\u0005-\u0014a\u00038foB\u000b'/\u001a8u\u0013\u0012Dqaa\u00164\u0001\u0004\t\u0019+\u0001\u000bbYJ,\u0017\rZ=Fq&\u001cHo\u001d\"z)&$H.\u001a\u000b\u0007\u0003G\u001bYka,\t\u000f\r5F\u00071\u0001\u0002l\u0005a\u0001/\u0019;uKJtG+\u001b;mK\"I\u0011\u0011\u000e\u001b\u0011\u0002\u0003\u0007\u00111N\u0001\u001fC2\u0014X-\u00193z\u000bbL7\u000f^:CsRKG\u000f\\3%I\u00164\u0017-\u001e7uII*\"a!.+\t\u0005-$1O\u0001\u0011G\",7m[%t+B$\u0017\r^1cY\u0016$b!!6\u0004<\u000e}\u0006bBB_m\u0001\u0007\u0011\u0011L\u0001\u0011KbL7\u000f^5oO\u0012+G.\u001b<fefD\u0011b!17!\u0003\u0005\r!a\u001b\u0002\r\u0005\u001cG/[8oQ\r\u00011Q\u0019\t\u0005\u0007\u000f\u001ci-\u0004\u0002\u0004J*!11ZA%\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007\u001f\u001cIMA\u0004TKJ4\u0018nY3")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validate(Delivery delivery, boolean withQueries) {
        DeliveryServiceUtils.validate$(this, delivery, withQueries);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)pattern, (String)"Release delivery");
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append(pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetPattern(pattern, this.resetPattern$default$2());
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append(updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$"));
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])c))).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1)));
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(Integer.toString(++orderNumber)).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        if (parameters.getFolderId() != null) {
            delivery.setFolderId(parameters.getFolderId());
        }
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.deliveryRepository().search((AbstractDeliveryFilters)filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (scala.collection.immutable.Seq<Permission>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Optional<Integer> position) {
        return this.addStage(this.getPattern(patternId), stage, position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Timed
    public Stage addStageBetween(String patternId, Stage stage, Option<String> before, Option<String> after) {
        Stage stage2;
        Delivery pattern = this.getPattern(patternId);
        Option beforeIndex = before.map(DeliveryPatternService.getStageIndex$1(pattern));
        Option afterIndex = after.map(DeliveryPatternService.getStageIndex$1(pattern));
        if (before.isDefined()) {
            if (after.isDefined()) {
                if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != BoxesRunTime.unboxToInt((Object)beforeIndex.get()) - 1) throw new LogFriendlyConcurrentModificationException("Unable to add stage between %s and %s, because these two stages are not neighbors any more", new Object[]{after.get(), before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)beforeIndex.get()))));
                return stage2;
            } else {
                if (BoxesRunTime.unboxToInt((Object)beforeIndex.get()) != 0) throw new LogFriendlyConcurrentModificationException("Unable to add first stage before %s, because it is not first stage of delivery pattern any more", new Object[]{before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(0)));
            }
            return stage2;
        } else if (after.isDefined()) {
            if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != pattern.getStages().size() - 1) throw new LogFriendlyConcurrentModificationException("Unable to add last stage after %s, because it is not last stage of the delivery pattern any more", new Object[]{after.get()});
            stage2 = this.addStage(pattern, stage, Optional.empty());
            return stage2;
        } else {
            if (!pattern.getStages().isEmpty()) throw new LogFriendlyConcurrentModificationException("Unable to add first stage to the pattern, because pattern is not empty any more", new Object[0]);
            stage2 = this.addStage(pattern, stage, Optional.empty());
        }
        return stage2;
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage, Optional<Integer> position) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Adding new stage '").append(stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        this.generateTitleIfNecessary(stage, (scala.collection.immutable.Seq<Stage>)stages);
        Integer realPosition = position.orElse(Predef$.MODULE$.int2Integer(stages.size()));
        this.validateStageProperties(stage);
        this.validateNewStage((scala.collection.immutable.Seq<Stage>)stages, stage, Predef$.MODULE$.Integer2int(realPosition));
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, Predef$.MODULE$.Integer2int(realPosition));
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    public Optional<Integer> addStage$default$3() {
        return Optional.empty();
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated, boolean fromBatch) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(31).append("Updating stage '").append(updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStageProperties(updated);
        scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().toSeq();
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        if (!fromBatch) {
            this.validateNewStage((scala.collection.immutable.Seq<Stage>)((scala.collection.immutable.Seq)stages.diff((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Stage[]{original})))), updated, stages.indexOf((Object)original));
        }
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    public boolean updateStage$default$3() {
        return false;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Adding new transition '").append(transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        if (stage.getTransition() != null) {
            throw new LogFriendlyConcurrentModificationException("There is already a transition named '%s' associated with stage '%s'", new Object[]{stage.getTransition().getTitle(), stage.getTitle()});
        }
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)x$2));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Updating transition '").append(updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)updated, (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)x$3));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, scala.collection.immutable.Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)stage, (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    public void validatePattern(Delivery delivery) {
        this.validatePattern(delivery, true);
    }

    public void validatePattern(Delivery delivery, boolean withQueries) {
        block0: {
            this.validate(delivery, withQueries);
            this.checkIsPattern(delivery);
            Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
            if (!withQueries) break block0;
            Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
        }
    }

    public void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties((Stage)stage);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getStages()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTitle());
        Buffer duplicateStages = (Buffer)((SeqOps)stageTitles.diff((Seq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pattern.getTrackedItems()).asScala().map((Function1 & Serializable)x$6 -> x$6.getTitle().toLowerCase());
        Buffer duplicateItems = (Buffer)((SeqOps)trackedItemTitles.diff((Seq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(scala.collection.immutable.Seq<Stage> stages, Stage stage, int position) {
        Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        Checks.checkArgument((!stages.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Stage stage) {
        Checks.checkNotNull((Object)stage, (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    public void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    public boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds((AbstractDeliveryFilters)filters).exists((Function1 & Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$addStageBetween$2(String folderlessId$1, Tuple2 t) {
        return Ids.getName((String)((BaseConfigurationItem)t._1()).getId()).equals(folderlessId$1);
    }

    public static final /* synthetic */ int $anonfun$addStageBetween$1(Delivery pattern$2, String id) {
        String folderlessId = Ids.getName((String)id);
        return ((Tuple2)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(pattern$2.getStages()).asScala().zipWithIndex()).find((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$addStageBetween$2(folderlessId, t))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyConcurrentModificationException("Stage %s not found", new Object[]{id});
        }))._2$mcI$sp();
    }

    private static final Function1 getStageIndex$1(Delivery pattern$2) {
        return (Function1 & Serializable)id -> BoxesRunTime.boxToInteger((int)DeliveryPatternService.$anonfun$addStageBetween$1(pattern$2, id));
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
        Statics.releaseFence();
    }
}

