/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryDeletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tMaaB\u000f\u001f!\u0003\r\t!\u000b\u0005\u0006q\u0001!\t!\u000f\u0005\b{\u0001\u0011\rQ\"\u0001?\u0011\u001d)\u0005A1A\u0007\u0002\u0019Cq!\u0014\u0001C\u0002\u001b\u0005a\nC\u0004U\u0001\t\u0007i\u0011A+\t\u000fq\u0003!\u0019!D\u0001;\"9\u0011\r\u0001b\u0001\u000e\u0003\u0011\u0007bB6\u0001\u0005\u00045\t\u0001\u001c\u0005\ba\u0002\u0011\r\u0011\"\u0005r\u0011\u0015A\bA\"\u0005z\u0011%\t\t\u0003AI\u0001\n#\t\u0019\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011Q\f\u0001\u0005\u0012\u0005}\u0003bBA3\u0001\u0011E\u0011q\r\u0005\b\u0003W\u0002A\u0011CA7\u0011\u001d\t\t\b\u0001C\t\u0003gBq!a\u001e\u0001\t#\tI\bC\u0004\u0002\u0012\u0002!\t\"a%\t\u000f\u0005]\u0005\u0001\"\u0005\u0002\u001a\"9\u0011Q\u0016\u0001\u0005\u0012\u0005=\u0006bBAa\u0001\u0011E\u00111\u0019\u0005\n\u0003O\u0004\u0011\u0013!C\t\u0003SD\u0011\"!<\u0001#\u0003%\t\"a<\t\u0013\u0005M\b!%A\u0005\u0012\u0005=\bbBA{\u0001\u0011%\u0011q\u001f\u0005\n\u0005\u000b\u0001\u0011\u0013!C\u0005\u0003SDqAa\u0002\u0001\t\u0013\u0011IA\u0001\u000bEK2Lg/\u001a:z'\u0016\u0014h/[2f+RLGn\u001d\u0006\u0003?\u0001\nqa]3sm&\u001cWM\u0003\u0002\"E\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u0002$I\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003K\u0019\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u001d\n1aY8n\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0006g24GG\u001b\u0006\u0002k\u0005AqM]5{u2,G-\u0003\u00028e\t9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001;!\tY3(\u0003\u0002=Y\t!QK\\5u\u0003I!W\r\\5wKJL(+\u001a9pg&$xN]=\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002E\u0003\n\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001cX#A$\u0011\u0005![U\"A%\u000b\u0005)\u0013\u0013AB3wK:$8/\u0003\u0002M\u0013\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\u001dI,G.Z1tKN+'O^5dKV\tq\n\u0005\u0002Q%6\t\u0011K\u0003\u0002 E%\u00111+\u0015\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003A\t'o\u00195jm\u0016$'+\u001a7fCN,7/F\u0001W!\t9&,D\u0001Y\u0015\tI&%\u0001\u0002eE&\u00111\f\u0017\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\fQBZ8mI\u0016\u00148+\u001a:wS\u000e,W#\u00010\u0011\u0005A{\u0016B\u00011R\u000551u\u000e\u001c3feN+'O^5dK\u0006Y!o\u001c7f'\u0016\u0014h/[2f+\u0005\u0019\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003!\u0019XmY;sSRL(B\u00015%\u0003!!W\r\u001d7ps&$\u0018B\u00016f\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002[B\u0011\u0001K\\\u0005\u0003_F\u00131bQ5JIN+'O^5dK\u00069a-Y2u_JLX#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u0004\u0013\u0001B;uS2L!a\u001e;\u0003+\u0011+G.\u001b<fef|%M[3di\u001a\u000b7\r^8ss\u0006\u00012\r[3dW&\u001bX\u000b\u001d3bi\u0006\u0014G.\u001a\u000b\u0005ui\f9\u0001C\u0003|\u0015\u0001\u0007A0\u0001\tfq&\u001cH/\u001b8h\t\u0016d\u0017N^3ssB\u0019Q0a\u0001\u000e\u0003yT!!I@\u000b\u0007\u0005\u0005!%\u0001\u0004e_6\f\u0017N\\\u0005\u0004\u0003\u000bq(\u0001\u0003#fY&4XM]=\t\u0013\u0005%!\u0002%AA\u0002\u0005-\u0011AB1di&|g\u000e\u0005\u0003\u0002\u000e\u0005ma\u0002BA\b\u0003/\u00012!!\u0005-\u001b\t\t\u0019BC\u0002\u0002\u0016!\na\u0001\u0010:p_Rt\u0014bAA\rY\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007-\u0003i\u0019\u0007.Z2l\u0013N,\u0006\u000fZ1uC\ndW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t)C\u000b\u0003\u0002\f\u0005\u001d2FAA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005MB&\u0001\u0006b]:|G/\u0019;j_:LA!a\u000e\u0002.\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)\u001d,G\u000fR3mSZ,'/_(s!\u0006$H/\u001a:o)\ra\u0018Q\b\u0005\b\u0003\u007fa\u0001\u0019AA\u0006\u0003)!W\r\\5wKJL\u0018\n\u001a\u0015\u0004\u0019\u0005\r\u0003\u0003BA#\u0003#j!!a\u0012\u000b\t\u0005M\u0012\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005=c%\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t\u0019&a\u0012\u0003\u000bQKW.\u001a3\u0002\u0017\u001d,GOR8mI\u0016\u0014\u0018\n\u001a\u000b\u0005\u0003\u0017\tI\u0006C\u0004\u0002@5\u0001\r!a\u0003)\u00075\t\u0019%\u0001\u0005e_V\u0003H-\u0019;f)\ra\u0018\u0011\r\u0005\u0007\u0003Gr\u0001\u0019\u0001?\u0002\u000fU\u0004H-\u0019;fI\u0006AAm\u001c#fY\u0016$X\rF\u0002;\u0003SBq!a\u0010\u0010\u0001\u0004\tY!\u0001\u0005wC2LG-\u0019;f)\rQ\u0014q\u000e\u0005\u0006CA\u0001\r\u0001`\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012+G.\u001b<fef$2AOA;\u0011\u0015\t\u0013\u00031\u0001}\u0003I1\u0018\r\\5eCR,GK]1og&$\u0018n\u001c8\u0015\u000fi\nY(! \u0002\b\")\u0011E\u0005a\u0001y\"9\u0011q\u0010\nA\u0002\u0005\u0005\u0015!B:uC\u001e,\u0007cA?\u0002\u0004&\u0019\u0011Q\u0011@\u0003\u000bM#\u0018mZ3\t\u000f\u0005%%\u00031\u0001\u0002\f\u0006QAO]1og&$\u0018n\u001c8\u0011\u0007u\fi)C\u0002\u0002\u0010z\u0014!\u0002\u0016:b]NLG/[8o\u0003=\u0019\u0007.Z2l\u0013N$U\r\\5wKJLHc\u0001\u001e\u0002\u0016\")\u0011e\u0005a\u0001y\u0006\t2-\u001e:sK:$\bK]5oG&\u0004\u0018\r\\:\u0016\u0005\u0005m\u0005CBAO\u0003O\u000bYA\u0004\u0003\u0002 \u0006\rf\u0002BA\t\u0003CK\u0011!L\u0005\u0004\u0003Kc\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003S\u000bYK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t)\u000bL\u0001\u000fGV\u0014(/\u001a8u%>dW-\u00133t+\t\t\t\f\u0005\u0004\u00024\u0006u\u00161B\u0007\u0003\u0003kSA!a.\u0002:\u00069Q.\u001e;bE2,'bAA^Y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0016Q\u0017\u0002\u0007\u0005V4g-\u001a:\u0002+\r|W\u000e];uK\u0006sG-\u00169eCR,G)\u0019;fgRI!(!2\u0002H\u0006E\u00171\u001d\u0005\u0006CY\u0001\r\u0001 \u0005\n\u0003\u00134\u0002\u0013!a\u0001\u0003\u0017\f1\u0002Z;sCRLwN\\(qiB\u00191&!4\n\u0007\u0005=GFA\u0002J]RD\u0011\"a5\u0017!\u0003\u0005\r!!6\u0002\u0019M$\u0018M\u001d;ECR,w\n\u001d;\u0011\t\u0005]\u0017q\\\u0007\u0003\u00033T1!^An\u0015\t\ti.\u0001\u0003kCZ\f\u0017\u0002BAq\u00033\u0014A\u0001R1uK\"I\u0011Q\u001d\f\u0011\u0002\u0003\u0007\u0011Q[\u0001\u000bK:$G)\u0019;f\u001fB$\u0018aH2p[B,H/Z!oIV\u0003H-\u0019;f\t\u0006$Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001e\u0016\u0005\u0003\u0017\f9#A\u0010d_6\u0004X\u000f^3B]\u0012,\u0006\u000fZ1uK\u0012\u000bG/Z:%I\u00164\u0017-\u001e7uIM*\"!!=+\t\u0005U\u0017qE\u0001 G>l\u0007/\u001e;f\u0003:$W\u000b\u001d3bi\u0016$\u0015\r^3tI\u0011,g-Y;mi\u0012\"\u0014AE2bY\u000e,H.\u0019;f\u001fRDWM\u001d#bi\u0016$\u0002\"!6\u0002z\u0006u(\u0011\u0001\u0005\b\u0003wT\u0002\u0019AAk\u0003\u0011!\u0017\r^3\t\u000f\u0005}(\u00041\u0001\u0002L\u0006AA-\u001e:bi&|g\u000eC\u0005\u0003\u0004i\u0001\n\u00111\u0001\u0002L\u0006A\u0011\r\u001a3ji&|g.\u0001\u000fdC2\u001cW\u000f\\1uK>#\b.\u001a:ECR,G\u0005Z3gCVdG\u000fJ\u001a\u0002#\r\fGnY;mCR,G)\u001e:bi&|g\u000e\u0006\u0004\u0002L\n-!q\u0002\u0005\b\u0005\u001ba\u0002\u0019AAk\u0003%\u0019H/\u0019:u\t\u0006$X\rC\u0004\u0003\u0012q\u0001\r!!6\u0002\u000f\u0015tG\rR1uK\u0002")
public interface DeliveryServiceUtils
extends Logging {
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory var1);

    public DeliveryRepository deliveryRepository();

    public XLReleaseEventBus eventBus();

    public ReleaseService releaseService();

    public ArchivedReleases archivedReleases();

    public FolderService folderService();

    public RoleService roleService();

    public CiIdService ciIdService();

    public DeliveryObjectFactory factory();

    public void checkIsUpdatable(Delivery var1, String var2);

    public static /* synthetic */ String checkIsUpdatable$default$2$(DeliveryServiceUtils $this) {
        return $this.checkIsUpdatable$default$2();
    }

    default public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static /* synthetic */ Delivery getDeliveryOrPattern$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getDeliveryOrPattern(deliveryId);
    }

    @Timed
    default public Delivery getDeliveryOrPattern(String deliveryId) {
        return this.deliveryRepository().read(deliveryId);
    }

    public static /* synthetic */ String getFolderId$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getFolderId(deliveryId);
    }

    @Timed
    default public String getFolderId(String deliveryId) {
        return this.deliveryRepository().findFolderId(deliveryId);
    }

    public static /* synthetic */ Delivery doUpdate$(DeliveryServiceUtils $this, Delivery updated) {
        return $this.doUpdate(updated);
    }

    /*
     * WARNING - void declaration
     */
    default public Delivery doUpdate(Delivery updated) {
        void var2_2;
        Delivery original = this.deliveryRepository().read(updated.getId());
        this.checkIsUpdatable(original, this.checkIsUpdatable$default$2());
        original.setTitle(updated.getTitle());
        original.setDescription(updated.getDescription());
        this.computeAndUpdateDates(original, Predef$.MODULE$.Integer2int(updated.getPlannedDuration()), updated.getStartDate(), updated.getEndDate());
        if (Strings.isNotBlank((String)updated.getFolderId())) {
            original.setFolderId(updated.getFolderId());
        }
        this.deliveryRepository().update(original);
        this.eventBus().publish((XLReleaseEvent)new DeliveryUpdatedEvent(original));
        return var2_2;
    }

    public static /* synthetic */ void doDelete$(DeliveryServiceUtils $this, String deliveryId) {
        $this.doDelete(deliveryId);
    }

    default public void doDelete(String deliveryId) {
        if (this.deliveryRepository().exists(deliveryId)) {
            Delivery delivery = this.deliveryRepository().read(deliveryId);
            this.checkIsUpdatable(delivery, "delete");
            this.deliveryRepository().delete(deliveryId);
            this.eventBus().publish((XLReleaseEvent)new DeliveryDeletedEvent(delivery));
        } else {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(35).append("Release delivery [").append(deliveryId).append("] already deleted").toString());
        }
    }

    public static /* synthetic */ void validate$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validate(delivery);
    }

    default public void validate(Delivery delivery) {
        block0: {
            Checks.checkNotNull((Object)delivery, (String)"Release delivery");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            Checks.checkArgument((delivery.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
            Checks.checkArgument((!delivery.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
            Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
            Checks.checkArgument((!Ids.isRoot((String)delivery.getFolderId()) ? 1 : 0) != 0, (String)new StringBuilder(47).append("Provided folder ID '").append(delivery.getFolderId()).append("' must not be a root folder").toString(), (Object[])new Object[0]);
            Checks.checkArgument((boolean)this.folderService().exists(delivery.getFolderId()), (String)new StringBuilder(48).append("Provided folder ID '").append(delivery.getFolderId()).append("' must exist in the database").toString(), (Object[])new Object[0]);
            if (!Strings.isNotEmpty((String)delivery.getDescription())) break block0;
            Checks.checkArgument((delivery.getDescription().length() < 1024 ? 1 : 0) != 0, (String)"Description must be 1024 characters or less", (Object[])new Object[0]);
        }
    }

    public static /* synthetic */ void validateDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validateDelivery(delivery);
    }

    default public void validateDelivery(Delivery delivery) {
        this.validate(delivery);
        this.checkIsDelivery(delivery);
        Checks.checkArgument((delivery.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((delivery.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)delivery.getEndDate().after(delivery.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
    }

    public static /* synthetic */ void validateTransition$(DeliveryServiceUtils $this, Delivery delivery, Stage stage, Transition transition) {
        $this.validateTransition(delivery, stage, transition);
    }

    default public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        Checks.checkNotNull((Object)transition, (String)"Transition");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)transition.getTitle()), (String)"Transition title must be set", (Object[])new Object[0]);
        Checks.checkArgument((transition.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Transition title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!transition.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkArgument((!delivery.isLastStage(stage) ? 1 : 0) != 0, (String)"Transition can not be added to the last stage", (Object[])new Object[0]);
        CollectionConverters$.MODULE$.ListHasAsScala(transition.getAllConditions()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.validate(delivery);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void checkIsDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.checkIsDelivery(delivery);
    }

    default public void checkIsDelivery(Delivery delivery) {
        Checks.checkArgument((!delivery.isTemplate() ? 1 : 0) != 0, (String)new StringBuilder(19).append(delivery.getId()).append(" must be a Delivery").toString(), (Object[])new Object[0]);
    }

    public static /* synthetic */ Iterable currentPrincipals$(DeliveryServiceUtils $this) {
        return $this.currentPrincipals();
    }

    default public Iterable<String> currentPrincipals() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    public static /* synthetic */ Buffer currentRoleIds$(DeliveryServiceUtils $this) {
        return $this.currentRoleIds();
    }

    default public Buffer<String> currentRoleIds() {
        return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$2 -> x$2.getId());
    }

    public static /* synthetic */ void computeAndUpdateDates$(DeliveryServiceUtils $this, Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        $this.computeAndUpdateDates(delivery, durationOpt, startDateOpt, endDateOpt);
    }

    default public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        Function1 & Serializable isNotEmptyDate = (Function1 & Serializable)date -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$1(date));
        int plannedDuration = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)durationOpt)).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 > 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(delivery.getPlannedDuration())));
        if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt)) && BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.calculateDuration(startDateOpt, endDateOpt)), (Object)startDateOpt, (Object)endDateOpt);
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDateOpt, (Object)this.calculateOtherDate(startDateOpt, plannedDuration, this.calculateOtherDate$default$3()));
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)this.calculateOtherDate(endDateOpt, plannedDuration, -1), (Object)endDateOpt);
        } else {
            Date startDate = Date.from(Instant.now());
            tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDate, (Object)this.calculateOtherDate(startDate, plannedDuration, this.calculateOtherDate$default$3()));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int duration = BoxesRunTime.unboxToInt((Object)tuple3._1());
        Date startDate = (Date)tuple3._2();
        Date endDate = (Date)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)duration), (Object)startDate, (Object)endDate);
        Tuple3 tuple34 = tuple33;
        int duration2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        Date startDate2 = (Date)tuple34._2();
        Date endDate2 = (Date)tuple34._3();
        delivery.setPlannedDuration(Predef$.MODULE$.int2Integer(duration2));
        delivery.setStartDate(startDate2);
        delivery.setEndDate(endDate2);
    }

    public static /* synthetic */ int computeAndUpdateDates$default$2$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$2();
    }

    default public int computeAndUpdateDates$default$2() {
        return 0;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$3$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$3();
    }

    default public Date computeAndUpdateDates$default$3() {
        return null;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$4$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$4();
    }

    default public Date computeAndUpdateDates$default$4() {
        return null;
    }

    private Date calculateOtherDate(Date date, int duration, int addition) {
        return duration > 0 ? DateUtils.addHours((Date)date, (int)(duration * addition)) : DateUtils.addMonths((Date)date, (int)(1 * addition));
    }

    private int calculateOtherDate$default$3() {
        return 1;
    }

    private int calculateDuration(Date startDate, Date endDate) {
        LocalDateTime localScheduledStartDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(startDate.getTime()), ZoneId.systemDefault());
        LocalDateTime localDueDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(endDate.getTime()), ZoneId.systemDefault());
        return (int)localScheduledStartDate.until(localDueDate, ChronoUnit.HOURS);
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$2(Date x$3) {
        return x$3.getTime() != 0L;
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$1(Date date) {
        return Option$.MODULE$.apply((Object)date).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$2(x$3)));
    }

    public static void $init$(DeliveryServiceUtils $this) {
        $this.com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(new DeliveryObjectFactory($this.ciIdService()));
    }
}

