/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0005\t\rf\u0001\u0002\u0010 \u00011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!b\u0001\n\u0007q\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011a\u0003!Q1A\u0005\u0004eC\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\te\u0002\u0011)\u0019!C\u0001g\"AA\u0010\u0001B\u0001B\u0003%A\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!!'\u0001\t\u0003\nY\nC\u0004\u0002|\u0002!\t%!@\t\u000f\t\u0015\u0001\u0001\"\u0011\u0003\b!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u0010\u0001\u0011\u0005#\u0011\u0005\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000fBqA!\u0015\u0001\t\u0003\u0012\u0019\u0006C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!\u0011\u000f\u0001\u0005\n\tM\u0004b\u0002BB\u0001\u0011\u0005#Q\u0011\u0002\u0016'FdG)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002%K\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u0002'O\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003Q%\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003)\n1aY8n\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'N\u0007\u0002C%\u0011a'\t\u0002\u0013\t\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180A\neK2Lg/\u001a:z!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002:y5\t!H\u0003\u0002<?\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\ti$HA\nEK2Lg/\u001a:z!\u0016\u00148/[:uK:\u001cW-A\reK2Lg/\u001a:z\u001b\u0016l'-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA\u001dA\u0013\t\t%HA\rEK2Lg/\u001a:z\u001b\u0016l'-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0006;sC\u000e\\W\rZ%uK6\u0004VM]:jgR,gnY3\u0011\u0005e\"\u0015BA#;\u0005Y!&/Y2lK\u0012LE/Z7QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001F:rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002!\u0015*\u0011!%J\u0005\u0003\u0019&\u0013AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ,\u0012a\u0014\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000b\u0001b]3dkJLG/\u001f\u0006\u0003)\u001e\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003-F\u0013!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u0006\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA\u00059A-[1mK\u000e$X#\u0001.\u0011\u0005msgB\u0001/l\u001d\ti\u0016N\u0004\u0002_O:\u0011qL\u001a\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!aY\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002iK\u0005\u0011AMY\u0005\u0003A)T!\u0001[\u0013\n\u00051l\u0017AC*rY\n+\u0018\u000e\u001c3fe*\u0011\u0001E[\u0005\u0003_B\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002m[\u0006AA-[1mK\u000e$\b%\u0001\teK\u000e|'/\u0019;peN+'O^5dKV\tA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002zK\u0005\u0019\u0011\r]5\n\u0005m4(\u0001I%oi\u0016\u0014h.\u00197NKR\fG-\u0019;b\t\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016\f\u0011\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Qyq0a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\t\u0019\u0004E\u0002\u0002\u0002\u0001i\u0011a\b\u0005\u0006o-\u0001\r\u0001\u000f\u0005\u0006}-\u0001\ra\u0010\u0005\u0006\u0005.\u0001\ra\u0011\u0005\u0006\r.\u0001\ra\u0012\u0005\u0006\u001b.\u0001\u001da\u0014\u0005\u00061.\u0001\u001dA\u0017\u0015\t\u0003\u001b\t\t\"!\f\u00020A!\u00111CA\u0015\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011AC1o]>$\u0018\r^5p]*!\u00111DA\u000f\u0003\u001d1\u0017m\u0019;pefTA!a\b\u0002\"\u0005)!-Z1og*!\u00111EA\u0013\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0014\u0003\ry'oZ\u0005\u0005\u0003W\t)BA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u0011\u0011G\u0001\u0018q2\u0014(+\u001a9pg&$xN]=Tc2$\u0015.\u00197fGRDQA]\u0006A\u0002Q\fAA]3bIR!\u0011\u0011HA$!\u0011\tY$a\u0011\u000e\u0005\u0005u\"b\u0001\u0013\u0002@)\u0019\u0011\u0011I\u0013\u0002\r\u0011|W.Y5o\u0013\u0011\t)%!\u0010\u0003\u0011\u0011+G.\u001b<fefDq!!\u0013\r\u0001\u0004\tY%\u0001\u0006eK2Lg/\u001a:z\u0013\u0012\u0004B!!\u0014\u0002V9!\u0011qJA)!\t\tw&C\u0002\u0002T=\na\u0001\u0015:fI\u00164\u0017\u0002BA,\u00033\u0012aa\u0015;sS:<'bAA*_!\u001aA\"!\u0018\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019n\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0014\u0011\r\u0002\u000b\u0013N\u0014V-\u00193P]2L\u0018AD4fi\nK\u0018\nZ(s)&$H.\u001a\u000b\u0005\u0003s\ti\u0007C\u0004\u0002p5\u0001\r!a\u0013\u0002#\u0011,G.\u001b<fefLEm\u0014:USRdW\rK\u0002\u000e\u0003;\naa\u0019:fCR,G\u0003BA<\u0003{\u00022ALA=\u0013\r\tYh\f\u0002\u0005+:LG\u000f\u0003\u0004%\u001d\u0001\u0007\u0011\u0011H\u0001\u0007kB$\u0017\r^3\u0015\t\u0005]\u00141\u0011\u0005\u0007I=\u0001\r!!\u000f\u0002\r\u0015D\u0018n\u001d;t)\u0011\tI)a$\u0011\u00079\nY)C\u0002\u0002\u000e>\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002JA\u0001\r!a\u0013)\u0007A\ti&\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003o\n9\nC\u0004\u0002JE\u0001\r!a\u0013\u0002\rM,\u0017M]2i)9\ti*a,\u0002D\u0006=\u0017\u0011\\Ar\u0003O\u0004b!a(\u0002*\u0006eb\u0002BAQ\u0003Ks1!YAR\u0013\u0005\u0001\u0014bAAT_\u00059\u0001/Y2lC\u001e,\u0017\u0002BAV\u0003[\u00131aU3r\u0015\r\t9k\f\u0005\b\u0003c\u0013\u0002\u0019AAZ\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,A\u0003g_Jl7OC\u0002\u0002>b\f!A^\u0019\n\t\u0005\u0005\u0017q\u0017\u0002\u0018\u0003\n\u001cHO]1di\u0012+G.\u001b<fef4\u0015\u000e\u001c;feNDq!!2\u0013\u0001\u0004\t9-\u0001\u0003qC\u001e,\u0007\u0003BAe\u0003\u0017l\u0011AS\u0005\u0004\u0003\u001bT%\u0001\u0002)bO\u0016Dq!!5\u0013\u0001\u0004\t\u0019.A\u0004pe\u0012,'OQ=\u0011\t\u0005U\u0016Q[\u0005\u0005\u0003/\f9LA\tEK2Lg/\u001a:z\u001fJ$WM]'pI\u0016Dq!a7\u0013\u0001\u0004\ti.\u0001\u0006qe&t7-\u001b9bYN\u0004b!a(\u0002`\u0006-\u0013\u0002BAq\u0003[\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003K\u0014\u0002\u0019AAo\u0003\u001d\u0011x\u000e\\3JINDq!!;\u0013\u0001\u0004\tY/\u0001\tb]f|e\rU3s[&\u001c8/[8ogB1\u0011qTAU\u0003[\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g\f\u0016A\u00039fe6L7o]5p]&!\u0011q_Ay\u0005)\u0001VM]7jgNLwN\u001c\u0015\u0004%\u0005u\u0013!C:fCJ\u001c\u0007.\u00133t)\u0011\tyP!\u0001\u0011\r\u0005}\u0015\u0011VA&\u0011\u001d\t\tl\u0005a\u0001\u0003gC3aEA/\u0003\t2\u0017N\u001c3EK2Lg/\u001a:jKN\u0014VMZ3sK:\u001c\u0017N\\4SK2,\u0017m]3JIR!\u0011q B\u0005\u0011\u001d\u0011Y\u0001\u0006a\u0001\u0003\u0017\n\u0011B]3mK\u0006\u001cX-\u00133\u0002O\u0019Lg\u000eZ!di&4X\rR3mSZ,'/[3t%\u00164WM]3oG&twMR8mI\u0016\u0014\u0018\n\u001a\u000b\u0005\u0005#\u0011I\u0002\u0005\u0004\u0002 \u0006%&1\u0003\t\u0004s\tU\u0011b\u0001B\fu\ti1)[%e/&$\b\u000eV5uY\u0016DqAa\u0007\u0016\u0001\u0004\tY%\u0001\u0005g_2$WM]%eQ\r)\u0012QL\u0001\u0019M&tGMU3mK\u0006\u001cXm\u001d\"z\t\u0016d\u0017N^3ss&#G\u0003\u0002B\u0012\u0005c\u0001b!a(\u0002*\n\u0015\u0002\u0003\u0002B\u0014\u0005[i!A!\u000b\u000b\t\t-\u00121X\u0001\u0006m&,wo]\u0005\u0005\u0005_\u0011ICA\fEK2Lg/\u001a:z\r2|wOU3mK\u0006\u001cX-\u00138g_\"9\u0011\u0011\n\fA\u0002\u0005-\u0003f\u0001\f\u0002^\u0005aAo\u001c#fY&4XM]5fgR!\u0011Q\u0014B\u001d\u0011\u001d\u0011Yd\u0006a\u0001\u0005{\tAA]8xgB1\u0011qTAU\u0005\u007f\u00012!\u000fB!\u0013\r\u0011\u0019E\u000f\u0002\f\t\u0016d\u0017N^3ssJ{w/\u0001\u0006u_\u0012+G.\u001b<fef$b!!\u000f\u0003J\t5\u0003b\u0002B&1\u0001\u0007!qH\u0001\u0004e><\bb\u0002B(1\u0001\u0007\u0011q`\u0001\u000e]\u0016<(+\u001a7fCN,\u0017\nZ:\u0002\u0019\u0019Lg\u000e\u001a$pY\u0012,'/\u00133\u0015\t\u0005-#Q\u000b\u0005\b\u0003\u0013J\u0002\u0019AA&Q\rI\u0012QL\u0001/I\u0016\u001cwN]1uK^KG\u000f[#gM\u0016\u001cG/\u001b<f'\u0016\u001cWO]5us\u0006sG\rU1ui\u0016\u0014h\u000eR3uC&d7\u000f\u0006\u0003\u0002\u001e\nu\u0003b\u0002B05\u0001\u0007\u0011QT\u0001\u000bI\u0016d\u0017N^3sS\u0016\u001c\u0018!D7baR{G)\u001a7jm\u0016\u0014\u0018\u0010\u0006\u0003\u0003f\t-\u0004#\u0002\u0018\u0003h\u0005e\u0012b\u0001B5_\t1q\n\u001d;j_:DqA!\u001c\u001c\u0001\u0004\u0011y'\u0001\beK2Lg/\u001a:z%><x\n\u001d;\u0011\u000b9\u00129Ga\u0010\u0002)\u0005\u0014X-\u0013;f[NLe\u000eV1cY\u0016,\u0015/^1m)\u0019\tII!\u001e\u0003\u0000!9!q\u000f\u000fA\u0002\te\u0014aB8mI&#X-\u001c\t\u0005\u0003w\u0011Y(\u0003\u0003\u0003~\u0005u\"a\u0003+sC\u000e\\W\rZ%uK6DqA!!\u001d\u0001\u0004\u0011I(A\u0004oK^LE/Z7\u0002%\u0019Lg\u000e\u001a)biR,'O\u001c\"z)&$H.\u001a\u000b\u0005\u0003s\u00119\tC\u0004\u0003\nv\u0001\r!a\u0013\u0002\u000bQLG\u000f\\3)\u0007u\ti\u0006K\u0002\u0001\u0005\u001f\u0003BA!%\u0003\u00186\u0011!1\u0013\u0006\u0005\u0005+\u000b\t#\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!'\u0003\u0014\nQ!+\u001a9pg&$xN]=)\u0007\u0001\u0011i\n\u0005\u0003\u0002`\t}\u0015\u0002\u0002BQ\u0003C\u0012q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryId).append(" not found").toString(), new Object[0]);
        });
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryIdOrTitle).append(" not found").toString(), new Object[0]);
        });
    }

    @Override
    public void create(Delivery delivery) {
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala().toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(originalDelivery.getTrackedItems()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala(), (Function1 & Serializable)x$1 -> x$1.getId(), (Function2 & Serializable)(oldItem, newItem) -> BoxesRunTime.boxToBoolean((boolean)this.areItemsInTableEqual(oldItem, newItem)));
        itemDiff.updatedValues().foreach((Function1 & Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.SetHasAsScala(originalDelivery.getReleaseIds()).asScala(), (Iterable)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, scala.collection.immutable.Seq<Permission> anyOfPermissions) {
        scala.collection.immutable.Seq<DeliveryRow> seq;
        if (filters.hasStatuses()) {
            String string;
            DeliverySqlBuilder deliverySqlBuilder = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withTrackedItemTitleLike(filters.getTrackedItemTitle(), filters.isStrictTrackedItemTitleMatch()).withOneOfStatuses((scala.collection.immutable.Seq<DeliveryStatus>)((scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)filters.getStatuses()).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))).withFolder(filters.getFolderId()).withPermissions((scala.collection.immutable.Seq<Permission>)(this.permissionEnforcer().isCurrentUserAdmin() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty() : anyOfPermissions), principals, roleIds);
            AbstractDeliveryFilters abstractDeliveryFilters = filters;
            if (abstractDeliveryFilters instanceof DeliveryFilters) {
                DeliveryFilters deliveryFilters = (DeliveryFilters)abstractDeliveryFilters;
                string = deliveryFilters.getOriginPatternId();
            } else {
                string = null;
            }
            Tuple2 sqlWithParams = deliverySqlBuilder.withOriginPatternId(string).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        } else {
            seq = (scala.collection.immutable.Seq<DeliveryRow>)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq<DeliveryRow> deliveryRows = seq;
        scala.collection.immutable.Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        return this.permissionEnforcer().isCurrentUserAdmin() ? deliveries : this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((scala.collection.immutable.Seq<DeliveryStatus>)((scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)filters.getStatuses()).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))).withFolder(filters.getFolderId()).build();
        return (scala.collection.immutable.Seq)this.deliveryPersistence.findByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).map((Function1 & Serializable)x$4 -> x$4.domainId());
    }

    @Override
    public scala.collection.immutable.Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (scala.collection.immutable.Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false));
    }

    private scala.collection.immutable.Seq<Delivery> toDeliveries(scala.collection.immutable.Seq<DeliveryRow> rows) {
        Map<Object, scala.collection.immutable.Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)rows.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()))));
        return (scala.collection.immutable.Seq)rows.map((Function1 & Serializable)row -> this.toDelivery((DeliveryRow)row, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
    }

    private Delivery toDelivery(DeliveryRow row, scala.collection.immutable.Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content(), new ResolveOptionsBuilder().withEverything().build());
        Option option = deliveryOption;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(58).append("Error reading release delivery ").append(row.ciUid()).append(", see logs for more details").toString(), new Object[0]);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Delivery delivery = (Delivery)some.value();
        delivery.setFolderId(row.folderId().absolute());
        Set mergedReleaseIds = (Set)CollectionConverters$.MODULE$.SetHasAsScala(delivery.getReleaseIds()).asScala().map((Function1 & Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable)() -> oldId));
        delivery.setReleaseIds(new HashSet(CollectionConverters$.MODULE$.MutableSetHasAsJava(mergedReleaseIds).asJava()));
        Delivery delivery2 = delivery;
        return delivery2;
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return this.deliveryPersistence.findFolderId(deliveryId).absolute();
    }

    private scala.collection.immutable.Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(scala.collection.immutable.Seq<Delivery> deliveries) {
        return (scala.collection.immutable.Seq)deliveries.map((Function1 & Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS()}))).asJava());
            return delivery;
        });
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable)delivery -> (Delivery)this.decorateWithEffectiveSecurityAndPatternDetails((scala.collection.immutable.Seq<Delivery>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Delivery[]{delivery})))).head());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areItemsInTableEqual(TrackedItem oldItem, TrackedItem newItem) {
        String string = oldItem.getTitle();
        String string2 = newItem.getTitle();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (oldItem.isDescoped() != newItem.isDescoped()) return false;
        Date date = oldItem.getModifiedDate();
        Date date2 = newItem.getModifiedDate();
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    @Override
    @IsReadOnly
    public Delivery findPatternByTitle(String title) {
        return (Delivery)this.mapToDelivery(this.deliveryPersistence.findPatternByTitle(title)).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(title).append(" not found").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        DeliveryRepository.$init$(this);
    }
}

