/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.ConditionSatisfiedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.transition.ConditionTrigger;
import com.xebialabs.xlrelease.delivery.transition.TransitionParams;
import com.xebialabs.xlrelease.delivery.transition.UserTrigger;
import com.xebialabs.xlrelease.delivery.util.DeliveryUtils$;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tUg\u0001B\u0010!\u0001-B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000b}\u0003A\u0011\u00011\t\u000ba\u0004A\u0011A=\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a.\u0001\t\u0003\tI\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#A\u0011Ba\r\u0001#\u0003%\tA!\u000e\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!Q\u000b\u0001\u0005\u0002\t]\u0003b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u00119\t\u0001C\u0005\u0005\u0013CqAa$\u0001\t\u0013\u0011\t\nC\u0004\u0003.\u0002!IAa,\t\u000f\t]\u0006\u0001\"\u0003\u0003:\"9!q\u0018\u0001\u0005\n\t\u0005'\u0001\u0007#fY&4XM]=Fq\u0016\u001cW\u000f^5p]N+'O^5dK*\u0011\u0011EI\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019C%\u0001\u0005eK2Lg/\u001a:z\u0015\t)c%A\u0005yYJ,G.Z1tK*\u0011q\u0005K\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!K\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024q5\tAG\u0003\u00026m\u0005)1\u000f\u001c45U*\tq'\u0001\u0005he&T(\u0010\\3e\u0013\tIDGA\u0004M_\u001e<\u0017N\\4\u0002%\u0011,G.\u001b<fef\u0014V\r]8tSR|'/\u001f\t\u0003y}j\u0011!\u0010\u0006\u0003}\t\n!B]3q_NLGo\u001c:z\u0013\t\u0001UH\u0001\nEK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u00111)R\u0007\u0002\t*\u0011a\bJ\u0005\u0003\r\u0012\u0013\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u00039!\u0018m]6SKB|7/\u001b;pef\u0004\"aQ%\n\u0005)#%A\u0004+bg.\u0014V\r]8tSR|'/_\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002N\u001f6\taJ\u0003\u0002\"I%\u0011\u0001K\u0014\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0005fm\u0016tGOQ;t!\t\u0019f+D\u0001U\u0015\t)F%\u0001\u0004fm\u0016tGo]\u0005\u0003/R\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\tQV,D\u0001\\\u0015\taF%\u0001\u0004bGR|'o]\u0005\u0003=n\u00131CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDcB1dI\u00164w\r\u001b\t\u0003E\u0002i\u0011\u0001\t\u0005\u0006u\u001d\u0001\ra\u000f\u0005\u0006\u0003\u001e\u0001\rA\u0011\u0005\u0006\u000f\u001e\u0001\r\u0001\u0013\u0005\u0006\u0017\u001e\u0001\r\u0001\u0014\u0005\u0006#\u001e\u0001\rA\u0015\u0005\u00061\u001e\u0001\r!\u0017\u0015\u0003\u000f)\u0004\"a\u001b<\u000e\u00031T!!\u001c8\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002pa\u00069a-Y2u_JL(BA9s\u0003\u0015\u0011W-\u00198t\u0015\t\u0019H/A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005)\u0018aA8sO&\u0011q\u000f\u001c\u0002\n\u0003V$xn^5sK\u0012\f\u0001$\\1sW\u000e{g\u000eZ5uS>t\u0017i]*bi&\u001ch-[3e)\u0011QX0!\u0006\u0011\u00055Z\u0018B\u0001?/\u0005\u0011)f.\u001b;\t\u000byD\u0001\u0019A@\u0002\u0015\u0011,G.\u001b<fefLE\r\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002/\u001b\t\t9AC\u0002\u0002\n)\na\u0001\u0010:p_Rt\u0014bAA\u0007]\u00051\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004/\u0011\u0019\t9\u0002\u0003a\u0001\u007f\u0006Y1m\u001c8eSRLwN\\%eQ\rA\u00111\u0004\t\u0005\u0003;\tI#\u0004\u0002\u0002 )\u0019Q.!\t\u000b\t\u0005\r\u0012QE\u0001\b[\u0016$(/[2t\u0015\r\t9\u0003K\u0001\tG>$\u0017\r[1mK&!\u00111FA\u0010\u0005\u0015!\u0016.\\3e\u0003ai\u0017M\\;bY\u000e{W\u000e\u001d7fi\u0016$&/\u00198tSRLwN\u001c\u000b\bu\u0006E\u00121GA\u001c\u0011\u0015q\u0018\u00021\u0001\u0000\u0011\u0019\t)$\u0003a\u0001\u007f\u0006aAO]1og&$\u0018n\u001c8JI\"9\u0011\u0011H\u0005A\u0002\u0005m\u0012A\u00039be\u0006lW\r^3sgB!\u0011QHA&\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013!\u00024pe6\u001c(\u0002BA#\u0003\u000f\n!A^\u0019\u000b\u0007\u0005%C%A\u0002ba&LA!!\u0014\u0002@\t\u00112i\\7qY\u0016$X\r\u0016:b]NLG/[8oQ\rI\u00111D\u0001\u0012Kb,7-\u001e;f)J\fgn]5uS>tG#\u0002>\u0002V\u0005\u001d\u0004bBA,\u0015\u0001\u0007\u0011\u0011L\u0001\u000biJ\fgn]5uS>t\u0007\u0003BA.\u0003Gj!!!\u0018\u000b\u0007\r\nyFC\u0002\u0002b\u0011\na\u0001Z8nC&t\u0017\u0002BA3\u0003;\u0012!\u0002\u0016:b]NLG/[8o\u0011\u001d\tIG\u0003a\u0001\u0003W\na\u0001]1sC6\u001c\b\u0003BA7\u0003cj!!a\u001c\u000b\u0007\u0005]#%\u0003\u0003\u0002t\u0005=$\u0001\u0005+sC:\u001c\u0018\u000e^5p]B\u000b'/Y7t\u0003I\u0011XmZ5ti\u0016\u00148+\u001e2tGJL'-\u001a:\u0015\r\u0005e\u0014qPAA!\u0011\tY&a\u001f\n\t\u0005u\u0014Q\f\u0002\u0013'V\u00147o\u0019:jaRLwN\u001c*fgVdG\u000fC\u0003\u007f\u0017\u0001\u0007q\u0010C\u0004\u0002\u0004.\u0001\r!!\"\u0002\u0015M,(m]2sS\n,'\u000f\u0005\u0003\u0002\\\u0005\u001d\u0015\u0002BAE\u0003;\u0012!bU;cg\u000e\u0014\u0018NY3sQ\rY\u00111D\u0001\u0016O\u0016$HK]1dW\u0016$\u0017\n^3n\u0005f$\u0016\u000e\u001e7f)\u0019\t\t*a&\u0002\u001aB!\u00111LAJ\u0013\u0011\t)*!\u0018\u0003\u0017Q\u0013\u0018mY6fI&#X-\u001c\u0005\u0006}2\u0001\ra \u0005\u0007\u00037c\u0001\u0019A@\u0002\u0013%$X-\u001c+ji2,\u0007f\u0001\u0007\u0002\u001c\u0005yq-\u001a;Ue\u0006\u001c7.\u001a3Ji\u0016l7\u000f\u0006\u0003\u0002$\u0006M\u0006CBAS\u0003_\u000b\t*\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\u0011)H/\u001b7\u000b\u0005\u00055\u0016\u0001\u00026bm\u0006LA!!-\u0002(\n!A*[:u\u0011\u0015qX\u00021\u0001\u0000Q\ri\u00111D\u0001\u0012GJ,\u0017\r^3Ue\u0006\u001c7.\u001a3Ji\u0016lGCBAI\u0003w\u000bi\fC\u0003\u007f\u001d\u0001\u0007q\u0010C\u0004\u0002@:\u0001\r!!%\u0002\t%$X-\u001c\u0015\u0004\u001d\u0005m\u0011!E;qI\u0006$X\r\u0016:bG.,G-\u0013;f[R1\u0011\u0011SAd\u0003\u0013DQA`\bA\u0002}Dq!a0\u0010\u0001\u0004\t\t\nK\u0002\u0010\u00037\t\u0011\u0003Z3mKR,GK]1dW\u0016$\u0017\n^3n)\u0015Q\u0018\u0011[Aj\u0011\u0015q\b\u00031\u0001\u0000\u0011\u0019\t)\u000e\u0005a\u0001\u007f\u00061\u0011\u000e^3n\u0013\u0012D3\u0001EA\u000e\u0003I!Wm]2pa\u0016$&/Y2lK\u0012LE/Z7\u0015\u000bi\fi.a8\t\u000by\f\u0002\u0019A@\t\r\u0005U\u0017\u00031\u0001\u0000Q\r\t\u00121D\u0001\u0013e\u0016\u001c8m\u001c9f)J\f7m[3e\u0013R,W\u000eF\u0003{\u0003O\fI\u000fC\u0003\u007f%\u0001\u0007q\u0010\u0003\u0004\u0002VJ\u0001\ra \u0015\u0004%\u0005m\u0011\u0001\u0006:fO&\u001cH/\u001a:Ue\u0006\u001c7.\u001a3Ji\u0016l7\u000fF\u0004{\u0003c\f\u0019P!\u0003\t\u000by\u001c\u0002\u0019A@\t\u000f\u0005U8\u00031\u0001\u0002x\u0006)\u0011\u000e^3ngB)\u0011\u0011 B\u0002\u007f:!\u00111`A\u0000\u001d\u0011\t)!!@\n\u0003=J1A!\u0001/\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0002\u0003\b\t\u00191+Z9\u000b\u0007\t\u0005a\u0006\u0003\u0004\u0003\fM\u0001\ra`\u0001\u000eMJ|WNU3mK\u0006\u001cX-\u00133)\u0007M\tY\"A\fnCJ\\GK]1dW\u0016$\u0017\n^3ng&s7\u000b^1hKRq\u00111\u0015B\n\u0005+\u0011IBa\u0007\u0003&\t\u001d\u0002\"\u0002@\u0015\u0001\u0004y\bB\u0002B\f)\u0001\u0007q0A\u0004ti\u0006<W-\u00133\t\u000f\u0005UH\u00031\u0001\u0002x\"9!Q\u0004\u000bA\u0002\t}\u0011AB:uCR,8\u000f\u0005\u0003\u0002\\\t\u0005\u0012\u0002\u0002B\u0012\u0003;\u0012\u0011\u0003\u0016:bG.,G-\u0013;f[N#\u0018\r^;t\u0011\u0019\u0011Y\u0001\u0006a\u0001\u007f\"I!\u0011\u0006\u000b\u0011\u0002\u0003\u0007!1F\u0001\u0010aJ,7-\u001a3j]\u001e\u001cF/Y4fgB\u0019QF!\f\n\u0007\t=bFA\u0004C_>dW-\u00198)\u0007Q\tY\"A\u0011nCJ\\GK]1dW\u0016$\u0017\n^3ng&s7\u000b^1hK\u0012\"WMZ1vYR$c'\u0006\u0002\u00038)\"!1\u0006B\u001dW\t\u0011Y\u0004\u0005\u0003\u0003>\t\u0015SB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\u0013Ut7\r[3dW\u0016$'BA7/\u0013\u0011\u00119Ea\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\ftW&\u0004HK]1dW\u0016$\u0017\n^3n\u0013:\u001cF/Y4f)\u001dQ(Q\nB(\u0005#BQA \fA\u0002}DaAa\u0006\u0017\u0001\u0004y\bBBAk-\u0001\u0007q\u0010K\u0002\u0017\u00037\tQbY8na2,G/Z*uC\u001e,G#\u0002>\u0003Z\tm\u0003\"\u0002@\u0018\u0001\u0004y\bB\u0002B\f/\u0001\u0007q\u0010K\u0002\u0018\u00037\t1B]3pa\u0016t7\u000b^1hKR)!Pa\u0019\u0003f!)a\u0010\u0007a\u0001\u007f\"1!q\u0003\rA\u0002}D3\u0001GA\u000e\u0003-!wnV5uQN#\u0018mZ3\u0015\u000fi\u0014iGa\u001c\u0003r!)a0\u0007a\u0001\u007f\"1!qC\rA\u0002}DqAa\u001d\u001a\u0001\u0004\u0011)(\u0001\u0002g]BAQFa\u001e\u0003|\t\u0005%0C\u0002\u0003z9\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0007\t\u0014i(C\u0002\u0003\u0000\u0001\u0012A\u0003R3mSZ,'/_*uCR,W*\u00198bO\u0016\u0014\b\u0003BA.\u0005\u0007KAA!\"\u0002^\t)1\u000b^1hK\u0006q\u0001O]8dKN\u001c8\t[1oO\u0016\u001cHc\u0001>\u0003\f\"9!Q\u0012\u000eA\u0002\tm\u0014aB7b]\u0006<WM]\u0001\u001fa\u0006\u0014H/\u001b;j_:LE/Z7t\u0005f,\u00050[:uS:<\u0017I\u001c3OK^$bAa%\u0003\u001c\n\r\u0006cB\u0017\u0003\u0016\ne%\u0011T\u0005\u0004\u0005/s#A\u0002+va2,'\u0007\u0005\u0004\u0002z\n\r\u0011\u0011\u0013\u0005\u0007Gm\u0001\rA!(\u0011\t\u0005m#qT\u0005\u0005\u0005C\u000biF\u0001\u0005EK2Lg/\u001a:z\u0011\u001d\u0011)k\u0007a\u0001\u0005O\u000ba\"\u001b;f[&#wJ\u001d+ji2,7\u000fE\u0003\u0002\u0002\t%v0\u0003\u0003\u0003,\u0006M!aA*fi\u0006aa/\u00197jI\u0006$X-\u0013;f[R)!P!-\u00034\"11\u0005\ba\u0001\u0005;CqA!.\u001d\u0001\u0004\t\t*A\u0006ue\u0006\u001c7.\u001a3Ji\u0016l\u0017A\u0004<bY&$\u0017\r^3NK6\u0014WM\u001d\u000b\u0004u\nm\u0006B\u0002B_;\u0001\u0007q0A\u0005sK2,\u0017m]3JI\u0006aa/\u00197jI\u0006$X\rV1tWR\u0019!Pa1\t\r\t\u0015g\u00041\u0001\u0000\u0003\u0019!\u0018m]6JI\"\u001a\u0001A!3\u0011\t\t-'\u0011[\u0007\u0003\u0005\u001bT1Aa4s\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005'\u0014iMA\u0004TKJ4\u0018nY3")
public class DeliveryExecutionService
implements Logging {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryExecutionService deliveryExecutionService = this;
        synchronized (deliveryExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void markConditionAsSatisfied(String deliveryId, String conditionId) {
        block1: {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(33).append("Marking condition '").append(conditionId).append("' as satisfied").toString());
            Delivery delivery = this.deliveryRepository.read(deliveryId);
            Transition transition = delivery.getTransitionByIdOrTitle(DeliveryUtils$.MODULE$.transitionIdFrom(conditionId));
            Condition condition = transition.getConditionById(conditionId);
            Stage stage = transition.getStage();
            Condition root = transition.getRootCondition();
            Buffer changes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(root.markAsSatisfied(conditionId, new Date())).asScala().$minus$eq((Object)root);
            if (!changes.nonEmpty()) break block1;
            this.deliveryRepository.update(delivery);
            ((IterableOnceOps)changes.map((Function1 & Serializable)x$1 -> new ConditionSatisfiedEvent((Condition)((Object)x$1), transition, delivery))).foreach((Function1 & Serializable)x$1 -> {
                this.eventBus.publish(x$1);
                return BoxedUnit.UNIT;
            });
            if (root.isSatisfied() && stage.isOpen()) {
                scala.collection.immutable.Seq stages = CollectionConverters$.MODULE$.ListHasAsScala(delivery.getStageGroupOfStage(stage)).asScala().toSeq();
                Set completedItems = ((IterableOnceOps)DeliveryUtils$.MODULE$.getItemsCompletedInAllStages((scala.collection.immutable.Seq<TrackedItem>)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDescoped()))).toSeq(), (scala.collection.immutable.Seq<Stage>)stages).map((Function1 & Serializable)x$3 -> x$3.getId())).toSet();
                Seq transitionedItems = (Seq)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delivery.findNextStage(stage))).map((Function1 & Serializable)x$4 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$4.getItems()).asScala().map((Function1 & Serializable)x$5 -> x$5.getTrackedItemId())).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
                Set toTransition = (Set)completedItems.$minus$minus((IterableOnce)transitionedItems);
                this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)toTransition, true, new ConditionTrigger(conditionId, condition.toString())));
            }
        }
    }

    @Timed
    public void manualCompleteTransition(String deliveryId, String transitionId, CompleteTransition parameters) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(50).append("Manual transition '").append(transitionId).append("' on delivery '").append(deliveryId).append("' with params '").append(parameters).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByTransitionId(transitionId);
        Transition transition = stage.getTransition();
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(40).append("Transition already completed on stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        Checks.checkNotNull(parameters.getTransitionItems(), (String)"Transition items");
        Set transitionItems = CollectionConverters$.MODULE$.ListHasAsScala(parameters.getTransitionItems()).asScala().toSet();
        transitionItems.foreach((Function1 & Serializable)itemId -> {
            DeliveryExecutionService.$anonfun$manualCompleteTransition$2(delivery, stage, itemId);
            return BoxedUnit.UNIT;
        });
        this.executeTransition(transition, new TransitionParams(delivery, stage, (Set<String>)transitionItems, parameters.isCloseStages(), new UserTrigger(Permissions.getAuthenticatedUserName())));
    }

    private void executeTransition(Transition transition, TransitionParams params) {
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(params.delivery(), this.ciIdService);
        manager.handleTransition(transition, params);
        this.processChanges(manager);
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(40).append("Registering subscriber '").append((Object)subscriber).append("' to delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateTask(subscriber.sourceId());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        SubscriptionResult result = manager.registerSubscriber(subscriber);
        this.processChanges(manager);
        return result;
    }

    @Timed
    public TrackedItem getTrackedItemByTitle(String deliveryId, String itemTitle) {
        return this.deliveryRepository.read(deliveryId).getItemByIdOrTitle(itemTitle);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String deliveryId) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        return delivery.getTrackedItems();
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem addedItem = manager.addTrackedItem(item);
        this.processChanges(manager);
        return addedItem;
    }

    @Timed
    public TrackedItem updateTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(47).append("Updating tracked item with id '").append(item.getId()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem updatedItem = manager.updateTrackedItem(item);
        this.processChanges(manager);
        return updatedItem;
    }

    @Timed
    public void deleteTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(41).append("Removing tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.deleteTrackedItem(itemId);
        this.processChanges(manager);
    }

    @Timed
    public void descopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Descoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.descopeItems((scala.collection.immutable.Seq<TrackedItem>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void rescopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(42).append("Rescoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.rescopeItems((scala.collection.immutable.Seq<TrackedItem>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, scala.collection.immutable.Seq<String> items, String fromReleaseId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(63).append("Registering new tracked items [").append(items.mkString(", ")).append("] on delivery '").append(deliveryId).append("' from release '").append(fromReleaseId).append("'").toString());
        this.validateMember(fromReleaseId);
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> tuple2 = this.partitionItemsByExistingAndNew(delivery, (Set<String>)items.toSet());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq newItems = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingItems, (Object)newItems);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Seq existingItems2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq newItems2 = (scala.collection.immutable.Seq)tuple23._2();
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        existingItems2.foreach((Function1 & Serializable)item -> {
            manager.addReleaseToItem(item, fromReleaseId);
            return BoxedUnit.UNIT;
        });
        this.processChanges(manager);
        newItems2.foreach((Function1 & Serializable)item -> {
            item.addReleaseId(fromReleaseId);
            return this.createTrackedItem(deliveryId, (TrackedItem)((Object)item));
        });
    }

    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageId, scala.collection.immutable.Seq<String> items, TrackedItemStatus status, String fromReleaseId, boolean precedingStages) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(64).append("Marking tracked items [").append(items.mkString(", ")).append("] as completed on stage '").append(stageId).append("' on delivery '").append(deliveryId).append("'").toString()).append(String.valueOf(fromReleaseId != null ? new StringBuilder(7).append("from '").append(fromReleaseId).append("'").toString() : "")).toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        scala.collection.immutable.Seq existingItems = (scala.collection.immutable.Seq)((IterableOps)items.distinct()).map((Function1 & Serializable)idOrTitle -> {
            LazyRef lowercaseTitle$lzy = new LazyRef();
            return (TrackedItem)((Object)((Object)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().find((Function1 & Serializable)trackedItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$markTrackedItemsInStage$3(idOrTitle, lowercaseTitle$lzy, trackedItem))).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(45).append("Tracked item '").append((String)idOrTitle).append("' does not exist in delivery '").append(delivery.getTitle()).append("'").toString(), new Object[0]);
            })));
        });
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        if (fromReleaseId != null) {
            this.validateMember(fromReleaseId);
            existingItems.foreach((Function1 & Serializable)x$9 -> {
                manager.addReleaseToItem(x$9, fromReleaseId);
                return BoxedUnit.UNIT;
            });
        }
        scala.collection.immutable.Seq<TrackedItem> markedItems = manager.markTrackedItemsInStage((scala.collection.immutable.Seq<TrackedItem>)existingItems, stage, status, precedingStages, fromReleaseId);
        this.processChanges(manager);
        return CollectionConverters$.MODULE$.SeqHasAsJava(markedItems).asJava();
    }

    public boolean markTrackedItemsInStage$default$6() {
        return false;
    }

    @Timed
    public void skipTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("Skipping tracked item '").append(itemId).append("' on stage '").append(stageId).append("' in delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.skipTrackedItemInStage(trackedItem, stage);
        this.processChanges(manager);
    }

    @Timed
    public void completeStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(29).append("Marking stage '").append(stageId).append("' as completed").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.completeStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void reopenStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(30).append("Marking stage '").append(stageId).append("' as open again").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable)(manager, stage) -> {
            manager.reopenStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    private void doWithStage(String deliveryId, String stageId, Function2<DeliveryStateManager, Stage, BoxedUnit> fn) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        fn.apply((Object)manager, (Object)stage);
        this.processChanges(manager);
    }

    private void processChanges(DeliveryStateManager manager) {
        this.deliveryRepository.update(manager.delivery());
        manager.getMessages().foreach((Function1 & Serializable)x$10 -> {
            DeliveryExecutionService.$anonfun$processChanges$1(this, x$10);
            return BoxedUnit.UNIT;
        });
        manager.getEvents().foreach((Function1 & Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<scala.collection.immutable.Seq<TrackedItem>, scala.collection.immutable.Seq<TrackedItem>> partitionItemsByExistingAndNew(Delivery delivery, Set<String> itemIdOrTitles) {
        Map idsByTitles = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)i.getTitle().toLowerCase(), (Object)Ids.getName((String)i.getId())))).toSeq());
        Map itemsByIds = (Map)Predef$.MODULE$.Map().apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().map((Function1 & Serializable)i -> new Tuple2((Object)Ids.getName((String)i.getId()), (Object)i))).toSeq());
        return (Tuple2)itemIdOrTitles.foldRight((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().empty()), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String idOrTitle;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    idOrTitle = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            scala.collection.immutable.Seq existingAcc = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq newAcc = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple23 = (Tuple2)itemsByIds.get((Object)Ids.getName((String)idOrTitle)).orElse((Function0 & Serializable)() -> idsByTitles.get((Object)idOrTitle.toLowerCase()).flatMap((Function1 & Serializable)key -> itemsByIds.get(key))).fold((Function0 & Serializable)() -> {
                TrackedItem trackedItem = new TrackedItem(idOrTitle);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingAcc), newAcc.$plus$colon((Object)trackedItem));
            }, (Function1 & Serializable)item -> {
                TrackedItem trackedItem = item;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(existingAcc.$plus$colon((Object)trackedItem)), (Object)newAcc);
            });
            return tuple23;
        });
    }

    private void validateItem(Delivery delivery, TrackedItem trackedItem) {
        LazyRef lowerCaseTitle$lzy = new LazyRef();
        Checks.checkNotNull((Object)((Object)trackedItem), (String)"Tracked item");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)trackedItem.getTitle()), (String)"Tracked item title must be set", (Object[])new Object[0]);
        Checks.checkArgument((trackedItem.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!trackedItem.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkArgument((!CollectionConverters$.MODULE$.ListHasAsScala(delivery.getTrackedItems()).asScala().exists((Function1 & Serializable)existing -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$validateItem$1(trackedItem, lowerCaseTitle$lzy, existing))) ? 1 : 0) != 0, (String)new StringBuilder(43).append("A tracked item with title '").append(trackedItem.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
        if (trackedItem.getReleaseIds() == null) {
            trackedItem.setReleaseIds(new HashSet<String>());
        }
        trackedItem.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must be a valid release ID").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        Checks.checkArgument((releaseStatus != null ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must exist in the database").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus2 = releaseStatus;
        ReleaseStatus releaseStatus3 = ReleaseStatus.TEMPLATE;
        Checks.checkArgument(((releaseStatus2 == null ? releaseStatus3 != null : !releaseStatus2.equals(releaseStatus3)) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Provided entity '").append(releaseId).append("' must be a release").toString(), (Object[])new Object[0]);
    }

    private void validateTask(String taskId) {
        Checks.checkArgument((boolean)Ids.isTaskId((String)taskId), (String)new StringBuilder(38).append("Provided ID '").append(taskId).append("' must be a valid task ID").toString(), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(taskId), (String)new StringBuilder(46).append("Provided task ID '").append(taskId).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$manualCompleteTransition$3(String itemId$1, Stage x$6) {
        return x$6.getItemById(itemId$1).getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$manualCompleteTransition$2(Delivery delivery$2, Stage stage$1, String itemId) {
        TrackedItem trackedItem = delivery$2.getItemByIdOrTitle(itemId);
        Checks.checkArgument((!trackedItem.isDescoped() ? 1 : 0) != 0, (String)new StringBuilder(49).append("De-scoped tracked item '").append(trackedItem.getTitle()).append("' can not be transitioned").toString(), (Object[])new Object[0]);
        Buffer notDoneInStages = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery$2.getStagesBefore(stage$1)).asScala().$colon$plus((Object)stage$1)).filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeliveryExecutionService.$anonfun$manualCompleteTransition$3(itemId, x$6)));
        Checks.checkArgument((boolean)notDoneInStages.isEmpty(), (String)new StringBuilder(0).append(new StringBuilder(44).append("Tracked item '").append(trackedItem.getTitle()).append("' must be completed or skipped").toString()).append(new StringBuilder(53).append(" in stage '").append(((IterableOnceOps)notDoneInStages.map((Function1 & Serializable)x$7 -> x$7.getTitle())).mkString("', '")).append("' in order to transition to the next stage").toString()).toString(), (Object[])new Object[0]);
    }

    private static final /* synthetic */ String lowercaseTitle$lzycompute$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        String string;
        LazyRef lazyRef = lowercaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : (String)lowercaseTitle$lzy$1.initialize((Object)idOrTitle$1.toLowerCase());
        }
        return string;
    }

    private static final String lowercaseTitle$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        return lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : DeliveryExecutionService.lowercaseTitle$lzycompute$1(lowercaseTitle$lzy$1, idOrTitle$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$3(String idOrTitle$1, LazyRef lowercaseTitle$lzy$1, TrackedItem trackedItem) {
        String string = Ids.getName((String)trackedItem.getId());
        String string2 = Ids.getName((String)idOrTitle$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trackedItem.getTitle().toLowerCase();
        String string4 = DeliveryExecutionService.lowercaseTitle$1(lowercaseTitle$lzy$1, idOrTitle$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$processChanges$1(DeliveryExecutionService $this, String x$10) {
        $this.logger().info((Function0 & Serializable)() -> x$10);
    }

    private static final /* synthetic */ String lowerCaseTitle$lzycompute$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        String string;
        LazyRef lazyRef = lowerCaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : (String)lowerCaseTitle$lzy$1.initialize((Object)trackedItem$1.getTitle().toLowerCase());
        }
        return string;
    }

    private static final String lowerCaseTitle$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        return lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : DeliveryExecutionService.lowerCaseTitle$lzycompute$1(lowerCaseTitle$lzy$1, trackedItem$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateItem$1(TrackedItem trackedItem$1, LazyRef lowerCaseTitle$lzy$1, TrackedItem existing) {
        String string = existing.getTitle().toLowerCase();
        String string2 = DeliveryExecutionService.lowerCaseTitle$1(lowerCaseTitle$lzy$1, trackedItem$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = existing.getId();
        String string4 = trackedItem$1.getId();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    @Autowired
    public DeliveryExecutionService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, TaskRepository taskRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, ReleaseActorService releaseActorService) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

