/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.MetadataIncludingCiConverter;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySchema$;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySchema$RELEASE_DELIVERIES$;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySchema$RELEASE_DELIVERY_MEMBERS$;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder$;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.utils.FolderId;
import com.xebialabs.xlrelease.domain.utils.FolderId$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001\u0002\u0014(\u0001YB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\u0019!\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005\r\"A1\u000b\u0001BC\u0002\u0013\rA\u000b\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003V\u0011!i\u0007A!A!\u0002\u0017q\u0007\"B9\u0001\t\u0003\u0011\b\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\t\t\u0004\u0001Q\u0001\n\u0005\u0005\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\n\u0003S\u0002!\u0019!C\u0001\u0003?A\u0001\"a\u001b\u0001A\u0003%\u0011\u0011\u0005\u0005\b\u0003[\u0002A\u0011AA8\u0011%\t\t\t\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u0002\u0004\u0002\u0001\u000b\u0011BA\u0011\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fC\u0011\"!%\u0001\u0005\u0004%I!a\b\t\u0011\u0005M\u0005\u0001)A\u0005\u0003CAq!!&\u0001\t\u0003\t9\nC\u0005\u0002\u001c\u0002\u0011\r\u0011\"\u0003\u0002 !A\u0011Q\u0014\u0001!\u0002\u0013\t\t\u0003C\u0004\u0002 \u0002!\t!!)\t\u0013\u0005-\u0006A1A\u0005\n\u0005}\u0001\u0002CAW\u0001\u0001\u0006I!!\t\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"I\u0011q\u0018\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u0002\"!9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\n\u0003_\u0004!\u0019!C\u0005\u0003?A\u0001\"!=\u0001A\u0003%\u0011\u0011\u0005\u0005\b\u0003g\u0004A\u0011AA{\u0011%\u0011)\u0001\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u0003\b\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u0017A\u0011B!\b\u0001\u0005\u0004%IAa\b\t\u0011\t\u001d\u0002\u0001)A\u0005\u0005CAqA!\u000b\u0001\t\u0013\u0011YCA\nEK2Lg/\u001a:z!\u0016\u00148/[:uK:\u001cWM\u0003\u0002)S\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\tQ3&A\u0002tc2T!\u0001L\u0017\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002/_\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u00021c\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003eM\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Q\n1aY8n\u0007\u0001\u00192\u0001A\u001c>!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fMB\u0011aHQ\u0007\u0002\u007f)\u0011\u0001\u0006\u0011\u0006\u0003U\u0005S!\u0001L\u0018\n\u0005\r{$A\u0005)feNL7\u000f^3oG\u0016\u001cV\u000f\u001d9peR\fAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012A\u0012\t\u0003\u000fBk\u0011\u0001\u0013\u0006\u0003\u0013*\u000bAaY8sK*\u00111\nT\u0001\u0005U\u0012\u00147M\u0003\u0002N\u001d\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001P\u0003\ry'oZ\u0005\u0003#\"\u0013AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013a\u00023jC2,7\r^\u000b\u0002+B\u0011a+\u001b\b\u0003/\u001at!\u0001\u00173\u000f\u0005e\u0013gB\u0001.b\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_k\u00051AH]8pizJ\u0011\u0001N\u0005\u0003eMJ!\u0001M\u0019\n\u0005\r|\u0013A\u00013c\u0013\tQSM\u0003\u0002d_%\u0011q\r[\u0001\u000b'Fd')^5mI\u0016\u0014(B\u0001\u0016f\u0013\tQ7NA\u0004ES\u0006dWm\u0019;\u000b\u0005\u001dD\u0017\u0001\u00033jC2,7\r\u001e\u0011\u0002#\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002?_&\u0011\u0001o\u0010\u0002\u0012\r>dG-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0002\u001fj]&$h\bF\u0001t)\u0019!h/a\u0003\u0002\u0014A\u0011Q\u000fA\u0007\u0002O!)AI\u0002a\u0002\r\"2a\u000f_A\u0003\u0003\u000f\u00012!_A\u0001\u001b\u0005Q(BA>}\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003{z\fqAZ1di>\u0014\u0018P\u0003\u0002\u0000\u0019\u0006)!-Z1og&\u0019\u00111\u0001>\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017EAA\u0005\u0003eAHN\u001d*fa>\u001c\u0018\u000e^8ss*#'m\u0019+f[Bd\u0017\r^3\t\u000bM3\u00019A+)\u000f\u0005-\u00010!\u0002\u0002\u0010\u0005\u0012\u0011\u0011C\u0001\u0018q2\u0014(+\u001a9pg&$xN]=Tc2$\u0015.\u00197fGRDQ!\u001c\u0004A\u00049D3ABA\f!\rI\u0018\u0011D\u0005\u0004\u00037Q(!C!vi><\u0018N]3e\u0003I\u0019F+\u0014+`\u000f\u0016#v,V%E?\nKv,\u0013#\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003WqA!!\n\u0002(A\u0011A,O\u0005\u0004\u0003SI\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002.\u0005=\"AB*ue&twMC\u0002\u0002*e\n1c\u0015+N)~;U\tV0V\u0013\u0012{&)W0J\t\u0002\naaZ3u+&$G\u0003BA\u001c\u0003/\u0002R\u0001OA\u001d\u0003{I1!a\u000f:\u0005\u0019y\u0005\u000f^5p]B!\u0011qHA)\u001d\u0011\t\t%!\u0014\u000f\t\u0005\r\u00131\n\b\u0005\u0003\u000b\nIED\u0002Z\u0003\u000fJ!\u0001L\u0018\n\u0005)\n\u0015B\u0001\u0015A\u0013\r\tyeP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\u000b\rKW+\u001b3\u000b\u0007\u0005=s\bC\u0004\u0002Z%\u0001\r!a\u0017\u0002\u0015\u0011,G.\u001b<fefLE\r\u0005\u0003\u0002^\u0005\rd\u0002BA!\u0003?J1!!\u0019@\u0003\u0011\u0019\u0015.\u00133\n\t\u0005\u0015\u0014q\r\u0002\u0005\u0007&LEMC\u0002\u0002b}\nAd\u0015+N)~KejU#S)~\u0013V\tT#B'\u0016{F)\u0012'J-\u0016\u0013\u0016,A\u000fT)6#v,\u0013(T\u000bJ#vLU#M\u000b\u0006\u001bVi\u0018#F\u0019&3VIU-!\u0003\u0019Ign]3siR!\u0011QHA9\u0011\u0019qC\u00021\u0001\u0002tA!\u0011QOA?\u001b\t\t9HC\u0002/\u0003sR1!a\u001f0\u0003\u0019!w.\\1j]&!\u0011qPA<\u0005!!U\r\\5wKJL\u0018\u0001H*U\u001bR{V\u000b\u0015#B)\u0016{&+\u0012'F\u0003N+u\fR#M\u0013Z+%+W\u0001\u001e'RkEkX+Q\t\u0006#Vi\u0018*F\u0019\u0016\u000b5+R0E\u000b2Ke+\u0012*ZA\u00051Q\u000f\u001d3bi\u0016$B!!#\u0002\u0010B\u0019\u0001(a#\n\u0007\u00055\u0015H\u0001\u0003V]&$\bB\u0002\u0018\u0010\u0001\u0004\t\u0019(\u0001\u0012T)6#v\fR#M\u000bR+uLU#M\u000b\u0006\u001bVi\u0018#F\u0019&3VIU-`\u0005f{\u0016\nR\u0001$'RkEk\u0018#F\u0019\u0016#Vi\u0018*F\u0019\u0016\u000b5+R0E\u000b2Ke+\u0012*Z?\nKv,\u0013#!\u0003\u0019!W\r\\3uKR!\u0011\u0011RAM\u0011\u001d\tIF\u0005a\u0001\u00037\n!e\u0015+N)~+\u0005,S*U'~\u0013V\tT#B'\u0016{F)\u0012'J-\u0016\u0013\u0016l\u0018\"Z?&#\u0015aI*U\u001bR{V\tW%T)N{&+\u0012'F\u0003N+u\fR#M\u0013Z+%+W0C3~KE\tI\u0001\u0007KbL7\u000f^:\u0015\t\u0005\r\u0016\u0011\u0016\t\u0004q\u0005\u0015\u0016bAATs\t9!i\\8mK\u0006t\u0007bBA-+\u0001\u0007\u00111L\u0001!'RkEk\u0018$J\u001d\u0012{&+\u0012'F\u0003N+u\fR#M\u0013Z+%+W0C3~KE)A\u0011T)6#vLR%O\t~\u0013V\tT#B'\u0016{F)\u0012'J-\u0016\u0013\u0016l\u0018\"Z?&#\u0005%\u0001\u0005gS:$')_%e)\u0011\t\u0019,a/\u0011\u000ba\nI$!.\u0011\u0007U\f9,C\u0002\u0002:\u001e\u00121\u0002R3mSZ,'/\u001f*po\"9\u0011Q\u0018\rA\u0002\u0005m\u0013AA5e\u0003\r\u001aF+\u0014+`\r&sEi\u0018*F\u0019\u0016\u000b5+R0E\u000b2Ke+\u0012*Z?\nKv\fV%U\u0019\u0016\u000bAe\u0015+N)~3\u0015J\u0014#`%\u0016cU)Q*F?\u0012+E*\u0013,F%f{&)W0U\u0013RcU\tI\u0001\fM&tGMQ=USRdW\r\u0006\u0003\u00024\u0006\u001d\u0007bBAe7\u0001\u0007\u0011\u0011E\u0001\u0006i&$H.Z\u0001\fM&tGMQ=Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002P\u0006}\u0007CBAi\u00033\f)L\u0004\u0003\u0002T\u0006]gb\u0001/\u0002V&\t!(C\u0002\u0002PeJA!a7\u0002^\n\u00191+Z9\u000b\u0007\u0005=\u0013\bC\u0004\u0002br\u0001\r!a9\u0002#M\fHnV5uQB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002f\u0006%hbA,\u0002h&\u0019\u0011q\n5\n\t\u0005-\u0018Q\u001e\u0002\u0012'Fdw+\u001b;i!\u0006\u0014\u0018-\\3uKJ\u001c(bAA(Q\u0006\t3\u000bV'U?\u001e+Ek\u0018$P\u0019\u0012+%kX%E?\nKv\fR#M\u0013Z+%+W0J\t\u0006\u00113\u000bV'U?\u001e+Ek\u0018$P\u0019\u0012+%kX%E?\nKv\fR#M\u0013Z+%+W0J\t\u0002\nABZ5oI\u001a{G\u000eZ3s\u0013\u0012$B!a>\u0003\u0004A!\u0011\u0011`A\u0000\u001b\t\tYP\u0003\u0003\u0002~\u0006e\u0014!B;uS2\u001c\u0018\u0002\u0002B\u0001\u0003w\u0014\u0001BR8mI\u0016\u0014\u0018\n\u001a\u0005\b\u00033z\u0002\u0019AA\u0011\u0003\u0001\u001aF+\u0014+`\u000f\u0016#vLU#M\u000b\u0006\u001bViU0C3~#U\tT%W\u000bJKv,\u0013#\u0002CM#V\nV0H\u000bR{&+\u0012'F\u0003N+5k\u0018\"Z?\u0012+E*\u0013,F%f{\u0016\n\u0012\u0011\u00021\u0019Lg\u000e\u001a*fY\u0016\f7/Z:Cs\u0012+G.\u001b<fefLE\r\u0006\u0003\u0003\u000e\tm\u0001CBAi\u00033\u0014y\u0001\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\r\u0011)\"Q\u0001\u0006cV,'/_\u0005\u0005\u00053\u0011\u0019BA\nSK2,\u0017m]3CCNL7\rR1uC\u0016CH\u000fC\u0004\u0002Z\t\u0002\r!!\t\u0002#\u0011,G.\u001b<fef\u0014vn^'baB,'/\u0006\u0002\u0003\"A)qIa\t\u00026&\u0019!Q\u0005%\u0003\u0013I{w/T1qa\u0016\u0014\u0018A\u00053fY&4XM]=S_^l\u0015\r\u001d9fe\u0002\n\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005\u0005\"Q\u0006\u0005\u0007]\u0015\u0002\r!a\u001d)\u0007\u0001\u0011\t\u0004\u0005\u0003\u00034\teRB\u0001B\u001b\u0015\r\u00119\u0004[\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0003<\tU\"aD%t)J\fgn]1di&|g.\u00197)\u0007\u0001\u0011y\u0004\u0005\u0003\u0003B\t\u001dSB\u0001B\"\u0015\r\u0011)\u0005T\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B%\u0005\u0007\u0012!BU3q_NLGo\u001c:z\u0001")
public class DeliveryPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final FolderPersistence folderPersistence;
    private final String STMT_GET_UID_BY_ID;
    private final String STMT_INSERT_RELEASE_DELIVERY;
    private final String STMT_UPDATE_RELEASE_DELIVERY;
    private final String STMT_DELETE_RELEASE_DELIVERY_BY_ID;
    private final String STMT_EXISTS_RELEASE_DELIVERY_BY_ID;
    private final String STMT_FIND_RELEASE_DELIVERY_BY_ID;
    private final String STMT_FIND_RELEASE_DELIVERY_BY_TITLE;
    private final String STMT_GET_FOLDER_ID_BY_DELIVERY_ID;
    private final String STMT_GET_RELEASES_BY_DELIVERY_ID;
    private final RowMapper<DeliveryRow> deliveryRowMapper;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        DeliveryPersistence deliveryPersistence = this;
        synchronized (deliveryPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    private String STMT_GET_UID_BY_ID() {
        return this.STMT_GET_UID_BY_ID;
    }

    public Option<Integer> getUid(String deliveryId) {
        return this.sqlQuery(this.STMT_GET_UID_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID()))).headOption();
    }

    public String STMT_INSERT_RELEASE_DELIVERY() {
        return this.STMT_INSERT_RELEASE_DELIVERY;
    }

    public Integer insert(Delivery delivery) {
        Integer n;
        Integer folderUid = this.folderPersistence.getUid(delivery.getFolderId());
        String content = this.serialize(delivery);
        try {
            n = (Integer)this.sqlInsertWithContent(this.pkName(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID()), this.STMT_INSERT_RELEASE_DELIVERY(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID())), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(delivery.getId())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID())), (Object)folderUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE())), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(delivery.getTitle()), DeliverySchema$.MODULE$.COLUMN_LENGTH_TITLE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS())), (Object)delivery.getStatus().value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE())), (Object)delivery.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE())), (Object)delivery.getEndDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ORIGIN_PATTERN_ID())), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(delivery.getOriginPatternId()))))})), (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT())), (Object)content), (Function1 & Serializable)ciUid -> ciUid);
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException(new StringBuilder(42).append("Release delivery with ID '").append(delivery.getId()).append("' already exists").toString(), ex);
        }
        return n;
    }

    private String STMT_UPDATE_RELEASE_DELIVERY() {
        return this.STMT_UPDATE_RELEASE_DELIVERY;
    }

    public void update(Delivery delivery) {
        Integer folderUid = this.folderPersistence.getUid(delivery.getFolderId());
        String content = this.serialize(delivery);
        this.sqlExecWithContent(this.STMT_UPDATE_RELEASE_DELIVERY(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(delivery.getId())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folderUid"), (Object)folderUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newTitle"), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(delivery.getTitle()), DeliverySchema$.MODULE$.COLUMN_LENGTH_TITLE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newStatus"), (Object)delivery.getStatus().value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newStartDate"), (Object)delivery.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newEndDate"), (Object)delivery.getEndDate())})), (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)content), this.checkCiUpdated(delivery.getId()));
    }

    private String STMT_DELETE_RELEASE_DELIVERY_BY_ID() {
        return this.STMT_DELETE_RELEASE_DELIVERY_BY_ID;
    }

    public void delete(String deliveryId) {
        this.sqlExec(this.STMT_DELETE_RELEASE_DELIVERY_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> ps.execute()));
    }

    private String STMT_EXISTS_RELEASE_DELIVERY_BY_ID() {
        return this.STMT_EXISTS_RELEASE_DELIVERY_BY_ID;
    }

    public boolean exists(String deliveryId) {
        return BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_RELEASE_DELIVERY_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPersistence.$anonfun$exists$1(x$1))).head());
    }

    private String STMT_FIND_RELEASE_DELIVERY_BY_ID() {
        return this.STMT_FIND_RELEASE_DELIVERY_BY_ID;
    }

    public Option<DeliveryRow> findById(String id) {
        return this.findOptional((Function1 & Serializable)x$2 -> (DeliveryRow)x$2.queryForObject(this.STMT_FIND_RELEASE_DELIVERY_BY_ID(), this.deliveryRowMapper(), new Object[]{Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)))}), this.jdbcTemplate());
    }

    private String STMT_FIND_RELEASE_DELIVERY_BY_TITLE() {
        return this.STMT_FIND_RELEASE_DELIVERY_BY_TITLE;
    }

    public Option<DeliveryRow> findByTitle(String title) {
        return this.findOptional((Function1 & Serializable)x$3 -> (DeliveryRow)x$3.queryForObject(this.STMT_FIND_RELEASE_DELIVERY_BY_TITLE(), this.deliveryRowMapper(), new Object[]{title.toLowerCase()}), this.jdbcTemplate());
    }

    public Seq<DeliveryRow> findByQuery(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), this.deliveryRowMapper())).asScala().toSeq();
    }

    private String STMT_GET_FOLDER_ID_BY_DELIVERY_ID() {
        return this.STMT_GET_FOLDER_ID_BY_DELIVERY_ID;
    }

    public FolderId findFolderId(String deliveryId) {
        return (FolderId)this.sqlQuery(this.STMT_GET_FOLDER_ID_BY_DELIVERY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)rs -> (FolderId)Option$.MODULE$.apply((Object)rs.getString(1)).map((Function1 & Serializable)x$5 -> new FolderId(x$5)).getOrElse((Function0 & Serializable)() -> FolderId$.MODULE$.Root())).headOption().getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(47).append("Cannot find folderId for non existing delivery ").append(deliveryId).toString(), new Object[0]);
        });
    }

    private String STMT_GET_RELEASES_BY_DELIVERY_ID() {
        return this.STMT_GET_RELEASES_BY_DELIVERY_ID;
    }

    public Seq<ReleaseBasicDataExt> findReleasesByDeliveryId(String deliveryId) {
        return this.sqlQuery(this.STMT_GET_RELEASES_BY_DELIVERY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(deliveryId))))})), (Function1 & Serializable)rs -> new ReleaseBasicDataExt(rs.getString(Schema.RELEASES$.MODULE$.RELEASE_ID()), rs.getString(Schema.RELEASES$.MODULE$.RELEASE_TITLE()), rs.getString(Schema.RELEASES$.MODULE$.STATUS()), (Date)rs.getTimestamp(Schema.RELEASES$.MODULE$.START_DATE()), (Date)rs.getTimestamp(Schema.RELEASES$.MODULE$.END_DATE()))).toSeq();
    }

    private RowMapper<DeliveryRow> deliveryRowMapper() {
        return this.deliveryRowMapper;
    }

    private String serialize(Delivery delivery) {
        MetadataIncludingCiConverter ciConverter = new MetadataIncludingCiConverter(null, null);
        Delivery deliveryCopy = (Delivery)CiCloneHelper.cloneCi((ConfigurationItem)delivery);
        deliveryCopy.setFolderId(null);
        String content = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)deliveryCopy, (ConfigurationItemConverter)ciConverter);
        return content;
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    @Autowired
    public DeliveryPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, FolderPersistence folderPersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.folderPersistence = folderPersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_GET_UID_BY_ID = new StringBuilder(26).append("SELECT ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID()).append(" FROM ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE()).append(" WHERE ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append(" = :id").toString();
        this.STMT_INSERT_RELEASE_DELIVERY = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(315).append("|INSERT INTO ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE()).append("\n        |   ( ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append("\n        |   , ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID()).append("\n        |   , ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE()).append("\n        |   , ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS()).append("\n        |   , ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE()).append("\n        |   , ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE()).append("\n        |   , ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ORIGIN_PATTERN_ID()).append("\n        |   , ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT()).append("\n        |   )\n        | VALUES\n        |   ( :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append("\n        |   , :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID()).append("\n        |   , :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE()).append("\n        |   , :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS()).append("\n        |   , :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE()).append("\n        |   , :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE()).append("\n        |   , :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ORIGIN_PATTERN_ID()).append("\n        |   , :").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT()).append("\n        |   )\n        ").toString()));
        this.STMT_UPDATE_RELEASE_DELIVERY = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(221).append("|UPDATE ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE()).append("\n        | SET\n        |  ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE()).append(" = :newTitle,\n        |  ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID()).append(" = :folderUid,\n        |  ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.STATUS()).append(" = :newStatus,\n        |  ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.START_DATE()).append(" = :newStartDate,\n        |  ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.END_DATE()).append(" = :newEndDate,\n        |  ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT()).append(" = :content\n        | WHERE\n        |  ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append(" = :id\n        ").toString()));
        this.STMT_DELETE_RELEASE_DELIVERY_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(36).append("|DELETE FROM ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE()).append("\n        | WHERE ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append(" = :id").toString()));
        this.STMT_EXISTS_RELEASE_DELIVERY_BY_ID = new StringBuilder(34).append("SELECT COUNT(*) FROM ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE()).append(" WHERE ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append(" = :id").toString();
        this.STMT_FIND_RELEASE_DELIVERY_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(26).append("|").append(DeliverySqlBuilder$.MODULE$.STMT_RELEASE_DELIVERY_SELECT()).append("\n        | WHERE del.").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append(" = ?").toString()));
        this.STMT_FIND_RELEASE_DELIVERY_BY_TITLE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(33).append("|").append(DeliverySqlBuilder$.MODULE$.STMT_RELEASE_DELIVERY_SELECT()).append("\n        | WHERE LOWER(del.").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TITLE()).append(") = ?").toString()));
        this.STMT_GET_FOLDER_ID_BY_DELIVERY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(103).append("| SELECT f.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append("\n        | FROM ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE()).append(" del\n        | INNER JOIN ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" f ON f.").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" = del.").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.FOLDER_UID()).append("\n        | WHERE del.").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append(" = :deliveryId").toString()));
        this.STMT_GET_RELEASES_BY_DELIVERY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(170).append("|SELECT rel.").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", rel.").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(", rel.").append(Schema.RELEASES$.MODULE$.STATUS()).append(", rel.").append(Schema.RELEASES$.MODULE$.START_DATE()).append(",\n        | rel.").append(Schema.RELEASES$.MODULE$.END_DATE()).append("\n        | FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).append(" rel\n        | LEFT JOIN ").append(DeliverySchema$RELEASE_DELIVERY_MEMBERS$.MODULE$.TABLE()).append(" m ON m.").append(DeliverySchema$RELEASE_DELIVERY_MEMBERS$.MODULE$.RELEASE_ID()).append(" = rel.").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append("\n        | INNER JOIN ").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.TABLE()).append(" d ON d.").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID()).append(" = m.").append(DeliverySchema$RELEASE_DELIVERY_MEMBERS$.MODULE$.DELIVERY_UID()).append("\n        | WHERE d.").append(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()).append(" = :deliveryId").toString()));
        this.deliveryRowMapper = (rs, x$6) -> {
            DeliveryRow deliveryRow;
            try (InputStream contentStream = rs.getBinaryStream(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CONTENT());){
                String content = this.decompress(contentStream);
                deliveryRow = new DeliveryRow(content, rs.getInt(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.CI_UID()), new FolderId(rs.getString(Schema.FOLDERS$.MODULE$.FOLDER_PATH())).$div(rs.getString(Schema.FOLDERS$.MODULE$.FOLDER_ID())), rs.getString(DeliverySchema$RELEASE_DELIVERIES$.MODULE$.ID()));
            }
            return deliveryRow;
        };
    }
}

