/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0001\r\u001dg\u0001\u0002\u001c8\u0001\tC\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003Y\u0011!q\u0006A!b\u0001\n\u0003y\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\u0019\u0004!Q1A\u0005\u0002\u001dD\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tY\u0002\u0011)\u0019!C\u0001[\"AA\u000f\u0001B\u0001B\u0003%a\u000e\u0003\u0005v\u0001\t\u0015\r\u0011\"\u0001w\u0011!Q\bA!A!\u0002\u00139\b\u0002C>\u0001\u0005\u000b\u0007I\u0011\u0001?\t\u0013\u0005-\u0001A!A!\u0002\u0013i\bBCA\u0007\u0001\t\u0015\r\u0011\"\u0001\u0002\u0010!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!!\u0005\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!a/\u0001\t\u0003\ti\fC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0005\u0003l\u0001\t\n\u0011\"\u0001\u0003n!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002B%\u0001\u0011\u0005!\u0011\u0014\u0005\b\u0005G\u0003A\u0011\u0001BS\u0011%\u0011\t\fAI\u0001\n\u0003\u0011\u0019\fC\u0004\u00038\u0002!\tA!/\t\u000f\t\r\u0007\u0001\"\u0001\u0003F\"9!1\u0019\u0001\u0005\u0002\te\u0007b\u0002Br\u0001\u0011\u0005!Q\u001d\u0005\b\u0005G\u0004A\u0011\u0001Bw\u0011\u001d\u0011)\u0010\u0001C\u0001\u0005oDqa!\u0001\u0001\t\u0013\u0019\u0019\u0001C\u0004\u0004\u001e\u0001!Iaa\b\t\u000f\r\r\u0002\u0001\"\u0003\u0004&!91\u0011\u0006\u0001\u0005\n\r-\u0002bBB\u0018\u0001\u0011%1\u0011\u0007\u0005\b\u0007\u007f\u0001A\u0011BB!\u0011\u001d\u0019)\u0005\u0001C\u0005\u0007\u000fB\u0011ba\u0014\u0001#\u0003%IAa-\t\u000f\rE\u0003\u0001\"\u0003\u0004T!91\u0011\r\u0001\u0005\n\r\r\u0004bBBO\u0001\u0011%1q\u0014\u0005\n\u0007O\u0003\u0011\u0013!C\u0005\u0007SCqa!,\u0001\t#\u001ayK\u0001\fEK2Lg/\u001a:z!\u0006$H/\u001a:o'\u0016\u0014h/[2f\u0015\tA\u0014(A\u0004tKJ4\u0018nY3\u000b\u0005iZ\u0014\u0001\u00033fY&4XM]=\u000b\u0005qj\u0014!\u0003=me\u0016dW-Y:f\u0015\tqt(A\u0005yK\nL\u0017\r\\1cg*\t\u0001)A\u0002d_6\u001c\u0001aE\u0002\u0001\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013a!\u00118z%\u00164\u0007C\u0001&L\u001b\u00059\u0014B\u0001'8\u0005Q!U\r\\5wKJL8+\u001a:wS\u000e,W\u000b^5mg\u0006\u0011B-\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*:\u0003)\u0011X\r]8tSR|'/_\u0005\u0003)F\u0013!\u0003R3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ss\u0006\u0019B-\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:zA\u0005\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0016\u0003a\u0003\"!W.\u000e\u0003iS!AU\u001e\n\u0005qS&!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0011\"/\u001a7fCN,'+\u001a9pg&$xN]=!\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016,\u0012\u0001\u0019\t\u0003C\u000el\u0011A\u0019\u0006\u0003qmJ!\u0001\u001a2\u0003\u001dI+G.Z1tKN+'O^5dK\u0006y!/\u001a7fCN,7+\u001a:wS\u000e,\u0007%A\u0006dS&#7+\u001a:wS\u000e,W#\u00015\u0011\u0005\u0005L\u0017B\u00016c\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002!\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001cX#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\\\u0014A\u00013c\u0013\t\u0019\bO\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\u0006\t\u0012M]2iSZ,GMU3mK\u0006\u001cXm\u001d\u0011\u0002\u001b\u0019|G\u000eZ3s'\u0016\u0014h/[2f+\u00059\bCA1y\u0013\tI(MA\u0007G_2$WM]*feZL7-Z\u0001\u000fM>dG-\u001a:TKJ4\u0018nY3!\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t\u0001b]3dkJLG/\u001f\u0006\u0004\u0003\u000bi\u0014\u0001\u00033fa2|\u00170\u001b;\n\u0007\u0005%qPA\u0006S_2,7+\u001a:wS\u000e,\u0017\u0001\u0004:pY\u0016\u001cVM\u001d<jG\u0016\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]1(\u0001\u0004fm\u0016tGo]\u0005\u0005\u00037\t)BA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)I\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u0011\u0005)\u0003\u0001\"B'\u0012\u0001\u0004y\u0005\"\u0002,\u0012\u0001\u0004A\u0006\"\u00020\u0012\u0001\u0004\u0001\u0007\"\u00024\u0012\u0001\u0004A\u0007\"\u00027\u0012\u0001\u0004q\u0007\"B;\u0012\u0001\u00049\b\"B>\u0012\u0001\u0004i\bbBA\u0007#\u0001\u0007\u0011\u0011\u0003\u0015\u0004#\u0005]\u0002\u0003BA\u001d\u0003\u001fj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u000bC:tw\u000e^1uS>t'\u0002BA!\u0003\u0007\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002F\u0005\u001d\u0013!\u00022fC:\u001c(\u0002BA%\u0003\u0017\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003\u001b\n1a\u001c:h\u0013\u0011\t\t&a\u000f\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AC4fiB\u000bG\u000f^3s]R!\u0011qKA3!\u0011\tI&!\u0019\u000e\u0005\u0005m#b\u0001\u001e\u0002^)\u0019\u0011qL\u001e\u0002\r\u0011|W.Y5o\u0013\u0011\t\u0019'a\u0017\u0003\u0011\u0011+G.\u001b<fefDq!a\u001a\u0013\u0001\u0004\tI'A\u0005qCR$XM\u001d8JIB!\u00111NA=\u001d\u0011\ti'!\u001e\u0011\u0007\u0005=T)\u0004\u0002\u0002r)\u0019\u00111O!\u0002\rq\u0012xn\u001c;?\u0013\r\t9(R\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]T\tK\u0002\u0013\u0003\u0003\u0003B!a!\u0002\u00106\u0011\u0011Q\u0011\u0006\u0005\u0003{\t9I\u0003\u0003\u0002\n\u0006-\u0015aB7fiJL7m\u001d\u0006\u0004\u0003\u001b{\u0014\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005E\u0015Q\u0011\u0002\u0006)&lW\rZ\u0001\u0016O\u0016$\b+\u0019;uKJt')_%e\u001fJ$\u0016\u000e\u001e7f)\u0011\t9&a&\t\u000f\u0005e5\u00031\u0001\u0002j\u0005\u0001\u0002/\u0019;uKJt\u0017\nZ(s)&$H.\u001a\u0015\u0004'\u0005\u0005\u0015AF3ySN$8\u000fU1ui\u0016\u0014hnV5uQRKG\u000f\\3\u0015\r\u0005\u0005\u0016qUAV!\r!\u00151U\u0005\u0004\u0003K+%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003S#\u0002\u0019AA5\u0003\tIG\rC\u0004\u0002.R\u0001\r!!\u001b\u0002\u000bQLG\u000f\\3)\u0007Q\t\t)A\u0007fq&\u001cHo\u001d)biR,'O\u001c\u000b\u0005\u0003C\u000b)\fC\u0004\u00028V\u0001\r!!\u001b\u0002\u0015\u0011,G.\u001b<fefLE\rK\u0002\u0016\u0003\u0003\u000bQc\u0019:fCR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002X\u0005}\u0006bBAa-\u0001\u0007\u0011qK\u0001\ba\u0006$H/\u001a:oQ\r1\u0012\u0011Q\u0001\u0016kB$\u0017\r^3EK2Lg/\u001a:z!\u0006$H/\u001a:o)\u0011\t9&!3\t\u000f\u0005-w\u00031\u0001\u0002X\u00059Q\u000f\u001d3bi\u0016$\u0007fA\f\u0002\u0002\u0006)B-\u001a7fi\u0016$U\r\\5wKJL\b+\u0019;uKJtG\u0003BAj\u00033\u00042\u0001RAk\u0013\r\t9.\u0012\u0002\u0005+:LG\u000fC\u0004\u0002ha\u0001\r!!\u001b)\u0007a\t\t)\u0001\rekBd\u0017nY1uK\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:$b!a\u0016\u0002b\u0006\r\bbBA43\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003KL\u0002\u0019AAt\u0003\u0019\u0001\u0018M]1ngB!\u0011\u0011^A|\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018!\u00024pe6\u001c(\u0002BAy\u0003g\f!A^\u0019\u000b\u0007\u0005U8(A\u0002ba&LA!!?\u0002l\nAB)\u001e9mS\u000e\fG/\u001a#fY&4XM]=QCR$XM\u001d8)\u0007e\t\t)A\rde\u0016\fG/\u001a#fY&4XM]=Ge>l\u0007+\u0019;uKJtGCBA,\u0005\u0003\u0011\u0019\u0001C\u0004\u0002hi\u0001\r!!\u001b\t\u000f\t\u0015!\u00041\u0001\u0003\b\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0011\t\u0005%(\u0011B\u0005\u0005\u0005\u0017\tYO\u0001\bDe\u0016\fG/\u001a#fY&4XM]=)\u0007i\t\t)\u0001\btK\u0006\u00148\r\u001b)biR,'O\\:\u0015\r\tM!1\u0005B\u0017!\u0019\u0011)Ba\b\u0002X5\u0011!q\u0003\u0006\u0005\u00053\u0011Y\"\u0001\u0003vi&d'B\u0001B\u000f\u0003\u0011Q\u0017M^1\n\t\t\u0005\"q\u0003\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003&m\u0001\rAa\n\u0002\u000f\u0019LG\u000e^3sgB!\u0011\u0011\u001eB\u0015\u0013\u0011\u0011Y#a;\u0003-\u0011+G.\u001b<fef\u0004\u0016\r\u001e;fe:4\u0015\u000e\u001c;feNDqAa\f\u001c\u0001\u0004\u0011\t$\u0001\u0003qC\u001e,\u0007cA-\u00034%\u0019!Q\u0007.\u0003\tA\u000bw-\u001a\u0015\u00047\u0005\u0005\u0015!C4fiN#\u0018mZ3t)\u0011\u0011iD!\u0012\u0011\r\tU!q\u0004B !\u0011\tIF!\u0011\n\t\t\r\u00131\f\u0002\u0006'R\fw-\u001a\u0005\b\u0003Ob\u0002\u0019AA5Q\ra\u0012\u0011Q\u0001\tC\u0012$7\u000b^1hKRA!q\bB'\u0005\u001f\u0012\u0019\u0006C\u0004\u0002hu\u0001\r!!\u001b\t\u000f\tES\u00041\u0001\u0003@\u0005)1\u000f^1hK\"I!QK\u000f\u0011\u0002\u0003\u0007!qK\u0001\ta>\u001c\u0018\u000e^5p]B1!Q\u0003B-\u0005;JAAa\u0017\u0003\u0018\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\u0011\u0011\u0019Ga\u0007\u0002\t1\fgnZ\u0005\u0005\u0005O\u0012\tGA\u0004J]R,w-\u001a:)\u0007u\t\t)\u0001\nbI\u0012\u001cF/Y4fI\u0011,g-Y;mi\u0012\u001aTC\u0001B8U\u0011\u00119F!\u001d,\u0005\tM\u0004\u0003\u0002B;\u0005{j!Aa\u001e\u000b\t\te$1P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0010F\u0013\u0011\u0011yHa\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbI\u0012\u001cF/Y4f\u0005\u0016$x/Z3o))\u0011yD!\"\u0003\b\n%%1\u0013\u0005\b\u0003Oz\u0002\u0019AA5\u0011\u001d\u0011\tf\ba\u0001\u0005\u007fAqAa# \u0001\u0004\u0011i)\u0001\u0004cK\u001a|'/\u001a\t\u0006\t\n=\u0015\u0011N\u0005\u0004\u0005#+%AB(qi&|g\u000eC\u0004\u0003\u0016~\u0001\rA!$\u0002\u000b\u00054G/\u001a:)\u0007}\t\t\t\u0006\u0005\u0003@\tm%Q\u0014BP\u0011\u001d\t\t\r\ta\u0001\u0003/BqA!\u0015!\u0001\u0004\u0011y\u0004C\u0004\u0003V\u0001\u0002\rAa\u0016)\u0007\u0001\n\t)A\u0006va\u0012\fG/Z*uC\u001e,G\u0003\u0003B \u0005O\u0013IKa+\t\u000f\u0005\u001d\u0014\u00051\u0001\u0002j!9\u00111Z\u0011A\u0002\t}\u0002\"\u0003BWCA\u0005\t\u0019AAQ\u0003%1'o\\7CCR\u001c\u0007\u000eK\u0002\"\u0003\u0003\u000bQ#\u001e9eCR,7\u000b^1hK\u0012\"WMZ1vYR$3'\u0006\u0002\u00036*\"\u0011\u0011\u0015B9\u0003-!W\r\\3uKN#\u0018mZ3\u0015\r\u0005M'1\u0018B_\u0011\u001d\t9g\ta\u0001\u0003SBqAa0$\u0001\u0004\tI'A\u0004ti\u0006<W-\u00133)\u0007\r\n\t)A\u0007bI\u0012$&/\u00198tSRLwN\u001c\u000b\t\u0005\u000f\u0014iMa4\u0003TB!\u0011\u0011\fBe\u0013\u0011\u0011Y-a\u0017\u0003\u0015Q\u0013\u0018M\\:ji&|g\u000eC\u0004\u0002h\u0011\u0002\r!!\u001b\t\u000f\tEG\u00051\u0001\u0002j\u0005q1\u000f^1hK&#wJ\u001d+ji2,\u0007b\u0002BkI\u0001\u0007!qY\u0001\u000biJ\fgn]5uS>t\u0007f\u0001\u0013\u0002\u0002RA!q\u0019Bn\u0005;\u0014y\u000eC\u0004\u0002B\u0016\u0002\r!a\u0016\t\u000f\tEW\u00051\u0001\u0002j!9!Q[\u0013A\u0002\t\u001d\u0007fA\u0013\u0002\u0002\u0006\u0001R\u000f\u001d3bi\u0016$&/\u00198tSRLwN\u001c\u000b\u0007\u0005\u000f\u00149O!;\t\u000f\u0005\u001dd\u00051\u0001\u0002j!9\u00111\u001a\u0014A\u0002\t\u001d\u0007f\u0001\u0014\u0002\u0002R1!q\u0019Bx\u0005cDq!!1(\u0001\u0004\t9\u0006C\u0004\u0002L\u001e\u0002\rAa2)\u0007\u001d\n\t)\u0001\teK2,G/\u001a+sC:\u001c\u0018\u000e^5p]R1\u00111\u001bB}\u0005wDq!a\u001a)\u0001\u0004\tI\u0007C\u0004\u0003~\"\u0002\r!!\u001b\u0002\u0019Q\u0014\u0018M\\:ji&|g.\u00133)\u0007!\n\t)\u0001\rhK:,'/\u0019;f)&$H.Z%g\u001d\u0016\u001cWm]:bef$b!a5\u0004\u0006\r\u001d\u0001b\u0002B)S\u0001\u0007!q\b\u0005\b\u0007\u0013I\u0003\u0019AB\u0006\u0003\u0019\u0019H/Y4fgB11QBB\f\u0005\u007fqAaa\u0004\u0004\u00149!\u0011qNB\t\u0013\u00051\u0015bAB\u000b\u000b\u00069\u0001/Y2lC\u001e,\u0017\u0002BB\r\u00077\u00111aU3r\u0015\r\u0019)\"R\u0001\u000fG\",7m[%t!\u0006$H/\u001a:o)\u0011\t\u0019n!\t\t\riR\u0003\u0019AA,\u0003=1\u0018\r\\5eCR,\u0007+\u0019;uKJtG\u0003BAj\u0007OAaAO\u0016A\u0002\u0005]\u0013\u0001\n<bY&$\u0017\r^3Ti\u0006<Wm]!oIR\u0013\u0018M\\:ji&|gn]!oI&#X-\\:\u0015\t\u0005M7Q\u0006\u0005\b\u0003\u0003d\u0003\u0019AA,\u0003A1\u0018\r\\5eCR,g*Z<Ti\u0006<W\r\u0006\u0005\u0002T\u000eM2QGB\u001c\u0011\u001d\u0019I!\fa\u0001\u0007\u0017AqA!\u0015.\u0001\u0004\u0011y\u0004C\u0004\u0003V5\u0002\ra!\u000f\u0011\u0007\u0011\u001bY$C\u0002\u0004>\u0015\u00131!\u00138u\u0003]1\u0018\r\\5eCR,7\u000b^1hKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002T\u000e\r\u0003b\u0002B)]\u0001\u0007!qH\u0001\re\u0016\u001cX\r\u001e)biR,'O\u001c\u000b\u0007\u0003'\u001cIea\u0013\t\u000f\u0005\u0005w\u00061\u0001\u0002X!I1QJ\u0018\u0011\u0002\u0003\u0007\u0011\u0011U\u0001\fM>\u00148-\u001a(fo&#7/\u0001\fsKN,G\u000fU1ui\u0016\u0014h\u000e\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0011Xm]3u\u0007>tG-\u001b;j_:$b!a5\u0004V\r]\u0003b\u0002Bkc\u0001\u0007!q\u0019\u0005\b\u00073\n\u0004\u0019AB.\u0003%\u0019wN\u001c3ji&|g\u000e\u0005\u0003\u0002Z\ru\u0013\u0002BB0\u00037\u0012\u0011bQ8oI&$\u0018n\u001c8\u0002%\u001d,g.\u001a:bi\u0016|%/\u00169eCR,\u0017\nZ\u000b\u0005\u0007K\u001ai\b\u0006\u0006\u0004h\r=51SBL\u00077#B!!\u001b\u0004j!I11\u000e\u001a\u0002\u0002\u0003\u000f1QN\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBB8\u0007k\u001aI(\u0004\u0002\u0004r)\u001911O#\u0002\u000fI,g\r\\3di&!1qOB9\u0005!\u0019E.Y:t)\u0006<\u0007\u0003BB>\u0007{b\u0001\u0001B\u0004\u0004\u0000I\u0012\ra!!\u0003\u0003Q\u000bBaa!\u0004\nB\u0019Ai!\"\n\u0007\r\u001dUIA\u0004O_RD\u0017N\\4\u0011\u0007\u0011\u001bY)C\u0002\u0004\u000e\u0016\u00131!\u00118z\u0011\u001d\u0019\tJ\ra\u0001\u0003S\n!\"\u001a=jgRLgnZ%e\u0011\u001d\u0019)J\ra\u0001\u0003S\n1b\u001c7e!\u0006\u0014XM\u001c;JI\"91\u0011\u0014\u001aA\u0002\u0005%\u0014a\u00038foB\u000b'/\u001a8u\u0013\u0012Dqa!\u00143\u0001\u0004\t\t+\u0001\u000bbYJ,\u0017\rZ=Fq&\u001cHo\u001d\"z)&$H.\u001a\u000b\u0007\u0003C\u001b\tk!*\t\u000f\r\r6\u00071\u0001\u0002j\u0005a\u0001/\u0019;uKJtG+\u001b;mK\"I\u0011qM\u001a\u0011\u0002\u0003\u0007\u0011\u0011N\u0001\u001fC2\u0014X-\u00193z\u000bbL7\u000f^:CsRKG\u000f\\3%I\u00164\u0017-\u001e7uII*\"aa++\t\u0005%$\u0011O\u0001\u0011G\",7m[%t+B$\u0017\r^1cY\u0016$b!a5\u00042\u000eU\u0006bBBZk\u0001\u0007\u0011qK\u0001\u0011KbL7\u000f^5oO\u0012+G.\u001b<fefD\u0011ba.6!\u0003\u0005\r!!\u001b\u0002\r\u0005\u001cG/[8oQ\r\u000111\u0018\t\u0005\u0007{\u001b\u0019-\u0004\u0002\u0004@*!1\u0011YA$\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007\u000b\u001cyLA\u0004TKJ4\u0018nY3")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var3_6;
        Delivery delivery;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getDeliveryOrPattern(patternIdOrTitle));
        if (try_ instanceof Success) {
            Delivery value;
            Success success = (Success)try_;
            delivery = value = (Delivery)((Object)success.value());
        } else if (try_ instanceof Failure) {
            delivery = this.deliveryRepository().findPatternByTitle(patternIdOrTitle);
        } else {
            throw new MatchError((Object)try_);
        }
        Delivery pattern = delivery;
        this.checkIsPattern(pattern);
        return var3_6;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetPattern(pattern, this.resetPattern$default$2());
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = new StringOps(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$")).r();
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])c)).head()).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = new StringOps(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1))).toInt();
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(((Object)BoxesRunTime.boxToInteger((int)(++orderNumber))).toString()).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        if (parameters.getFolderId() != null) {
            delivery.setFolderId(parameters.getFolderId());
        }
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public java.util.List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public java.util.List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Optional<Integer> position) {
        return this.addStage(this.getPattern(patternId), stage, position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Timed
    public Stage addStageBetween(String patternId, Stage stage, Option<String> before, Option<String> after) {
        Stage stage2;
        Delivery pattern = this.getPattern(patternId);
        Option beforeIndex = before.map(DeliveryPatternService.getStageIndex$1(pattern));
        Option afterIndex = after.map(DeliveryPatternService.getStageIndex$1(pattern));
        if (before.isDefined()) {
            if (after.isDefined()) {
                if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != BoxesRunTime.unboxToInt((Object)beforeIndex.get()) - 1) throw new LogFriendlyConcurrentModificationException("Unable to add stage between %s and %s, because these two stages are not neighbors any more", new Object[]{after.get(), before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)beforeIndex.get()))));
                return stage2;
            } else {
                if (BoxesRunTime.unboxToInt((Object)beforeIndex.get()) != 0) throw new LogFriendlyConcurrentModificationException("Unable to add first stage before %s, because it is not first stage of delivery pattern any more", new Object[]{before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(0)));
            }
            return stage2;
        } else if (after.isDefined()) {
            if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != pattern.getStages().size() - 1) throw new LogFriendlyConcurrentModificationException("Unable to add last stage after %s, because it is not last stage of the delivery pattern any more", new Object[]{after.get()});
            stage2 = this.addStage(pattern, stage, Optional.empty());
            return stage2;
        } else {
            if (!pattern.getStages().isEmpty()) throw new LogFriendlyConcurrentModificationException("Unable to add first stage to the pattern, because pattern is not empty any more", new Object[0]);
            stage2 = this.addStage(pattern, stage, Optional.empty());
        }
        return stage2;
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage, Optional<Integer> position) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.generateTitleIfNecessary(stage, (Seq<Stage>)stages);
        Integer realPosition = position.orElse(Predef$.MODULE$.int2Integer(stages.size()));
        this.validateStageProperties(stage);
        this.validateNewStage((Seq<Stage>)stages, stage, Predef$.MODULE$.Integer2int(realPosition));
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, Predef$.MODULE$.Integer2int(realPosition));
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    public Optional<Integer> addStage$default$3() {
        return Optional.empty();
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated, boolean fromBatch) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStageProperties(updated);
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        if (!fromBatch) {
            this.validateNewStage((Seq<Stage>)stages.$minus$minus((GenTraversableOnce)new .colon.colon((Object)original, (List)Nil$.MODULE$)), updated, stages.indexOf((Object)original));
        }
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    public boolean updateStage$default$3() {
        return false;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        if (stage.getTransition() != null) {
            throw new LogFriendlyConcurrentModificationException("There is already a transition named '%s' associated with stage '%s'", new Object[]{stage.getTransition().getTitle(), stage.getTitle()});
        }
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)((Object)x$2)));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)((Object)updated), (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)((Object)x$3)));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties((Stage)((Object)stage));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateStages = (Buffer)((SeqLike)stageTitles.diff((GenSeq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle().toLowerCase(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateItems = (Buffer)((SeqLike)trackedItemTitles.diff((GenSeq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(Seq<Stage> stages, Stage stage, int position) {
        Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        Checks.checkArgument((!stages.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Stage stage) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    private void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$addStageBetween$2(String folderlessId$1, Tuple2 t) {
        return Ids.getName((String)((BaseConfigurationItem)t._1()).getId()).equals(folderlessId$1);
    }

    public static final /* synthetic */ int $anonfun$addStageBetween$1(Delivery pattern$2, String id) {
        String folderlessId = Ids.getName((String)id);
        return ((Tuple2)((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern$2.getStages()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$addStageBetween$2(folderlessId, t))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyConcurrentModificationException("Stage %s not found", new Object[]{id});
        }))._2$mcI$sp();
    }

    private static final Function1 getStageIndex$1(Delivery pattern$2) {
        return (Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToInteger((int)DeliveryPatternService.$anonfun$addStageBetween$1(pattern$2, id));
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

