/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatingEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.StageUpdatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionRemovedEvent;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0001\r}f\u0001B\u001b7\u0001\u0005C\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005\u001d\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003X\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0015\u0004!Q1A\u0005\u0002\u0019D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u0002\u0011)\u0019!C\u0001Y\"A1\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011!I\bA!A!\u0002\u00131\b\u0002\u0003>\u0001\u0005\u000b\u0007I\u0011A>\t\u0013\u0005%\u0001A!A!\u0002\u0013a\bBCA\u0006\u0001\t\u0015\r\u0011\"\u0001\u0002\u000e!Q\u00111\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!!/\u0001\t\u0003\tY\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007bBA~\u0001\u0011\u0005\u0011Q \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sAqAa\u0012\u0001\t\u0003\u0011I\u0005C\u0005\u0003j\u0001\t\n\u0011\"\u0001\u0003l!9!q\u0010\u0001\u0005\u0002\t\u0005\u0005b\u0002B$\u0001\u0011\u0005!q\u0013\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011Y\u000b\u0001C\u0001\u0005[CqAa.\u0001\t\u0003\u0011I\fC\u0004\u00038\u0002!\tA!4\t\u000f\t]\u0007\u0001\"\u0001\u0003Z\"9!q\u001b\u0001\u0005\u0002\t\u0005\bb\u0002Bu\u0001\u0011\u0005!1\u001e\u0005\b\u0005k\u0004A\u0011\u0002B|\u0011\u001d\u0019\t\u0002\u0001C\u0005\u0007'Aqaa\u0006\u0001\t\u0013\u0019I\u0002C\u0004\u0004\u001e\u0001!Iaa\b\t\u000f\r\r\u0002\u0001\"\u0003\u0004&!911\u0007\u0001\u0005\n\rU\u0002bBB\u001d\u0001\u0011%11\b\u0005\n\u0007\u0007\u0002\u0011\u0013!C\u0005\u0007\u000bBqa!\u0013\u0001\t\u0013\u0019Y\u0005C\u0004\u0004Z\u0001!Iaa\u0017\t\u000f\rU\u0005\u0001\"\u0003\u0004\u0018\"I1q\u0014\u0001\u0012\u0002\u0013%1\u0011\u0015\u0005\b\u0007K\u0003A\u0011KBT\u0005Y!U\r\\5wKJL\b+\u0019;uKJt7+\u001a:wS\u000e,'BA\u001c9\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u000f\u001e\u0002\u0011\u0011,G.\u001b<fefT!a\u000f\u001f\u0002\u0013ad'/\u001a7fCN,'BA\u001f?\u0003%AXMY5bY\u0006\u00147OC\u0001@\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\t\u0013\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%SU\"\u0001\u001c\n\u0005-3$\u0001\u0006#fY&4XM]=TKJ4\u0018nY3Vi&d7/\u0001\neK2Lg/\u001a:z%\u0016\u0004xn]5u_JLX#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005EC\u0014A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\u000b\u0015\u0002\u0013\t\u0016d\u0017N^3ssJ+\u0007o\\:ji>\u0014\u00180A\neK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\b%A\tsK2,\u0017m]3SKB|7/\u001b;pef,\u0012a\u0016\t\u00031jk\u0011!\u0017\u0006\u0003#jJ!aW-\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\nsK2,\u0017m]3SKB|7/\u001b;pef\u0004\u0013A\u0004:fY\u0016\f7/Z*feZL7-Z\u000b\u0002?B\u0011\u0001MY\u0007\u0002C*\u0011qGO\u0005\u0003G\u0006\u0014aBU3mK\u0006\u001cXmU3sm&\u001cW-A\bsK2,\u0017m]3TKJ4\u0018nY3!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0003\u001d\u0004\"\u0001\u00195\n\u0005%\f'aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fAbY5JIN+'O^5dK\u0002\n\u0001#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0016\u00035\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\u001e\u0002\u0005\u0011\u0014\u0017B\u0001:p\u0005A\t%o\u00195jm\u0016$'+\u001a7fCN,7/A\tbe\u000eD\u0017N^3e%\u0016dW-Y:fg\u0002\nQBZ8mI\u0016\u00148+\u001a:wS\u000e,W#\u0001<\u0011\u0005\u0001<\u0018B\u0001=b\u000551u\u000e\u001c3feN+'O^5dK\u0006qam\u001c7eKJ\u001cVM\u001d<jG\u0016\u0004\u0013a\u0003:pY\u0016\u001cVM\u001d<jG\u0016,\u0012\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0005tK\u000e,(/\u001b;z\u0015\r\t\u0019\u0001P\u0001\tI\u0016\u0004Hn\\=ji&\u0019\u0011q\u0001@\u0003\u0017I{G.Z*feZL7-Z\u0001\re>dWmU3sm&\u001cW\rI\u0001\tKZ,g\u000e\u001e\"vgV\u0011\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u001e\u0002\r\u00154XM\u001c;t\u0013\u0011\tI\"a\u0005\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u00051A(\u001b8jiz\"\"#!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022A\u0011\u0011\n\u0001\u0005\u0006\u0019F\u0001\rA\u0014\u0005\u0006+F\u0001\ra\u0016\u0005\u0006;F\u0001\ra\u0018\u0005\u0006KF\u0001\ra\u001a\u0005\u0006WF\u0001\r!\u001c\u0005\u0006iF\u0001\rA\u001e\u0005\u0006uF\u0001\r\u0001 \u0005\b\u0003\u0017\t\u0002\u0019AA\bQ\r\t\u0012Q\u0007\t\u0005\u0003o\ti%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u007f\t\t%A\u0004gC\u000e$xN]=\u000b\t\u0005\r\u0013QI\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003\u000f\nI%A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tY%A\u0002pe\u001eLA!a\u0014\u0002:\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u000bO\u0016$\b+\u0019;uKJtG\u0003BA+\u0003G\u0002B!a\u0016\u0002`5\u0011\u0011\u0011\f\u0006\u0004s\u0005m#bAA/u\u00051Am\\7bS:LA!!\u0019\u0002Z\tAA)\u001a7jm\u0016\u0014\u0018\u0010C\u0004\u0002fI\u0001\r!a\u001a\u0002\u0013A\fG\u000f^3s]&#\u0007\u0003BA5\u0003orA!a\u001b\u0002tA\u0019\u0011Q\u000e#\u000e\u0005\u0005=$bAA9\u0001\u00061AH]8pizJ1!!\u001eE\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011PA>\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000f#)\u0007I\ty\b\u0005\u0003\u0002\u0002\u00065UBAAB\u0015\u0011\tY$!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\b[\u0016$(/[2t\u0015\r\tYIP\u0001\tG>$\u0017\r[1mK&!\u0011qRAB\u0005\u0015!\u0016.\\3e\u0003U9W\r\u001e)biR,'O\u001c\"z\u0013\u0012|%\u000fV5uY\u0016$B!!\u0016\u0002\u0016\"9\u0011qS\nA\u0002\u0005\u001d\u0014\u0001\u00059biR,'O\\%e\u001fJ$\u0016\u000e\u001e7fQ\r\u0019\u0012qP\u0001\u0017KbL7\u000f^:QCR$XM\u001d8XSRDG+\u001b;mKR1\u0011qTAS\u0003S\u00032aQAQ\u0013\r\t\u0019\u000b\u0012\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\u000b\u0006a\u0001\u0003O\n!!\u001b3\t\u000f\u0005-F\u00031\u0001\u0002h\u0005)A/\u001b;mK\"\u001aA#a \u0002\u001b\u0015D\u0018n\u001d;t!\u0006$H/\u001a:o)\u0011\ty*a-\t\u000f\u0005UV\u00031\u0001\u0002h\u0005QA-\u001a7jm\u0016\u0014\u00180\u00133)\u0007U\ty(A\u000bde\u0016\fG/\u001a#fY&4XM]=QCR$XM\u001d8\u0015\t\u0005U\u0013Q\u0018\u0005\b\u0003\u007f3\u0002\u0019AA+\u0003\u001d\u0001\u0018\r\u001e;fe:D3AFA@\u0003U)\b\u000fZ1uK\u0012+G.\u001b<fef\u0004\u0016\r\u001e;fe:$B!!\u0016\u0002H\"9\u0011\u0011Z\fA\u0002\u0005U\u0013aB;qI\u0006$X\r\u001a\u0015\u0004/\u0005}\u0014!\u00063fY\u0016$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u0003#\f9\u000eE\u0002D\u0003'L1!!6E\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002h!\u001a\u0001$a \u00021\u0011,\b\u000f\\5dCR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0004\u0002V\u0005}\u0017\u0011\u001d\u0005\b\u0003KJ\u0002\u0019AA4\u0011\u001d\t\u0019/\u0007a\u0001\u0003K\fa\u0001]1sC6\u001c\b\u0003BAt\u0003kl!!!;\u000b\t\u0005-\u0018Q^\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0003_\f\t0\u0001\u0002wc)\u0019\u00111\u001f\u001e\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002x\u0006%(\u0001\u0007#va2L7-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]\"\u001a\u0011$a \u00023\r\u0014X-\u0019;f\t\u0016d\u0017N^3ss\u001a\u0013x.\u001c)biR,'O\u001c\u000b\u0007\u0003+\nyP!\u0001\t\u000f\u0005\u0015$\u00041\u0001\u0002h!9!1\u0001\u000eA\u0002\t\u0015\u0011A\u00039be\u0006lW\r^3sgB!\u0011q\u001dB\u0004\u0013\u0011\u0011I!!;\u0003\u001d\r\u0013X-\u0019;f\t\u0016d\u0017N^3ss\"\u001a!$a \u0002\u001dM,\u0017M]2i!\u0006$H/\u001a:ogR1!\u0011\u0003B\u0011\u0005W\u0001bAa\u0005\u0003\u001e\u0005USB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u00057\tAA[1wC&!!q\u0004B\u000b\u0005\u0011a\u0015n\u001d;\t\u000f\t\r2\u00041\u0001\u0003&\u00059a-\u001b7uKJ\u001c\b\u0003BAt\u0005OIAA!\u000b\u0002j\n1B)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014hNR5mi\u0016\u00148\u000fC\u0004\u0003.m\u0001\rAa\f\u0002\tA\fw-\u001a\t\u00041\nE\u0012b\u0001B\u001a3\n!\u0001+Y4fQ\rY\u0012qP\u0001\nO\u0016$8\u000b^1hKN$BAa\u000f\u0003DA1!1\u0003B\u000f\u0005{\u0001B!a\u0016\u0003@%!!\u0011IA-\u0005\u0015\u0019F/Y4f\u0011\u001d\t)\u0007\ba\u0001\u0003OB3\u0001HA@\u0003!\tG\rZ*uC\u001e,G\u0003\u0003B\u001f\u0005\u0017\u0012iE!\u0015\t\u000f\u0005\u0015T\u00041\u0001\u0002h!9!qJ\u000fA\u0002\tu\u0012!B:uC\u001e,\u0007\"\u0003B*;A\u0005\t\u0019\u0001B+\u0003!\u0001xn]5uS>t\u0007C\u0002B\n\u0005/\u0012Y&\u0003\u0003\u0003Z\tU!\u0001C(qi&|g.\u00197\u0011\t\tu#1M\u0007\u0003\u0005?RAA!\u0019\u0003\u001a\u0005!A.\u00198h\u0013\u0011\u0011)Ga\u0018\u0003\u000f%sG/Z4fe\"\u001aQ$a \u0002%\u0005$Gm\u0015;bO\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0005[RCA!\u0016\u0003p-\u0012!\u0011\u000f\t\u0005\u0005g\u0012Y(\u0004\u0002\u0003v)!!q\u000fB=\u0003%)hn\u00195fG.,GMC\u0002\u0002<\u0011KAA! \u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005$Gm\u0015;bO\u0016\u0014U\r^<fK:$\"B!\u0010\u0003\u0004\n\u0015%q\u0011BI\u0011\u001d\t)g\ba\u0001\u0003OBqAa\u0014 \u0001\u0004\u0011i\u0004C\u0004\u0003\n~\u0001\rAa#\u0002\r\t,gm\u001c:f!\u0015\u0019%QRA4\u0013\r\u0011y\t\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\tMu\u00041\u0001\u0003\f\u0006)\u0011M\u001a;fe\"\u001aq$a \u0015\u0011\tu\"\u0011\u0014BN\u0005;Cq!a0!\u0001\u0004\t)\u0006C\u0004\u0003P\u0001\u0002\rA!\u0010\t\u000f\tM\u0003\u00051\u0001\u0003V!\u001a\u0001%a \u0002\u0017U\u0004H-\u0019;f'R\fw-\u001a\u000b\u0007\u0005{\u0011)Ka*\t\u000f\u0005\u0015\u0014\u00051\u0001\u0002h!9\u0011\u0011Z\u0011A\u0002\tu\u0002fA\u0011\u0002\u0000\u0005YA-\u001a7fi\u0016\u001cF/Y4f)\u0019\t\tNa,\u00032\"9\u0011Q\r\u0012A\u0002\u0005\u001d\u0004b\u0002BZE\u0001\u0007\u0011qM\u0001\bgR\fw-Z%eQ\r\u0011\u0013qP\u0001\u000eC\u0012$GK]1og&$\u0018n\u001c8\u0015\u0011\tm&\u0011\u0019Bb\u0005\u000f\u0004B!a\u0016\u0003>&!!qXA-\u0005)!&/\u00198tSRLwN\u001c\u0005\b\u0003K\u001a\u0003\u0019AA4\u0011\u001d\u0011)m\ta\u0001\u0003O\nab\u001d;bO\u0016LEm\u0014:USRdW\rC\u0004\u0003J\u000e\u0002\rAa/\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000eK\u0002$\u0003\u007f\"\u0002Ba/\u0003P\nE'1\u001b\u0005\b\u0003\u007f#\u0003\u0019AA+\u0011\u001d\u0011)\r\na\u0001\u0003OBqA!3%\u0001\u0004\u0011Y\fK\u0002%\u0003\u007f\n\u0001#\u001e9eCR,GK]1og&$\u0018n\u001c8\u0015\r\tm&1\u001cBo\u0011\u001d\t)'\na\u0001\u0003OBq!!3&\u0001\u0004\u0011Y\fK\u0002&\u0003\u007f\"bAa/\u0003d\n\u0015\bbBA`M\u0001\u0007\u0011Q\u000b\u0005\b\u0003\u00134\u0003\u0019\u0001B^Q\r1\u0013qP\u0001\u0011I\u0016dW\r^3Ue\u0006t7/\u001b;j_:$b!!5\u0003n\n=\bbBA3O\u0001\u0007\u0011q\r\u0005\b\u0005c<\u0003\u0019AA4\u00031!(/\u00198tSRLwN\\%eQ\r9\u0013qP\u0001\u0019O\u0016tWM]1uKRKG\u000f\\3JM:+7-Z:tCJLHCBAi\u0005s\u0014Y\u0010C\u0004\u0003P!\u0002\rA!\u0010\t\u000f\tu\b\u00061\u0001\u0003\u0000\u000611\u000f^1hKN\u0004ba!\u0001\u0004\f\tub\u0002BB\u0002\u0007\u000fqA!!\u001c\u0004\u0006%\tQ)C\u0002\u0004\n\u0011\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0004\u000e\r=!aA*fc*\u00191\u0011\u0002#\u0002\u001d\rDWmY6JgB\u000bG\u000f^3s]R!\u0011\u0011[B\u000b\u0011\u0019I\u0014\u00061\u0001\u0002V\u0005ya/\u00197jI\u0006$X\rU1ui\u0016\u0014h\u000e\u0006\u0003\u0002R\u000em\u0001BB\u001d+\u0001\u0004\t)&\u0001\u0013wC2LG-\u0019;f'R\fw-Z:B]\u0012$&/\u00198tSRLwN\\:B]\u0012LE/Z7t)\u0011\t\tn!\t\t\u000f\u0005}6\u00061\u0001\u0002V\u0005\u0001b/\u00197jI\u0006$XMT3x'R\fw-\u001a\u000b\t\u0003#\u001c9c!\u000b\u0004,!9!Q \u0017A\u0002\t}\bb\u0002B(Y\u0001\u0007!Q\b\u0005\b\u0005'b\u0003\u0019AB\u0017!\r\u00195qF\u0005\u0004\u0007c!%aA%oi\u00069b/\u00197jI\u0006$Xm\u0015;bO\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003#\u001c9\u0004C\u0004\u0003P5\u0002\rA!\u0010\u0002\u0019I,7/\u001a;QCR$XM\u001d8\u0015\r\u0005E7QHB \u0011\u001d\tyL\fa\u0001\u0003+B\u0011b!\u0011/!\u0003\u0005\r!a(\u0002\u0017\u0019|'oY3OK^LEm]\u0001\u0017e\u0016\u001cX\r\u001e)biR,'O\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\t\u0016\u0005\u0003?\u0013y'\u0001\bsKN,GoQ8oI&$\u0018n\u001c8\u0015\r\u0005E7QJB(\u0011\u001d\u0011I\r\ra\u0001\u0005wCqa!\u00151\u0001\u0004\u0019\u0019&A\u0005d_:$\u0017\u000e^5p]B!\u0011qKB+\u0013\u0011\u00199&!\u0017\u0003\u0013\r{g\u000eZ5uS>t\u0017AE4f]\u0016\u0014\u0018\r^3PeV\u0003H-\u0019;f\u0013\u0012,Ba!\u0018\u0004vQQ1qLBD\u0007\u0017\u001byia%\u0015\t\u0005\u001d4\u0011\r\u0005\n\u0007G\n\u0014\u0011!a\u0002\u0007K\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\u00199g!\u001c\u0004r5\u00111\u0011\u000e\u0006\u0004\u0007W\"\u0015a\u0002:fM2,7\r^\u0005\u0005\u0007_\u001aIG\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\u0019\u0019h!\u001e\r\u0001\u001191qO\u0019C\u0002\re$!\u0001+\u0012\t\rm4\u0011\u0011\t\u0004\u0007\u000eu\u0014bAB@\t\n9aj\u001c;iS:<\u0007cA\"\u0004\u0004&\u00191Q\u0011#\u0003\u0007\u0005s\u0017\u0010C\u0004\u0004\nF\u0002\r!a\u001a\u0002\u0015\u0015D\u0018n\u001d;j]\u001eLE\rC\u0004\u0004\u000eF\u0002\r!a\u001a\u0002\u0017=dG\rU1sK:$\u0018\n\u001a\u0005\b\u0007#\u000b\u0004\u0019AA4\u0003-qWm\u001e)be\u0016tG/\u00133\t\u000f\r\u0005\u0013\u00071\u0001\u0002 \u0006!\u0012\r\u001c:fC\u0012LX\t_5tiN\u0014\u0015\u0010V5uY\u0016$b!a(\u0004\u001a\u000eu\u0005bBBNe\u0001\u0007\u0011qM\u0001\ra\u0006$H/\u001a:o)&$H.\u001a\u0005\n\u0003K\u0012\u0004\u0013!a\u0001\u0003O\na$\u00197sK\u0006$\u00170\u0012=jgR\u001c()\u001f+ji2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\r&\u0006BA4\u0005_\n\u0001c\u00195fG.L5/\u00169eCR\f'\r\\3\u0015\r\u0005E7\u0011VBW\u0011\u001d\u0019Y\u000b\u000ea\u0001\u0003+\n\u0001#\u001a=jgRLgn\u001a#fY&4XM]=\t\u0013\r=F\u0007%AA\u0002\u0005\u001d\u0014AB1di&|g\u000eK\u0002\u0001\u0007g\u0003Ba!.\u0004<6\u00111q\u0017\u0006\u0005\u0007s\u000b)%\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAa!0\u00048\n91+\u001a:wS\u000e,\u0007")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryObjectFactory factory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        DeliveryServiceUtils.validateTransition$(this, delivery, stage, transition);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public DeliveryObjectFactory factory() {
        return this.factory;
    }

    @Override
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory x$1) {
        this.factory = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetPattern(pattern, this.resetPattern$default$2());
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.factory().stageId(pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.validateStagesAndTransitionsAndItems(pattern);
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetPattern(pattern, true);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            Option option;
            Regex regExp = new StringOps(Predef$.MODULE$.augmentString("\\(([0-9]+)\\)$")).r();
            String[] c = regExp.split((CharSequence)pattern.getTitle());
            if (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])c)).head()).length() == pattern.getTitle().length()) {
                pattern.setTitle(new StringBuilder(4).append(pattern.getTitle()).append(" (0)").toString());
            }
            if ((option = regExp.findFirstIn((CharSequence)pattern.getTitle())) instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                int orderNumber = new StringOps(Predef$.MODULE$.augmentString(value.substring(1, value.length() - 1))).toInt();
                do {
                    String newTitle = regExp.replaceAllIn((CharSequence)pattern.getTitle(), new StringBuilder(2).append("(").append(((Object)BoxesRunTime.boxToInteger((int)(++orderNumber))).toString()).append(")").toString());
                    pattern.setTitle(newTitle);
                } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && orderNumber < 100);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.validatePattern(pattern);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetPattern(delivery, this.resetPattern$default$2());
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        if (parameters.getFolderId() != null) {
            delivery.setFolderId(parameters.getFolderId());
        }
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatingEvent(startedDelivery));
        this.deliveryRepository().create(startedDelivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(startedDelivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public java.util.List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public java.util.List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Optional<Integer> position) {
        return this.addStage(this.getPattern(patternId), stage, position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Timed
    public Stage addStageBetween(String patternId, Stage stage, Option<String> before, Option<String> after) {
        Stage stage2;
        Delivery pattern = this.getPattern(patternId);
        Option beforeIndex = before.map(DeliveryPatternService.getStageIndex$1(pattern));
        Option afterIndex = after.map(DeliveryPatternService.getStageIndex$1(pattern));
        if (before.isDefined()) {
            if (after.isDefined()) {
                if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != BoxesRunTime.unboxToInt((Object)beforeIndex.get()) - 1) throw new LogFriendlyConcurrentModificationException("Unable to add stage between %s and %s, because these two stages are not neighbors any more", new Object[]{after.get(), before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)beforeIndex.get()))));
                return stage2;
            } else {
                if (BoxesRunTime.unboxToInt((Object)beforeIndex.get()) != 0) throw new LogFriendlyConcurrentModificationException("Unable to add first stage before %s, because it is not first stage of delivery pattern any more", new Object[]{before.get()});
                stage2 = this.addStage(pattern, stage, Optional.of(Predef$.MODULE$.int2Integer(0)));
            }
            return stage2;
        } else if (after.isDefined()) {
            if (BoxesRunTime.unboxToInt((Object)afterIndex.get()) != pattern.getStages().size() - 1) throw new LogFriendlyConcurrentModificationException("Unable to add last stage after %s, because it is not last stage of the delivery pattern any more", new Object[]{after.get()});
            stage2 = this.addStage(pattern, stage, Optional.empty());
            return stage2;
        } else {
            if (!pattern.getStages().isEmpty()) throw new LogFriendlyConcurrentModificationException("Unable to add first stage to the pattern, because pattern is not empty any more", new Object[0]);
            stage2 = this.addStage(pattern, stage, Optional.empty());
        }
        return stage2;
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage, Optional<Integer> position) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.generateTitleIfNecessary(stage, (Seq<Stage>)stages);
        Integer realPosition = position.orElse(Predef$.MODULE$.int2Integer(stages.size()));
        this.validateStageProperties(stage);
        this.validateNewStage((Seq<Stage>)stages, stage, Predef$.MODULE$.Integer2int(realPosition));
        stage.setId(this.factory().stageId(pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        stage.setTransition(null);
        stage.setItems(Collections.emptyList());
        pattern.addStage(stage, Predef$.MODULE$.Integer2int(realPosition));
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreatedEvent(stage, pattern));
        return stage;
    }

    public Optional<Integer> addStage$default$3() {
        return Optional.empty();
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStageProperties(updated);
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        this.validateNewStage((Seq<Stage>)stages.$minus$minus((GenTraversableOnce)new .colon.colon((Object)original, (List)Nil$.MODULE$)), updated, stages.indexOf((Object)original));
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdatedEvent(updated, pattern));
        return original;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageId);
        if (pattern.isLastStage(stage)) {
            pattern.findPreviousStage(stage).ifPresent(x$1 -> x$1.setTransition(null));
        }
        pattern.removeStage(stage);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemovedEvent(stage, pattern));
    }

    @Timed
    public Transition addTransition(String patternId, String stageIdOrTitle, Transition transition) {
        return this.addTransition(this.getPattern(patternId), stageIdOrTitle, transition);
    }

    @Timed
    public Transition addTransition(Delivery pattern, String stageIdOrTitle, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Stage stage = pattern.getStageByIdOrTitle(stageIdOrTitle);
        this.validateTransition(pattern, stage, transition);
        if (stage.getTransition() != null) {
            throw new LogFriendlyConcurrentModificationException("There is already a transition named '%s' associated with stage '%s'", new Object[]{stage.getTransition().getTitle(), stage.getTitle()});
        }
        transition.setId(this.factory().transitionId(stage.getId()));
        transition.getAllConditions().forEach(x$2 -> this.resetCondition(transition, (Condition)((Object)x$2)));
        stage.setTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreatedEvent(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        return this.updateTransition(this.getPattern(patternId), updated);
    }

    @Timed
    public Transition updateTransition(Delivery pattern, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Checks.checkNotNull((Object)((Object)updated), (String)"Transition");
        Stage stage = pattern.getStageByTransition(updated);
        Transition original = stage.getTransition();
        this.validateTransition(pattern, stage, updated);
        updated.getAllConditions().forEach(x$3 -> this.resetCondition(updated, (Condition)((Object)x$3)));
        stage.setTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdatedEvent(original, updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.getStageByTransition(transition).setTransition(null);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemovedEvent(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$4)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((Predef$.MODULE$.Integer2int(delivery.getPlannedDuration()) <= 73755 ? 1 : 0) != 0, (String)"Duration must be equal or less than 99 months 99 days 99 hours (73755 hours)", (Object[])new Object[0]);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void validateStagesAndTransitionsAndItems(Delivery pattern) {
        pattern.getStages().forEach(stage -> {
            this.validateStageProperties((Stage)((Object)stage));
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.validateTransition(pattern, stage, t);
                return BoxedUnit.UNIT;
            });
        });
        Buffer stageTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateStages = (Buffer)((SeqLike)stageTitles.diff((GenSeq)stageTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateStages.isEmpty(), (String)new StringBuilder(58).append("Stages with duplicate titles [").append(duplicateStages.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
        Buffer trackedItemTitles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), Buffer$.MODULE$.canBuildFrom());
        Buffer duplicateItems = (Buffer)((SeqLike)trackedItemTitles.diff((GenSeq)trackedItemTitles.distinct())).distinct();
        Checks.checkArgument((boolean)duplicateItems.isEmpty(), (String)new StringBuilder(65).append("Tracked items with duplicate titles [").append(duplicateItems.mkString(", ")).append("] are not allowed in pattern").toString(), (Object[])new Object[0]);
    }

    private void validateNewStage(Seq<Stage> stages, Stage stage, int position) {
        Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        Checks.checkArgument((!stages.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateNewStage$1(stage, x$7))) ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateStageProperties(Stage stage) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
    }

    private void resetPattern(Delivery pattern, boolean forceNewIds) {
        Date resetDate = new Date();
        String oldDeliveryId = pattern.getId();
        String newDeliveryId = this.factory().deliveryId();
        pattern.setId(newDeliveryId);
        pattern.getStages().forEach(stage -> {
            String oldStageId = stage.getId();
            String newStageId = this.generateOrUpdateId(oldStageId, oldDeliveryId, newDeliveryId, forceNewIds, ClassTag$.MODULE$.apply(Stage.class));
            stage.setId(newStageId);
            Option$.MODULE$.apply((Object)stage.getTransition()).foreach((Function1 & Serializable & scala.Serializable)transition -> {
                DeliveryPatternService.$anonfun$resetPattern$2(this, oldStageId, newStageId, forceNewIds, stage, transition);
                return BoxedUnit.UNIT;
            });
        });
        pattern.getTrackedItems().forEach(item -> {
            item.setId(this.factory().trackedItemId(newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean resetPattern$default$2() {
        return false;
    }

    private void resetCondition(Transition transition, Condition condition) {
        condition.setId(this.generateOrUpdateId(condition.getId(), transition.getId(), transition.getId(), false, ClassTag$.MODULE$.apply(Condition.class)));
        condition.reset();
    }

    private <T> String generateOrUpdateId(String existingId, String oldParentId, String newParentId, boolean forceNewIds, ClassTag<T> evidence$1) {
        String typeName = Type.valueOf((Class)((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass()).getName();
        boolean idNotDefined = existingId == null || existingId.trim().isEmpty() || !Ids.getName((String)existingId).startsWith(typeName);
        return forceNewIds || idNotDefined ? this.factory().createUniqueId(newParentId, evidence$1) : existingId.replace((CharSequence)Option$.MODULE$.apply((Object)oldParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (CharSequence)Option$.MODULE$.apply((Object)newParentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$addStageBetween$2(String folderlessId$1, Tuple2 t) {
        return Ids.getName((String)((BaseConfigurationItem)t._1()).getId()).equals(folderlessId$1);
    }

    public static final /* synthetic */ int $anonfun$addStageBetween$1(Delivery pattern$2, String id) {
        String folderlessId = Ids.getName((String)id);
        return ((Tuple2)((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pattern$2.getStages()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$addStageBetween$2(folderlessId, t))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyConcurrentModificationException("Stage %s not found", new Object[]{id});
        }))._2$mcI$sp();
    }

    private static final Function1 getStageIndex$1(Delivery pattern$2) {
        return (Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToInteger((int)DeliveryPatternService.$anonfun$addStageBetween$1(pattern$2, id));
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$4) {
        String string = x$4.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateNewStage$1(Stage stage$3, Stage x$7) {
        String string = x$7.getTitle();
        String string2 = stage$3.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetPattern$2(DeliveryPatternService $this, String oldStageId$1, String newStageId$1, boolean forceNewIds$1, Stage stage$4, Transition transition) {
        String oldTransitionId = transition.getId();
        String newTransitionId = $this.generateOrUpdateId(transition.getId(), oldStageId$1, newStageId$1, forceNewIds$1, ClassTag$.MODULE$.apply(Transition.class));
        transition.setId(newTransitionId);
        transition.setStage(stage$4);
        transition.getAllConditions().forEach(condition -> condition.setId($this.generateOrUpdateId(condition.getId(), oldTransitionId, newTransitionId, forceNewIds$1, ClassTag$.MODULE$.apply(Condition.class))));
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$7, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$7);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

