/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.quartz.events.SchedulerStartingEvent;
import com.xebialabs.xlrelease.quartz.release.scheduler.ReleaseSchedulerService;
import com.xebialabs.xlrelease.service.StuckGateDetectorSchedulerJob;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005=4Aa\u0003\u0007\u0001+!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u00151\u0004\u0001\"\u00018\u0011\u001da\u0004A1A\u0005\u0002uBaA\u0012\u0001!\u0002\u0013q\u0004bB$\u0001\u0005\u0004%\t!\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002 \t\u000f%\u0003!\u0019!C\u0005\u0015\"1a\n\u0001Q\u0001\n-CQa\u0014\u0001\u0005\u0002A\u0013!d\u0015;vG.<\u0015\r^3EKR,7\r^8s'\u000eDW\rZ;mKJT!!\u0004\b\u0002\u000fM,'O^5dK*\u0011q\u0002E\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0005\n\u0002\u0013a,'-[1mC\n\u001c(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nQa\u001d7gi)T\u0011!I\u0001\tOJL'P\u001f7fI&\u00111E\b\u0002\b\u0019><w-\u001b8h\u0003%AHN]\"p]\u001aLw\r\u0005\u0002'S5\tqE\u0003\u0002)\u001d\u000511m\u001c8gS\u001eL!AK\u0014\u0003\u0013ac'oQ8oM&<\u0017a\u0006:fY\u0016\f7/Z*dQ\u0016$W\u000f\\3s'\u0016\u0014h/[2f!\tiC'D\u0001/\u0015\ty\u0003'A\u0005tG\",G-\u001e7fe*\u0011\u0011GM\u0001\be\u0016dW-Y:f\u0015\t\u0019d\"\u0001\u0004rk\u0006\u0014HO_\u0005\u0003k9\u0012qCU3mK\u0006\u001cXmU2iK\u0012,H.\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\rA$h\u000f\t\u0003s\u0001i\u0011\u0001\u0004\u0005\u0006I\r\u0001\r!\n\u0005\u0006W\r\u0001\r\u0001L\u0001\t\u0015>\u0013uLT!N\u000bV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!A.\u00198h\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\rM#(/\u001b8h\u0003%QuJQ0O\u00036+\u0005%\u0001\u0006H%>+\u0006k\u0018(B\u001b\u0016\u000b1b\u0012*P+B{f*Q'FA\u0005)A-\u001a7bsV\t1\n\u0005\u0002\u0018\u0019&\u0011Q\n\u0007\u0002\u0005\u0019>tw-\u0001\u0004eK2\f\u0017\u0010I\u0001\n_:\u001cF/\u0019:ukB$\"!\u0015+\u0011\u0005]\u0011\u0016BA*\u0019\u0005\u0011)f.\u001b;\t\u000bUS\u0001\u0019\u0001,\u0002\u000b\u00154XM\u001c;\u0011\u0005]SV\"\u0001-\u000b\u0005e\u0013\u0014AB3wK:$8/\u0003\u0002\\1\n12k\u00195fIVdWM]*uCJ$\u0018N\\4Fm\u0016tG\u000f\u000b\u0002\u000b;B\u0011aLZ\u0007\u0002?*\u0011Q\u000b\u0019\u0006\u0003C\n\fqaY8oi\u0016DHO\u0003\u0002dI\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001f\u0003\ry'oZ\u0005\u0003O~\u0013Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bF\u0001\u0001j!\tQW.D\u0001l\u0015\ta'-\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!A\\6\u0003\u0013\r{W\u000e]8oK:$\b")
public class StuckGateDetectorScheduler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ReleaseSchedulerService releaseSchedulerService;
    private final String JOB_NAME;
    private final String GROUP_NAME;
    private final long delay;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        StuckGateDetectorScheduler stuckGateDetectorScheduler = this;
        synchronized (stuckGateDetectorScheduler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String JOB_NAME() {
        return this.JOB_NAME;
    }

    public String GROUP_NAME() {
        return this.GROUP_NAME;
    }

    private long delay() {
        return this.delay;
    }

    @EventListener
    public void onStartup(SchedulerStartingEvent event) {
        if (event != null && event.schedulerName() != null) {
            String string = event.schedulerName();
            String string2 = "xlrQuartzScheduler";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try {
                    JobDetail job = JobBuilder.newJob(StuckGateDetectorSchedulerJob.class).withDescription(this.JOB_NAME()).withIdentity(this.JOB_NAME(), this.GROUP_NAME()).storeDurably(true).build();
                    Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.JOB_NAME(), this.GROUP_NAME()).withDescription(this.JOB_NAME()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.xlrConfig.features().gateActor().unstuckInterval().toMillis()).repeatForever().withMisfireHandlingInstructionNextWithRemainingCount()).startAt(Date.from(new Date().toInstant().plusMillis(this.delay()))).build();
                    if (this.xlrConfig.features().gateActor().enabled()) {
                        this.logger().debug((Function0 & Serializable)() -> "Scheduling stuck gate detector");
                        this.releaseSchedulerService.schedule(job, trigger);
                    } else {
                        this.releaseSchedulerService.unschedule(job.getKey());
                    }
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Error while starting " + StuckGateDetectorScheduler.class.getName() + " service", (Function0 & Serializable)() -> e);
                }
                return;
            }
        }
    }

    public StuckGateDetectorScheduler(XlrConfig xlrConfig, ReleaseSchedulerService releaseSchedulerService) {
        this.xlrConfig = xlrConfig;
        this.releaseSchedulerService = releaseSchedulerService;
        Logging.$init$((Logging)this);
        this.JOB_NAME = "STUCK_GATE_DETECTOR_JOB";
        this.GROUP_NAME = "STUCK_GATE_DETECTOR";
        this.delay = xlrConfig.durations().startupJobsDelay().toMillis();
    }
}

