/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.quartz.config;

import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.sql.DatabaseInfo;
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration$;
import com.xebialabs.xlrelease.quartz.release.scheduler.ReleaseSchedulerService;
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.service.QuartzLifecycleManager;
import com.xebialabs.xlrelease.spring.config.SqlConfiguration;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import grizzled.slf4j.Logging;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.quartz.impl.jdbcjobstore.DB2v8Delegate;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.jdbcjobstore.oracle.OracleDelegate;
import org.quartz.spi.JobFactory;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import scala.Function0;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Configuration
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u000f\u001e\u0001!B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003G\u0011!\u0011\u0007A!A!\u0002\u0013\u0019\u0007\"B5\u0001\t\u0003Q\u0007\u0002\u0003;\u0001\u0011\u000b\u0007I\u0011I;\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!1\u0011Q\u0006\u0001\u0005\u0002yDq!!\u000f\u0001\t\u0003\tY\u0002C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!!0\u0001\t\u0013\tylB\u0004\u0002LvA\t!!4\u0007\rqi\u0002\u0012AAh\u0011\u0019IG\u0003\"\u0001\u0002R\"I\u00111\u001b\u000bC\u0002\u0013\u0015\u0011Q\u001b\u0005\t\u0003;$\u0002\u0015!\u0004\u0002X\"I\u0011q\u001c\u000bC\u0002\u0013\u0015\u0011\u0011\u001d\u0005\t\u0003S$\u0002\u0015!\u0004\u0002d\"I\u00111\u001e\u000bC\u0002\u0013\u0015\u0011Q\u001e\u0005\t\u0003k$\u0002\u0015!\u0004\u0002p\n\u0019\u0012+^1sij\u001cuN\u001c4jOV\u0014\u0018\r^5p]*\u0011adH\u0001\u0007G>tg-[4\u000b\u0005\u0001\n\u0013AB9vCJ$(P\u0003\u0002#G\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003I\u0015\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0019\n1aY8n\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0006g24GG\u001b\u0006\u0002i\u0005AqM]5{u2,G-\u0003\u00027c\t9Aj\\4hS:<\u0017\u0001E:rY\u000e{gNZ5hkJ\fG/[8o!\tIT(D\u0001;\u0015\tq2H\u0003\u0002=C\u000511\u000f\u001d:j]\u001eL!A\u0010\u001e\u0003!M\u000bHnQ8oM&<WO]1uS>t\u0017!\u0003=me\u000e{gNZ5h!\t\t5)D\u0001C\u0015\tq\u0012%\u0003\u0002E\u0005\nI\u0001\f\u001c:D_:4\u0017nZ\u0001\u0010iJLwmZ3s\u000bb,7-\u001e;peB\u0011qIS\u0007\u0002\u0011*\u0011\u0011*I\u0001\ng\u000eDW\rZ;mKJL!a\u0013%\u00035I+7\u000f^1si\u0006\u0014G.Z#yK\u000e,Ho\u001c:TKJ4\u0018nY3)\t\ri5\f\u0018\t\u0003\u001dfk\u0011a\u0014\u0006\u0003!F\u000b!\"\u00198o_R\fG/[8o\u0015\t\u00116+A\u0004gC\u000e$xN]=\u000b\u0005Q+\u0016!\u00022fC:\u001c(B\u0001,X\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[\u001f\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002;\u0006y!/\u001a7fCN,W\u0006\u001e:jO\u001e,'/A\trk\u0006\u0014HO\u001f&pE\u0016CXmY;u_JDC\u0001B'\\A\u0006\n\u0011-A\nrk\u0006\u0014HO_\u0017k_\nlS\r_3dkR|'/\u0001\bfm\u0016tG\u000fU;cY&\u001c\b.\u001a:\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019,\u0016aB2p]R,\u0007\u0010^\u0005\u0003Q\u0016\u0014\u0011$\u00119qY&\u001c\u0017\r^5p]\u00163XM\u001c;Qk\nd\u0017n\u001d5fe\u00061A(\u001b8jiz\"ba[7o_F\u001c\bC\u00017\u0001\u001b\u0005i\u0002\"B\u001c\u0007\u0001\u0004A\u0004\"B \u0007\u0001\u0004\u0001\u0005\"B#\u0007\u0001\u00041\u0005\u0006B8N7rCQA\u0018\u0004A\u0002\u0019CC!]'\\A\")!M\u0002a\u0001G\u00061An\\4hKJ,\u0012A\u001e\t\u0003a]L!\u0001_\u0019\u0003\r1{wmZ3sQ\t9!\u0010\u0005\u0002+w&\u0011Ap\u000b\u0002\niJ\fgn]5f]R\fq\u0003\u001e:jO\u001e,'oU2iK\u0012,H.\u001a:TKJ4\u0018nY3\u0015\u0003}\u0004B!!\u0001\u0002\n5\u0011\u00111\u0001\u0006\u0004\u0013\u0006\u0015!bAA\u0004?\u00059!/\u001a7fCN,\u0017\u0002BA\u0006\u0003\u0007\u0011qCU3mK\u0006\u001cXmU2iK\u0012,H.\u001a:TKJ4\u0018nY3)\u0007!\ty\u0001\u0005\u0003\u0002\u0012\u0005UQBAA\n\u0015\t\u0001V-\u0003\u0003\u0002\u0018\u0005M!\u0001\u0002\"fC:\fq\u0003\u001e:jO\u001e,'oU2iK\u0012,H.\u001a:GC\u000e$xN]=\u0015\u0005\u0005u\u0001\u0003BA\u0010\u0003Oi!!!\t\u000b\u0007\u0001\n\u0019CC\u0002\u0002&U\u000b!b]2iK\u0012,H.\u001b8h\u0013\u0011\tI#!\t\u0003)M\u001b\u0007.\u001a3vY\u0016\u0014h)Y2u_JL()Z1oQ\rI\u0011qB\u0001\u001acV\f'\u000f\u001e>K_\n\u001c6\r[3ek2,'oU3sm&\u001cW\rK\u0002\u000b\u0003\u001fA3ACA\u001a!\u0011\t\t\"!\u000e\n\t\u0005]\u00121\u0003\u0002\b!JLW.\u0019:z\u0003e\tX/\u0019:uu*{'mU2iK\u0012,H.\u001a:GC\u000e$xN]=)\u0007-\ty\u0001K\u0002\f\u0003g\ta#];beRTH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013\n\u0013aB:feZL7-Z\u0005\u0005\u0003\u001b\n9E\u0001\fRk\u0006\u0014HO\u001f'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3sQ\ra\u0011qB\u0001\u000bU>\u0014g)Y2u_JLHCAA+!\u0011\t9&a\u0018\u000e\u0005\u0005e#\u0002BA.\u0003;\n1a\u001d9j\u0015\t\u0001s+\u0003\u0003\u0002b\u0005e#A\u0003&pE\u001a\u000b7\r^8ss\"\u001aQ\"a\u0004\u0002!E,\u0018M\u001d;{!J|\u0007/\u001a:uS\u0016\u001cHCAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\nA!\u001e;jY*\u0011\u00111O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002x\u00055$A\u0003)s_B,'\u000f^5fg\"\u001aa\"a\u0004\u00021Y\fG.\u001b3bi\u0016\fV/\u0019:uuB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002\u0000\u0005\u0015\u0005c\u0001\u0016\u0002\u0002&\u0019\u00111Q\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000f{\u0001\u0019AA5\u0003\u0015\u0001(o\u001c9t\u0003Y\u0019'/Z1uKN\u001b\u0007.\u001a3vY\u0016\u0014h)Y2u_JLHCBA\u000f\u0003\u001b\u000b9\u000bC\u0004\u0002\u0010B\u0001\r!!%\u0002\u001bM\u001c\u0007.\u001a3vY\u0016\u0014h*Y7f!\u0011\t\u0019*!)\u000f\t\u0005U\u0015Q\u0014\t\u0004\u0003/[SBAAM\u0015\r\tYjJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}5&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\u000b)K\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?[\u0003bBAU!\u0001\u0007\u00111V\u0001\ri\u0006\u001c8.\u0012=fGV$xN\u001d\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*!\u0011\u0011WA7\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003k\u000byK\u0001\u0005Fq\u0016\u001cW\u000f^8s\u0003E\u0019wN\u001c4jOV\u0014XMS8c'R|'/\u001a\u000b\u0005\u0003\u007f\nY\fC\u0004\u0002\bF\u0001\r!!\u001b\u0002'\r|gNZ5hkJ,7\t\\;ti\u0016\u0014\u0018N\\4\u0015\t\u0005}\u0014\u0011\u0019\u0005\b\u0003\u000f\u0013\u0002\u0019AA5Q\r\u0001\u0011Q\u0019\t\u0005\u0003#\t9-\u0003\u0003\u0002J\u0006M!!D\"p]\u001aLw-\u001e:bi&|g.A\nRk\u0006\u0014HO_\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002m)M\u0011A#\u000b\u000b\u0003\u0003\u001b\fa\u0003\u0016*J\u000f\u001e+%kX*D\u0011\u0016#U\u000bT#S?:\u000bU*R\u000b\u0003\u0003/|!!!7\"\u0005\u0005m\u0017a\u0005=meR\u0013\u0018nZ4feN\u001b\u0007.\u001a3vY\u0016\u0014\u0018a\u0006+S\u0013\u001e;UIU0T\u0007\"+E)\u0016'F%~s\u0015)T#!\u0003U\tV+\u0011*U5~\u001b6\tS#E+2+%k\u0018(B\u001b\u0016+\"!a9\u0010\u0005\u0005\u0015\u0018EAAt\u0003IAHN])vCJ$(pU2iK\u0012,H.\u001a:\u0002-E+\u0016I\u0015+[?N\u001b\u0005*\u0012#V\u0019\u0016\u0013vLT!N\u000b\u0002\n1#U+B%RSv\fV!C\u0019\u0016{\u0006KU#G\u0013b+\"!a<\u0010\u0005\u0005E\u0018EAAz\u0003\t\tv,\u0001\u000bR+\u0006\u0013FKW0U\u0003\ncUi\u0018)S\u000b\u001aK\u0005\f\t")
public class QuartzConfiguration
implements Logging {
    private transient Logger logger;
    private final SqlConfiguration sqlConfiguration;
    private final XlrConfig xlrConfig;
    @Qualifier(value="release-trigger")
    private final RestartableExecutorService triggerExecutor;
    @Qualifier(value="quartz-job-executor")
    private final RestartableExecutorService quartzJobExecutor;
    private final ApplicationEventPublisher eventPublisher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient byte bitmap$trans$0;

    public static String QUARTZ_TABLE_PREFIX() {
        return QuartzConfiguration$.MODULE$.QUARTZ_TABLE_PREFIX();
    }

    public static String QUARTZ_SCHEDULER_NAME() {
        return QuartzConfiguration$.MODULE$.QUARTZ_SCHEDULER_NAME();
    }

    public static String TRIGGER_SCHEDULER_NAME() {
        return QuartzConfiguration$.MODULE$.TRIGGER_SCHEDULER_NAME();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        QuartzConfiguration quartzConfiguration = this;
        synchronized (quartzConfiguration) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Logger logger$lzycompute() {
        QuartzConfiguration quartzConfiguration = this;
        synchronized (quartzConfiguration) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.logger = Logger$.MODULE$.apply(QuartzConfiguration.class);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Bean
    public ReleaseSchedulerService triggerSchedulerService() {
        return new ReleaseSchedulerService(this.triggerSchedulerFactory());
    }

    @Bean
    public SchedulerFactoryBean triggerSchedulerFactory() {
        return this.createSchedulerFactory("xlrTriggerScheduler", (Executor)this.triggerExecutor);
    }

    @Bean
    @Primary
    public ReleaseSchedulerService quartzJobSchedulerService() {
        return new ReleaseSchedulerService(this.quartzJobSchedulerFactory());
    }

    @Bean
    @Primary
    public SchedulerFactoryBean quartzJobSchedulerFactory() {
        return this.createSchedulerFactory("xlrQuartzScheduler", (Executor)this.quartzJobExecutor);
    }

    @Bean
    public QuartzLifecycleManager quartzLifecycleManager() {
        .colon.colon schedulers = new .colon.colon((Object)this.triggerSchedulerFactory(), (List)new .colon.colon((Object)this.quartzJobSchedulerFactory(), (List)Nil$.MODULE$));
        .colon.colon executors = new .colon.colon((Object)this.triggerExecutor, (List)new .colon.colon((Object)this.quartzJobExecutor, (List)Nil$.MODULE$));
        return new QuartzLifecycleManager((List<SchedulerFactoryBean>)schedulers, (List<RestartableExecutorService>)executors, this.eventPublisher, this.xlrConfig);
    }

    @Bean
    public JobFactory jobFactory() {
        return new SpringBeanJobFactory();
    }

    @Bean
    public Properties quartzProperties() {
        Properties properties;
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setLocation((Resource)new ClassPathResource("/quartz.properties"));
        try {
            propertiesFactoryBean.afterPropertiesSet();
            properties = new Properties(propertiesFactoryBean.getObject());
        }
        catch (IOException e) {
            this.logger().debug((Function0 & Serializable)() -> "Cannot load quartz.properties.");
            properties = new Properties();
        }
        Properties props = properties;
        this.configureJobStore(props);
        this.configureClustering(props);
        this.validateQuartzProperties(props);
        return props;
    }

    private void validateQuartzProperties(Properties props) {
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalStateException("Quartz property '" + key + "' value should be string");
            }
        }));
    }

    private SchedulerFactoryBean createSchedulerFactory(String schedulerName, Executor taskExecutor) {
        SchedulerFactoryBean quartzScheduler = new SchedulerFactoryBean();
        quartzScheduler.setDataSource(this.sqlConfiguration.xlrRepositoryDataSourceProxy());
        quartzScheduler.setTransactionManager(this.sqlConfiguration.xlrRepositoryTransactionManager());
        quartzScheduler.setOverwriteExistingJobs(true);
        quartzScheduler.setAutoStartup(false);
        quartzScheduler.setSchedulerName(schedulerName);
        quartzScheduler.setTaskExecutor(taskExecutor);
        quartzScheduler.setJobFactory(this.jobFactory());
        quartzScheduler.setWaitForJobsToCompleteOnShutdown(true);
        quartzScheduler.setQuartzProperties(this.quartzProperties());
        return quartzScheduler;
    }

    private void configureJobStore(Properties props) {
        String string;
        props.put("org.quartz.jobStore.useProperties", Boolean.TRUE.toString());
        props.put("org.quartz.jobStore.class", LocalDataSourceJobStore.class.getCanonicalName());
        props.put("org.quartz.jobStore.tablePrefix", "Q_");
        DatabaseInfo databaseInfo = this.sqlConfiguration.xlrDbInfo();
        if (databaseInfo instanceof DatabaseInfo.Db2) {
            string = DB2v8Delegate.class.getCanonicalName();
        } else if (databaseInfo instanceof DatabaseInfo.Oracle) {
            string = OracleDelegate.class.getCanonicalName();
        } else if (databaseInfo instanceof DatabaseInfo.MsSqlServer) {
            props.put("org.quartz.jobStore.acquireTriggersWithinLock", Boolean.TRUE.toString());
            string = MSSQLDelegate.class.getCanonicalName();
        } else {
            string = databaseInfo instanceof DatabaseInfo.PostgreSql ? PostgreSQLDelegate.class.getCanonicalName() : StdJDBCDelegate.class.getCanonicalName();
        }
        String driverDelegateClass = string;
        props.put("org.quartz.jobStore.driverDelegateClass", driverDelegateClass);
    }

    private void configureClustering(Properties props) {
        Boolean FALSE = BoxesRunTime.boxToBoolean((boolean)false);
        ClusterMode clusterMode = this.xlrConfig.cluster().mode();
        ClusterMode.Standalone$ standalone$ = ClusterMode.Standalone$.MODULE$;
        boolean isClustered = clusterMode == null ? standalone$ != null : !clusterMode.equals(standalone$);
        props.put("org.quartz.jobStore.isClustered", Boolean.toString(isClustered));
        if (isClustered) {
            props.put("org.quartz.scheduler.instanceId", "AUTO");
            props.put("org.quartz.jobStore.misfireThreshold", "60000");
            v1 = props.put("org.quartz.jobStore.clusterCheckinInterval", "20000");
        } else {
            v1 = BoxedUnit.UNIT;
        }
        props.put("org.quartz.scheduler.rmi.export", FALSE.toString());
        props.put("org.quartz.scheduler.rmi.proxy", FALSE.toString());
    }

    public QuartzConfiguration(SqlConfiguration sqlConfiguration, XlrConfig xlrConfig, @Qualifier(value="release-trigger") RestartableExecutorService triggerExecutor, @Qualifier(value="quartz-job-executor") RestartableExecutorService quartzJobExecutor, ApplicationEventPublisher eventPublisher) {
        this.sqlConfiguration = sqlConfiguration;
        this.xlrConfig = xlrConfig;
        this.triggerExecutor = triggerExecutor;
        this.quartzJobExecutor = quartzJobExecutor;
        this.eventPublisher = eventPublisher;
        Logging.$init$((Logging)this);
    }
}

