package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.domain.{PlanItem, Release}
import com.xebialabs.xlrelease.user.User
import grizzled.slf4j.Logging
import org.quartz.JobExecutionContext
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class PendingReleaseQuartzJob extends PendingPlanItemQuartzJob[Release] with Logging {

  @Autowired
  var releaseActorService: ReleaseActorService = _

  override def execute(context: JobExecutionContext): Unit = {
    val jobKey = context.getJobDetail.getKey
    val releaseId = getPlanItemIdFromJobData(context, "Unable to get release id from job data")
    Try {
      releaseId.foreach(releaseActorService.startRelease(_, User.SYSTEM))
    } match {
      case Failure(ex) => logger.error(s"Unable to start pending release [$releaseId]", ex)
      case Success(_) => logger.debug(s"Started pending release quartz job [$jobKey]")
    }
  }

  override def supports(planItem: PlanItem): Boolean = planItem.isInstanceOf[Release]

}
