package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.domain.{PlanItem, Task}
import com.xebialabs.xlrelease.user.User
import org.quartz.JobExecutionContext
import org.springframework.beans.factory.annotation.Autowired

class PendingTaskQuartzJob extends PendingPlanItemQuartzJob[Task] {

  @Autowired
  var releaseActorService: ReleaseActorService = _

  override def execute(context: JobExecutionContext): Unit = {
    val taskId = getPlanItemIdFromJobData(context)
    releaseActorService.startTaskAsync(taskId, null, User.SYSTEM)
  }

  override def supports(planItem: PlanItem): Boolean = planItem.isInstanceOf[Task]

}
