package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.release.scheduler.OverdueNotificationService._
import org.springframework.stereotype.Service

@Service
class OverdueNotificationService(val releaseSchedulerService: ReleaseSchedulerService)
  extends BaseNotificationService(name = OVERDUE_NOTIFICATION_SERVICE,
    jobClazz = classOf[OverdueNotificationJob],
    defaultTriggerInterval = XlrConfig.getInstance.durations.notifyOverduePlanItemsInterval,
    isEnabled = XlrConfig.getInstance.features.notifications.overdueEnabled)

object OverdueNotificationService {
  val OVERDUE_NOTIFICATION_SERVICE = "Overdue Notification"
}
