/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent;
import com.xebialabs.xlrelease.quartz.release.scheduler.ReleaseSchedulerService;
import com.xebialabs.xlrelease.service.StuckGateDetectorSchedulerJob;
import com.xebialabs.xlrelease.service.StuckGateDetectorService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u000554AAC\u0006\u0001)!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!)\u0004A!A!\u0002\u00131\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004b\u0002!\u0001\u0005\u0004%\t!\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002\"\t\u000f-\u0003!\u0019!C\u0001\u0003\"1A\n\u0001Q\u0001\n\tCQ!\u0014\u0001\u0005\u00029\u0013!d\u0015;vG.<\u0015\r^3EKR,7\r^8s'\u000eDW\rZ;mKJT!\u0001D\u0007\u0002\u000fM,'O^5dK*\u0011abD\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001E\t\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tQa\u001d7gi)T\u0011\u0001I\u0001\tOJL'P\u001f7fI&\u0011!%\b\u0002\b\u0019><w-\u001b8h\u0003%AHN]\"p]\u001aLw\r\u0005\u0002&Q5\taE\u0003\u0002(\u001b\u000511m\u001c8gS\u001eL!!\u000b\u0014\u0003\u0013ac'oQ8oM&<\u0017a\u0006:fY\u0016\f7/Z*dQ\u0016$W\u000f\\3s'\u0016\u0014h/[2f!\ta3'D\u0001.\u0015\tqs&A\u0005tG\",G-\u001e7fe*\u0011\u0001'M\u0001\be\u0016dW-Y:f\u0015\t\u0011T\"\u0001\u0004rk\u0006\u0014HO_\u0005\u0003i5\u0012qCU3mK\u0006\u001cXmU2iK\u0012,H.\u001a:TKJ4\u0018nY3\u00021M$XoY6HCR,G)\u001a;fGR|'oU3sm&\u001cW\r\u0005\u00028q5\t1\"\u0003\u0002:\u0017\tA2\u000b^;dW\u001e\u000bG/\u001a#fi\u0016\u001cGo\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011aTHP \u0011\u0005]\u0002\u0001\"B\u0012\u0005\u0001\u0004!\u0003\"\u0002\u0016\u0005\u0001\u0004Y\u0003\"B\u001b\u0005\u0001\u00041\u0014\u0001\u0003&P\u0005~s\u0015)T#\u0016\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0004TiJLgnZ\u0001\n\u0015>\u0013uLT!N\u000b\u0002\n!b\u0012*P+B{f*Q'F\u0003-9%kT+Q?:\u000bU*\u0012\u0011\u0002\u0013=t7\u000b^1siV\u0004HCA(S!\t1\u0002+\u0003\u0002R/\t!QK\\5u\u0011\u0015\u0019\u0016\u00021\u0001U\u0003\u0015)g/\u001a8u!\t)\u0006,D\u0001W\u0015\t9\u0016'\u0001\u0004fm\u0016tGo]\u0005\u00033Z\u0013QcU2iK\u0012,H.\u001a:Ti\u0006\u0014H/\u001a3Fm\u0016tG\u000f\u000b\u0002\n7B\u0011A\fZ\u0007\u0002;*\u00111K\u0018\u0006\u0003?\u0002\fqaY8oi\u0016DHO\u0003\u0002bE\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001d\u0003\ry'oZ\u0005\u0003Kv\u0013Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bF\u0001\u0001h!\tA7.D\u0001j\u0015\tQ\u0007-\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!\u0001\\5\u0003\u0013\r{W\u000e]8oK:$\b")
public class StuckGateDetectorScheduler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ReleaseSchedulerService releaseSchedulerService;
    private final String JOB_NAME;
    private final String GROUP_NAME;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        StuckGateDetectorScheduler stuckGateDetectorScheduler = this;
        synchronized (stuckGateDetectorScheduler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String JOB_NAME() {
        return this.JOB_NAME;
    }

    public String GROUP_NAME() {
        return this.GROUP_NAME;
    }

    @EventListener
    public void onStartup(SchedulerStartedEvent event) {
        block3: {
            try {
                JobDetail job = JobBuilder.newJob(StuckGateDetectorSchedulerJob.class).withDescription(this.JOB_NAME()).withIdentity(this.JOB_NAME(), this.GROUP_NAME()).storeDurably(true).build();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.JOB_NAME(), this.GROUP_NAME()).withDescription(this.JOB_NAME()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.xlrConfig.features().gateActor().unstuckInterval().toMillis()).repeatForever()).build();
                if (this.xlrConfig.features().gateActor().enabled()) {
                    this.logger().debug((Function0 & Serializable)() -> "Scheduling stuck gate detector");
                    this.releaseSchedulerService.schedule(job, trigger);
                    break block3;
                }
                this.releaseSchedulerService.unschedule(job.getKey());
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> "Error while starting " + StuckGateDetectorScheduler.class.getName() + " service", (Function0 & Serializable)() -> e);
            }
        }
    }

    public StuckGateDetectorScheduler(XlrConfig xlrConfig, ReleaseSchedulerService releaseSchedulerService, StuckGateDetectorService stuckGateDetectorService) {
        this.xlrConfig = xlrConfig;
        this.releaseSchedulerService = releaseSchedulerService;
        Logging.$init$((Logging)this);
        this.JOB_NAME = "STUCK_GATE_DETECTOR_JOB";
        this.GROUP_NAME = "STUCK_GATE_DETECTOR";
    }
}

