package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.service.DueSoonAndOverdueService
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

@DisallowConcurrentExecution
class DueSoonNotificationJob extends Job with Logging {

  @Autowired
  var dueSoonAndOverdueService: DueSoonAndOverdueService = _

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing due soon notification job")
    dueSoonAndOverdueService.notifyAboutDueSoonTasks()
  }

}
