package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_JOB_SCHEDULER
import com.xebialabs.xlrelease.quartz.release.scheduler.OverdueNotificationService._
import org.quartz._
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.stereotype.Service

@Service
class OverdueNotificationService(@Qualifier(BEAN_QUARTZ_JOB_SCHEDULER) val scheduler: Scheduler)
  extends BaseNotificationService(serviceName = OVERDUE_NOTIFICATION_SERVICE,
    jobClazz = classOf[OverdueNotificationJob],
    defaultTriggerInterval = XlrConfig.getInstance.durations.notifyOverduePlanItemsInterval,
    notificationEnabled = XlrConfig.getInstance.features.notifications.overdueEnabled)

object OverdueNotificationService {
  val OVERDUE_NOTIFICATION_SERVICE = "Overdue Notification"
}
