package com.xebialabs.xlrelease.quartz.config

import com.xebialabs.xlrelease.quartz.release.scheduler.{PendingReleaseQuartzJob, PendingTaskQuartzJob, QuartzPendingPlanItemScheduledJobService}
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ScheduledJobServicesConfiguration(quartzConfiguration: QuartzConfiguration) {

  @Bean
  def pendingReleaseQuartzJob(): PendingReleaseQuartzJob = new PendingReleaseQuartzJob()

  @Bean
  def pendingTaskQuartzJob(): PendingTaskQuartzJob = new PendingTaskQuartzJob()

  @Bean
  def quartzPendingPlanItemScheduledJobService(): QuartzPendingPlanItemScheduledJobService = {
    new QuartzPendingPlanItemScheduledJobService(quartzConfiguration.scheduler(), List(pendingReleaseQuartzJob(), pendingTaskQuartzJob()))
  }

}
