package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_SCHEDULER
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent
import grizzled.slf4j.Logging
import org.quartz.JobBuilder.newJob
import org.quartz.SimpleScheduleBuilder.simpleSchedule
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{JobDetail, Scheduler, Trigger}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.context.event
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class StuckGateDetectorScheduler @Autowired()(
                                               xlrConfig: XlrConfig,
                                               @Qualifier(BEAN_QUARTZ_SCHEDULER) val scheduler: Scheduler,
                                               stuckGateDetectorService: StuckGateDetectorService) extends Logging {

  val JOB_NAME = "STUCK_GATE_DETECTOR_JOB"
  val GROUP_NAME = "STUCK_GATE_DETECTOR"

  @event.EventListener
  def onStartup(event: SchedulerStartedEvent): Unit = {
    try {
      if (xlrConfig.features.gateActor.enabled) {
        val job: JobDetail = newJob(classOf[StuckGateDetectorSchedulerJob])
          .withDescription(JOB_NAME)
          .withIdentity(JOB_NAME, GROUP_NAME)
          .build()
        val trigger: Trigger = newTrigger()
          .withIdentity(JOB_NAME, GROUP_NAME)
          .withDescription(JOB_NAME)
          .withSchedule(simpleSchedule()
            .withIntervalInMilliseconds(xlrConfig.features.gateActor.unstuckInterval.toMillis)
            .repeatForever())
          .build()
        scheduler.scheduleJob(job, Set(trigger).asJava, true)
      }
    } catch {
      case e: Exception => logger.error(s"Error while starting ${classOf[StuckGateDetectorScheduler].getName} service", e)
    }
  }
}
