package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlplatform.cluster.ClusterMode.Full
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.scheduler.service.JobCleanupService
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

@DisallowConcurrentExecution
class ScheduledTaskRecoveryJob extends Job with Logging {

  @Autowired
  var jobCleanupService: JobCleanupService = _

  override def execute(context: JobExecutionContext): Unit = {
    // we need to check once more here, because eventually job may be
    // already in the database, when confiugration is switched from cluster to
    // standalone mode, and job will be executed before we manage to delete it
    // in ScheduledTaskRecovery component

    XlrConfig.getInstance.clusterMode match {
      case Full => jobCleanupService.detectAbandonedTasks()
      case _ => logger.info(s"Skipping ${classOf[ScheduledTaskRecoveryJob].getName} because it only runs in a cluster mode")
    }
  }
}
