package com.xebialabs.xlrelease.pendo.extractors

import com.xebialabs.analytics.pendo.PendoEvent
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent
import com.xebialabs.xlrelease.pendo.PendoConstants.RELEASE_ABORTED
import org.springframework.stereotype.Component

import java.time.Instant

@Component
class ReleaseAbortedExtractor extends ReleaseFullEventExtractor[ReleaseAbortedEvent] {

  override def extractPendoData(event: Any): Option[PendoEvent] = {
    event match {
      case ev: ReleaseAbortedEvent => Some(PendoEvent(RELEASE_ABORTED, eventProperties(ev.release), Instant.now.toEpochMilli))
      case _ => None
    }
  }

  override def supports(): Class[ReleaseAbortedEvent] = classOf[ReleaseAbortedEvent]

}
