package com.xebialabs.xlrelease.pendo.utils

import com.xebialabs.analytics.pendo.PendoAccountHolder
import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.license.service.LicenseService
import com.xebialabs.xlrelease.analytics.service.AnalyticsService
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.views.LicenseView
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import java.net.InetAddress

class ReleasePendoAccountHolder @Autowired()(serverConfiguration: ServerConfiguration,
                                             licenseService: LicenseService,
                                             analyticsService: AnalyticsService) extends PendoAccountHolder with Logging {

  def getVisitorId(): String = {
    val accountId = getAccountId()
    val host = if (XlrConfig.getInstance.cluster.config.hasPath("name")) {
      XlrConfig.getInstance.cluster.config.getString("name")
    } else {
      InetAddress.getLocalHost.getHostName
    }
    generatePendoVistorId(accountId, host)
  }

  def getAccountId(): String = {
    val licenseView = new LicenseView(licenseService.getLicense)
    analyticsService.getAccountId(licenseView.getLicensedTo, serverConfiguration.getServerUrl)
  }

  def generatePendoVistorId(accountId: String, host: String): String = {
    s"${accountId}/${host}"
  }

}
