package com.xebialabs.xlrelease.pendo.extractors

import com.xebialabs.analytics.pendo.PendoEvent
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent
import com.xebialabs.xlrelease.pendo.PendoConstants._
import org.springframework.stereotype.Component

import java.time.Instant

@Component
class ReleaseCompletedExtractor extends ReleaseFullEventExtractor[ReleaseCompletedEvent] {

  override def extractPendoData(event: Any): Option[PendoEvent] = {
    event match {
      case ev: ReleaseCompletedEvent => Some(PendoEvent(RELEASE_COMPLETED, eventProperties(ev.release), Instant.now.toEpochMilli))
      case _ => None
    }
  }

  override def supports(): Class[ReleaseCompletedEvent] = classOf[ReleaseCompletedEvent]

}
