package com.xebialabs.xlrelease.pendo.metrics

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.pendo.metrics.PendoMetricsCollectionService.{GROUP_NAME, JOB_NAME, PENDO_METRICS_SERVICE_NAME}
import com.xebialabs.xlrelease.quartz.release.scheduler.{QuartzScheduledService, ReleaseSchedulerService}
import com.xebialabs.xlrelease.utils.QuartzUtils._
import org.quartz.CronScheduleBuilder.cronSchedule
import org.quartz.JobBuilder.newJob
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{CronTrigger, JobDetail, Trigger}
import org.springframework.stereotype.Service

@Service
class PendoMetricsCollectionService(val releaseSchedulerService: ReleaseSchedulerService,
                                    xlrConfig: XlrConfig) extends QuartzScheduledService {

  private lazy val job: JobDetail = newJob(classOf[PendoMetricsCollectionJob])
    .withDescription(s"$PENDO_METRICS_SERVICE_NAME job")
    .withIdentity(JOB_NAME, GROUP_NAME)
    .storeDurably(true)
    .build()

  private lazy val trigger: CronTrigger = newTrigger()
    .withIdentity(JOB_NAME, GROUP_NAME)
    .withDescription(s"Trigger $PENDO_METRICS_SERVICE_NAME jobs")
    .withSchedule(
      cronSchedule(xlrConfig.features.analytics.pendoMetricsCron.asQuartzCron)
        .withMisfireHandlingInstructionDoNothing()
    )
    .startNow()
    .build()

  override def getJobDetail: JobDetail = job

  override def getTrigger: Trigger = trigger

  override def name(): String = PENDO_METRICS_SERVICE_NAME

  override def isEnabled: Boolean = true
}

object PendoMetricsCollectionService {
  val PENDO_METRICS_SERVICE_NAME = "Pendo Metrics Collection"
  val JOB_NAME = "PENDO_METRICS_COLLECTION_JOB"
  val GROUP_NAME = "PENDO_METRICS"
}

