package com.xebialabs.xlrelease.pendo.metrics

import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

/**
 * Even though we shouldn't create quartz jobs this job is a quartz job. Why? It's being triggered once every 24 hours
 * and the amount of locking that quartz does on it's tables is very low. Besides, quartz is not properly maintained
 * anymore. For use cases that fire more frequently it's better to use akka scheduling.
 *
 * Have in mind that quartz was introduced to XLR for a specific use case (it enabled decoupling of a release from its
 * triggers, and removed the need to read entire release objects from the DB only to find out if there's a duesoon or
 * overdue task), and not for general usage.
 */
@DisallowConcurrentExecution
class PendoMetricsCollectionJob extends Job with Logging {

  @Autowired
  var pendoMetricsService: PendoMetricsService = _

  override def execute(context: JobExecutionContext): Unit = {
    pendoMetricsService.processMetrics()
  }
}
