package com.xebialabs.xlrelease.pendo.extractors

import com.xebialabs.analytics.pendo.PendoEvent
import com.xebialabs.xlrelease.domain.events.ReleaseStartedEvent
import com.xebialabs.xlrelease.pendo.PendoConstants._
import org.springframework.stereotype.Component

import java.time.Instant

@Component
class ReleaseStartedExtractor extends ReleaseEventExtractor[ReleaseStartedEvent] {

  override def extractPendoData(event: Any): Option[PendoEvent] = {
    event match {
      case ev: ReleaseStartedEvent => Some(PendoEvent(RELEASE_STARTED, eventProperties(ev.release), Instant.now.toEpochMilli))
      case _ => None
    }
  }

  override def supports(): Class[ReleaseStartedEvent] = classOf[ReleaseStartedEvent]

}
