package com.xebialabs.xlrelease.pendo

import com.xebialabs.analytics.pendo.{PendoDataExtractor, PendoEventQueue, PendoSender}
import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.license.service.LicenseService
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.pendo.actor.PendoDataPublisherInitializer
import com.xebialabs.xlrelease.pendo.metrics.PendoMetricsService
import com.xebialabs.xlrelease.pendo.utils.ReleasePendoAccountHolder
import com.xebialabs.xlrelease.repository.MetadataRepository
import com.xebialabs.xlrelease.service.{BroadcastService, ConfigurationService}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Value}
import org.springframework.context.annotation.{Bean, Configuration}

import scala.jdk.CollectionConverters.ListHasAsScala
import scala.language.postfixOps

@Configuration
class XlrPendoConfiguration extends Logging {

  @Autowired
  var extractors: java.util.List[_ <: PendoDataExtractor[_]] = _

  @Autowired
  var configurationService: ConfigurationService = _

  @Autowired
  var broadcastService: BroadcastService = _

  @Autowired
  var serverConfiguration: ServerConfiguration = _

  @Autowired
  var licenseService: LicenseService = _

  @Autowired
  var metadataRepository: MetadataRepository = _

  @Value("${xl.features.analytics.pendoQueueSize}")
  var pendoQueueSize: Int = _

  @Bean
  def pendoSwitch = new PendoSwitch(configurationService, broadcastService)

  @Bean
  def pendoAccountHolder = new ReleasePendoAccountHolder(serverConfiguration, licenseService, metadataRepository)

  @Bean
  def pendoRelevantEventsListener(pendoDataHolder: PendoEventQueue, pendoSwitch: PendoSwitch): PendoRelevantEventsListener = {
    val extractorsMap = extractors.asScala.toList map (e => e.supports() -> e) toMap
    val funnel = new PendoRelevantEventsListener(pendoSwitch, pendoDataHolder, extractorsMap)
    funnel
  }

  @Bean
  def pendoEventQueue(): PendoEventQueue = new PendoEventQueue(pendoQueueSize)

  @Bean
  def pendoSender(asHolder: ActorSystemHolder): PendoSender = {
    implicit val actorSystem = asHolder.actorSystem

    new PendoSender(pendoAccountHolder, PendoConstants.TRACKED_EVENT_INTEGRATION_KEY)
  }

  @Bean
  def pendoDataPublisherInitializer(queue: PendoEventQueue, sender: PendoSender, pendoSwitch: PendoSwitch, asHolder: ActorSystemHolder) = {
    new PendoDataPublisherInitializer(queue, sender, asHolder, pendoSwitch.isEnabled)
  }

  @Bean
  def pendoMetricsService(dataHolder: PendoEventQueue, pendoSwitch: PendoSwitch): PendoMetricsService = {
    new PendoMetricsService(dataHolder, pendoSwitch)
  }
}

