package com.xebialabs.xlrelease.pendo.metrics

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.pendo.metrics.PendoMetricsCollectionService.{GROUP_NAME, JOB_NAME, PENDO_METRICS_SERVICE_NAME}
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_JOB_SCHEDULER
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent
import com.xebialabs.xlrelease.utils.QuartzUtils._
import grizzled.slf4j.Logging
import org.quartz.CronScheduleBuilder.cronSchedule
import org.quartz.JobBuilder.newJob
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{CronTrigger, JobDetail, Scheduler}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.context.event.EventListener
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class PendoMetricsCollectionService @Autowired()(@Qualifier(BEAN_QUARTZ_JOB_SCHEDULER) val scheduler: Scheduler,
                                                 xlrConfig: XlrConfig) extends Logging {

  private lazy val job: JobDetail = newJob(classOf[PendoMetricsCollectionJob])
    .withDescription(s"$PENDO_METRICS_SERVICE_NAME job")
    .withIdentity(JOB_NAME, GROUP_NAME)
    .build()

  private lazy val trigger: CronTrigger = newTrigger()
    .withIdentity(JOB_NAME, GROUP_NAME)
    .withDescription(s"Trigger $PENDO_METRICS_SERVICE_NAME jobs")
    .withSchedule(
      cronSchedule(xlrConfig.features.analytics.pendoMetricsCron.asQuartzCron)
        .withMisfireHandlingInstructionDoNothing()
    )
    .startNow()
    .build()

  private def schedule(): Unit = {
    logger.debug(s"Schedule $PENDO_METRICS_SERVICE_NAME job")
    if (scheduler.checkExists(trigger.getKey)) {
      scheduler.rescheduleJob(trigger.getKey, trigger)
    } else {
      scheduler.scheduleJob(job, Set(trigger).asJava, true)
    }
  }

  @EventListener
  def onStartup(event: SchedulerStartedEvent): Unit = {
    try {
      schedule()
    } catch {
      case e: Exception => logger.error(s"Error while starting $PENDO_METRICS_SERVICE_NAME service", e)
    }
  }
}

object PendoMetricsCollectionService {
  val PENDO_METRICS_SERVICE_NAME = "Pendo Metrics Collection"
  val JOB_NAME = "PENDO_METRICS_COLLECTION_JOB"
  val GROUP_NAME = "PENDO_METRICS"
}

