package com.xebialabs.xlrelease.pendo.actor

import akka.actor.ActorRef
import com.xebialabs.analytics.pendo.{PendoDataPublisher, PendoEventQueue, PendoSender}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import grizzled.slf4j.Logging

object PendoDataPublisherInitializer {

  var actor: ActorRef = _

  def setInstance(actorRef: ActorRef): Unit = actor = actorRef

  def getInstance(): ActorRef = actor
}

class PendoDataPublisherInitializer(queue: PendoEventQueue, sender: PendoSender, systemHolder: ActorSystemHolder)
  extends ActorInitializer with Logging {

  lazy val pendoDataPublishingActor: ActorRef = systemHolder.actorSystem.actorOf(PendoDataPublisher.props(queue, sender, systemHolder.actorSystem.scheduler))

  override def initialize(): Unit = {
    PendoDataPublisherInitializer.setInstance(pendoDataPublishingActor)
  }
}
