/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001\u0002\t\u0012\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015A\u0007\u0001\"\u0001j\u0011%\t\u0019\u0002AI\u0001\n\u0003\t)\u0002C\u0004\u0002*\u0001!I!a\u000b\t\u000f\u0005E\u0002\u0001\"\u0003\u00024!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!a \u0001\t\u0013\t\tI\u0001\fF[\u0006LGNU3dSBLWM\u001c;SKN|GN^3s\u0015\t\u00112#A\u0003f[\u0006LGN\u0003\u0002\u0015+\u0005ian\u001c;jM&\u001c\u0017\r^5p]NT!AF\f\u0002\u0013ad'/\u001a7fCN,'B\u0001\r\u001a\u0003%AXMY5bY\u0006\u00147OC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\fe>dWmU3sm&\u001cW\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005A1/Z2ve&$\u0018P\u0003\u0002*/\u0005AA-\u001a9m_fLG/\u0003\u0002,M\tY!k\u001c7f'\u0016\u0014h/[2f\u0003-!X-Y7TKJ4\u0018nY3\u0011\u00059\nT\"A\u0018\u000b\u0005A*\u0012aB:feZL7-Z\u0005\u0003e=\u00121\u0002V3b[N+'O^5dK\u0006\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\tqS'\u0003\u00027_\t\u0011Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u0003U\u0001(/\u001b8dSB\fG.\u00138g_J+7o\u001c7wKJ\u0004\"AL\u001d\n\u0005iz#!\u0006)sS:\u001c\u0017\u000e]1m\u0013:4wNU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000buz\u0004)\u0011\"\u0011\u0005y\u0002Q\"A\t\t\u000b\r*\u0001\u0019\u0001\u0013\t\u000b1*\u0001\u0019A\u0017\t\u000bM*\u0001\u0019\u0001\u001b\t\u000b]*\u0001\u0019\u0001\u001d)\u0005\u0015!\u0005CA#Q\u001b\u00051%BA$I\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0013*\u000bqAZ1di>\u0014\u0018P\u0003\u0002L\u0019\u0006)!-Z1og*\u0011QJT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq*A\u0002pe\u001eL!!\u0015$\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u0005:fg>dg/\u001a*fG&\u0004\u0018.\u001a8u)\t!F\f\u0005\u0002V56\taK\u0003\u0002X1\u0006!A.\u00198h\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017,\u0003\rM#(/\u001b8h\u0011\u0015if\u00011\u0001_\u00035\u0001(/\u001b8dSB\fGNT1nKB\u0011qL\u001a\b\u0003A\u0012\u0004\"!Y\u0010\u000e\u0003\tT!aY\u000e\u0002\rq\u0012xn\u001c;?\u0013\t)w$\u0001\u0004Qe\u0016$WMZ\u0005\u00037\u001eT!!Z\u0010\u0002#I,7o\u001c7wKJ+7-\u001b9jK:$8\u000fF\u0004k[bTH0!\u0003\u0011\u0007}[g,\u0003\u0002mO\n\u00191+\u001a;\t\u000b9<\u0001\u0019A8\u0002\u000bI|G.Z:\u0011\u0007A,hL\u0004\u0002rg:\u0011\u0011M]\u0005\u0002A%\u0011AoH\u0001\ba\u0006\u001c7.Y4f\u0013\t1xO\u0001\u0003MSN$(B\u0001; \u0011\u0015Ix\u00011\u0001p\u0003-9Gn\u001c2bYJ{G.Z:\t\u000bm<\u0001\u0019A8\u0002\u000bU\u001cXM]:\t\u000bu<\u0001\u0019\u0001@\u0002\u0011Ad\u0017M\\%uK6\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004U\ta\u0001Z8nC&t\u0017\u0002BA\u0004\u0003\u0003\u0011\u0001\u0002\u00157b]&#X-\u001c\u0005\n\u0003\u00179\u0001\u0013!a\u0001\u0003\u001b\tQ\"\u001a=dYV$W-Q;uQ>\u0014\bc\u0001\u0010\u0002\u0010%\u0019\u0011\u0011C\u0010\u0003\u000f\t{w\u000e\\3b]\u0006Y\"/Z:pYZ,'+Z2ja&,g\u000e^:%I\u00164\u0017-\u001e7uIU*\"!a\u0006+\t\u00055\u0011\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002&5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0011qiH\u0005\u0005\u0003O\tyBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\"[:Vg\u0016\u0014XI\\1cY\u0016$G\u0003BA\u0007\u0003[Aa!a\f\n\u0001\u0004q\u0016\u0001C;tKJt\u0017-\\3\u0002\u0015A\f'o]3S_2,7\u000fF\u0004k\u0003k\t\t%a\u0011\t\u000f\u0005]\"\u00021\u0001\u0002:\u0005Y\u0011m]:jO:lWM\u001c;t!\u0011\u0001X/a\u000f\u0011\u0007\u0015\ni$C\u0002\u0002@\u0019\u0012AAU8mK\")aN\u0003a\u0001_\")QP\u0003a\u0001}\u0006q\u0001/\u0019:tKR\u000b7o\u001b*pY\u0016\u001cHc\u00026\u0002J\u0005M\u0013Q\u000b\u0005\b\u0003\u0017Z\u0001\u0019AA'\u0003\u0011!\u0018m]6\u0011\u0007}\fy%\u0003\u0003\u0002R\u0005\u0005!\u0001\u0002+bg.DQA\\\u0006A\u0002=Dq!a\u000e\f\u0001\u0004\tI$A\tqCJ\u001cXMU3mK\u0006\u001cXMU8mKN$rA[A.\u0003K\n9\u0007C\u0004\u0002^1\u0001\r!a\u0018\u0002\u000fI,G.Z1tKB\u0019q0!\u0019\n\t\u0005\r\u0014\u0011\u0001\u0002\b%\u0016dW-Y:f\u0011\u0015qG\u00021\u0001p\u0011\u001d\t9\u0004\u0004a\u0001\u0003s\t\u0011cZ3u%\u0016dW-Y:f\u001b\u0016l'-\u001a:t)\u0019\ti'a\u001d\u0002vA!a$a\u001ck\u0013\r\t\th\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005uS\u00021\u0001\u0002`!9\u0011qG\u0007A\u0002\u0005e\u0012\u0001\u00059beN,w\t\\8cC2\u0014v\u000e\\3t)\u0015y\u00171PA?\u0011\u001d\t9D\u0004a\u0001\u0003sAQ!\u001f\bA\u0002=\fQbZ3u\u00032dW*Z7cKJ\u001cH#\u00026\u0002\u0004\u00065\u0005bBAC\u001f\u0001\u0007\u0011qQ\u0001\u0005i\u0016\fW\u000eE\u0002\u0000\u0003\u0013KA!a#\u0002\u0002\t!A+Z1n\u0011\u001d\t9d\u0004a\u0001\u0003sA3\u0001AAI!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL\u0019\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005m\u0015Q\u0013\u0002\b'\u0016\u0014h/[2f\u0001")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)((SetLike)allPrincipals.filter((Function1 & Serializable & scala.Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.isUserEnabled(username)))).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean isUserEnabled(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() : false;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(task.getWatchers()).asScala()).toSet();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$4(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

