/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!a\u0004A!A!\u0002\u0013i\u0004\"B\"\u0001\t\u0003!\u0005\"B.\u0001\t\u0003a\u0006\"\u00026\u0001\t\u0003Y\u0007\"CA\f\u0001E\u0005I\u0011AA\r\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAK\u0001\u0011%\u0011q\u0013\u0005\b\u0003;\u0003A\u0011BAP\u0005Y)U.Y5m%\u0016\u001c\u0017\u000e]5f]R\u0014Vm]8mm\u0016\u0014(BA\n\u0015\u0003\u0015)W.Y5m\u0015\t)b#A\u0007o_RLg-[2bi&|gn\u001d\u0006\u0003/a\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005eQ\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0012aA2p[\u000e\u00011C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u0006Y!o\u001c7f'\u0016\u0014h/[2f!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0005tK\u000e,(/\u001b;z\u0015\tQ\u0003$\u0001\u0005eKBdw._5u\u0013\tasEA\u0006S_2,7+\u001a:wS\u000e,\u0017a\u0003;fC6\u001cVM\u001d<jG\u0016\u0004\"a\f\u001a\u000e\u0003AR!!\r\f\u0002\u000fM,'O^5dK&\u00111\u0007\r\u0002\f)\u0016\fWnU3sm&\u001cW-\u0001\nvg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0007CA\u00187\u0013\t9\u0004G\u0001\nVg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0017!\u00069sS:\u001c\u0017\u000e]1m\u0013:4wNU3t_24XM\u001d\t\u0003_iJ!a\u000f\u0019\u0003+A\u0013\u0018N\\2ja\u0006d\u0017J\u001c4p%\u0016\u001cx\u000e\u001c<fe\u0006I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001Z\taaY8oM&<\u0017B\u0001\"@\u0005%AFN]\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0007\u000b\u001eC\u0015JS&\u0011\u0005\u0019\u0003Q\"\u0001\n\t\u000b\u00112\u0001\u0019A\u0013\t\u000b52\u0001\u0019\u0001\u0018\t\u000bQ2\u0001\u0019A\u001b\t\u000ba2\u0001\u0019A\u001d\t\u000bq2\u0001\u0019A\u001f)\u0005\u0019i\u0005C\u0001(Z\u001b\u0005y%B\u0001)R\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003%N\u000bqAZ1di>\u0014\u0018P\u0003\u0002U+\u0006)!-Z1og*\u0011akV\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001,A\u0002pe\u001eL!AW(\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u0005:fg>dg/\u001a*fG&\u0004\u0018.\u001a8u)\ti\u0006\u000e\u0005\u0002_K:\u0011ql\u0019\t\u0003A\u0002j\u0011!\u0019\u0006\u0003Er\ta\u0001\u0010:p_Rt\u0014B\u00013!\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\u0004\u0003\"B5\b\u0001\u0004i\u0016!\u00049sS:\u001c\u0017\u000e]1m\u001d\u0006lW-A\tsKN|GN^3SK\u000eL\u0007/[3oiN$r\u0001\\8{yz\fi\u0001E\u0002_[vK!A\\4\u0003\u0007M+G\u000fC\u0003q\u0011\u0001\u0007\u0011/A\u0003s_2,7\u000fE\u0002sovs!a];\u000f\u0005\u0001$\u0018\"A\u0011\n\u0005Y\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003qf\u0014A\u0001T5ti*\u0011a\u000f\t\u0005\u0006w\"\u0001\r!]\u0001\fO2|'-\u00197S_2,7\u000fC\u0003~\u0011\u0001\u0007\u0011/A\u0003vg\u0016\u00148\u000f\u0003\u0004\u0000\u0011\u0001\u0007\u0011\u0011A\u0001\ta2\fg.\u0013;f[B!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\bY\ta\u0001Z8nC&t\u0017\u0002BA\u0006\u0003\u000b\u0011\u0001\u0002\u00157b]&#X-\u001c\u0005\n\u0003\u001fA\u0001\u0013!a\u0001\u0003#\tQ\"\u001a=dYV$W-Q;uQ>\u0014\bcA\u0010\u0002\u0014%\u0019\u0011Q\u0003\u0011\u0003\u000f\t{w\u000e\\3b]\u0006Y\"/Z:pYZ,'+Z2ja&,g\u000e^:%I\u00164\u0017-\u001e7uIU*\"!a\u0007+\t\u0005E\u0011QD\u0016\u0003\u0003?\u0001B!!\t\u0002*5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0011\u0001\u000bI\u0005\u0005\u0003W\t\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!B\\8uS\u001aLXk]3s)\u0011\t\t\"!\r\t\r\u0005M\"\u00021\u0001^\u0003!)8/\u001a:oC6,\u0017A\u00039beN,'k\u001c7fgRIA.!\u000f\u0002F\u0005\u001d\u0013\u0011\n\u0005\b\u0003wY\u0001\u0019AA\u001f\u0003-\t7o]5h]6,g\u000e^:\u0011\tI<\u0018q\b\t\u0004M\u0005\u0005\u0013bAA\"O\t!!k\u001c7f\u0011\u0015\u00018\u00021\u0001r\u0011\u0019y8\u00021\u0001\u0002\u0002!9\u00111J\u0006A\u0002\u00055\u0013!B2bG\",\u0007\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\tS:$XM\u001d8bY*\u0019\u0011q\u000b\f\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\\\u0005E#a\u0004#fG>\u0014\u0018\r^8sg\u000e\u000b7\r[3\u0002\u001dA\f'o]3UCN\\'k\u001c7fgRIA.!\u0019\u0002l\u00055\u0014q\u000e\u0005\b\u0003Gb\u0001\u0019AA3\u0003\u0011!\u0018m]6\u0011\t\u0005\r\u0011qM\u0005\u0005\u0003S\n)A\u0001\u0003UCN\\\u0007\"\u00029\r\u0001\u0004\t\bbBA\u001e\u0019\u0001\u0007\u0011Q\b\u0005\b\u0003\u0017b\u0001\u0019AA'\u0003E\u0001\u0018M]:f%\u0016dW-Y:f%>dWm\u001d\u000b\nY\u0006U\u0014qPAA\u0003\u0007Cq!a\u001e\u000e\u0001\u0004\tI(A\u0004sK2,\u0017m]3\u0011\t\u0005\r\u00111P\u0005\u0005\u0003{\n)AA\u0004SK2,\u0017m]3\t\u000bAl\u0001\u0019A9\t\u000f\u0005mR\u00021\u0001\u0002>!9\u00111J\u0007A\u0002\u00055\u0013!E4fiJ+G.Z1tK6+WNY3sgRA\u0011\u0011RAH\u0003#\u000b\u0019\n\u0005\u0003 \u0003\u0017c\u0017bAAGA\t1q\n\u001d;j_:Dq!a\u001e\u000f\u0001\u0004\tI\bC\u0004\u0002<9\u0001\r!!\u0010\t\u000f\u0005-c\u00021\u0001\u0002N\u0005\u0001\u0002/\u0019:tK\u001ecwNY1m%>dWm\u001d\u000b\u0006c\u0006e\u00151\u0014\u0005\b\u0003wy\u0001\u0019AA\u001f\u0011\u0015Yx\u00021\u0001r\u000359W\r^!mY6+WNY3sgR)A.!)\u0002,\"9\u00111\u0015\tA\u0002\u0005\u0015\u0016\u0001\u0002;fC6\u0004B!a\u0001\u0002(&!\u0011\u0011VA\u0003\u0005\u0011!V-Y7\t\u000f\u0005m\u0002\u00031\u0001\u0002>!\u001a\u0001!a,\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.V\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003s\u000b\u0019LA\u0004TKJ4\u0018nY3")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;
    private final XlrConfig xlrConfig;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem, cache).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)((SetLike)allPrincipals.filter((Function1 & Serializable & scala.Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.notifyUser(username)))).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean notifyUser(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() || this.xlrConfig.isNotifyInactiveUsers() : true;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments, cache);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments, cache);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments, cache).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(task.getWatchers()).asScala()).toSet();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments, cache).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments, DecoratorsCache cache) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release, cache)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$4(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver, XlrConfig xlrConfig) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
        this.xlrConfig = xlrConfig;
    }
}

