/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.notifications.TriggerType$;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.email.EmailNotifications;
import com.xebialabs.xlrelease.notifications.views.EmailNotificationSettingsView;
import com.xebialabs.xlrelease.notifications.views.EmailPreviewView;
import com.xebialabs.xlrelease.notifications.views.converters.EmailNotificationSettingsConverter;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@Path(value="/settings/notifications")
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\t\u0013\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rm\u0003\u0001\u0015!\u0003T\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u00151\b\u0001\"\u0001x\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002\"CA(\u0001\t\u0007I1BA)\u0011!\t\t\u0007\u0001Q\u0001\n\u0005M\u0003\"CA2\u0001\t\u0007I1BA3\u0011!\tI\u0007\u0001Q\u0001\n\u0005\u001d\u0004\"CA6\u0001\t\u0007I1BA7\u0011!\ty\t\u0001Q\u0001\n\u0005=$!\u0006(pi&4\u0017nY1uS>t7OU3t_V\u00148-\u001a\u0006\u0003'Q\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003+Y\t1!\u00199j\u0015\t9\u0002$A\u0007o_RLg-[2bi&|gn\u001d\u0006\u00033i\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011C\u0001\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u0006\u0011R-\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8t!\tA3&D\u0001*\u0015\tQc#A\u0003f[\u0006LG.\u0003\u0002-S\t\u0011R)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8t\u0003-\u0001XM]7jgNLwN\\:\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005EB\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005M\u0002$!\u0005)fe6L7o]5p]\u000eCWmY6fe\u0006\u00192/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011a'O\u0007\u0002o)\u0011\u0001HG\u0001\tI\u0016\u0004Hn\\=ji&\u0011!h\u000e\u0002\u0014'\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\tuz\u0004)\u0011\t\u0003}\u0001i\u0011A\u0005\u0005\u0006M\u0011\u0001\ra\n\u0005\u0006[\u0011\u0001\rA\f\u0005\u0006i\u0011\u0001\r!\u000e\u0015\u0003\t\r\u0003\"\u0001R(\u000e\u0003\u0015S!AR$\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002I\u0013\u00069a-Y2u_JL(B\u0001&L\u0003\u0015\u0011W-\u00198t\u0015\taU*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005q\u0015aA8sO&\u0011\u0001+\u0012\u0002\n\u0003V$xn^5sK\u0012\f\u0011b]3sm\u0016\u0014XK\u001d7\u0016\u0003M\u0003\"\u0001V-\u000e\u0003US!AV,\u0002\t1\fgn\u001a\u0006\u00021\u0006!!.\u0019<b\u0013\tQVK\u0001\u0004TiJLgnZ\u0001\u000bg\u0016\u0014h/\u001a:Ve2\u0004\u0013\u0001H4fi\u0016k\u0017-\u001b7O_RLg-[2bi&|gnU3ui&twm]\u000b\u0002=B\u0011qLY\u0007\u0002A*\u0011\u0011MF\u0001\u0006m&,wo]\u0005\u0003G\u0002\u0014Q$R7bS2tu\u000e^5gS\u000e\fG/[8o'\u0016$H/\u001b8hgZKWm\u001e\u0015\u0005\u000f\u0015|\u0007\u000f\u0005\u0002g[6\tqM\u0003\u0002iS\u0006\u0011!o\u001d\u0006\u0003U.\f!a^:\u000b\u00031\fQA[1wCbL!A\\4\u0003\tA\u000bG\u000f[\u0001\u0006m\u0006dW/Z\u0011\u0002c\u00061Q-\\1jYND#aB:\u0011\u0005\u0019$\u0018BA;h\u0005\r9U\tV\u0001 kB$\u0017\r^3F[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001cHC\u00010y\u0011\u0015I\b\u00021\u0001_\u0003u)W.Y5m\u001d>$\u0018NZ5dCRLwN\\*fiRLgnZ:WS\u0016<\b\u0006\u0002\u0005f_BD#\u0001\u0003?\u0011\u0005\u0019l\u0018B\u0001@h\u0005\u0011\u0001vj\u0015+\u00027U\u0004H-\u0019;f\u000b6\f\u0017\u000e\u001c+f[Bd\u0017\r^3TKR$\u0018N\\4t)\u0011\t\u0019!!\u0003\u0011\u0007\u0005\n)!C\u0002\u0002\b\t\u0012A!\u00168ji\"9\u00111B\u0005A\u0002\u00055\u0011a\u00078pi&4\u0017nY1uS>tGK]5hO\u0016\u00148+\u001a;uS:<7\u000f\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u000fQ\u0014\u0018nZ4fe*\u0019\u0011q\u0003\f\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\tY\"!\u0005\u000379{G/\u001b4jG\u0006$\u0018n\u001c8Ue&<w-\u001a:TKR$\u0018N\\4tQ\u0015IQm\\A\u0010C\t\t\t#\u0001\ff[\u0006LGn]\u0018ue&<w-\u001a:TKR$\u0018N\\4tQ\tIA0A\u0004qe\u00164\u0018.Z<\u0015\t\u0005%\u0012Q\b\t\u0005\u0003W\tID\u0004\u0003\u0002.\u0005U\u0002cAA\u0018E5\u0011\u0011\u0011\u0007\u0006\u0004\u0003gq\u0012A\u0002\u001fs_>$h(C\u0002\u00028\t\na\u0001\u0015:fI\u00164\u0017b\u0001.\u0002<)\u0019\u0011q\u0007\u0012\t\u000f\u0005}\"\u00021\u0001\u0002B\u0005!a/[3x!\ry\u00161I\u0005\u0004\u0003\u000b\u0002'\u0001E#nC&d\u0007K]3wS\u0016<h+[3xQ\u0015QQm\\A%C\t\tY%\u0001\bf[\u0006LGn]\u0018qe\u00164\u0018.Z<)\u0005)a\u0018\u0001\u00043p[\u0006Lg\u000eV8WS\u0016<XCAA*!\u0019\t\u0013QKA-=&\u0019\u0011q\u000b\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA.\u0003;j!!!\u0006\n\t\u0005}\u0013Q\u0003\u0002\u001a\u000b6\f\u0017\u000e\u001c(pi&4\u0017nY1uS>t7+\u001a;uS:<7/A\u0007e_6\f\u0017N\u001c+p-&,w\u000fI\u0001\rm&,w\u000fV8E_6\f\u0017N\\\u000b\u0003\u0003O\u0002b!IA+=\u0006e\u0013!\u0004<jK^$v\u000eR8nC&t\u0007%A\ntiJLgn\u001a+p)JLwmZ3s)f\u0004X-\u0006\u0002\u0002pA9\u0011%!\u0016\u0002*\u0005E\u0004\u0003BA:\u0003\u0013sA!!\u001e\u0002\u0006:!\u0011qOAB\u001d\u0011\tI(!!\u000f\t\u0005m\u0014q\u0010\b\u0005\u0003_\ti(C\u0001\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0004\u0003\u000f3\u0012a\u0003+sS\u001e<WM\u001d+za\u0016LA!a#\u0002\u000e\nYAK]5hO\u0016\u0014H+\u001f9f\u0015\r\t9IF\u0001\u0015gR\u0014\u0018N\\4U_R\u0013\u0018nZ4feRK\b/\u001a\u0011)\u0007\u0001\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIjS\u0001\u000bgR,'/Z8usB,\u0017\u0002BAO\u0003/\u0013!bQ8oiJ|G\u000e\\3sQ\u0019\u0001\u0011\u0011U8\u0002(B\u0019a-a)\n\u0007\u0005\u0015vM\u0001\u0005Qe>$WoY3tY\t\tI+\t\u0002\u0002,\u0006\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\u001c\u0015\u0006\u0001\u0015|\u0017qV\u0011\u0003\u0003c\u000bqcL:fiRLgnZ:0]>$\u0018NZ5dCRLwN\\:")
public class NotificationsResource {
    private final EmailNotifications emailNotifications;
    private final PermissionChecker permissions;
    private final String serverUrl;
    private final Function1<EmailNotificationSettings, EmailNotificationSettingsView> domainToView;
    private final Function1<EmailNotificationSettingsView, EmailNotificationSettings> viewToDomain;
    private final Function1<String, Enumeration.Value> stringToTriggerType;

    private String serverUrl() {
        return this.serverUrl;
    }

    @GET
    @Path(value="emails")
    public EmailNotificationSettingsView getEmailNotificationSettings() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return (EmailNotificationSettingsView)this.domainToView().apply((Object)this.emailNotifications.getSettings());
    }

    @POST
    @Path(value="emails")
    public EmailNotificationSettingsView updateEmailNotificationSettings(EmailNotificationSettingsView emailNotificationSettingsView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return (EmailNotificationSettingsView)this.domainToView().apply((Object)this.emailNotifications.updateSettings((EmailNotificationSettings)((Object)this.viewToDomain().apply((Object)emailNotificationSettingsView))));
    }

    @POST
    @Path(value="emails/triggerSettings")
    public void updateEmailTemplateSettings(NotificationTriggerSettings notificationTriggerSettings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        EmailNotificationSettings settings = this.emailNotifications.getSettings();
        settings.setNotificationTriggerSettings(notificationTriggerSettings);
        this.emailNotifications.updateSettings(settings);
    }

    @POST
    @Path(value="emails/preview")
    public String preview(EmailPreviewView view) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.emailNotifications.createPreview((Enumeration.Value)this.stringToTriggerType().apply((Object)view.triggerType()), view.body(), this.serverUrl());
    }

    private Function1<EmailNotificationSettings, EmailNotificationSettingsView> domainToView() {
        return this.domainToView;
    }

    private Function1<EmailNotificationSettingsView, EmailNotificationSettings> viewToDomain() {
        return this.viewToDomain;
    }

    private Function1<String, Enumeration.Value> stringToTriggerType() {
        return this.stringToTriggerType;
    }

    @Autowired
    public NotificationsResource(EmailNotifications emailNotifications, PermissionChecker permissions, ServerConfiguration serverConfiguration) {
        this.emailNotifications = emailNotifications;
        this.permissions = permissions;
        this.serverUrl = serverConfiguration.getServerUrl();
        this.domainToView = (Function1 & java.io.Serializable & Serializable)settings -> EmailNotificationSettingsConverter.toView(settings);
        this.viewToDomain = (Function1 & java.io.Serializable & Serializable)view -> EmailNotificationSettingsConverter.fromView(view);
        this.stringToTriggerType = (Function1 & java.io.Serializable & Serializable)s -> TriggerType$.MODULE$.withName((String)s);
    }
}

