/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\b\u0011\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00159\u0007\u0001\"\u0001i\u0011%\t\t\u0002AI\u0001\n\u0003\t\u0019\u0002C\u0004\u0002(\u0001!I!!\u000b\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t)\b\u0001C\u0005\u0003o\u0012a#R7bS2\u0014VmY5qS\u0016tGOU3t_24XM\u001d\u0006\u0003#I\tQ!Z7bS2T!a\u0005\u000b\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\t)b#A\u0005yYJ,G.Z1tK*\u0011q\u0003G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!G\u0001\u0004G>l7\u0001A\n\u0003\u0001q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0017a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u0011M,7-\u001e:jifT!\u0001\u000b\f\u0002\u0011\u0011,\u0007\u000f\\8zSRL!AK\u0013\u0003\u0017I{G.Z*feZL7-Z\u0001\fi\u0016\fWnU3sm&\u001cW\r\u0005\u0002.a5\taF\u0003\u00020)\u000591/\u001a:wS\u000e,\u0017BA\u0019/\u0005-!V-Y7TKJ4\u0018nY3\u0002%U\u001cXM\u001d)s_\u001aLG.Z*feZL7-\u001a\t\u0003[QJ!!\u000e\u0018\u0003%U\u001bXM\u001d)s_\u001aLG.Z*feZL7-Z\u0001\u0016aJLgnY5qC2LeNZ8SKN|GN^3s!\ti\u0003(\u0003\u0002:]\t)\u0002K]5oG&\u0004\u0018\r\\%oM>\u0014Vm]8mm\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003=}}\u0002\u0015\t\u0005\u0002>\u00015\t\u0001\u0003C\u0003#\u000b\u0001\u00071\u0005C\u0003,\u000b\u0001\u0007A\u0006C\u00033\u000b\u0001\u00071\u0007C\u00037\u000b\u0001\u0007q\u0007\u000b\u0002\u0006\u0007B\u0011AiT\u0007\u0002\u000b*\u0011aiR\u0001\u000bC:tw\u000e^1uS>t'B\u0001%J\u0003\u001d1\u0017m\u0019;pefT!AS&\u0002\u000b\t,\u0017M\\:\u000b\u00051k\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001VIA\u0005BkR|w/\u001b:fI\u0006\u0001\"/Z:pYZ,'+Z2ja&,g\u000e\u001e\u000b\u0003'n\u0003\"\u0001V-\u000e\u0003US!AV,\u0002\t1\fgn\u001a\u0006\u00021\u0006!!.\u0019<b\u0013\tQVK\u0001\u0004TiJLgn\u001a\u0005\u00069\u001a\u0001\r!X\u0001\u000eaJLgnY5qC2t\u0015-\\3\u0011\u0005y+gBA0d!\t\u0001g$D\u0001b\u0015\t\u0011'$\u0001\u0004=e>|GOP\u0005\u0003Iz\ta\u0001\u0015:fI\u00164\u0017B\u0001.g\u0015\t!g$A\tsKN|GN^3SK\u000eL\u0007/[3oiN$r!\u001b7xsn\f9\u0001E\u0002_UvK!a\u001b4\u0003\u0007M+G\u000fC\u0003n\u000f\u0001\u0007a.A\u0003s_2,7\u000fE\u0002pivs!\u0001\u001d:\u000f\u0005\u0001\f\u0018\"A\u0010\n\u0005Mt\u0012a\u00029bG.\fw-Z\u0005\u0003kZ\u0014A\u0001T5ti*\u00111O\b\u0005\u0006q\u001e\u0001\rA\\\u0001\fO2|'-\u00197S_2,7\u000fC\u0003{\u000f\u0001\u0007a.A\u0003vg\u0016\u00148\u000fC\u0003}\u000f\u0001\u0007Q0\u0001\u0005qY\u0006t\u0017\n^3n!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u000b\u0002\r\u0011|W.Y5o\u0013\r\t)a \u0002\t!2\fg.\u0013;f[\"I\u0011\u0011B\u0004\u0011\u0002\u0003\u0007\u00111B\u0001\u000eKb\u001cG.\u001e3f\u0003V$\bn\u001c:\u0011\u0007u\ti!C\u0002\u0002\u0010y\u0011qAQ8pY\u0016\fg.A\u000esKN|GN^3SK\u000eL\u0007/[3oiN$C-\u001a4bk2$H%N\u000b\u0003\u0003+QC!a\u0003\u0002\u0018-\u0012\u0011\u0011\u0004\t\u0005\u00037\t\u0019#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003%)hn\u00195fG.,GM\u0003\u0002G=%!\u0011QEA\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000ba\u0006\u00148/\u001a*pY\u0016\u001cHcB5\u0002,\u0005]\u0012\u0011\b\u0005\b\u0003[I\u0001\u0019AA\u0018\u0003-\t7o]5h]6,g\u000e^:\u0011\t=$\u0018\u0011\u0007\t\u0004I\u0005M\u0012bAA\u001bK\t!!k\u001c7f\u0011\u0015i\u0017\u00021\u0001o\u0011\u0015a\u0018\u00021\u0001~\u00039\u0001\u0018M]:f)\u0006\u001c8NU8mKN$r![A \u0003\u0013\nY\u0005C\u0004\u0002B)\u0001\r!a\u0011\u0002\tQ\f7o\u001b\t\u0004}\u0006\u0015\u0013bAA$\u007f\n!A+Y:l\u0011\u0015i'\u00021\u0001o\u0011\u001d\tiC\u0003a\u0001\u0003_\t\u0011\u0003]1sg\u0016\u0014V\r\\3bg\u0016\u0014v\u000e\\3t)\u001dI\u0017\u0011KA.\u0003;Bq!a\u0015\f\u0001\u0004\t)&A\u0004sK2,\u0017m]3\u0011\u0007y\f9&C\u0002\u0002Z}\u0014qAU3mK\u0006\u001cX\rC\u0003n\u0017\u0001\u0007a\u000eC\u0004\u0002.-\u0001\r!a\f\u0002#\u001d,GOU3mK\u0006\u001cX-T3nE\u0016\u00148\u000f\u0006\u0004\u0002d\u0005%\u00141\u000e\t\u0005;\u0005\u0015\u0014.C\u0002\u0002hy\u0011aa\u00149uS>t\u0007bBA*\u0019\u0001\u0007\u0011Q\u000b\u0005\b\u0003[a\u0001\u0019AA\u0018\u0003A\u0001\u0018M]:f\u000f2|'-\u00197S_2,7\u000fF\u0003o\u0003c\n\u0019\bC\u0004\u0002.5\u0001\r!a\f\t\u000bal\u0001\u0019\u00018\u0002\u001b\u001d,G/\u00117m\u001b\u0016l'-\u001a:t)\u0015I\u0017\u0011PAB\u0011\u001d\tYH\u0004a\u0001\u0003{\nA\u0001^3b[B\u0019a0a \n\u0007\u0005\u0005uP\u0001\u0003UK\u0006l\u0007bBA\u0017\u001d\u0001\u0007\u0011q\u0006\u0015\u0004\u0001\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u000555*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!%\u0002\f\n91+\u001a:wS\u000e,\u0007")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)allPrincipals.map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$2(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(task.getWatchers()).asScala()).toSet();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$2(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

