/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.task;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plumbing.scheduler.FutureTaskAdapter;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.notifications.email.ContextHelper;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailSender;
import com.xebialabs.xlrelease.notifications.email.templates.Templater$;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.MarkdownProcessor;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0005\u000b\u0001UA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015!\b\u0001\"\u0011v\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\u0011\u0001DT8uS\u001aL7-\u0019;j_:$\u0016m]6Fq\u0016\u001cW\u000f^8s\u0015\tYA\"\u0001\u0003uCN\\'BA\u0007\u000f\u00035qw\u000e^5gS\u000e\fG/[8og*\u0011q\u0002E\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0005\n\u0002\u0013a,'-[1mC\n\u001c(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u00011bD\u000b\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tA\u0001\\1oO*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0019\u0005\u0019y%M[3diB\u0019q\u0004\n\u0014\u000e\u0003\u0001R!!\t\u0012\u0002\u000bQ\f7o[:\u000b\u0005\rr\u0011A\u00023p[\u0006Lg.\u0003\u0002&A\taA+Y:l\u000bb,7-\u001e;peB\u0011q\u0005K\u0007\u0002E%\u0011\u0011F\t\u0002\u0011\u001d>$\u0018NZ5dCRLwN\u001c+bg.\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003=\n\u0001b\u001a:jujdW\rZ\u0005\u0003c1\u0012q\u0001T8hO&tw-A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u00025o5\tQG\u0003\u00027\u001d\u00051\u0011m\u0019;peNL!\u0001O\u001b\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\u001b\r|g\u000e^3yi\"+G\u000e]3s!\tYd(D\u0001=\u0015\tiD\"A\u0003f[\u0006LG.\u0003\u0002@y\ti1i\u001c8uKb$\b*\u001a7qKJ\f1\"Z7bS2\u001cVM\u001c3feB\u00111HQ\u0005\u0003\u0007r\u00121\"R7bS2\u001cVM\u001c3fe\u0006I1o\u00195fIVdWM\u001d\t\u0003\r2k\u0011a\u0012\u0006\u0003\t\"S!!\u0013&\u0002\u0011AdW/\u001c2j]\u001eT!a\u0013\t\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!T$\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003Q%N#V\u000b\u0005\u0002R\u00015\t!\u0002C\u00033\u000b\u0001\u00071\u0007C\u0003:\u000b\u0001\u0007!\bC\u0003A\u000b\u0001\u0007\u0011\tC\u0003E\u000b\u0001\u0007Q\t\u000b\u0002\u0006/B\u0011\u0001lY\u0007\u00023*\u0011!lW\u0001\u000bC:tw\u000e^1uS>t'B\u0001/^\u0003\u001d1\u0017m\u0019;pefT!AX0\u0002\u000b\t,\u0017M\\:\u000b\u0005\u0001\f\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\t\f1a\u001c:h\u0013\t!\u0017LA\u0005BkR|w/\u001b:fI\u0006aq-\u001a;UCN\\7\t\\1tgR\tq\rE\u0002ic\u001ar!![8\u0011\u0005)lW\"A6\u000b\u00051$\u0012A\u0002\u001fs_>$hHC\u0001o\u0003\u0015\u00198-\u00197b\u0013\t\u0001X.\u0001\u0004Qe\u0016$WMZ\u0005\u0003eN\u0014Qa\u00117bgNT!\u0001]7\u00021\u0015DXmY;uK^KG\u000f[*pMR\u0014VMZ3sK:\u001cW\r\u0006\u0003wu\u0006\u0015\u0001CA<y\u001b\u0005i\u0017BA=n\u0005\u0011)f.\u001b;\t\u000bm<\u0001\u0019\u0001?\u0002\u000fQ\f7o\u001b*fMB!Q0!\u0001'\u001b\u0005q(BA@\u000f\u0003\u0019\u00198M]5qi&\u0019\u00111\u0001@\u0003#Q\u000b7o[*pMR\u0014VMZ3sK:\u001cW\rC\u0004\u0002\b\u001d\u0001\r!!\u0003\u0002\u0011M\u001c'/\u001e2cKJ\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fq\u0011!B;uS2\u001c\u0018\u0002BA\n\u0003\u001b\u0011acU3og&$\u0018N^3WC2,XmU2sk\n\u0014WM]\u0001\u0011g\u0016tGMT8uS\u001aL7-\u0019;j_:$2A^A\r\u0011\u0015Y\u0001\u00021\u0001'Q\r\u0001\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111E0\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002(\u0005\u0005\"!C\"p[B|g.\u001a8u\u0001")
public class NotificationTaskExecutor
implements TaskExecutor<NotificationTask>,
Logging {
    private final ReleaseActorService releaseActorService;
    private final ContextHelper contextHelper;
    private final EmailSender emailSender;
    private final Scheduler scheduler;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void execute(Task x$1, SensitiveValueScrubber x$2) {
        super.execute(x$1, x$2);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        NotificationTaskExecutor notificationTaskExecutor = this;
        synchronized (notificationTaskExecutor) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Class<NotificationTask> getTaskClass() {
        return NotificationTask.class;
    }

    public void executeWithSoftReference(TaskSoftReference<NotificationTask> taskRef, SensitiveValueScrubber scrubber) {
        this.scheduler.supplyAsync(FutureTaskAdapter.ofNotificationTask((String)taskRef.getTaskId(), (ReleaseActorService)this.releaseActorService, (String)taskRef.getExecutionId(), () -> {
            this.sendNotification((NotificationTask)taskRef.get());
            return null;
        }));
    }

    private void sendNotification(NotificationTask task) {
        scala.collection.immutable.Map context = this.contextHelper.baseContext().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"body"), MarkdownProcessor.process((String)task.getBody()).orElse(null)));
        String body = Templater$.MODULE$.processTemplate("notification-task-template.mustache", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)context).asJava());
        Email email = new Email(task.getAddresses(), task.getSubject(), body);
        email.withPriority(task.getPriority()).withReplyTo(task.getReplyTo()).withCc(task.getCc()).withBcc(task.getBcc()).withFrom(task.getFrom()).withSenderUsername(task.getSenderUsername()).withSenderPassword(task.getSenderPassword());
        List list = ((MapLike)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"To"), (Object)BoxesRunTime.boxToBoolean((boolean)task.getAddresses().isEmpty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Subject"), (Object)BoxesRunTime.boxToBoolean((boolean)Strings.isNullOrEmpty((String)task.getSubject()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Body"), (Object)BoxesRunTime.boxToBoolean((boolean)Strings.isNullOrEmpty((String)task.getBody())))}))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().toList();
        if (Nil$.MODULE$.equals(list)) {
            Failure failure;
            Throwable e;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.emailSender.sendEmailSync(email));
            if (try_ instanceof Success) {
                this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure && (e = (failure = (Failure)try_).exception()) != null) {
                Throwable throwable = e;
                this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{throwable.getMessage()}), User.SYSTEM, this.releaseActorService.failTaskAsync$default$4());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String errorMessage = new StringBuilder(33).append("The required fields [").append(list.mkString(", ")).append("] are missed").toString();
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Email not sent for notification task '").append(task.getId()).append("'. ").append(errorMessage).toString());
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{errorMessage}), User.SYSTEM, this.releaseActorService.failTaskAsync$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Autowired
    public NotificationTaskExecutor(ReleaseActorService releaseActorService, ContextHelper contextHelper, EmailSender emailSender, Scheduler scheduler) {
        this.releaseActorService = releaseActorService;
        this.contextHelper = contextHelper;
        this.emailSender = emailSender;
        this.scheduler = scheduler;
        Logging.$init$((Logging)this);
    }
}

